/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.v2.ao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.ManagedCache;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.moveworkforward.ao.entity.PersistenceEntity;
import com.moveworkforward.ao.impl.CachedRepository;
import com.moveworkforward.v2.ao.impl.AbstractPluginRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;
import net.java.ao.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCachedPluginRepository<K extends Entity & PersistenceEntity>
extends AbstractPluginRepository<K>
implements CachedRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCachedPluginRepository.class);
    protected CacheManager cacheManager;
    protected Cache<LoadKey, List<?>> cache;
    protected CacheSettings cacheSettings;

    public AbstractCachedPluginRepository(ActiveObjects activeObjects, CacheManager cacheManager, TransactionTemplate transactionTemplate) {
        super(activeObjects, transactionTemplate);
        this.cacheManager = cacheManager;
        this.cacheSettings = new CacheSettingsBuilder().remote().replicateViaInvalidation().maxEntries(500).expireAfterAccess(1440L, TimeUnit.MINUTES).build();
        this.cache = cacheManager.getCache(this.getClass().getName(), this::load, this.cacheSettings);
    }

    @Override
    public <T> T save(T entity) {
        T result = super.save(entity);
        this.invalidateCache();
        return result;
    }

    @Override
    public <T> T get(int id, Class<T> clazz) {
        return this.getData(String.valueOf(id), clazz, CacheStrategy.ID).stream().findFirst().orElse(null);
    }

    @Override
    public <T> T delete(int id, Class<T> clazz) {
        T result = super.delete(id, clazz);
        this.invalidateCache();
        return result;
    }

    @Override
    public <T> T deleteByKey(String key, Class<T> clazz) {
        T result = super.deleteByKey(key, clazz);
        this.invalidateCache();
        return result;
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz) {
        return this.getData(null, clazz, CacheStrategy.TYPE);
    }

    @Override
    public <T> int deleteAll(Class<T> clazz) {
        int count = super.deleteAll(clazz);
        this.invalidateCache();
        return count;
    }

    @Override
    public <T> T getByKey(@NonNull String key, Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getData(key, clazz, CacheStrategy.KEY).stream().findFirst().orElse(null);
    }

    @Override
    public <T> int deleteByTag(@NonNull String tag, Class<T> clazz) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        int count = super.deleteByTag(tag, clazz);
        this.invalidateCache();
        return count;
    }

    @Override
    public <T> List<T> getByTag(@NonNull String tag, Class<T> clazz) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        return this.getData(tag, clazz, CacheStrategy.TAG);
    }

    @Override
    public void invalidateCache() {
        this.cache.removeAll();
    }

    @Nonnull
    protected <T> List<T> getData(String key, Class<T> clazz, CacheStrategy cacheStrategy) {
        LoadKey<T> loadKey = new LoadKey<T>(key, cacheStrategy, clazz);
        List result = null;
        boolean exception = false;
        try {
            result = (List)this.cache.get(loadKey);
        }
        catch (Exception e) {
            log.warn("Can't get data from cache, reload");
            exception = true;
        }
        if (exception || result == null) {
            this.cache.remove(loadKey);
            result = (List)this.cache.get(loadKey);
        }
        return Optional.ofNullable(result).map(ArrayList::new).orElse(new ArrayList());
    }

    @Nonnull
    protected <T> List<T> load(@Nonnull LoadKey loadKey) {
        List result;
        String key = loadKey.getKey();
        Class clazz = loadKey.getClazz();
        CacheStrategy cacheStrategy = loadKey.getCacheStrategy();
        switch (cacheStrategy) {
            case ID: {
                result = this.loadById(Integer.parseInt(key), clazz);
                break;
            }
            case KEY: {
                result = this.loadByKey(key, clazz);
                break;
            }
            case TAG: {
                result = this.loadByTag(key, clazz);
                break;
            }
            default: {
                result = this.loadAll(clazz);
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected <T> List<T> loadAll(Class<T> clazz) {
        return AbstractCachedPluginRepository.super.getAll(clazz);
    }

    protected <T> List<T> loadByTag(String tag, Class<T> clazz) {
        return AbstractCachedPluginRepository.super.getByTag(tag, clazz);
    }

    protected <T> List<T> loadByKey(String key, Class<T> clazz) {
        return Optional.ofNullable(AbstractCachedPluginRepository.super.getByKey(key, clazz)).map(t -> new ArrayList<Object>(Collections.singletonList(t))).orElse(new ArrayList());
    }

    protected <T> List<T> loadById(int id, Class<T> clazz) {
        return Optional.ofNullable(AbstractCachedPluginRepository.super.get(id, clazz)).map(t -> new ArrayList<Object>(Collections.singletonList(t))).orElse(new ArrayList());
    }

    @Override
    public void updateCacheConfiguration(int maxEntries, int expirationInMinutes) {
        log.info("Old cache size: {} ", (Object)this.cache.getKeys().size());
        log.info("Previous settings: max entries {}, expiration {}", (Object)this.cacheSettings.getMaxEntries(), (Object)this.cacheSettings.getExpireAfterAccess());
        log.info("New settings: max entries {}, expiration {}(min)", (Object)maxEntries, (Object)expirationInMinutes);
        CacheSettings newCacheSettings = new CacheSettingsBuilder().remote().maxEntries(maxEntries).expireAfterAccess((long)expirationInMinutes, TimeUnit.MINUTES).replicateViaInvalidation().build();
        if (this.cache instanceof ManagedCache) {
            ((ManagedCache)this.cache).updateExpireAfterWrite((long)expirationInMinutes, TimeUnit.MINUTES);
            ((ManagedCache)this.cache).updateMaxEntries(maxEntries);
        } else {
            Cache newCache = this.cacheManager.getCache(this.getClass().getName(), this::load, newCacheSettings);
            Cache<LoadKey, List<?>> oldCache = this.cache;
            this.cache = newCache;
            oldCache.removeAll();
            this.cacheSettings = newCacheSettings;
        }
        this.cache.removeAll();
        this.cacheSettings = newCacheSettings;
    }

    public static class LoadKey<T>
    implements Serializable {
        private String key;
        private CacheStrategy cacheStrategy;
        private Class<T> clazz;

        @Generated
        public LoadKey(String key, CacheStrategy cacheStrategy, Class<T> clazz) {
            this.key = key;
            this.cacheStrategy = cacheStrategy;
            this.clazz = clazz;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public CacheStrategy getCacheStrategy() {
            return this.cacheStrategy;
        }

        @Generated
        public Class<T> getClazz() {
            return this.clazz;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoadKey)) {
                return false;
            }
            LoadKey other = (LoadKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            CacheStrategy this$cacheStrategy = this.getCacheStrategy();
            CacheStrategy other$cacheStrategy = other.getCacheStrategy();
            if (this$cacheStrategy == null ? other$cacheStrategy != null : !this$cacheStrategy.equals(other$cacheStrategy)) {
                return false;
            }
            Class<T> this$clazz = this.getClazz();
            Class<T> other$clazz = other.getClazz();
            return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoadKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            CacheStrategy $cacheStrategy = this.getCacheStrategy();
            result = result * 59 + ($cacheStrategy == null ? 43 : $cacheStrategy.hashCode());
            Class<T> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractCachedPluginRepository.LoadKey(key=" + this.getKey() + ", cacheStrategy=" + this.getCacheStrategy() + ", clazz=" + this.getClazz() + ")";
        }
    }

    public static enum CacheStrategy implements Serializable
    {
        TAG,
        TYPE,
        ID,
        KEY;

    }
}

