/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.util;

import com.google.common.collect.ImmutableMap;
import com.moveworkforward.model.Delivery;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DayTimeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DayTimeUtil.class);
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final Map<Integer, Integer> CALENDAR_DAYS_MAP = ImmutableMap.builder().put((Object)2, (Object)1).put((Object)3, (Object)2).put((Object)4, (Object)3).put((Object)5, (Object)4).put((Object)6, (Object)5).put((Object)7, (Object)6).put((Object)1, (Object)7).build();

    private DayTimeUtil() {
    }

    public static int adjustMinute(int minute) {
        return minute / 15 * 15;
    }

    public static Day getDay(int calendarDay) {
        Integer day = CALENDAR_DAYS_MAP.get(calendarDay);
        if (day == null) {
            throw new RuntimeException("Unknown day: " + calendarDay);
        }
        return Day.getDay(day);
    }

    public static String getTime(int hour, int minute) {
        return String.format("|%s|:|%s|", hour, minute);
    }

    public static String getDateTimePattern(int day, int hour, int minute) {
        Day weekDay = Day.getDay(day);
        return DayTimeUtil.formatReportTime("%" + weekDay.getAbbreviation() + "%", "%|" + hour + "|%:%|" + minute + "|%");
    }

    public static String getDateTimePattern(Date date, int hour, int minute) {
        return DayTimeUtil.formatReportTime(DATE_FORMAT.format(date), "%|" + hour + "|%:%|" + minute + "|%");
    }

    protected static String formatReportTime(String days, String time) {
        return String.format("%s-%s", days, time);
    }

    public static String getReportTime(Delivery delivery) {
        String days;
        String time;
        block10: {
            int hour;
            block8: {
                block9: {
                    time = "";
                    days = "";
                    DateTime zonedDateTime = DayTimeUtil.getZoneDateTime(delivery);
                    hour = zonedDateTime.getHourOfDay();
                    int minute = zonedDateTime.getMinuteOfHour();
                    if (!delivery.isDeliverOnSchedule()) break block8;
                    log.debug("Deliver on schedule {}", (Object)delivery);
                    time = DayTimeUtil.getTime(hour, minute);
                    if (!StringUtils.isNotBlank((CharSequence)delivery.getDate())) break block9;
                    days = delivery.getDate();
                    break block10;
                }
                switch (delivery.getFrequency()) {
                    case WORKING_DAY: {
                        days = Stream.of(Day.MONDAY, Day.TUESDAY, Day.WEDNESDAY, Day.THURSDAY, Day.FRIDAY).map(Day::getAbbreviation).collect(Collectors.joining(","));
                        break block10;
                    }
                    case WEEKLY: {
                        days = Objects.requireNonNull(Day.getDay(delivery.getDay())).getAbbreviation();
                        break block10;
                    }
                    case DAILY: {
                        days = Stream.of(Day.values()).map(Day::getAbbreviation).collect(Collectors.joining(","));
                        break block10;
                    }
                    case SCHEDULED: {
                        days = DayTimeUtil.getNextExecutionDate(delivery);
                        break block10;
                    }
                    default: {
                        throw new RuntimeException("Unknown frequency: " + (Object)((Object)delivery.getFrequency()));
                    }
                }
            }
            if (delivery.isRunEveryTime()) {
                String hoursPattern = IntStream.rangeClosed(0, 23).mapToObj(String::valueOf).collect(Collectors.joining("|"));
                String minutePattern = "|0|15|30|45|";
                time = "|" + hoursPattern + "|:" + minutePattern;
            } else {
                time = DayTimeUtil.getPeriodicalHours(hour, delivery.getCheckHoursPeriod());
            }
            days = delivery.isRunOnWeekends() ? Stream.of(Day.values()).map(Day::getAbbreviation).collect(Collectors.joining(",")) : Stream.of(Day.MONDAY, Day.TUESDAY, Day.WEDNESDAY, Day.THURSDAY, Day.FRIDAY).map(Day::getAbbreviation).collect(Collectors.joining(","));
        }
        log.debug("Report time: {}-{}", (Object)days, (Object)time);
        return DayTimeUtil.formatReportTime(days, time);
    }

    public static String getNextExecutionDate(Delivery delivery) {
        DateTime now = new DateTime();
        DateTime scheduledTime = now.withHourOfDay(Optional.ofNullable(delivery.getHour()).orElse(0).intValue()).withMinuteOfHour(Optional.ofNullable(delivery.getMinute()).orElse(0).intValue());
        if (now.isAfter((ReadableInstant)scheduledTime) || now.withSecondOfMinute(0).withMillisOfSecond(0).equals((Object)scheduledTime.withSecondOfMinute(0).withMillisOfSecond(0))) {
            scheduledTime = now.plus((ReadablePeriod)delivery.getTimePeriod().getPeriod());
        }
        return DATE_FORMAT.format(scheduledTime.toDate());
    }

    private static DateTime getZoneDateTime(Delivery delivery) {
        String userTimeZone = delivery.getUserTimeZone() == null ? ZoneId.systemDefault().getId() : delivery.getUserTimeZone();
        String serverTimeZone = delivery.getServerTimeZone() == null ? ZoneId.systemDefault().getId() : delivery.getServerTimeZone();
        return new DateTime().withZone(DateTimeZone.forID((String)userTimeZone)).withHourOfDay(delivery.getHour().intValue()).withMinuteOfHour(delivery.getMinute().intValue()).toDateTime(DateTimeZone.forID((String)serverTimeZone));
    }

    private static String getPeriodicalHours(int startHour, int checkPeriod) {
        int checksCount = 1;
        if (checkPeriod > 0) {
            checksCount = 24 / checkPeriod + (24 % checkPeriod == 0 ? 0 : 1);
        }
        LinkedHashSet<Integer> hours = new LinkedHashSet<Integer>();
        for (int i = 0; i < checksCount; ++i) {
            hours.add((startHour + checkPeriod * i) % 24);
        }
        String hoursPattern = hours.stream().map(String::valueOf).collect(Collectors.joining("|"));
        return "|" + hoursPattern + "|:|0|";
    }

    public static enum Day {
        MONDAY(1, "MON"),
        TUESDAY(2, "TUE"),
        WEDNESDAY(3, "WED"),
        THURSDAY(4, "THU"),
        FRIDAY(5, "FRI"),
        SATURDAY(6, "SAT"),
        SUNDAY(7, "SUN");

        private final int number;
        private final String abbreviation;

        private Day(int number, String abbreviation) {
            this.number = number;
            this.abbreviation = abbreviation;
        }

        public static Day getDay(int day) {
            for (Day value : Day.values()) {
                if (day != value.getNumber()) continue;
                return value;
            }
            throw new RuntimeException("Can't find day by number: " + day);
        }

        @Generated
        public int getNumber() {
            return this.number;
        }

        @Generated
        public String getAbbreviation() {
            return this.abbreviation;
        }
    }
}

