/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.statistics.service;

import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.moveworkforward.component.TenantIdProvider;
import com.moveworkforward.service.OperationListener;
import com.moveworkforward.statistics.PropertyStatisticsCollector;
import com.moveworkforward.statistics.annotations.StatisticsEntity;
import com.moveworkforward.statistics.annotations.StatisticsField;
import com.moveworkforward.statistics.annotations.StatisticsRuleLevel;
import com.moveworkforward.statistics.ao.converter.RuleDataConverter;
import com.moveworkforward.statistics.ao.repository.StatisticsEntityRepository;
import com.moveworkforward.statistics.model.RuleData;
import com.moveworkforward.statistics.model.StatisticsMessage;
import com.moveworkforward.statistics.model.StatisticsMetaData;
import com.moveworkforward.statistics.model.Tenant;
import com.moveworkforward.statistics.service.StatisticsService;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.util.HttpUtils;
import com.moveworkforward.util.JavaUtils;
import com.moveworkforward.util.JwtUtil;
import com.moveworkforward.util.MwfPropertyUtils;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACSigner;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AbstractStatisticsService
implements StatisticsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractStatisticsService.class);
    private static final int DEFAULT_TIMEOUT = 10;
    public static StatisticsService INSTANCE;
    private final StatisticsEntityRepository statisticsRepository;
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private final PluginLicenseManager pluginLicenseManager;
    private final TenantIdProvider tenantIdProvider;
    private final PropertyStatisticsCollector propertyStatisticsCollector = new PropertyStatisticsCollector();
    private List<Class<?>> statisticsClasses;

    public AbstractStatisticsService(StatisticsEntityRepository statisticsRepository, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginLicenseManager pluginLicenseManager, TenantIdProvider tenantIdProvider) {
        this.statisticsRepository = statisticsRepository;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
        this.pluginLicenseManager = pluginLicenseManager;
        this.tenantIdProvider = tenantIdProvider;
        this.statisticsClasses = this.resolveStatisticsClasses();
        INSTANCE = this;
    }

    protected List<Class<?>> resolveStatisticsClasses() {
        List<String> packages = Arrays.asList(this.getPackagesToScan());
        return packages.stream().flatMap(p -> JavaUtils.getClassesWithAnnotation(p, StatisticsEntity.class).stream()).collect(Collectors.toList());
    }

    protected <T> String getEntityType(Class<T> tClass) {
        StatisticsEntity annotation = (StatisticsEntity)AnnotationUtils.findAnnotation(tClass, StatisticsEntity.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    protected abstract boolean isCollectStatistics();

    protected abstract boolean isSendStatistics();

    @Transactional
    public <T> RuleData addRuleStatistics(@NonNull T value, @NonNull OperationListener.OperationType action, @NonNull Consumer<RuleData> updater) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (updater == null) {
            throw new NullPointerException("updater is marked non-null but is null");
        }
        if (!this.isCollectStatistics()) {
            return null;
        }
        String configurationType = this.getEntityType(value.getClass());
        if (configurationType == null) {
            log.debug("Can't find configuration type for class: " + value.getClass());
            return null;
        }
        String ruleType = this.getRuleType(value);
        RuleData ruleData = Optional.ofNullable(this.statisticsRepository.getByKey(RuleDataConverter.getKey(configurationType, action, ruleType), RuleData.class)).orElseGet(() -> {
            RuleData data = new RuleData();
            data.setAction(action);
            data.setRuleType(ruleType);
            data.setConfigurationType(configurationType);
            return data;
        });
        updater.accept(ruleData);
        return this.statisticsRepository.save(ruleData);
    }

    @Override
    public boolean sendStatistics() {
        if (!this.isSendStatistics()) {
            return false;
        }
        StatisticsMessage statisticsMessage = this.generateMessage();
        MwfPropertyUtils propertyUtils = MwfPropertyUtils.getInstance();
        String url = propertyUtils.getProperty(MwfPropertyUtils.STATISTICS_URL);
        String secret = propertyUtils.getProperty(MwfPropertyUtils.STATISTICS_SECRET);
        this.sendStatistics(url, this.getAuthToken(statisticsMessage.getTenant().getId(), secret), ConnectorUtil.createObjectMapper(true).writeValueAsString((Object)statisticsMessage));
        StatisticsMetaData statisticsMetaData = Optional.ofNullable(this.statisticsRepository.getByKey("META_DATA", StatisticsMetaData.class)).orElse(new StatisticsMetaData());
        statisticsMetaData.setLastSendDate(new Date());
        this.statisticsRepository.save(statisticsMetaData);
        this.cleanUp();
        return true;
    }

    private String getAuthToken(String tenantId, String secret) {
        String payload = "{\"tenantId\":\"" + tenantId + "\"}";
        JwtUtil.enableBouncyCastleIfPossible();
        MACSigner signer = new MACSigner(secret);
        JWSObject jwsObject = new JWSObject(new JWSHeader(JWSAlgorithm.HS256), new Payload(payload));
        jwsObject.sign(signer);
        return jwsObject.serialize();
    }

    private void sendStatistics(String url, String token, String payload) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(new StringEntity(payload, ContentType.APPLICATION_JSON));
        String authHeader = "Bearer " + token;
        httpPost.setHeader("Authorization", authHeader);
        try (CloseableHttpClient httpClient = HttpUtils.createHttpClient(URI.create(url), 10);
             CloseableHttpResponse response = httpClient.execute(httpPost);){
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString(entity, StandardCharsets.UTF_8);
            if (response.getStatusLine().getStatusCode() != 200) {
                log.error("Error during sending statistics: " + responseString);
                log.error("\tstatus code: " + response.getStatusLine().getStatusCode());
                log.error("\tstatus reason: " + response.getStatusLine().getReasonPhrase());
                throw new RuntimeException("Can't send statistics: " + response.getStatusLine().getStatusCode() + " - " + responseString);
            }
        }
    }

    @Override
    @Transactional
    public void cleanUp() {
        this.statisticsRepository.deleteAll(RuleData.class);
    }

    @Override
    public StatisticsMessage generateMessage() {
        StatisticsMessage statisticsMessage = new StatisticsMessage();
        statisticsMessage.setInstallationData(this.getInstallationData());
        statisticsMessage.setTenant(this.getTenant());
        statisticsMessage.setData(this.getStatisticsData());
        return statisticsMessage;
    }

    private StatisticsMessage.StatisticsData getStatisticsData() {
        StatisticsMessage.StatisticsData statisticsData = new StatisticsMessage.StatisticsData();
        statisticsData.setPeriod(this.getPeriod());
        statisticsData.setFeatures(this.getFeatures());
        return statisticsData;
    }

    private Map<String, StatisticsMessage.Rules> getFeatures() {
        LinkedHashMap<String, StatisticsMessage.Rules> features = new LinkedHashMap<String, StatisticsMessage.Rules>();
        List<RuleData> rulesData = this.statisticsRepository.getAll(RuleData.class);
        this.getStatisticsClasses().forEach(clazz -> {
            StatisticsMessage.Rules rules = this.collectRules(rulesData, () -> this.getAllEntities((Class)clazz), (Class)clazz);
            if (!rules.isEmpty()) {
                features.put(this.getEntityType((Class)clazz), rules);
            }
        });
        return features;
    }

    protected abstract <T> List<T> getAllEntities(Class<T> var1);

    protected List<Class<?>> getStatisticsClasses() {
        return this.statisticsClasses;
    }

    protected abstract String[] getPackagesToScan();

    private <T> StatisticsMessage.Rules collectRules(List<RuleData> rulesData, Supplier<List<T>> configurationsSupplier, Class clazz) {
        String configurationType = this.getEntityType(clazz);
        Set<String> properties = JavaUtils.getAnnotatedProperties(clazz, StatisticsField.class);
        StatisticsMessage.Rules rules = new StatisticsMessage.Rules();
        if (CollectionUtils.isEmpty(properties) || configurationType == null) {
            log.warn("Can't find data to collect for class: {}", (Object)clazz);
            return rules;
        }
        rules.setCreated(rulesData.stream().filter(r -> configurationType.equals(r.getConfigurationType())).filter(r -> OperationListener.OperationType.CREATE.equals((Object)r.getAction())).collect(Collectors.toMap(RuleData::getRuleType, StatisticsMessage.RulesStatistics::new)));
        rules.setUpdated(rulesData.stream().filter(r -> configurationType.equals(r.getConfigurationType())).filter(r -> OperationListener.OperationType.UPDATE.equals((Object)r.getAction())).collect(Collectors.toMap(RuleData::getRuleType, StatisticsMessage.RulesStatistics::new)));
        rules.setDeleted(rulesData.stream().filter(r -> configurationType.equals(r.getConfigurationType())).filter(r -> OperationListener.OperationType.DELETE.equals((Object)r.getAction())).collect(Collectors.toMap(RuleData::getRuleType, StatisticsMessage.RulesStatistics::new)));
        List<Object> configurations = configurationsSupplier.get();
        rules.setTotal(configurations.size());
        HashMap<String, Object> propertyStatistics = new HashMap<String, Object>();
        configurations.forEach(configuration -> this.collectPropertiesStatistics(propertyStatistics, properties, configuration));
        rules.setPropertyStatistics(propertyStatistics);
        return rules;
    }

    private StatisticsMessage.Period getPeriod() {
        StatisticsMessage.Period period = new StatisticsMessage.Period();
        period.setTo(new Date());
        Optional.ofNullable(this.statisticsRepository.getByKey("META_DATA", StatisticsMetaData.class)).ifPresent(statisticsMetaData -> period.setFrom(statisticsMetaData.getLastSendDate()));
        return period;
    }

    private Tenant getTenant() {
        Tenant tenant = new Tenant();
        tenant.setApp(this.getPluginKey());
        Optional.ofNullable(this.pluginAccessor.getPlugin(this.getPluginKey())).ifPresent(plugin -> tenant.setAppVersion(plugin.getPluginInformation().getVersion()));
        StatisticsMetaData statisticsMetaData = Optional.ofNullable(this.statisticsRepository.getByKey("META_DATA", StatisticsMetaData.class)).orElseGet(() -> {
            StatisticsMetaData metaData = new StatisticsMetaData();
            metaData.setTenantId(this.tenantIdProvider.getTenantId());
            this.statisticsRepository.save(metaData);
            return metaData;
        });
        tenant.setId(statisticsMetaData.getTenantId());
        tenant.setHostAppVersion(this.applicationProperties.getVersion());
        tenant.setHostLocale(Locale.getDefault().toString());
        tenant.setDeployment("data-center");
        tenant.setHostApp(this.getHostApp());
        tenant.setLicense(this.getLicense());
        return tenant;
    }

    protected abstract String getHostApp();

    private Tenant.License getLicense() {
        Tenant.License license = new Tenant.License();
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            license.setType(pluginLicense.getLicenseType().toString());
            license.setUsers((Integer)pluginLicense.getMaximumNumberOfUsers().getOrElse((Object)0));
            license.setSupportEntitlementNumber((String)pluginLicense.getSupportEntitlementNumber().getOrElse((Object)"Unknown"));
        } else {
            license.setType("NONE");
        }
        return license;
    }

    private StatisticsMessage.InstallationData getInstallationData() {
        StatisticsMessage.InstallationData installationData = new StatisticsMessage.InstallationData();
        Optional.ofNullable(this.pluginAccessor.getPlugin(this.getPluginKey())).ifPresent(plugin -> {
            installationData.setInstalledOn(plugin.getDateInstalled());
            installationData.setEnabledOn(plugin.getDateEnabled());
        });
        return installationData;
    }

    protected abstract String getPluginKey();

    public void collectPropertiesStatistics(Map<String, Object> propertyStatistics, Set<String> properties, Object configuration) {
        if (CollectionUtils.isEmpty(properties)) {
            log.warn("Can't find properties to collect for class: " + configuration.getClass());
            return;
        }
        for (String property : properties) {
            this.propertyStatisticsCollector.collect(propertyStatistics, property, configuration);
        }
    }

    protected String getRuleType(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(StatisticsRuleLevel.class)) continue;
                field.setAccessible(true);
                Object value = field.get(obj);
                return String.valueOf(value);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (((Method)accessibleObject).getParameterCount() != 0 || !accessibleObject.isAnnotationPresent(StatisticsRuleLevel.class)) continue;
                ((Method)accessibleObject).setAccessible(true);
                Object value = ((Method)accessibleObject).invoke(obj, new Object[0]);
                return String.valueOf(value);
            }
        }
        return "GLOBAL";
    }

    @Override
    public void onOperationPerformed(Object entity, OperationListener.OperationType operationType) {
        this.addRuleStatistics(entity, operationType, ruleData -> {
            this.collectPropertiesStatistics(ruleData.getPropertyStatistics(), JavaUtils.getAnnotatedProperties(entity.getClass(), StatisticsField.class), entity);
            ruleData.setAmount(ruleData.getAmount() + 1);
        });
    }
}

