/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.service.impl;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.moveworkforward.model.PluginInfo;
import com.moveworkforward.util.HttpUtils;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class AbstractAtlassianPluginService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAtlassianPluginService.class);
    protected static final String MARKET_PLACE_URL = "https://marketplace.atlassian.com";
    private static final int SILENCE_PERIOD = 7;
    protected final String PLUGIN_URL = "https://marketplace.atlassian.com/rest/2/addons/%s";
    private final ApplicationProperties applicationProperties;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, DateTime> userClosingDates = new ConcurrentReferenceHashMap();

    @Autowired
    public AbstractAtlassianPluginService(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PluginInfo getPluginInfo(String pluginKey) {
        try {
            URI uri = new URI(String.format("https://marketplace.atlassian.com/rest/2/addons/%s", pluginKey));
            try (CloseableHttpClient client = this.createHttpClient(uri);){
                HttpGet request = new HttpGet(uri);
                CloseableHttpResponse response = client.execute(request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (200 != statusCode) {
                    throw new RuntimeException("Can't get plugin info: " + pluginKey);
                }
                String content = EntityUtils.toString(response.getEntity());
                PluginInfo pluginInfo = this.buildPluginInfo(pluginKey, content);
                return pluginInfo;
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return null;
        }
    }

    public void closeForUser(String userKey) {
        this.userClosingDates.put(userKey, new DateTime());
    }

    public void openForUser(String userKey) {
        this.userClosingDates.remove(userKey);
    }

    public boolean isDisplayForUser(String userKey) {
        DateTime closingDate = this.userClosingDates.get(userKey);
        return closingDate == null || closingDate.plusDays(7).isBefore((ReadableInstant)new DateTime());
    }

    protected CloseableHttpClient createHttpClient(URI uri) {
        return HttpUtils.createHttpClient(uri, 10);
    }

    private PluginInfo buildPluginInfo(String pluginKey, String content) {
        Map pluginInfo = (Map)this.objectMapper.readValue(content, Map.class);
        String name = (String)pluginInfo.get("name");
        String url = this.getNestedProperty(pluginInfo, Arrays.asList("_links", "alternate", "href"), s -> MARKET_PLACE_URL + s);
        url = url + "&utm_source=product&utm_medium=referral&utm_campaign=" + this.getReferenceProduct() + "&utm_content=xsel";
        String logoUrl = this.getNestedProperty(pluginInfo, Arrays.asList("_embedded", "logo", "_links", "image", "href"), null);
        String summary = (String)pluginInfo.get("summary");
        String innerLogoUrl = this.getInnerLogoUrl(pluginKey);
        return new PluginInfo(pluginKey, name, summary, url, innerLogoUrl == null ? logoUrl : innerLogoUrl);
    }

    protected abstract String getReferenceProduct();

    private String getInnerLogoUrl(String pluginKey) {
        String logoImageName = pluginKey.replaceAll("\\.", "_") + ".png";
        URL url = this.getClass().getClassLoader().getResource("images/" + logoImageName);
        if (url != null) {
            return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + this.getContextPath() + "/" + logoImageName;
        }
        return null;
    }

    protected abstract String getContextPath();

    private String getNestedProperty(Object object, List<String> paths, Function<String, String> valueTransformer) {
        if (CollectionUtils.isEmpty(paths)) {
            String result;
            String string = result = object == null ? null : object.toString();
            if (valueTransformer != null && result != null) {
                return valueTransformer.apply(result);
            }
            return result;
        }
        if (object instanceof Map) {
            return this.getNestedProperty(((Map)object).get(paths.get(0)), paths.subList(1, paths.size()), valueTransformer);
        }
        return null;
    }
}

