/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.deployments.notification.DeploymentResultAwareNotificationRecipient;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.notification.recipients.AbstractNotificationRecipient;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.descriptor.NotificationRecipientModuleDescriptor;
import com.atlassian.bamboo.results.ExtraBuildResultsData;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.sal.message.BambooI18nResolver;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.moveworkforward.bamboo.microsoftteams.notifier.BeansProvider;
import com.moveworkforward.bamboo.microsoftteams.notifier.Constants;
import com.moveworkforward.bamboo.microsoftteams.notifier.LicenseManager;
import com.moveworkforward.bamboo.microsoftteams.notifier.MicrosoftTeamsNotificationTransport;
import com.moveworkforward.bamboo.microsoftteams.notifier.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named(value="MicrosoftTeamsNotificationRecipient")
public class MicrosoftTeamsNotificationRecipient
extends AbstractNotificationRecipient
implements DeploymentResultAwareNotificationRecipient,
NotificationRecipient.RequiresPlan,
NotificationRecipient.RequiresResultSummary {
    private static final Logger log = Logger.getLogger(MicrosoftTeamsNotificationRecipient.class);
    private final LicenseManager licenseManager;
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final BeansProvider beansProvider;
    private RecipientHolder recipientHolder = new RecipientHolder();
    private ImmutablePlan plan;
    private ResultsSummary resultsSummary;
    private DeploymentResult deploymentResult;
    @ComponentImport
    private CustomVariableContext customVariableContext;
    private BambooUrl bambooUrl;

    @Inject
    public MicrosoftTeamsNotificationRecipient(BeansProvider beansProvider, @ComponentImport CustomVariableContext customVariableContext, LicenseManager licenseManager, @ComponentImport I18nBeanFactory i18nBeanFactory, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.beansProvider = beansProvider;
        this.customVariableContext = customVariableContext;
        this.licenseManager = licenseManager;
        this.i18nResolver = new BambooI18nResolver(i18nBeanFactory);
        this.bambooUrl = new BambooUrl(administrationConfigurationAccessor);
    }

    public void populate(@NotNull Map<String, String[]> params) {
        log.debug((Object)"populate::parameters");
        for (String parameter : params.keySet()) {
            log.debug((Object)("parameter " + parameter + " = " + params.get(parameter)[0]));
        }
        if (params.containsKey(Constants.WEBHOOK_URL) && params.get(Constants.WEBHOOK_URL).length > 0) {
            int i = params.get(Constants.WEBHOOK_URL).length - 1;
            this.recipientHolder.setWebhookUrl(params.get(Constants.WEBHOOK_URL)[i]);
        }
        if (params.containsKey(Constants.CHANNEL) && params.get(Constants.CHANNEL).length > 0) {
            int i = params.get(Constants.CHANNEL).length - 1;
            this.recipientHolder.setChannel(params.get(Constants.CHANNEL)[i]);
        }
        this.recipientHolder.setIncludeImage(this.getBooleanParameter(params, Constants.INCLUDE_IMAGE));
        this.recipientHolder.setEnabled(this.getBooleanParameter(params, Constants.ENABLED));
        this.recipientHolder.setIncludeArtifacts(this.getBooleanParameter(params, "msIncludeArtifacts"));
        this.recipientHolder.setBuildStarted(this.getBooleanParameter(params, "msBuildStarted"));
        this.recipientHolder.setBuildInProgress(this.getBooleanParameter(params, "msBuildInProgress"));
        this.recipientHolder.setBuildFinished(this.getBooleanParameter(params, "msBuildFinished"));
        log.debug((Object)("configuration: " + this.recipientHolder));
    }

    private boolean getBooleanParameter(Map<String, String[]> params, String paramName) {
        if (params.containsKey(paramName) && params.get(paramName).length > 0) {
            int i = params.get(paramName).length - 1;
            String value = params.get(paramName)[i];
            return "true".equals(value) || "t".equals(value);
        }
        return false;
    }

    public void init(@Nullable String configurationData) {
        this.recipientHolder = new RecipientHolder(configurationData);
        log.debug((Object)("init = " + this.recipientHolder));
    }

    @NotNull
    public String getRecipientConfig() {
        log.debug((Object)("getRecipientConfig::recipientConfig = " + this.recipientHolder.toConfigString()));
        return this.recipientHolder.toConfigString();
    }

    @NotNull
    public String getEditHtml() {
        String editTemplateLocation = ((NotificationRecipientModuleDescriptor)this.getModuleDescriptor()).getEditTemplate();
        return Objects.requireNonNull(Objects.requireNonNull(this.beansProvider.getTemplateRenderer()).render(editTemplateLocation, this.populateContext()));
    }

    private Map<String, Object> populateContext() {
        HashMap<String, Object> context = new HashMap<String, Object>(this.recipientHolder.toConfigMap());
        context.put(Constants.IS_NOT_LICENSED, !this.licenseManager.isLicensed());
        log.debug((Object)("populateContext = " + context));
        return context;
    }

    @NotNull
    public String getViewHtml() {
        String viewTemplateLocation = ((NotificationRecipientModuleDescriptor)this.getModuleDescriptor()).getViewTemplate();
        return Objects.requireNonNull(Objects.requireNonNull(this.beansProvider.getTemplateRenderer()).render(viewTemplateLocation, this.populateContext()));
    }

    @NotNull
    public List<NotificationTransport> getTransports() {
        ArrayList list = Lists.newArrayList();
        ChainResultsSummary chainResultsSummary = this.getChainResultsSummary();
        ArrayList<String> errors = new ArrayList<String>();
        if (chainResultsSummary != null && chainResultsSummary.getFailedJobResults().size() > 0) {
            chainResultsSummary.getFailedJobResults().forEach(x -> {
                ExtraBuildResultsData extraBuildResultsData = x.getExtraBuildResultsData();
                if (extraBuildResultsData != null && extraBuildResultsData.getBuildErrors().size() > 0) {
                    errors.addAll(extraBuildResultsData.getBuildErrors());
                }
            });
        }
        list.add(new MicrosoftTeamsNotificationTransport(this.recipientHolder, this.resultsSummary, this.deploymentResult, this.licenseManager, this.customVariableContext, errors, this.i18nResolver, this.bambooUrl.getBaseUrl(UrlMode.ABSOLUTE)));
        return list;
    }

    private ChainResultsSummary getChainResultsSummary() {
        if (this.resultsSummary instanceof ChainResultsSummary) {
            return (ChainResultsSummary)this.resultsSummary;
        }
        if (this.beansProvider.getResultsSummaryManager() != null) {
            return this.beansProvider.getResultsSummaryManager().getParentResultSummary(this.resultsSummary);
        }
        return null;
    }

    public void setPlan(@Nullable Plan plan) {
        this.plan = plan;
    }

    public void setPlan(@Nullable ImmutablePlan plan) {
        this.plan = plan;
    }

    public void setDeploymentResult(@Nullable DeploymentResult deploymentResult) {
        this.deploymentResult = deploymentResult;
    }

    public void setResultsSummary(@Nullable ResultsSummary resultsSummary) {
        this.resultsSummary = resultsSummary;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public static class RecipientHolder {
        public static final String DELIMITER = "|";
        private String webhookUrl = null;
        private String channel = null;
        private boolean includeImage = true;
        private boolean enabled = true;
        private boolean buildStarted = true;
        private boolean buildInProgress = true;
        private boolean buildFinished = true;
        private boolean includeArtifacts = true;

        public RecipientHolder(String recipientConfig) {
            log.debug((Object)("parse recipientConfig: " + recipientConfig));
            if (StringUtils.isNotBlank(recipientConfig)) {
                String[] configValues = recipientConfig.split("\\|");
                if (configValues.length > 0) {
                    this.webhookUrl = configValues[0];
                    log.debug((Object)("webhookUrl = " + this.webhookUrl));
                }
                if (configValues.length > 1) {
                    this.channel = configValues[1];
                    log.debug((Object)("channel = " + this.channel));
                }
                this.includeImage = RecipientHolder.flagFromString(configValues, 2);
                this.enabled = RecipientHolder.flagFromString(configValues, 3);
                this.buildStarted = RecipientHolder.flagFromString(configValues, 4);
                this.buildInProgress = RecipientHolder.flagFromString(configValues, 5);
                this.buildFinished = RecipientHolder.flagFromString(configValues, 6);
                this.includeArtifacts = RecipientHolder.flagFromString(configValues, 7);
            }
        }

        private static void addBooleanToConfig(StringBuilder recipientConfig, boolean flag) {
            recipientConfig.append(DELIMITER);
            if (!flag) {
                recipientConfig.append("f");
            }
        }

        private static boolean flagFromString(String[] configValues, int index) {
            if (configValues.length > index) {
                String value = configValues[index];
                return StringUtils.isEmpty(value) || "true".equals(value) || "t".equals(value);
            }
            return true;
        }

        public String toConfigString() {
            StringBuilder recipientConfig = new StringBuilder();
            if (StringUtils.isNotBlank(this.webhookUrl)) {
                recipientConfig.append(this.webhookUrl);
            }
            recipientConfig.append(DELIMITER);
            if (StringUtils.isNotBlank(this.channel)) {
                recipientConfig.append(this.channel);
            }
            RecipientHolder.addBooleanToConfig(recipientConfig, this.includeImage);
            RecipientHolder.addBooleanToConfig(recipientConfig, this.enabled);
            RecipientHolder.addBooleanToConfig(recipientConfig, this.buildStarted);
            RecipientHolder.addBooleanToConfig(recipientConfig, this.buildInProgress);
            RecipientHolder.addBooleanToConfig(recipientConfig, this.buildFinished);
            RecipientHolder.addBooleanToConfig(recipientConfig, this.includeArtifacts);
            recipientConfig.append(DELIMITER);
            return recipientConfig.toString();
        }

        public Map<String, Object> toConfigMap() {
            HashMap context = Maps.newHashMap();
            if (this.webhookUrl != null) {
                context.put(Constants.WEBHOOK_URL, this.webhookUrl);
            }
            if (this.channel != null) {
                context.put(Constants.CHANNEL, this.channel);
            }
            context.put(Constants.INCLUDE_IMAGE, this.includeImage);
            context.put(Constants.ENABLED, this.enabled);
            context.put("msBuildStarted", this.buildStarted);
            context.put("msBuildInProgress", this.buildInProgress);
            context.put("msBuildFinished", this.buildFinished);
            context.put("msIncludeArtifacts", this.includeArtifacts);
            return context;
        }

        @Generated
        public String getWebhookUrl() {
            return this.webhookUrl;
        }

        @Generated
        public String getChannel() {
            return this.channel;
        }

        @Generated
        public boolean isIncludeImage() {
            return this.includeImage;
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isBuildStarted() {
            return this.buildStarted;
        }

        @Generated
        public boolean isBuildInProgress() {
            return this.buildInProgress;
        }

        @Generated
        public boolean isBuildFinished() {
            return this.buildFinished;
        }

        @Generated
        public boolean isIncludeArtifacts() {
            return this.includeArtifacts;
        }

        @Generated
        public void setWebhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        @Generated
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Generated
        public void setIncludeImage(boolean includeImage) {
            this.includeImage = includeImage;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setBuildStarted(boolean buildStarted) {
            this.buildStarted = buildStarted;
        }

        @Generated
        public void setBuildInProgress(boolean buildInProgress) {
            this.buildInProgress = buildInProgress;
        }

        @Generated
        public void setBuildFinished(boolean buildFinished) {
            this.buildFinished = buildFinished;
        }

        @Generated
        public void setIncludeArtifacts(boolean includeArtifacts) {
            this.includeArtifacts = includeArtifacts;
        }

        @Generated
        public RecipientHolder() {
        }

        @Generated
        public String toString() {
            return "MicrosoftTeamsNotificationRecipient.RecipientHolder(webhookUrl=" + this.getWebhookUrl() + ", channel=" + this.getChannel() + ", includeImage=" + this.isIncludeImage() + ", enabled=" + this.isEnabled() + ", buildStarted=" + this.isBuildStarted() + ", buildInProgress=" + this.isBuildInProgress() + ", buildFinished=" + this.isBuildFinished() + ", includeArtifacts=" + this.isIncludeArtifacts() + ")";
        }
    }
}

