/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.bamboo.microsoftteams.notifier.StringUtils;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.util.TeamsPayloadUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MicrosoftTeamsEventCreator {
    private static final Logger log = Logger.getLogger(MicrosoftTeamsEventCreator.class);
    private final I18nResolver i18nResolver;
    private final ObjectMapper objectMapper = ConnectorUtil.createObjectMapper(true);

    public MicrosoftTeamsEventCreator(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public String create(Notification notification, ResultsSummary resultsSummary, DeploymentResult deploymentResult, String channel, Boolean includeImage, String baseUrl, Boolean includeArtifacts, List<String> errors) {
        String message = notification instanceof Notification.HtmlImContentProvidingNotification ? ((Notification.HtmlImContentProvidingNotification)notification).getHtmlImContent() : notification.getIMContent();
        String title = resultsSummary != null ? this.makeTitle(resultsSummary) : this.makeTitle(deploymentResult);
        MessageData messageData = new MessageData(title, this.textMessage(Jsoup.parse((String)message)), null);
        ArrayList<List<Object>> items = new ArrayList<List<Object>>();
        if (includeImage.booleanValue()) {
            String imagePath = resultsSummary != null ? this.getActivityImage(resultsSummary) : (deploymentResult != null ? this.getActivityImage(deploymentResult) : "");
            items.add(Arrays.asList(new MessageData.ImageContent(imagePath)));
        }
        if (resultsSummary != null) {
            String authors = this.getResponsibleAuthors(resultsSummary);
            if (StringUtils.isNotBlank(authors)) {
                items.add(Arrays.asList(MessageData.WidthContent.builder().text(this.i18nResolver.getText("msteams.responsible.users")).width("150px").build(), MessageData.WidthContent.builder().text(authors).build()));
            }
            if (StringUtils.isNotBlank(channel)) {
                items.add(Arrays.asList(MessageData.WidthContent.builder().text(this.i18nResolver.getText("msteams.from")).width("150px").build(), MessageData.WidthContent.builder().text(channel).build()));
            }
            if (errors != null && errors.size() > 0) {
                items.add(Arrays.asList(MessageData.WidthContent.builder().text(this.i18nResolver.getText("msteams.errors")).width("150px").build(), MessageData.WidthContent.builder().text(String.join((CharSequence)"\n\n", errors)).build()));
            }
            if (includeArtifacts.booleanValue() && !resultsSummary.getArtifactLinks().isEmpty()) {
                String artifacts = resultsSummary.getArtifactLinks().stream().map(artifactLink -> StringUtils.link(artifactLink.getLabel(), baseUrl + "/browse/" + artifactLink.getArtifact().getPlanResultKey() + "/artifact/shared/" + artifactLink.getLabel() + "/")).collect(Collectors.joining(", "));
                items.add(Arrays.asList(MessageData.WidthContent.builder().text(this.i18nResolver.getText("msteams.artifacts")).width("150px").build(), MessageData.WidthContent.builder().text(artifacts).build()));
            }
            messageData.getItems().add(new MessageData.Item("facts", "", null, null, items));
        }
        String payload = this.objectMapper.writeValueAsString((Object)TeamsPayloadUtils.createToggleableItemsMessage(messageData));
        log.info((Object)("====================== >" + payload));
        return payload;
    }

    private String getResponsibleAuthors(ResultsSummary resultsSummary) {
        Set authors = resultsSummary.getUniqueAuthors();
        if (authors != null && !authors.isEmpty()) {
            List userNames = authors.stream().map(Author::getFullName).collect(Collectors.toList());
            return String.join((CharSequence)", ", userNames);
        }
        return "";
    }

    private String getActivityImage(DeploymentResult deploymentResult) {
        if (deploymentResult != null & deploymentResult.getDeploymentState() == BuildState.FAILED) {
            return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-failed.png";
        }
        if (deploymentResult.getDeploymentState() == BuildState.SUCCESS) {
            return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-successful.png";
        }
        return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-unknown.png";
    }

    private String getActivityImage(ResultsSummary resultSummary) {
        if (resultSummary != null && resultSummary.getBuildState() == BuildState.FAILED) {
            return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-failed.png";
        }
        if (resultSummary != null && resultSummary.getBuildState() == BuildState.SUCCESS) {
            return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-successful.png";
        }
        return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-unknown.png";
    }

    private String makeTitle(ResultsSummary resultsSummary) {
        return this.i18nResolver.getText("msteams.build") + String.format(" #%d %s", resultsSummary.getBuildNumber(), this.toBuildStateMessage(resultsSummary));
    }

    private String makeTitle(DeploymentResult deploymentResult) {
        if (deploymentResult == null) {
            return "";
        }
        return this.i18nResolver.getText("msteams.deployment") + String.format(" to %s %s", deploymentResult.getEnvironment().getName(), this.toDeploymentStateMessage(deploymentResult));
    }

    private String toDeploymentStateMessage(DeploymentResult deploymentResult) {
        String result = this.i18nResolver.getText("msteams.status.unknown");
        BuildState buildState = deploymentResult.getDeploymentState();
        if (buildState == BuildState.FAILED) {
            result = this.i18nResolver.getText("msteams.status.failed");
        } else if (buildState == BuildState.SUCCESS) {
            result = this.i18nResolver.getText("msteams.status.successful");
        } else if (LifeCycleState.isActive((LifeCycleState)deploymentResult.getLifeCycleState())) {
            result = this.i18nResolver.getText("msteams.status.in.progress");
        }
        return result;
    }

    private String toBuildStateMessage(ResultsSummary resultSummary) {
        String result = this.i18nResolver.getText("msteams.status.unknown");
        BuildState buildState = resultSummary.getBuildState();
        if (buildState == BuildState.FAILED) {
            result = this.i18nResolver.getText("msteams.status.failed");
        } else if (buildState == BuildState.SUCCESS) {
            result = this.i18nResolver.getText("msteams.status.successful");
        } else if (LifeCycleState.isActive((LifeCycleState)resultSummary.getLifeCycleState())) {
            result = this.i18nResolver.getText("msteams.status.in.progress");
        }
        return result;
    }

    private String textMessage(Document doc) {
        Elements links = doc.getElementsByTag("a");
        String resultMessage = doc.body().text().trim();
        for (Element link : links) {
            String linkHref = link.attr("href");
            String linkText = link.text();
            resultMessage = resultMessage.replace(linkText, "[" + linkText + "](" + linkHref + ")");
        }
        return resultMessage.replace("\n", "").replace("\u00a0", "").replace("&nbsp;", "").replace("+", "\\+").trim();
    }

    public String create(String message, CommonTaskContext taskContext) {
        String text = message;
        if (taskContext instanceof TaskContext) {
            text = ((TaskContext)taskContext).getBuildContext().getDisplayName();
        } else if (taskContext instanceof DeploymentTaskContext) {
            text = ((DeploymentTaskContext)taskContext).getDeploymentContext().getDisplayName();
        }
        MessageData messageData = new MessageData(message, text, null);
        return this.objectMapper.writeValueAsString((Object)TeamsPayloadUtils.createToggleableItemsMessage(messageData));
    }
}

