/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.service.impl;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.ao.impl.AppVersionRepository;
import com.moveworkforward.model.AppVersion;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.util.HttpUtils;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppVersionService {
    private static final Logger log = LoggerFactory.getLogger(AppVersionService.class);
    private static final String PRODUCT_VERSION_URL = "https://my.atlassian.com/download/feeds/current/%s.json";
    private static final String MARKET_PLACE_URL = "https://marketplace.atlassian.com";
    private static final String PLUGIN_VERSION_URL = "https://marketplace.atlassian.com/rest/2/addons/%s?withVersion=true";
    private static final String PRODUCT_WRAPPER_PREFIX = "downloads(";
    private static final String PRODUCT_WRAPPER_SUFFIX = ")";
    private final ApplicationProperties applicationProperties;
    private final ObjectMapper objectMapper = ConnectorUtil.createObjectMapper(true);
    private final AppVersionRepository repository;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public AppVersionService(AppVersionRepository repository, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginAccessor pluginAccessor) {
        this.applicationProperties = applicationProperties;
        this.repository = repository;
        this.pluginAccessor = pluginAccessor;
    }

    public AppVersion getLastNotifiedOrInstalledProductVersion(String product) {
        return this.getMostRecentVersion(product, () -> {
            String currentPlatformId = this.applicationProperties.getPlatformId();
            if (this.getProduct(product).equals(this.getProduct(currentPlatformId))) {
                return new AppVersion(product, StringUtils.capitalize((String)product), this.applicationProperties.getVersion());
            }
            return null;
        });
    }

    public AppVersion getLastAvailableProductVersion(String product) {
        AppVersion appVersion;
        block9: {
            URI uri = new URI(String.format(PRODUCT_VERSION_URL, this.getProduct(product)));
            CloseableHttpClient client = HttpUtils.createHttpClient(uri);
            try {
                HttpGet request = new HttpGet(uri);
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (200 != statusCode) {
                    throw new RuntimeException("Can't get product version: " + product);
                }
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                appVersion = this.buildProductVersion(product, content);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return new AppVersion(product);
                }
            }
            client.close();
        }
        return appVersion;
    }

    private AppVersion buildProductVersion(String product, String content) {
        AppVersion appVersion = new AppVersion(product);
        if (content.length() > PRODUCT_WRAPPER_PREFIX.length()) {
            content = content.substring(PRODUCT_WRAPPER_PREFIX.length(), content.length() - PRODUCT_WRAPPER_SUFFIX.length());
            List productVersions = (List)this.objectMapper.readValue(content, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            appVersion.setName(StringUtils.capitalize((String)product));
            if (productVersions.size() > 0) {
                String version = (String)((Map)productVersions.get(0)).get("version");
                String releaseNotesUrl = (String)((Map)productVersions.get(0)).get("releaseNotes");
                appVersion.setVersion(version);
                appVersion.setUrl(releaseNotesUrl);
            }
        }
        return appVersion;
    }

    public AppVersion getLastNotifiedOrInstalledPluginVersion(String pluginKey) {
        return this.getMostRecentVersion(pluginKey, () -> {
            try {
                Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
                if (plugin != null) {
                    return new AppVersion(pluginKey, plugin.getName(), plugin.getPluginInformation().getVersion());
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    public AppVersion getLastAvailablePluginVersion(String pluginKey) {
        AppVersion appVersion;
        block9: {
            URI uri = new URI(String.format(PLUGIN_VERSION_URL, pluginKey));
            CloseableHttpClient client = HttpUtils.createHttpClient(uri);
            try {
                HttpGet request = new HttpGet(uri);
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (200 != statusCode) {
                    throw new RuntimeException("Can't get plugin version: " + pluginKey);
                }
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                appVersion = this.buildPluginVersion(pluginKey, content);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return new AppVersion(pluginKey);
                }
            }
            client.close();
        }
        return appVersion;
    }

    private AppVersion buildPluginVersion(String pluginKey, String content) {
        Map pluginInfo = (Map)this.objectMapper.readValue(content, Map.class);
        String name = (String)pluginInfo.get("name");
        String url = Optional.ofNullable(pluginInfo.get("_links")).map(o -> ((Map)o).get("alternate")).map(o -> MARKET_PLACE_URL + ((Map)o).get("href")).orElse(null);
        Map versionInfo = (Map)((Map)pluginInfo.get("_embedded")).get("version");
        String version = (String)versionInfo.get("name");
        String releaseSummary = Optional.ofNullable(versionInfo.get("text")).map(o -> ((Map)o).get("releaseSummary")).orElse(null);
        return new AppVersion(pluginKey, name, version, releaseSummary, url);
    }

    private AppVersion getMostRecentVersion(String key, Supplier<AppVersion> installedVersionSupplier) {
        AppVersion notifiedVersion = this.get(key);
        AppVersion installedVersion = installedVersionSupplier.get();
        notifiedVersion = notifiedVersion == null ? new AppVersion(key) : notifiedVersion;
        installedVersion = installedVersion == null ? new AppVersion(key) : installedVersion;
        return notifiedVersion.compareTo(installedVersion) < 0 ? installedVersion : notifiedVersion;
    }

    public String getProduct(String platformId) {
        switch (platformId) {
            case "jira": {
                return "jira-core";
            }
            case "bitbucket": {
                return "stash";
            }
            case "conf": {
                return "confluence";
            }
        }
        return platformId;
    }

    public List<AppVersion> getAll() {
        return this.repository.getAll();
    }

    public int deleteAll() {
        return this.repository.deleteAll();
    }

    public AppVersion get(String key) {
        return (AppVersion)this.repository.getByKey(key);
    }

    public AppVersion delete(String key) {
        return (AppVersion)this.repository.deleteByKey(key);
    }

    public AppVersion save(AppVersion appVersion) {
        return this.repository.save(appVersion);
    }
}

