/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.Delivery;
import com.moveworkforward.model.Product;
import com.moveworkforward.model.UpdateConfiguration;
import com.moveworkforward.util.DayTimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect
public class AbstractApplicationUpdateConfiguration<D extends BaseDestination>
extends AbstractPluginEntity
implements UpdateConfiguration<D> {
    protected String key;
    protected Delivery delivery;
    protected String name;
    protected List<D> destinations = new ArrayList<D>();
    protected List<UpdateConfiguration.PluginSource> plugins = new ArrayList<UpdateConfiguration.PluginSource>();
    protected boolean onlyMajorVersion;
    protected List<Product> products = new ArrayList<Product>();

    @Override
    public String getKey() {
        if (StringUtils.isBlank((CharSequence)this.key)) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    @Override
    @JsonIgnore
    public String getReportTime() {
        return this.delivery == null ? "" : DayTimeUtil.getReportTime(this.delivery);
    }

    @Override
    public Delivery getDelivery() {
        return this.delivery;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<D> getDestinations() {
        return this.destinations;
    }

    @Override
    public List<UpdateConfiguration.PluginSource> getPlugins() {
        return this.plugins;
    }

    @Override
    public boolean isOnlyMajorVersion() {
        return this.onlyMajorVersion;
    }

    @Override
    public List<Product> getProducts() {
        return this.products;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDelivery(Delivery delivery) {
        this.delivery = delivery;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDestinations(List<D> destinations) {
        this.destinations = destinations;
    }

    public void setPlugins(List<UpdateConfiguration.PluginSource> plugins) {
        this.plugins = plugins;
    }

    public void setOnlyMajorVersion(boolean onlyMajorVersion) {
        this.onlyMajorVersion = onlyMajorVersion;
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }

    @Override
    public String toString() {
        return "AbstractApplicationUpdateConfiguration(super=" + super.toString() + ", key=" + this.key + ", delivery=" + this.delivery + ", name=" + this.name + ", destinations=" + this.destinations + ", plugins=" + this.plugins + ", onlyMajorVersion=" + this.onlyMajorVersion + ", products=" + this.products + ")";
    }
}

