/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.component;

import com.moveworkforward.model.MessageAudit;
import com.moveworkforward.service.MessageAuditService;
import com.moveworkforward.util.HttpUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendPayloadTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SendPayloadTask.class);
    private String payloadToSend;
    private String webhookUrl;
    private MessageAudit messageAudit;
    private MessageAuditService messageAuditService;

    public SendPayloadTask(String payloadToSend, String webhookUrl) {
        this.payloadToSend = payloadToSend;
        this.webhookUrl = webhookUrl;
    }

    public SendPayloadTask(String payloadToSend, String webhookUrl, MessageAudit messageAudit, MessageAuditService messageAuditService) {
        this.payloadToSend = payloadToSend;
        this.webhookUrl = webhookUrl;
        this.messageAudit = messageAudit;
        this.messageAuditService = messageAuditService;
    }

    @Override
    public void run() {
        try {
            this.sendMessage(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendMessage(boolean rethrowExceptions) throws IOException, URISyntaxException {
        this.sendMessage(rethrowExceptions, Method.POST);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendMessage(boolean rethrowExceptions, Method method) throws IOException, URISyntaxException {
        try {
            URI uri = new URI(this.webhookUrl);
            try (CloseableHttpClient client = HttpUtils.createHttpClient(uri);){
                HttpPost requestBase = Method.POST.equals((Object)method) ? this.setupPostMethod(this.webhookUrl) : this.setupDeleteMethod(this.webhookUrl);
                log.debug("Url: " + requestBase.getURI().toString());
                if (requestBase.getURI().toString().length() == 0) {
                    log.error("Url was not configured, won't try to send notification");
                    int n2 = 0;
                    return n2;
                }
                CloseableHttpResponse response = client.execute((HttpUriRequest)requestBase);
                log.debug(">>>>>>>>>>>> Request was sent");
                HttpEntity entity = response.getEntity();
                String content = EntityUtils.toString((HttpEntity)entity);
                log.debug("-------- Response --------\n");
                log.debug("Status code: " + response.getStatusLine().getStatusCode());
                log.debug("Response content: ");
                log.debug(content);
                if (response.getStatusLine().getStatusCode() >= 400) {
                    if (response.getStatusLine().getStatusCode() == 429) {
                        log.warn("Rate limited: too many requests.");
                    }
                    log.warn("Error response");
                    log.warn(content);
                }
                this.saveAudit(response.getStatusLine().getStatusCode() >= 300 ? content : null);
                int n = response.getStatusLine().getStatusCode();
                return n;
            }
        }
        catch (Exception e) {
            if (rethrowExceptions) {
                throw e;
            }
            this.saveAudit(e);
            log.error("Error (URISyntaxException) using API: " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    private void saveAudit(String error) {
        if (this.messageAudit == null || this.messageAuditService == null) {
            return;
        }
        if (error != null) {
            this.messageAudit.setError(error);
        }
        this.messageAuditService.save(this.messageAudit);
    }

    private void saveAudit(Exception e) {
        if (this.messageAudit == null || this.messageAuditService == null) {
            return;
        }
        if (e != null) {
            this.messageAudit.setException(e);
        }
        this.messageAuditService.save(this.messageAudit);
    }

    private HttpPost setupPostMethod(String webhookUrl) throws URISyntaxException {
        HttpPost result = new HttpPost(new URI(webhookUrl));
        result.addHeader("Content-Type", "application/json");
        result.setEntity((HttpEntity)new ByteArrayEntity(this.payloadToSend.getBytes(StandardCharsets.UTF_8)));
        log.debug("Headers: " + result.getEntity().toString());
        return result;
    }

    private HttpRequestBase setupDeleteMethod(String webhookUrl) throws URISyntaxException {
        HttpDelete result = new HttpDelete(new URI(webhookUrl + "/" + this.payloadToSend));
        result.addHeader("Content-Type", "application/json");
        return result;
    }

    public static enum Method {
        POST,
        DELETE;

    }
}

