/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.rest;

import com.google.gson.GsonBuilder;
import com.moveworkforward.model.MessageAudit;
import com.moveworkforward.service.MessageAuditService;
import java.io.BufferedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMessageAuditController {
    protected static final boolean CHECK_PERMISSIONS = true;
    private final MessageAuditService messageAuditService;

    @Autowired
    public AbstractMessageAuditController(MessageAuditService messageAuditService) {
        this.messageAuditService = messageAuditService;
    }

    @GET
    public List<MessageAudit> getAll() {
        return this.messageAuditService.getAll(true);
    }

    @GET
    @Path(value="/{tag}")
    public List<MessageAudit> getAll(@PathParam(value="tag") String tag) {
        return this.messageAuditService.getByTag(tag, true);
    }

    @Path(value="/download")
    @GET
    @Produces(value={"application/octet-stream"})
    public Response download() {
        List<MessageAudit> data = this.messageAuditService.getAll(true);
        String content = new GsonBuilder().setPrettyPrinting().create().toJson(data);
        StreamingOutput streamingOutput = outputStream -> {
            ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(outputStream));
            zipOut.putNextEntry(new ZipEntry("content.json"));
            zipOut.write(content.getBytes(StandardCharsets.UTF_8));
            zipOut.closeEntry();
            zipOut.close();
            outputStream.flush();
            outputStream.close();
        };
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)"attachment; filename=\"message-audit.zip\"").build();
    }

    @DELETE
    public int deleteAll() {
        return this.messageAuditService.deleteAll(true);
    }
}

