/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.rest;

import com.google.gson.GsonBuilder;
import com.moveworkforward.model.ConfigurationAudit;
import com.moveworkforward.service.ConfigurationAuditService;
import java.io.BufferedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractConfigurationAuditController {
    private final ConfigurationAuditService configurationAuditService;

    @Autowired
    public AbstractConfigurationAuditController(ConfigurationAuditService configurationAuditService) {
        this.configurationAuditService = configurationAuditService;
    }

    @GET
    public List<ConfigurationAudit> getAll(@QueryParam(value="entityType") String entityType, @QueryParam(value="operationType") String operationType) {
        return this.configurationAuditService.getByEntityAndOperation(entityType, operationType);
    }

    @Path(value="/download")
    @GET
    @Produces(value={"application/octet-stream"})
    public Response download() {
        List<ConfigurationAudit> data = this.configurationAuditService.getAll();
        String content = new GsonBuilder().setPrettyPrinting().create().toJson(data);
        StreamingOutput streamingOutput = outputStream -> {
            ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(outputStream));
            zipOut.putNextEntry(new ZipEntry("content.json"));
            zipOut.write(content.getBytes(StandardCharsets.UTF_8));
            zipOut.closeEntry();
            zipOut.close();
            outputStream.flush();
            outputStream.close();
        };
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)"attachment; filename=\"message-audit.zip\"").build();
    }

    @DELETE
    public int deleteAll() {
        return this.configurationAuditService.deleteAll();
    }

    @DELETE
    @Path(value="/{entityType}")
    public int deleteByEntityType(@PathParam(value="entityType") String entityType) {
        return this.configurationAuditService.deleteByEntityType(entityType).size();
    }
}

