/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.moveworkforward.model.UserAuth;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class TenantAuth {
    private final String hosting = "server";
    private Product product;
    private Application app;
    private Tenant tenant;
    private Date lastModifiedAt;
    private Mapping mapping;

    TenantAuth(Product product, Application app, Tenant tenant, Date lastModifiedAt, Mapping mapping) {
        this.product = product;
        this.app = app;
        this.tenant = tenant;
        this.lastModifiedAt = lastModifiedAt;
        this.mapping = mapping;
    }

    public static TenantAuthBuilder builder() {
        return new TenantAuthBuilder();
    }

    public String getHosting() {
        return this.hosting;
    }

    public Product getProduct() {
        return this.product;
    }

    public Application getApp() {
        return this.app;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public Date getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public void setApp(Application app) {
        this.app = app;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public void setLastModifiedAt(Date lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantAuth)) {
            return false;
        }
        TenantAuth other = (TenantAuth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hosting = this.getHosting();
        String other$hosting = other.getHosting();
        if (this$hosting == null ? other$hosting != null : !this$hosting.equals(other$hosting)) {
            return false;
        }
        Product this$product = this.getProduct();
        Product other$product = other.getProduct();
        if (this$product == null ? other$product != null : !((Object)this$product).equals(other$product)) {
            return false;
        }
        Application this$app = this.getApp();
        Application other$app = other.getApp();
        if (this$app == null ? other$app != null : !((Object)this$app).equals(other$app)) {
            return false;
        }
        Tenant this$tenant = this.getTenant();
        Tenant other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !((Object)this$tenant).equals(other$tenant)) {
            return false;
        }
        Date this$lastModifiedAt = this.getLastModifiedAt();
        Date other$lastModifiedAt = other.getLastModifiedAt();
        if (this$lastModifiedAt == null ? other$lastModifiedAt != null : !((Object)this$lastModifiedAt).equals(other$lastModifiedAt)) {
            return false;
        }
        Mapping this$mapping = this.getMapping();
        Mapping other$mapping = other.getMapping();
        return !(this$mapping == null ? other$mapping != null : !((Object)this$mapping).equals(other$mapping));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenantAuth;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hosting = this.getHosting();
        result = result * 59 + ($hosting == null ? 43 : $hosting.hashCode());
        Product $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : ((Object)$product).hashCode());
        Application $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : ((Object)$app).hashCode());
        Tenant $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : ((Object)$tenant).hashCode());
        Date $lastModifiedAt = this.getLastModifiedAt();
        result = result * 59 + ($lastModifiedAt == null ? 43 : ((Object)$lastModifiedAt).hashCode());
        Mapping $mapping = this.getMapping();
        result = result * 59 + ($mapping == null ? 43 : ((Object)$mapping).hashCode());
        return result;
    }

    public String toString() {
        return "TenantAuth(hosting=" + this.getHosting() + ", product=" + this.getProduct() + ", app=" + this.getApp() + ", tenant=" + this.getTenant() + ", lastModifiedAt=" + this.getLastModifiedAt() + ", mapping=" + this.getMapping() + ")";
    }

    public static class TenantAuthBuilder {
        private Product product;
        private Application app;
        private Tenant tenant;
        private Date lastModifiedAt;
        private Mapping mapping;

        TenantAuthBuilder() {
        }

        public TenantAuthBuilder product(Product product) {
            this.product = product;
            return this;
        }

        public TenantAuthBuilder app(Application app) {
            this.app = app;
            return this;
        }

        public TenantAuthBuilder tenant(Tenant tenant) {
            this.tenant = tenant;
            return this;
        }

        public TenantAuthBuilder lastModifiedAt(Date lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public TenantAuthBuilder mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public TenantAuth build() {
            return new TenantAuth(this.product, this.app, this.tenant, this.lastModifiedAt, this.mapping);
        }

        public String toString() {
            return "TenantAuth.TenantAuthBuilder(product=" + this.product + ", app=" + this.app + ", tenant=" + this.tenant + ", lastModifiedAt=" + this.lastModifiedAt + ", mapping=" + this.mapping + ")";
        }
    }

    @JsonAutoDetect
    public static class Mapping {
        private String verificationCode;
        private String microsoftTeamsTenantId;
        private Date mappedAt;
        private UserAuth.User mappedBy;

        public String getVerificationCode() {
            return this.verificationCode;
        }

        public String getMicrosoftTeamsTenantId() {
            return this.microsoftTeamsTenantId;
        }

        public Date getMappedAt() {
            return this.mappedAt;
        }

        public UserAuth.User getMappedBy() {
            return this.mappedBy;
        }

        public void setVerificationCode(String verificationCode) {
            this.verificationCode = verificationCode;
        }

        public void setMicrosoftTeamsTenantId(String microsoftTeamsTenantId) {
            this.microsoftTeamsTenantId = microsoftTeamsTenantId;
        }

        public void setMappedAt(Date mappedAt) {
            this.mappedAt = mappedAt;
        }

        public void setMappedBy(UserAuth.User mappedBy) {
            this.mappedBy = mappedBy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mapping)) {
                return false;
            }
            Mapping other = (Mapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$verificationCode = this.getVerificationCode();
            String other$verificationCode = other.getVerificationCode();
            if (this$verificationCode == null ? other$verificationCode != null : !this$verificationCode.equals(other$verificationCode)) {
                return false;
            }
            String this$microsoftTeamsTenantId = this.getMicrosoftTeamsTenantId();
            String other$microsoftTeamsTenantId = other.getMicrosoftTeamsTenantId();
            if (this$microsoftTeamsTenantId == null ? other$microsoftTeamsTenantId != null : !this$microsoftTeamsTenantId.equals(other$microsoftTeamsTenantId)) {
                return false;
            }
            Date this$mappedAt = this.getMappedAt();
            Date other$mappedAt = other.getMappedAt();
            if (this$mappedAt == null ? other$mappedAt != null : !((Object)this$mappedAt).equals(other$mappedAt)) {
                return false;
            }
            UserAuth.User this$mappedBy = this.getMappedBy();
            UserAuth.User other$mappedBy = other.getMappedBy();
            return !(this$mappedBy == null ? other$mappedBy != null : !((Object)this$mappedBy).equals(other$mappedBy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $verificationCode = this.getVerificationCode();
            result = result * 59 + ($verificationCode == null ? 43 : $verificationCode.hashCode());
            String $microsoftTeamsTenantId = this.getMicrosoftTeamsTenantId();
            result = result * 59 + ($microsoftTeamsTenantId == null ? 43 : $microsoftTeamsTenantId.hashCode());
            Date $mappedAt = this.getMappedAt();
            result = result * 59 + ($mappedAt == null ? 43 : ((Object)$mappedAt).hashCode());
            UserAuth.User $mappedBy = this.getMappedBy();
            result = result * 59 + ($mappedBy == null ? 43 : ((Object)$mappedBy).hashCode());
            return result;
        }

        public String toString() {
            return "TenantAuth.Mapping(verificationCode=" + this.getVerificationCode() + ", microsoftTeamsTenantId=" + this.getMicrosoftTeamsTenantId() + ", mappedAt=" + this.getMappedAt() + ", mappedBy=" + this.getMappedBy() + ")";
        }

        public Mapping(String verificationCode, String microsoftTeamsTenantId, Date mappedAt, UserAuth.User mappedBy) {
            this.verificationCode = verificationCode;
            this.microsoftTeamsTenantId = microsoftTeamsTenantId;
            this.mappedAt = mappedAt;
            this.mappedBy = mappedBy;
        }
    }

    @JsonAutoDetect
    public static class Tenant {
        private String tenantId;
        private String publicKey;
        private String privateKey;
        private final String consumerKey = "OauthKey";

        public String getTenantId() {
            return this.tenantId;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getConsumerKey() {
            return this.consumerKey;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tenant)) {
                return false;
            }
            Tenant other = (Tenant)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tenantId = this.getTenantId();
            String other$tenantId = other.getTenantId();
            if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                return false;
            }
            String this$publicKey = this.getPublicKey();
            String other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            String this$privateKey = this.getPrivateKey();
            String other$privateKey = other.getPrivateKey();
            if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
                return false;
            }
            String this$consumerKey = this.getConsumerKey();
            String other$consumerKey = other.getConsumerKey();
            return !(this$consumerKey == null ? other$consumerKey != null : !this$consumerKey.equals(other$consumerKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tenant;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tenantId = this.getTenantId();
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            String $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            String $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            String $consumerKey = this.getConsumerKey();
            result = result * 59 + ($consumerKey == null ? 43 : $consumerKey.hashCode());
            return result;
        }

        public String toString() {
            return "TenantAuth.Tenant(tenantId=" + this.getTenantId() + ", publicKey=" + this.getPublicKey() + ", privateKey=" + this.getPrivateKey() + ", consumerKey=" + this.getConsumerKey() + ")";
        }

        public Tenant(String tenantId, String publicKey, String privateKey) {
            this.tenantId = tenantId;
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }
    }

    @JsonAutoDetect
    public static class License {
        private boolean valid;

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof License)) {
                return false;
            }
            License other = (License)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isValid() == other.isValid();
        }

        protected boolean canEqual(Object other) {
            return other instanceof License;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isValid() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "TenantAuth.License(valid=" + this.isValid() + ")";
        }

        public License(boolean valid) {
            this.valid = valid;
        }
    }

    @JsonAutoDetect
    public static class Application {
        private String name;
        private String version;
        private License license;

        public Application(String name, String version, boolean licenseValid) {
            this.name = name;
            this.version = version;
            this.license = new License(licenseValid);
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public License getLicense() {
            return this.license;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setLicense(License license) {
            this.license = license;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Application)) {
                return false;
            }
            Application other = (Application)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            License this$license = this.getLicense();
            License other$license = other.getLicense();
            return !(this$license == null ? other$license != null : !((Object)this$license).equals(other$license));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Application;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            License $license = this.getLicense();
            result = result * 59 + ($license == null ? 43 : ((Object)$license).hashCode());
            return result;
        }

        public String toString() {
            return "TenantAuth.Application(name=" + this.getName() + ", version=" + this.getVersion() + ", license=" + this.getLicense() + ")";
        }

        public Application(String name, String version, License license) {
            this.name = name;
            this.version = version;
            this.license = license;
        }
    }

    @JsonAutoDetect
    public static class Product {
        private final String type;
        private String version;
        private String baseUrl;

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Product)) {
                return false;
            }
            Product other = (Product)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$baseUrl = this.getBaseUrl();
            String other$baseUrl = other.getBaseUrl();
            return !(this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Product;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $baseUrl = this.getBaseUrl();
            result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
            return result;
        }

        public String toString() {
            return "TenantAuth.Product(type=" + this.getType() + ", version=" + this.getVersion() + ", baseUrl=" + this.getBaseUrl() + ")";
        }

        public Product(String type, String version, String baseUrl) {
            this.type = type;
            this.version = version;
            this.baseUrl = baseUrl;
        }
    }
}

