/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.bamboo.microsoftteams.notifier.Constants;
import com.moveworkforward.bamboo.microsoftteams.notifier.LicenseManager;
import com.moveworkforward.bamboo.microsoftteams.notifier.MicrosoftTeamsEventCreator;
import com.moveworkforward.bamboo.microsoftteams.notifier.PayloadSender;
import org.apache.log4j.Logger;

public class MicrosoftTeamsTaskExecutor {
    private static final Logger log = Logger.getLogger(MicrosoftTeamsTaskExecutor.class);
    private final CommonTaskContext taskContext;
    private final TaskResultBuilder resultBuilder;
    private final I18nResolver i18nResolver;
    private final LicenseManager licenseManager;

    public MicrosoftTeamsTaskExecutor(CommonTaskContext taskContext, I18nResolver i18nResolver, LicenseManager licenseManager) {
        this.taskContext = taskContext;
        this.resultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        this.i18nResolver = i18nResolver;
        this.licenseManager = licenseManager;
    }

    public TaskResult execute() {
        try {
            if (this.licenseManager != null && !this.licenseManager.isLicensed()) {
                log.error((Object)"You don't have valid licence for Microsoft Teams Bamboo Connector.");
                this.taskContext.getBuildLogger().addErrorLogEntry("You don't have valid licence for Microsoft Teams Bamboo Connector.");
            } else {
                this.taskContext.getBuildLogger().addBuildLogEntry("Task Microsoft Teams started.");
                String message = (String)this.taskContext.getConfigurationMap().get((Object)"msMessage");
                String webhookUrl = (String)this.taskContext.getConfigurationMap().get((Object)Constants.WEBHOOK_URL);
                this.taskContext.getBuildLogger().addBuildLogEntry("Sending Microsoft Teams notification...");
                new PayloadSender().send(webhookUrl, new MicrosoftTeamsEventCreator(this.i18nResolver).create(message, this.taskContext));
                this.taskContext.getBuildLogger().addBuildLogEntry("Microsoft Teams notification sent.");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.taskContext.getBuildLogger().addErrorLogEntry("Failed to execute task Microsoft Teams notification: " + e.getMessage());
            this.resultBuilder.failedWithError();
        }
        return this.resultBuilder.build();
    }
}

