/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.bamboo.microsoftteams.notifier.AbstractChainAction;
import com.moveworkforward.bamboo.microsoftteams.notifier.StringUtils;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.util.TeamsPayloadUtils;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class MicrosoftTeamsChainActionCreator {
    private static final Logger log = Logger.getLogger(AbstractChainAction.class);
    private final I18nResolver i18nResolver;
    private final BambooUrl bambooUrl;
    private final ObjectMapper objectMapper = ConnectorUtil.createObjectMapper(true);

    public MicrosoftTeamsChainActionCreator(I18nResolver i18nResolver, BambooUrl bambooUrl) {
        this.i18nResolver = i18nResolver;
        this.bambooUrl = bambooUrl;
    }

    public String createContent(BuildContext buildContext, ChainResultsSummary chainResultSummary, AbstractChainAction.Notification notification, String channel) {
        String title = this.makeTitle((ResultsSummary)chainResultSummary, notification);
        String text = chainResultSummary.getImmutablePlan().getLastResultKey() == null ? buildContext.getDisplayName() : StringUtils.link(buildContext.getDisplayName(), this.bambooUrl.getBaseUrl(UrlMode.ABSOLUTE) + "/browse/" + chainResultSummary.getImmutablePlan().getLastResultKey().getKey());
        text = text + " " + buildContext.getTriggerReason().getNameForSentence();
        MessageData messageData = new MessageData(title, text, null);
        ArrayList<Object> items = new ArrayList<Object>();
        String authors = this.getResponsibleAuthors((ResultsSummary)chainResultSummary);
        this.initAuthorsFact(authors, items);
        this.initJobResultFacts(chainResultSummary, items);
        this.initFromChannelFact(channel, items);
        if (!items.isEmpty()) {
            messageData.getItems().add(new MessageData.Item("facts", "", null, null, items));
        }
        String payload = this.objectMapper.writeValueAsString((Object)TeamsPayloadUtils.createToggleableItemsMessage(messageData));
        log.info((Object)("====================== >" + payload));
        return payload;
    }

    private void initFromChannelFact(String channel, List<Object> items) {
        if (StringUtils.isNotBlank(channel)) {
            items.add(Arrays.asList(MessageData.WidthContent.builder().text(this.i18nResolver.getText("msteams.from")).width("150px").build(), MessageData.WidthContent.builder().text(channel).build()));
        }
    }

    private void initJobResultFacts(ChainResultsSummary chainResultSummary, List<Object> items) {
        for (ChainStageResult result : chainResultSummary.getStageResults()) {
            for (BuildResultsSummary jobResult : result.getBuildResults()) {
                this.initJobResultFact(result.getName(), jobResult, items);
            }
        }
    }

    private void initJobResultFact(String stage, BuildResultsSummary result, List<Object> items) {
        StringBuilder status = new StringBuilder(result.getPlanName());
        if (result.getTestResultsSummary().getTotalTestCaseCount() > 0) {
            status.append(MessageFormat.format(" {0} in {1}", result.getTestSummary(), LocalTime.MIN.plusSeconds(result.getTestResultsSummary().getTotalTestDuration() / 1000L).toString()));
        }
        if (result.isFinished()) {
            status.append(String.format("(%s)", StringUtils.link(this.i18nResolver.getText("msteams.status.results"), this.bambooUrl.getBaseUrl(UrlMode.ABSOLUTE) + "/browse/" + result.getBuildResultKey())));
        }
        items.add(Arrays.asList(MessageData.WidthContent.builder().text(stage).width("150px").build(), MessageData.WidthContent.builder().text(status.toString()).build()));
    }

    private void initAuthorsFact(String authors, List<Object> items) {
        if (StringUtils.isNotBlank(authors)) {
            items.add(Arrays.asList(MessageData.WidthContent.builder().text(this.i18nResolver.getText("msteams.responsible.users")).width("150px").build(), MessageData.WidthContent.builder().text(authors).build()));
        }
    }

    private String makeTitle(ResultsSummary resultsSummary, AbstractChainAction.Notification notification) {
        return this.i18nResolver.getText("msteams.build") + String.format(" #%d %s", resultsSummary.getBuildNumber(), this.toBuildStateMessage(notification));
    }

    private String toBuildStateMessage(AbstractChainAction.Notification notification) {
        String result = this.i18nResolver.getText("msteams.status.unknown");
        switch (notification) {
            case JOB: {
                result = this.i18nResolver.getText("msteams.status.in.progress");
                break;
            }
            case STARTED: {
                result = this.i18nResolver.getText("msteams.status.started");
                break;
            }
            case FINISHED: {
                result = this.i18nResolver.getText("msteams.status.finished");
            }
        }
        return result;
    }

    private String getResponsibleAuthors(ResultsSummary resultsSummary) {
        Set authors = resultsSummary.getUniqueAuthors();
        if (authors != null && !authors.isEmpty()) {
            List userNames = authors.stream().map(Author::getFullName).collect(Collectors.toList());
            return String.join((CharSequence)", ", userNames);
        }
        return "";
    }
}

