/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.moveworkforward.bamboo.microsoftteams.notifier.Constants;
import com.moveworkforward.bamboo.microsoftteams.notifier.LicenseManager;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractMicrosoftTeamsTaskConfigurator
extends AbstractTaskConfigurator {
    protected static final Logger log = Logger.getLogger(AbstractMicrosoftTeamsTaskConfigurator.class);
    protected LicenseManager licenseManager;

    public AbstractMicrosoftTeamsTaskConfigurator(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put(Constants.WEBHOOK_URL, params.getString(Constants.WEBHOOK_URL));
        config.put("msMessage", params.getString("msMessage"));
        return config;
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (!this.licenseManager.isLicensed()) {
            errorCollection.addError("msteams.licenseerror", "License expired");
            log.error((Object)"License expired");
        }
        this.validateFieldNotEmpty(params, Constants.WEBHOOK_URL, "msteams.fieldempty", errorCollection);
        this.validateFieldNotEmpty(params, "msMessage", "msteams.fieldempty", errorCollection);
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(Constants.WEBHOOK_URL, "");
        context.put("msMessage", "");
        this.checkLicense(context);
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put(Constants.WEBHOOK_URL, taskDefinition.getConfiguration().get(Constants.WEBHOOK_URL));
        context.put("msMessage", taskDefinition.getConfiguration().get("msMessage"));
        this.checkLicense(context);
    }

    public void populateContextForView(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        context.put(Constants.WEBHOOK_URL, taskDefinition.getConfiguration().get(Constants.WEBHOOK_URL));
        context.put("msMessage", taskDefinition.getConfiguration().get("msMessage"));
        this.checkLicense(context);
    }

    private void validateFieldNotEmpty(ActionParametersMap params, String fieldName, String errorFieldName, ErrorCollection errorCollection) {
        if (StringUtils.isBlank((String)params.getString(fieldName))) {
            errorCollection.addError(fieldName, "The field is empty");
            log.error((Object)"The field is empty");
        }
    }

    private void checkLicense(Map<String, Object> context) {
        context.put(Constants.IS_NOT_LICENSED, !this.licenseManager.isLicensed());
    }
}

