/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.bamboo.microsoftteams.notifier.BeansProvider;
import com.moveworkforward.bamboo.microsoftteams.notifier.LicenseManager;
import com.moveworkforward.bamboo.microsoftteams.notifier.MicrosoftTeamsChainActionCreator;
import com.moveworkforward.bamboo.microsoftteams.notifier.MicrosoftTeamsNotificationRecipient;
import com.moveworkforward.bamboo.microsoftteams.notifier.PayloadSender;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class AbstractChainAction {
    public static final String RECIPIENT_TYPE = "com.moveworkforward.bamboo.microsoft-teams-notifier:recipient.microsoftteams";
    private static final Logger log = Logger.getLogger(AbstractChainAction.class);
    private final BeansProvider beansProvider;
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final LicenseManager licenseManager;
    private final BambooUrl bambooUrl;

    public AbstractChainAction(BeansProvider beansProvider, I18nResolver i18nResolver, AdministrationConfigurationAccessor administrationConfigurationAccessor, LicenseManager licenseManager) {
        this.beansProvider = beansProvider;
        this.i18nResolver = i18nResolver;
        this.bambooUrl = new BambooUrl(administrationConfigurationAccessor);
        this.licenseManager = licenseManager;
    }

    public void sendNotification(BuildContext buildContext, ChainResultsSummary resultsSummary, Notification notification) {
        ChainResultsSummary chainResultSummary = (ChainResultsSummary)this.beansProvider.getResultsSummaryManager().getResultsSummary(buildContext.getPlanResultKey());
        if (this.licenseManager != null && !this.licenseManager.isLicensed()) {
            log.error((Object)"You don't have valid licence for Microsoft Teams Bamboo Connector.");
            return;
        }
        List notificationRules = chainResultSummary.getImmutablePlan().getNotificationSet().getNotificationRules().stream().filter(r -> "com.moveworkforward.bamboo.microsoft-teams-notifier:microsoftTeamsBuildType".equals(r.getConditionKey()) && RECIPIENT_TYPE.equals(r.getRecipientType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(notificationRules)) {
            log.debug((Object)"No rules to execute");
            return;
        }
        for (NotificationRule notificationRule : notificationRules) {
            try {
                MicrosoftTeamsNotificationRecipient.RecipientHolder recipientHolder = new MicrosoftTeamsNotificationRecipient.RecipientHolder(notificationRule.getRecipient());
                log.debug((Object)"------------- MicrosoftTeamsNotificationTransport::sendNotification --------------");
                if (!recipientHolder.isEnabled()) {
                    log.info((Object)"Notifications is disabled");
                    return;
                }
                if (this.skipNotification(notification, recipientHolder)) {
                    log.debug((Object)("Notification " + (Object)((Object)notification) + "is skipped, " + recipientHolder));
                    return;
                }
                try {
                    String content = new MicrosoftTeamsChainActionCreator(this.i18nResolver, this.bambooUrl).createContent(buildContext, chainResultSummary, notification, recipientHolder.getChannel());
                    log.debug((Object)("Microsoft Teams event => " + content));
                    new PayloadSender().send(recipientHolder.getWebhookUrl(), content);
                }
                catch (Exception e) {
                    log.error((Object)("Error using Microsoft Teams API: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error processing notification rule: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private boolean skipNotification(Notification notification, MicrosoftTeamsNotificationRecipient.RecipientHolder recipientHolder) {
        switch (notification) {
            case STARTED: {
                return !recipientHolder.isBuildStarted();
            }
            case JOB: {
                return !recipientHolder.isBuildInProgress();
            }
            case FINISHED: {
                return !recipientHolder.isBuildFinished();
            }
        }
        return false;
    }

    public static enum Notification {
        STARTED,
        JOB,
        FINISHED;

    }
}

