/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.ao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.ao.entity.PersistenceEntity;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.util.ConnectorUtil;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AbstractPluginRepository<T extends PluginEntity, K extends PersistenceEntity & Entity>
extends TypeReference<T>
implements PluginRepository<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPluginRepository.class);
    public static final int NO_LIMIT = -1;
    public static final int NO_OFFSET = -1;
    protected final ActiveObjects activeObjects;
    protected final String entityType;
    protected final Class<K> persistentClass;
    protected final TransactionTemplate transactionTemplate;
    protected ObjectMapper objectMapper = ConnectorUtil.createObjectMapper();

    public AbstractPluginRepository(ActiveObjects activeObjects, Class<K> persistentClass, TransactionTemplate transactionTemplate) {
        this.activeObjects = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
        this.transactionTemplate = transactionTemplate;
        this.entityType = this.getType() instanceof ParameterizedType ? AbstractPluginRepository.getType((Class)((ParameterizedType)this.getType()).getRawType()) : AbstractPluginRepository.getType((Class)this.getType());
        this.persistentClass = persistentClass;
    }

    public static <K> String getType(Class<K> tClass) {
        EntityType entityType = (EntityType)AnnotationUtils.findAnnotation(tClass, EntityType.class);
        return entityType == null ? tClass.getSimpleName().toUpperCase() : entityType.value();
    }

    @Override
    public String getEntityType() {
        return this.entityType;
    }

    @Override
    public T save(T entity) {
        return (T)((PluginEntity)this.transactionTemplate.execute(() -> {
            List pluginSettings;
            log.info("saving plugin setting: '{}' , type: {}", (Object)entity.getKey(), (Object)this.entityType);
            boolean newEntity = entity.getId() == null || entity.getId() == 0;
            List<Object> list = pluginSettings = newEntity ? Collections.emptyList() : Arrays.asList(this.activeObjects.find(this.persistentClass, this.idQuery(entity.getId())));
            if (!newEntity && pluginSettings.isEmpty()) {
                throw new RuntimeException("Can not update entity with id " + entity.getId() + " because it doesn't exist");
            }
            entity.setLastModified(new DateTime().withZone(DateTimeZone.UTC).toDate());
            PersistenceEntity pluginSetting = null;
            try {
                if (pluginSettings.isEmpty()) {
                    pluginSetting = (PersistenceEntity)this.activeObjects.create(this.persistentClass, this.createParams(entity));
                    log.info("New entity: '{}' has been saved", (Object)pluginSetting.getKey());
                } else {
                    T existingKey = this.doGetByKey(entity.getKey());
                    if (existingKey != null && !existingKey.getId().equals(entity.getId())) {
                        throw new RuntimeException("Key: '" + entity.getKey() + "' already exists for another id, can't be overridden");
                    }
                    pluginSetting = (PersistenceEntity)pluginSettings.get(0);
                    this.updateParams(pluginSetting, entity);
                    log.info("SettingEntity: '{}' was updated", (Object)entity.getKey());
                }
                ((RawEntity)pluginSetting).save();
            }
            catch (Exception e) {
                log.error("Can't save setting: " + entity.getKey(), (Throwable)e);
            }
            return this.convertValue(pluginSetting);
        }));
    }

    protected void updateParams(K pluginSetting, T entity) throws IOException {
        pluginSetting.setKey(entity.getKey());
        pluginSetting.setTag(entity.getTag());
        pluginSetting.setContent(this.objectMapper.writeValueAsString(entity));
    }

    protected Map<String, Object> createParams(T entity) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("TYPE", this.entityType);
        params.put("KEY", entity.getKey());
        params.put("TAG", entity.getTag());
        params.put("CONTENT", this.objectMapper.writeValueAsString(entity));
        return params;
    }

    @Override
    public T get(int id) {
        return (T)((PluginEntity)this.transactionTemplate.execute(() -> {
            log.info("Get entity by id: {} , type: {}", (Object)id, (Object)this.entityType);
            List<RawEntity> pluginSettings = Arrays.asList(this.activeObjects.find(this.persistentClass, this.idQuery(id)));
            if (pluginSettings.isEmpty()) {
                return null;
            }
            return this.convertValue((PersistenceEntity)pluginSettings.get(0));
        }));
    }

    @Override
    public T delete(int id) {
        return (T)((PluginEntity)this.transactionTemplate.execute(() -> {
            log.info("Delete entity for id:{} , type: {}", (Object)id, (Object)this.entityType);
            List<RawEntity> pluginSettings = Arrays.asList(this.activeObjects.find(this.persistentClass, this.idQuery(id)));
            if (pluginSettings.isEmpty()) {
                log.warn("Entity with id {} is not found, nothing to delete", (Object)id);
                return null;
            }
            this.activeObjects.delete(new RawEntity[]{pluginSettings.get(0)});
            return this.convertValue((PersistenceEntity)pluginSettings.get(0));
        }));
    }

    @Override
    public T deleteByKey(String key) {
        return (T)((PluginEntity)this.transactionTemplate.execute(() -> {
            log.info("Delete entity for key: {} , type: {}", (Object)key, (Object)this.entityType);
            List<RawEntity> pluginSettings = Arrays.asList(this.activeObjects.find(this.persistentClass, Query.select().where("TYPE = ? AND KEY = ?", new Object[]{this.entityType, key})));
            if (pluginSettings.isEmpty()) {
                log.warn("Entity with key {} is not found, nothing to delete", (Object)key);
                return null;
            }
            this.activeObjects.delete(new RawEntity[]{pluginSettings.get(0)});
            return this.convertValue((PersistenceEntity)pluginSettings.get(0));
        }));
    }

    @Override
    public List<T> getAll() {
        return this.getAll(-1, -1);
    }

    @Override
    public List<T> getAll(int limit, int offset) {
        return (List)this.transactionTemplate.execute(() -> {
            log.info("Loading all entities, type: {}", (Object)this.entityType);
            Query query = Query.select().where("TYPE = ?", new Object[]{this.entityType}).limit(limit).offset(offset).order("ID ASC");
            List<RawEntity> pluginSettings = Arrays.asList(this.activeObjects.find(this.persistentClass, query));
            return pluginSettings.stream().map(x$0 -> this.convertValue((PersistenceEntity)x$0)).collect(Collectors.toList());
        });
    }

    @Override
    public int deleteAll() {
        return (Integer)this.transactionTemplate.execute(() -> {
            log.info("Delete all entities, type: {}", (Object)this.entityType);
            return this.activeObjects.deleteWithSQL(this.persistentClass, "TYPE = ?", new Object[]{this.entityType});
        });
    }

    @Override
    public List<T> deleteByTag(String tag) {
        return (List)this.transactionTemplate.execute(() -> {
            log.info("Delete entities by tag: {} , type: {}", (Object)tag, (Object)this.entityType);
            List<RawEntity> pluginSettings = Arrays.asList(this.activeObjects.find(this.persistentClass, Query.select().where("TYPE = ? AND TAG = ?", new Object[]{this.entityType, tag})));
            if (pluginSettings.isEmpty()) {
                log.info("Entity with tag {} is not found", (Object)tag);
                return new ArrayList();
            }
            this.activeObjects.delete((RawEntity[])((PersistenceEntity[])pluginSettings.toArray()));
            return pluginSettings.stream().map(x$0 -> this.convertValue((PersistenceEntity)x$0)).collect(Collectors.toList());
        });
    }

    @Override
    public List<T> getByTag(String tag) {
        return this.getByTag(tag, -1, -1);
    }

    @Override
    public List<T> getByTag(String tag, int limit, int offset) {
        return (List)this.transactionTemplate.execute(() -> {
            log.info("Get entities by tag: {} , type: {}", (Object)tag, (Object)this.entityType);
            Query query = Query.select().where("TYPE = ? AND TAG = ?", new Object[]{this.entityType, tag}).limit(limit).offset(offset);
            List<RawEntity> pluginSettings = Arrays.asList(this.activeObjects.find(this.persistentClass, query));
            if (pluginSettings.isEmpty()) {
                log.info("Entity with tag {} is not found", (Object)tag);
                return new ArrayList();
            }
            return pluginSettings.stream().map(x$0 -> this.convertValue((PersistenceEntity)x$0)).collect(Collectors.toList());
        });
    }

    @Override
    public List<T> getByTagLike(String tagPattern, int limit, int offset) {
        if (StringUtils.isBlank((CharSequence)tagPattern)) {
            return this.getAll(limit, offset);
        }
        return (List)this.transactionTemplate.execute(() -> {
            log.info("Get entities by tag like: {} , type: {}", (Object)tagPattern, (Object)this.entityType);
            Query query = Query.select().where("TYPE = ? AND TAG like ?", new Object[]{this.entityType, tagPattern}).limit(limit).offset(offset).order("ID ASC");
            List<RawEntity> pluginSettings = Arrays.asList(this.activeObjects.find(this.persistentClass, query));
            if (pluginSettings.isEmpty()) {
                log.info("Entity like tag {} is not found", (Object)tagPattern);
                return new ArrayList();
            }
            return pluginSettings.stream().map(x$0 -> this.convertValue((PersistenceEntity)x$0)).collect(Collectors.toList());
        });
    }

    @Override
    public int count(String tagPattern) {
        if (StringUtils.isBlank((CharSequence)tagPattern)) {
            return this.count();
        }
        return (Integer)this.transactionTemplate.execute(() -> {
            Query query = Query.select().where("TYPE = ? AND TAG like ?", new Object[]{this.entityType, tagPattern});
            return this.activeObjects.count(this.persistentClass, query);
        });
    }

    @Override
    public T getByKey(String key) {
        return this.doGetByKey(key);
    }

    private T doGetByKey(String key) {
        return (T)((PluginEntity)this.transactionTemplate.execute(() -> {
            log.info("Get entity by key: {} , type: {}", (Object)key, (Object)this.entityType);
            List<RawEntity> pluginSettings = Arrays.asList(this.activeObjects.find(this.persistentClass, Query.select().where("TYPE = ? AND KEY = ?", new Object[]{this.entityType, key})));
            if (pluginSettings.isEmpty()) {
                log.info("Entity with key {} is not found", (Object)key);
                return null;
            }
            if (pluginSettings.size() > 1) {
                log.warn("More than one entity is found by key: {}", (Object)key);
            }
            return this.convertValue((PersistenceEntity)pluginSettings.get(0));
        }));
    }

    @Override
    public int count() {
        return (Integer)this.transactionTemplate.execute(() -> this.activeObjects.count(this.persistentClass, Query.select().where("TYPE = ?", new Object[]{this.entityType})));
    }

    protected T convertValue(K pluginSetting) {
        if (pluginSetting == null || pluginSetting.getContent() == null) {
            return null;
        }
        PluginEntity result = (PluginEntity)this.objectMapper.readValue(pluginSetting.getContent(), (TypeReference)this);
        result.setId(pluginSetting.getID());
        return (T)result;
    }

    protected Query idQuery(Integer id) {
        return Query.select().where("TYPE = ? AND ID = ?", new Object[]{this.entityType, id});
    }
}

