/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.ao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.moveworkforward.ao.AnalyticsRepository;
import com.moveworkforward.ao.entity.AnalyticsEntity;
import com.moveworkforward.ao.impl.AbstractCachedPluginRepository;
import com.moveworkforward.model.AbstractAnalytics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalyticsRepository<T extends AbstractAnalytics>
extends AbstractCachedPluginRepository<T, AnalyticsEntity>
implements AnalyticsRepository<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAnalyticsRepository.class);

    public AbstractAnalyticsRepository(ActiveObjects activeObjects, CacheManager cacheManager, TransactionTemplate transactionTemplate) {
        super(activeObjects, cacheManager, AnalyticsEntity.class, transactionTemplate);
    }

    @Override
    public void updateCacheValue(String compositeKey, T analyticsModel) {
        this.cache.put((Object)compositeKey, Collections.singletonList(analyticsModel));
    }

    @Override
    public void saveCachedData() {
        try {
            Collection keys = this.cache.getKeys();
            Set<AbstractAnalytics> data = keys.stream().map(arg_0 -> ((Cache)this.cache).get(arg_0)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
            data.forEach(this::save);
        }
        catch (Exception e) {
            log.warn("Analytics cache has not been flushed");
        }
    }

    @Override
    public List<T> getAll() {
        Collection keys = this.cache.getKeys();
        Set data = keys.stream().map(arg_0 -> ((Cache)this.cache).get(arg_0)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        data.addAll(this.loadAll());
        return new ArrayList(data);
    }
}

