/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model.teams.payload;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.moveworkforward.model.teams.payload.AbstractBodyItem;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class Container
extends AbstractBodyItem {
    private List<AbstractBodyItem> items = new ArrayList<AbstractBodyItem>();
    private String spacing;
    private String style;
    private boolean bleed;
    private String id;
    @JsonProperty(value="isVisible")
    private boolean visible = true;

    @Override
    public String getType() {
        return "Container";
    }

    public static ContainerBuilder builder() {
        return new ContainerBuilder();
    }

    public List<AbstractBodyItem> getItems() {
        return this.items;
    }

    public String getSpacing() {
        return this.spacing;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean isBleed() {
        return this.bleed;
    }

    public String getId() {
        return this.id;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setItems(List<AbstractBodyItem> items) {
        this.items = items;
    }

    public void setSpacing(String spacing) {
        this.spacing = spacing;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setBleed(boolean bleed) {
        this.bleed = bleed;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="isVisible")
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public String toString() {
        return "Container(super=" + super.toString() + ", items=" + this.items + ", spacing=" + this.spacing + ", style=" + this.style + ", bleed=" + this.bleed + ", id=" + this.id + ", visible=" + this.visible + ")";
    }

    public Container() {
    }

    public Container(List<AbstractBodyItem> items, String spacing, String style, boolean bleed, String id, boolean visible) {
        this.items = items;
        this.spacing = spacing;
        this.style = style;
        this.bleed = bleed;
        this.id = id;
        this.visible = visible;
    }

    public static class ContainerBuilder {
        private List<AbstractBodyItem> items;
        private String spacing;
        private String style;
        private boolean bleed;
        private String id;
        private boolean visible;

        ContainerBuilder() {
        }

        public ContainerBuilder items(List<AbstractBodyItem> items) {
            this.items = items;
            return this;
        }

        public ContainerBuilder spacing(String spacing) {
            this.spacing = spacing;
            return this;
        }

        public ContainerBuilder style(String style) {
            this.style = style;
            return this;
        }

        public ContainerBuilder bleed(boolean bleed) {
            this.bleed = bleed;
            return this;
        }

        public ContainerBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="isVisible")
        public ContainerBuilder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public Container build() {
            return new Container(this.items, this.spacing, this.style, this.bleed, this.id, this.visible);
        }

        public String toString() {
            return "Container.ContainerBuilder(items=" + this.items + ", spacing=" + this.spacing + ", style=" + this.style + ", bleed=" + this.bleed + ", id=" + this.id + ", visible=" + this.visible + ")";
        }
    }
}

