/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true, value={"period"})
public class TimePeriod {
    private static final int DAYS_IN_WEEK = 7;
    private int interval;
    private TimeUnit timeUnit = TimeUnit.DAY;

    public Period getPeriod() {
        if (this.timeUnit == null) {
            throw new IllegalArgumentException("Time unit is not set");
        }
        switch (this.timeUnit) {
            case MINUTE: {
                return Period.minutes(this.interval);
            }
            case HOUR: {
                return Period.hours(this.interval);
            }
            case DAY: {
                return Period.days(this.interval);
            }
            case WEEK: {
                return Period.days(this.interval * 7);
            }
            case MONTH: {
                return Period.months(this.interval);
            }
            case YEAR: {
                return Period.years(this.interval);
            }
        }
        throw new IllegalArgumentException("Unknown time unit: " + this.timeUnit);
    }

    public boolean isSet() {
        return this.interval > 0 && this.timeUnit != null;
    }

    public int getInterval() {
        return this.interval;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String toString() {
        return "TimePeriod(super=" + super.toString() + ", interval=" + this.interval + ", timeUnit=" + this.timeUnit + ")";
    }

    public TimePeriod() {
    }

    public TimePeriod(int interval, TimeUnit timeUnit) {
        this.interval = interval;
        this.timeUnit = timeUnit;
    }

    public static enum TimeUnit {
        YEAR(DurationFieldType.years()),
        MONTH(DurationFieldType.months()),
        WEEK(DurationFieldType.weeks()),
        DAY(DurationFieldType.days()),
        HOUR(DurationFieldType.hours()),
        MINUTE(DurationFieldType.minutes());

        private final DurationFieldType durationFieldType;

        private TimeUnit(DurationFieldType durationFieldType) {
            this.durationFieldType = durationFieldType;
        }

        public DurationFieldType getDurationFieldType() {
            return this.durationFieldType;
        }
    }
}

