/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.DestinationHolder;
import com.moveworkforward.model.Source;
import com.moveworkforward.model.SourcePluginEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@JsonAutoDetect
public abstract class AbstractConfiguration<D extends BaseDestination, S extends Source>
extends AbstractPluginEntity
implements Serializable,
PluginEntity,
SourcePluginEntity,
DestinationHolder<D> {
    protected String name;
    protected List<D> destinations = new ArrayList<D>();
    protected List<S> sources = new ArrayList<S>();
    protected List<S> ignoredSources = new ArrayList<S>();
    protected List<String> users = new ArrayList<String>();
    protected List<String> ignoredUsers = new ArrayList<String>();
    protected List<String> groups = new ArrayList<String>();
    protected List<String> ignoredGroups = new ArrayList<String>();
    protected String key;

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    @JsonProperty
    public abstract String getType();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<D> getDestinations() {
        return this.destinations;
    }

    public List<S> getSources() {
        return this.sources;
    }

    public List<S> getIgnoredSources() {
        return this.ignoredSources;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public List<String> getIgnoredUsers() {
        return this.ignoredUsers;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<String> getIgnoredGroups() {
        return this.ignoredGroups;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDestinations(List<D> destinations) {
        this.destinations = destinations;
    }

    public void setSources(List<S> sources) {
        this.sources = sources;
    }

    public void setIgnoredSources(List<S> ignoredSources) {
        this.ignoredSources = ignoredSources;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public void setIgnoredUsers(List<String> ignoredUsers) {
        this.ignoredUsers = ignoredUsers;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public void setIgnoredGroups(List<String> ignoredGroups) {
        this.ignoredGroups = ignoredGroups;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String toString() {
        return "AbstractConfiguration(super=" + super.toString() + ", name=" + this.name + ", destinations=" + this.destinations + ", sources=" + this.sources + ", ignoredSources=" + this.ignoredSources + ", users=" + this.users + ", ignoredUsers=" + this.ignoredUsers + ", groups=" + this.groups + ", ignoredGroups=" + this.ignoredGroups + ", key=" + this.key + ")";
    }
}

