/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.validator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(ValidatorBuilder.class);
    private T source;
    private boolean enabled = true;
    private Map<String, Filter<?>> filters = new LinkedHashMap();
    private List<ValidatorBuilder<T>> orValidators = new ArrayList<ValidatorBuilder<T>>();
    private List<ValidatorBuilder<T>> andValidators = new ArrayList<ValidatorBuilder<T>>();
    private ValidatorBuilder<T> root = this;

    public ValidatorBuilder(T source) {
        this.source = source;
    }

    private ValidatorBuilder(T source, ValidatorBuilder<T> root) {
        this.source = source;
        this.root = root;
    }

    public ValidatorBuilder<T> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public <K> Filter<K> target(String filterName, K target) {
        Filter<K> filter = new Filter<K>(filterName, target, false);
        this.filters.put(filterName, filter);
        return filter;
    }

    public <K> Filter<K> nullableTarget(String filterName, K target) {
        Filter<K> filter = new Filter<K>(filterName, target, true);
        this.filters.put(filterName, filter);
        return filter;
    }

    public ValidatorBuilder<T> or() {
        ValidatorBuilder<T> validatorBuilder = new ValidatorBuilder<T>(this.source, this.root);
        this.orValidators.add(validatorBuilder);
        return validatorBuilder;
    }

    public ValidatorBuilder<T> and() {
        ValidatorBuilder<T> validatorBuilder = new ValidatorBuilder<T>(this.source, this.root);
        this.andValidators.add(validatorBuilder);
        return validatorBuilder;
    }

    public boolean validate() {
        boolean result = this.enabled;
        result = result && this.filters.entrySet().stream().allMatch(entry -> {
            boolean validation = ((Filter)entry.getValue()).validate();
            log.info("\"{}\" validation is {}: {}", new Object[]{entry.getKey(), validation, entry.getValue()});
            return validation;
        });
        boolean bl = result = result && this.andValidators.stream().allMatch(ValidatorBuilder::validate) || this.orValidators.stream().anyMatch(ValidatorBuilder::validate);
        if (!result) {
            log.info("Validation failed");
        }
        return result;
    }

    public String toString() {
        return "ValidatorBuilder(enabled=" + this.enabled + ", filters=" + this.filters + ", orValidators=" + this.orValidators + ")";
    }

    public T getSource() {
        return this.source;
    }

    public class Filter<R> {
        static final String NULL_TARGET = "NULL_TARGET";
        static final String NOT_NULL_TARGET = "NOT_NULL_TARGET";
        static final String EMPTY_VALUES = "EMPTY_VALUES";
        static final String NOT_EMPTY_VALUES = "NOT_EMPTY_VALUES";
        private String name;
        private R target;
        private List<R> values;
        private Function<List<R>, Boolean> additionalChecker;
        private BiFunction<R, R, Boolean> testFunction = Object::equals;
        private MatchStrategy matchStrategy = MatchStrategy.ANY;
        private Set<String> rules = new LinkedHashSet<String>();
        private String message;

        public Filter(String name, R target, boolean nullable) {
            this.name = name;
            this.target = target;
            this.rules.add(nullable ? NULL_TARGET : NOT_NULL_TARGET);
        }

        public Filter<R> values(List<R> values) {
            this.values = values;
            this.rules.add(NOT_EMPTY_VALUES);
            return this;
        }

        public Filter<R> emptyValues(List<R> values) {
            this.values = values;
            this.rules.add(EMPTY_VALUES);
            return this;
        }

        public <K> Filter<K> and(String filterName, K target) {
            return ValidatorBuilder.this.target(filterName, target);
        }

        public <K> Filter<K> andNullable(String filterName, K target) {
            return ValidatorBuilder.this.nullableTarget(filterName, target);
        }

        public <K> Filter<K> or(String filterName, K target) {
            return ValidatorBuilder.this.or().target(filterName, target);
        }

        public <K> Filter<K> orNullable(String filterName, K target) {
            return ValidatorBuilder.this.or().nullableTarget(filterName, target);
        }

        public ValidatorBuilder<T> builder() {
            return ValidatorBuilder.this;
        }

        public ValidatorBuilder<T> rootBuilder() {
            return ValidatorBuilder.this.root;
        }

        public boolean validate() {
            log.info("Start validation for: " + this);
            boolean result = this.target == null && !this.rules.contains(NOT_NULL_TARGET) || this.additionalChecker != null && this.additionalChecker.apply(this.values) != false;
            try {
                if (!result) {
                    if (MatchStrategy.NOT_IN.equals((Object)this.matchStrategy)) {
                        result = this.values == null || this.values.stream().noneMatch(s -> this.testFunction.apply(s, this.target));
                    } else if (this.rules.contains(NOT_EMPTY_VALUES)) {
                        result = this.values != null && !this.values.isEmpty() && (MatchStrategy.ALL.equals((Object)this.matchStrategy) ? this.values.stream().allMatch(s -> this.testFunction.apply(s, this.target)) : this.values.stream().anyMatch(s -> this.testFunction.apply(s, this.target)));
                    } else {
                        boolean bl = this.values == null || this.values.isEmpty() || (MatchStrategy.ALL.equals((Object)this.matchStrategy) ? this.values.stream().allMatch(s -> this.testFunction.apply(s, this.target)) : this.values.stream().anyMatch(s -> this.testFunction.apply(s, this.target))) ? true : (result = false);
                    }
                }
                if (!result) {
                    if (StringUtils.isNotEmpty((CharSequence)this.message)) {
                        log.warn(this.message);
                    } else if (MatchStrategy.NOT_IN.equals((Object)this.matchStrategy)) {
                        log.info("\"{}\" is found in {}", this.target, this.values);
                    } else {
                        log.info("\"{}\" is not found in {}", this.target, this.values);
                    }
                }
            }
            catch (Exception e) {
                log.warn("error during validation <{}> in {}", this.target, this.values);
                result = false;
            }
            return result;
        }

        public String toString() {
            return "ValidatorBuilder.Filter(name=" + this.name + ", target=" + this.target + ", values=" + this.values + ", matchStrategy=" + this.matchStrategy + ", rules=" + this.rules + ")";
        }

        public Filter<R> additionalChecker(Function<List<R>, Boolean> additionalChecker) {
            this.additionalChecker = additionalChecker;
            return this;
        }

        public Filter<R> testFunction(BiFunction<R, R, Boolean> testFunction) {
            this.testFunction = testFunction;
            return this;
        }

        public Filter<R> matchStrategy(MatchStrategy matchStrategy) {
            this.matchStrategy = matchStrategy;
            return this;
        }

        public Filter<R> message(String message) {
            this.message = message;
            return this;
        }
    }

    public static enum MatchStrategy {
        ANY,
        ALL,
        NOT_IN;

    }
}

