/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.ao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.ao.AuditRepository;
import com.moveworkforward.ao.entity.AuditEntity;
import com.moveworkforward.model.ConfigurationAudit;
import com.moveworkforward.util.ConnectorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditRepositoryImpl
implements AuditRepository {
    private static final Logger log = LoggerFactory.getLogger(AuditRepositoryImpl.class);
    protected final ActiveObjects activeObjects;
    protected final TransactionTemplate transactionTemplate;
    protected ObjectMapper objectMapper = ConnectorUtil.createObjectMapper();

    @Autowired
    public AuditRepositoryImpl(@ComponentImport @NonNull ActiveObjects activeObjects, @NonNull TransactionTemplate transactionTemplate) {
        if (activeObjects == null) {
            throw new NullPointerException("activeObjects is marked non-null but is null");
        }
        if (transactionTemplate == null) {
            throw new NullPointerException("transactionTemplate is marked non-null but is null");
        }
        this.activeObjects = activeObjects;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public ConfigurationAudit save(ConfigurationAudit entity) {
        return (ConfigurationAudit)this.transactionTemplate.execute(() -> {
            log.debug("saving auditEntity information: '{}", (Object)entity);
            entity.setLastModified(new DateTime().withZone(DateTimeZone.UTC).toDate());
            AuditEntity auditEntity = null;
            try {
                auditEntity = (AuditEntity)this.activeObjects.create(AuditEntity.class, new DBParam[]{new DBParam("ENTITY", (Object)entity.getEntityType()), new DBParam("ENTITY_ID", (Object)entity.getEntityId()), new DBParam("OPERATION_TYPE", (Object)String.valueOf((Object)entity.getOperationType())), new DBParam("LAST_MODIFIED", (Object)entity.getLastModified()), new DBParam("USER", (Object)entity.getUser()), new DBParam("CONTENT", (Object)this.objectMapper.writeValueAsString((Object)entity))});
                auditEntity.save();
            }
            catch (Exception e) {
                log.error("Can't save setting, entity type: " + entity.getEntityType() + " entity id: " + entity.getEntityId(), (Throwable)e);
            }
            return this.convertValue(auditEntity);
        });
    }

    @Override
    public List<ConfigurationAudit> getByEntityAndOperation(String entityType, String operation) {
        return (List)this.transactionTemplate.execute(() -> {
            log.info("Get entity by entity type: {} , type: {}", (Object)entityType, (Object)operation);
            List<AuditEntity> auditEntities = Arrays.asList((AuditEntity[])this.activeObjects.find(AuditEntity.class, this.getQuery(entityType, operation)));
            return auditEntities.stream().map(this::convertValue).filter(Objects::nonNull).collect(Collectors.toList());
        });
    }

    @Override
    public List<ConfigurationAudit> getAll() {
        return (List)this.transactionTemplate.execute(() -> {
            log.info("Loading all audit records");
            List<AuditEntity> pluginSettings = Arrays.asList((AuditEntity[])this.activeObjects.find(AuditEntity.class));
            return pluginSettings.stream().map(this::convertValue).collect(Collectors.toList());
        });
    }

    @Override
    public int deleteAll() {
        return (Integer)this.transactionTemplate.execute(() -> {
            log.info("Delete all audit records");
            return this.activeObjects.deleteWithSQL(AuditEntity.class, "1 = 1", new Object[0]);
        });
    }

    @Override
    public List<ConfigurationAudit> deleteByEntityType(String entityType) {
        return (List)this.transactionTemplate.execute(() -> {
            log.info("Delete audit records  by entity type: {}", (Object)entityType);
            List<AuditEntity> pluginSettings = Arrays.asList((AuditEntity[])this.activeObjects.find(AuditEntity.class, Query.select().where("ENTITY = ?", new Object[]{entityType})));
            if (pluginSettings.isEmpty()) {
                log.info("AuditEntity records with entity type {} is not found", (Object)entityType);
                return new ArrayList();
            }
            this.activeObjects.delete((RawEntity[])pluginSettings.toArray(new AuditEntity[0]));
            return pluginSettings.stream().map(this::convertValue).collect(Collectors.toList());
        });
    }

    @Override
    public int count() {
        return (Integer)this.transactionTemplate.execute(() -> this.activeObjects.count(AuditEntity.class));
    }

    protected ConfigurationAudit convertValue(AuditEntity auditEntity) {
        if (auditEntity == null || auditEntity.getContent() == null) {
            return null;
        }
        ConfigurationAudit configurationAudit = (ConfigurationAudit)this.objectMapper.readValue(auditEntity.getContent(), ConfigurationAudit.class);
        configurationAudit.setId(auditEntity.getID());
        configurationAudit.setEntityId(auditEntity.getEntityId());
        configurationAudit.setEntityType(auditEntity.getEntity());
        configurationAudit.setLastModified(auditEntity.getLastModified());
        configurationAudit.setOperationType(ConfigurationAudit.OperationType.valueOf(auditEntity.getOperationType()));
        configurationAudit.setUser(auditEntity.getUser());
        return configurationAudit;
    }

    protected Query getQuery(String entityType, String operationType) {
        Query query = Query.select().where("1 = 1", new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)entityType) && StringUtils.isNotBlank((CharSequence)operationType)) {
            query = Query.select().where("ENTITY = ? AND OPERATION_TYPE = ?", new Object[]{entityType, operationType});
        } else if (StringUtils.isNotBlank((CharSequence)entityType)) {
            query = Query.select().where("ENTITY = ?", new Object[]{entityType});
        } else if (StringUtils.isNotBlank((CharSequence)operationType)) {
            query = Query.select().where("OPERATION_TYPE = ?", new Object[]{operationType});
        }
        return query;
    }
}

