/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.service.impl;

import com.moveworkforward.ao.AuditRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.ao.impl.AbstractPluginSettingRepository;
import com.moveworkforward.model.AbstractGlobalSettings;
import com.moveworkforward.model.ConfigurationAudit;
import com.moveworkforward.service.ConfigurationAuditService;
import com.moveworkforward.service.GlobalSettingsService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractConfigurationAuditService
implements ConfigurationAuditService {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigurationAuditService.class);
    private final AuditRepository auditRepository;
    private final GlobalSettingsService<? extends AbstractGlobalSettings> globalSettingsService;

    @Autowired
    protected AbstractConfigurationAuditService(AuditRepository auditRepository, GlobalSettingsService<? extends AbstractGlobalSettings> globalSettingsService) {
        this.auditRepository = auditRepository;
        this.globalSettingsService = globalSettingsService;
    }

    @Override
    public synchronized List<ConfigurationAudit> getAll() {
        this.hasUserAdminPermissions();
        return this.auditRepository.getAll();
    }

    @Override
    public synchronized List<ConfigurationAudit> getByEntityAndOperation(String entityType, String operation) {
        this.hasUserAdminPermissions();
        return this.auditRepository.getByEntityAndOperation(entityType, operation);
    }

    @Override
    public int deleteAll() {
        this.hasUserAdminPermissions();
        return this.auditRepository.deleteAll();
    }

    @Override
    public List<ConfigurationAudit> deleteByEntityType(String entityType) {
        this.hasUserAdminPermissions();
        return this.auditRepository.deleteByEntityType(entityType);
    }

    @Override
    public ConfigurationAudit performAudit(PluginEntity configuration, ConfigurationAudit.OperationType operationType) {
        AbstractGlobalSettings globalSettings = this.globalSettingsService.get(false);
        return AbstractConfigurationAuditService.performAudit(configuration, operationType, globalSettings, this.auditRepository, this.getUser());
    }

    public static ConfigurationAudit performAudit(PluginEntity configuration, ConfigurationAudit.OperationType operationType, AbstractGlobalSettings globalSettings, AuditRepository auditRepository, String user) {
        if (configuration == null) {
            log.debug("Nothing to audit");
            return null;
        }
        if (!globalSettings.isAuditSettingsEnabled()) {
            log.debug("Configuration audit is disabled");
            return null;
        }
        ConfigurationAudit audit = new ConfigurationAudit();
        audit.setEntityId(configuration.getId());
        audit.setEntityType(AbstractPluginSettingRepository.getType(configuration.getClass()));
        audit.setConfiguration(configuration);
        audit.setLastModified(new Date());
        audit.setOperationType(operationType);
        audit.setUser(user);
        return auditRepository.save(audit);
    }

    protected abstract String getUser();

    protected abstract void hasUserAdminPermissions();
}

