/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.ConfigurationLevel;
import com.moveworkforward.model.LevelPluginEntity;
import com.moveworkforward.model.SourcePluginEntity;
import com.moveworkforward.model.User;
import com.moveworkforward.model.UserPluginEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
@EntityType(value="URL_CONFIGURATION")
public abstract class AbstractUrlConfiguration<T extends ConfigurationLevel>
extends AbstractPluginEntity
implements PluginEntity,
SourcePluginEntity,
UserPluginEntity,
LevelPluginEntity<T> {
    private String url;
    private String name;
    private User owner;
    private List<User> users = new ArrayList<User>();

    @Override
    public List<String> getUserKeys() {
        return Optional.ofNullable(this.users).map(u -> this.users.stream().map(User::getUserKey).collect(Collectors.toList())).orElse(new ArrayList());
    }

    @Override
    public void setUserKeys(List<String> userKeys) {
        this.users = CollectionUtils.isEmpty(userKeys) ? new ArrayList<User>() : userKeys.stream().map(key -> new User(null, (String)key, null)).collect(Collectors.toList());
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    @Override
    public List<User> getUsers() {
        return this.users;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setOwner(User owner) {
        this.owner = owner;
    }

    @Override
    public void setUsers(List<User> users) {
        this.users = users;
    }

    @Override
    public String toString() {
        return "AbstractUrlConfiguration(super=" + super.toString() + ", url=" + this.url + ", name=" + this.name + ", owner=" + this.owner + ", users=" + this.users + ")";
    }
}

