/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.bamboo.microsoftteams.notifier.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MicrosoftTeamsEventCreator {
    private static final Logger log = Logger.getLogger(MicrosoftTeamsEventCreator.class);
    private final I18nResolver i18nResolver;

    public MicrosoftTeamsEventCreator(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public String create(Notification notification, ResultsSummary resultsSummary, DeploymentResult deploymentResult, String channel, Boolean includeImage, String baseUrl, Boolean includeArtifacts, List<String> errors) {
        String message = notification instanceof Notification.HtmlImContentProvidingNotification ? ((Notification.HtmlImContentProvidingNotification)notification).getHtmlImContent() : notification.getIMContent();
        String title = resultsSummary != null ? this.makeTitle(resultsSummary) : this.makeTitle(deploymentResult);
        JSONObject detailsSection = new JSONObject();
        JSONArray sections = new JSONArray();
        JSONObject object = new JSONObject();
        try {
            if (includeImage.booleanValue()) {
                JSONObject activitySection = new JSONObject();
                String imagePath = resultsSummary != null ? this.getActivityImage(resultsSummary) : (deploymentResult != null ? this.getActivityImage(deploymentResult) : "");
                activitySection.put("activityTitle", (Object)this.i18nResolver.getText("msteams.build.status.update"));
                activitySection.put("activitySubtitle", (Object)this.i18nResolver.getText("msteams.bamboo.notification"));
                activitySection.put("activityText", (Object)"");
                activitySection.put("activityImage", (Object)imagePath);
                sections.put((Object)activitySection);
            }
            if (resultsSummary != null) {
                JSONArray facts = new JSONArray();
                String authors = this.getResponsibleAuthors(resultsSummary);
                if (StringUtils.isNotBlank(authors)) {
                    facts.put((Object)this.getAuthorsFact(authors));
                }
                if (StringUtils.isNotBlank(channel)) {
                    this.putFromChannelFact(facts, channel);
                }
                if (errors != null && errors.size() > 0) {
                    facts.put((Object)this.getErrorsFact(errors));
                }
                if (includeArtifacts.booleanValue() && !resultsSummary.getArtifactLinks().isEmpty()) {
                    facts.put((Object)this.getArtifactsFact(resultsSummary.getArtifactLinks(), baseUrl));
                }
                if (facts.length() > 0) {
                    detailsSection.put("facts", (Object)facts);
                    sections.put((Object)detailsSection);
                }
            }
            object.put("title", (Object)title);
            object.put("text", (Object)this.textMessage(Jsoup.parse((String)message)));
            object.put("sections", (Object)sections);
        }
        catch (JSONException e) {
            log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
        }
        log.info((Object)("====================== >" + object));
        return object.toString();
    }

    private void putFromChannelFact(JSONArray facts, String channel) throws JSONException {
        if (channel != null && channel.length() > 0) {
            JSONObject fact = new JSONObject();
            fact.put("name", (Object)this.i18nResolver.getText("msteams.from"));
            fact.put("value", (Object)channel);
            facts.put((Object)fact);
        }
    }

    private JSONObject getArtifactsFact(Collection<ArtifactLink> artifactLinks, String baseUrl) throws JSONException {
        String artifacts = artifactLinks.stream().map(artifactLink -> StringUtils.link(artifactLink.getLabel(), baseUrl + "/browse/" + artifactLink.getArtifact().getPlanResultKey() + "/artifact/shared/" + artifactLink.getLabel() + "/")).collect(Collectors.joining(", "));
        JSONObject authorsFact = new JSONObject();
        authorsFact.put("name", (Object)this.i18nResolver.getText("msteams.artifacts"));
        authorsFact.put("value", (Object)artifacts);
        return authorsFact;
    }

    private JSONObject getAuthorsFact(String authors) throws JSONException {
        JSONObject authorsFact = new JSONObject();
        authorsFact.put("name", (Object)this.i18nResolver.getText("msteams.responsible.users"));
        authorsFact.put("value", (Object)authors);
        return authorsFact;
    }

    private JSONObject getErrorsFact(List<String> errors) throws JSONException {
        JSONObject errorsFact = new JSONObject();
        errorsFact.put("name", (Object)this.i18nResolver.getText("msteams.errors"));
        errorsFact.put("value", (Object)String.join((CharSequence)"\n\n", errors));
        return errorsFact;
    }

    private String getResponsibleAuthors(ResultsSummary resultsSummary) {
        Set authors = resultsSummary.getUniqueAuthors();
        if (authors != null && !authors.isEmpty()) {
            List userNames = authors.stream().map(Author::getFullName).collect(Collectors.toList());
            return String.join((CharSequence)", ", userNames);
        }
        return "";
    }

    private String getActivityImage(DeploymentResult deploymentResult) {
        if (deploymentResult != null & deploymentResult.getDeploymentState() == BuildState.FAILED) {
            return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-failed.png";
        }
        if (deploymentResult.getDeploymentState() == BuildState.SUCCESS) {
            return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-successful.png";
        }
        return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-unknown.png";
    }

    private String getActivityImage(ResultsSummary resultSummary) {
        if (resultSummary != null && resultSummary.getBuildState() == BuildState.FAILED) {
            return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-failed.png";
        }
        if (resultSummary != null && resultSummary.getBuildState() == BuildState.SUCCESS) {
            return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-successful.png";
        }
        return "https://resources.moveworkforward.com/bamboo-microsoft-teams-connector/icon-build-unknown.png";
    }

    private String makeTitle(ResultsSummary resultsSummary) {
        return this.i18nResolver.getText("msteams.build") + String.format(" #%d %s", resultsSummary.getBuildNumber(), this.toBuildStateMessage(resultsSummary));
    }

    private String makeTitle(DeploymentResult deploymentResult) {
        if (deploymentResult == null) {
            return "";
        }
        return this.i18nResolver.getText("msteams.deployment") + String.format(" to %s %s", deploymentResult.getEnvironment().getName(), this.toDeploymentStateMessage(deploymentResult));
    }

    private String toDeploymentStateMessage(DeploymentResult deploymentResult) {
        String result = this.i18nResolver.getText("msteams.status.unknown");
        BuildState buildState = deploymentResult.getDeploymentState();
        if (buildState == BuildState.FAILED) {
            result = this.i18nResolver.getText("msteams.status.failed");
        } else if (buildState == BuildState.SUCCESS) {
            result = this.i18nResolver.getText("msteams.status.successful");
        } else if (LifeCycleState.isActive((LifeCycleState)deploymentResult.getLifeCycleState())) {
            result = this.i18nResolver.getText("msteams.status.in.progress");
        }
        return result;
    }

    private String toBuildStateMessage(ResultsSummary resultSummary) {
        String result = this.i18nResolver.getText("msteams.status.unknown");
        BuildState buildState = resultSummary.getBuildState();
        if (buildState == BuildState.FAILED) {
            result = this.i18nResolver.getText("msteams.status.failed");
        } else if (buildState == BuildState.SUCCESS) {
            result = this.i18nResolver.getText("msteams.status.successful");
        } else if (LifeCycleState.isActive((LifeCycleState)resultSummary.getLifeCycleState())) {
            result = this.i18nResolver.getText("msteams.status.in.progress");
        }
        return result;
    }

    private String textMessage(Document doc) {
        Elements links = doc.getElementsByTag("a");
        String resultMessage = doc.body().text().trim();
        for (Element link : links) {
            String linkHref = link.attr("href");
            String linkText = link.text();
            resultMessage = resultMessage.replace(linkText, "[" + linkText + "](" + linkHref + ")");
        }
        return resultMessage.replace("\n", "").replace("\u00a0", "").replace("&nbsp;", "").replace("+", "\\+").trim();
    }

    public String create(String message, CommonTaskContext taskContext) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("title", (Object)message);
        String text = message;
        if (taskContext instanceof TaskContext) {
            text = ((TaskContext)taskContext).getBuildContext().getDisplayName();
        } else if (taskContext instanceof DeploymentTaskContext) {
            text = ((DeploymentTaskContext)taskContext).getDeploymentContext().getDisplayName();
        }
        object.put("text", (Object)text);
        return object.toString();
    }
}

