/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.bamboo.microsoftteams.notifier.LicenseManager;
import com.moveworkforward.bamboo.microsoftteams.notifier.MicrosoftTeamsEventCreator;
import com.moveworkforward.bamboo.microsoftteams.notifier.MicrosoftTeamsNotificationRecipient;
import com.moveworkforward.bamboo.microsoftteams.notifier.PayloadSender;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MicrosoftTeamsNotificationTransport
implements NotificationTransport {
    private static final Logger log = Logger.getLogger(MicrosoftTeamsNotificationTransport.class);
    private final String webhookUrl;
    private final String channel;
    private final Boolean includeImage;
    private final Boolean enabled;
    private final Boolean includeArtifacts;
    @Nullable
    private final ResultsSummary resultsSummary;
    @Nullable
    private final DeploymentResult deploymentResult;
    @Nullable
    private final LicenseManager licenseManager;
    private final List<String> errors;
    private final I18nResolver i18nResolver;
    private final PayloadSender payloadSender;
    private final String baseUrl;

    public MicrosoftTeamsNotificationTransport(MicrosoftTeamsNotificationRecipient.RecipientHolder recipientHolder, @Nullable ResultsSummary resultsSummary, @Nullable DeploymentResult deploymentResult, @Nullable LicenseManager licenseManager, CustomVariableContext customVariableContext, List<String> errors, I18nResolver i18nResolver, String baseUrl) {
        this.errors = errors;
        this.webhookUrl = customVariableContext.substituteString(recipientHolder.getWebhookUrl());
        this.channel = customVariableContext.substituteString(recipientHolder.getChannel());
        this.includeImage = recipientHolder.isIncludeImage();
        this.enabled = recipientHolder.isEnabled();
        this.includeArtifacts = recipientHolder.isIncludeArtifacts();
        this.resultsSummary = resultsSummary;
        this.deploymentResult = deploymentResult;
        this.licenseManager = licenseManager;
        this.i18nResolver = i18nResolver;
        this.payloadSender = new PayloadSender();
        this.baseUrl = baseUrl;
        log.debug((Object)"MicrosoftTeamsNotificationTransport constructor");
        log.debug((Object)("webhookUrl = " + this.webhookUrl));
        log.debug((Object)("channel = " + this.channel));
        log.debug((Object)("includeImage = " + this.includeImage));
        log.debug((Object)("enabled = " + this.enabled));
    }

    public void sendNotification(@NotNull Notification notification) {
        log.debug((Object)"------------- MicrosoftTeamsNotificationTransport::sendNotification --------------");
        if (this.enabled != null && !this.enabled.booleanValue()) {
            log.info((Object)"Notifications is disabled");
            return;
        }
        if (this.licenseManager != null && !this.licenseManager.isLicensed()) {
            log.error((Object)"You don't have valid licence for Microsoft Teams Bamboo Connector.");
            return;
        }
        try {
            MicrosoftTeamsEventCreator microsoftTeamsEventCreator = new MicrosoftTeamsEventCreator(this.i18nResolver);
            String content = microsoftTeamsEventCreator.create(notification, this.resultsSummary, this.deploymentResult, this.channel, this.includeImage, this.baseUrl, this.includeArtifacts, this.errors);
            log.debug((Object)("Microsoft Teams event => " + content));
            this.payloadSender.send(this.webhookUrl, content);
        }
        catch (Exception e) {
            log.error((Object)("Error using Microsoft Teams API: " + e.getMessage()), (Throwable)e);
        }
    }
}

