/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.bamboo.utils.HttpUtils;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class PayloadSender {
    private static final Logger log = Logger.getLogger(PayloadSender.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String webhookUrl, String content) throws Exception {
        URI uri = null;
        try {
            uri = new URI(webhookUrl);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Unable to set up proxy settings, invalid URI encountered: " + e));
            return;
        }
        CloseableHttpClient client = null;
        Closeable response = null;
        try {
            client = this.createClient(uri);
            HttpPost method = new HttpPost();
            method.setURI(uri);
            method.addHeader("Content-Type", "application/json");
            method.setEntity(new StringEntity(content, StandardCharsets.UTF_8));
            log.debug((Object)("Url: " + method.getURI().toString()));
            if (method.getURI().toString().length() == 0) {
                log.error((Object)"Url was not configured, won't try to send notification to Microsoft Teams");
                return;
            }
            log.debug((Object)("Headers" + method.getEntity().toString()));
            response = client.execute(method);
            log.debug((Object)">>>>>>>>>>>> Request was sent to Microsoft Teams");
            HttpEntity entity = response.getEntity();
            String responseContent = EntityUtils.toString(entity);
            log.debug((Object)"-------- Response --------\n");
            log.debug((Object)("Status code: " + response.getStatusLine().getStatusCode()));
            log.debug((Object)"Response content: ");
            log.debug((Object)responseContent);
            if (response.getStatusLine().getStatusCode() >= 400) {
                if (response.getStatusLine().getStatusCode() == 429) {
                    log.warn((Object)"Rate limited: too many requests.");
                    throw new RuntimeException("Rate limited: too many requests.");
                }
                log.warn((Object)"Error from Microsoft Teams");
                log.warn((Object)responseContent);
                throw new RuntimeException("Error from Microsoft Teams: " + responseContent);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
    }

    public CloseableHttpClient createClient(URI uri) {
        HttpUtils.EndpointSpec proxyForScheme = HttpUtils.getProxyForScheme((String)uri.getScheme());
        if (proxyForScheme != null) {
            HttpHost proxy = new HttpHost(proxyForScheme.host, (int)proxyForScheme.port);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            return HttpClients.custom().setRoutePlanner(routePlanner).build();
        }
        return HttpClients.createDefault();
    }
}

