/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.bamboo.microsoftteams.notifier;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.bamboo.microsoftteams.notifier.AbstractChainAction;
import com.moveworkforward.bamboo.microsoftteams.notifier.StringUtils;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MicrosoftTeamsChainActionCreator {
    private static final Logger log = Logger.getLogger(AbstractChainAction.class);
    private final I18nResolver i18nResolver;
    private final BambooUrl bambooUrl;

    public MicrosoftTeamsChainActionCreator(I18nResolver i18nResolver, BambooUrl bambooUrl) {
        this.i18nResolver = i18nResolver;
        this.bambooUrl = bambooUrl;
    }

    public String createContent(BuildContext buildContext, ChainResultsSummary chainResultSummary, AbstractChainAction.Notification notification, String channel) {
        String title = this.makeTitle((ResultsSummary)chainResultSummary, notification);
        JSONObject detailsSection = new JSONObject();
        JSONArray sections = new JSONArray();
        JSONObject object = new JSONObject();
        try {
            JSONArray facts = new JSONArray();
            String authors = this.getResponsibleAuthors((ResultsSummary)chainResultSummary);
            if (StringUtils.isNotBlank(authors)) {
                facts.put((Object)this.getAuthorsFact(authors));
            }
            for (ChainStageResult result : chainResultSummary.getStageResults()) {
                for (BuildResultsSummary jobResult : result.getBuildResults()) {
                    facts.put((Object)this.jobResultFact(result.getName(), jobResult));
                }
            }
            if (StringUtils.isNotBlank(channel)) {
                this.putFromChannelFact(facts, channel);
            }
            if (facts.length() > 0) {
                detailsSection.put("facts", (Object)facts);
                sections.put((Object)detailsSection);
            }
            String text = chainResultSummary.getImmutablePlan().getLastResultKey() == null ? buildContext.getDisplayName() : StringUtils.link(buildContext.getDisplayName(), this.bambooUrl.getBaseUrl(UrlMode.ABSOLUTE) + "/browse/" + chainResultSummary.getImmutablePlan().getLastResultKey().getKey());
            object.put("title", (Object)title);
            object.put("text", (Object)(text + " " + buildContext.getTriggerReason().getNameForSentence()));
            object.put("sections", (Object)sections);
        }
        catch (JSONException e) {
            log.error((Object)("JSON construction error :" + e.getMessage()), (Throwable)e);
        }
        log.info((Object)("====================== >" + object));
        return object.toString();
    }

    public JSONObject jobResultFact(String stage, BuildResultsSummary result) throws JSONException {
        StringBuffer status = new StringBuffer(result.getPlanName());
        if (result.getTestResultsSummary().getTotalTestCaseCount() > 0) {
            status.append(MessageFormat.format(" {0} in {1}", result.getTestSummary(), LocalTime.MIN.plusSeconds(result.getTestResultsSummary().getTotalTestDuration() / 1000L).toString()));
        }
        if (result.isFinished()) {
            status.append(String.format("(%s)", StringUtils.link(this.i18nResolver.getText("msteams.status.results"), this.bambooUrl.getBaseUrl(UrlMode.ABSOLUTE) + "/browse/" + result.getBuildResultKey())));
        }
        JSONObject fact = new JSONObject();
        fact.put("name", (Object)stage);
        fact.put("value", (Object)status.toString());
        return fact;
    }

    private String makeTitle(ResultsSummary resultsSummary, AbstractChainAction.Notification notification) {
        return this.i18nResolver.getText("msteams.build") + String.format(" #%d %s", resultsSummary.getBuildNumber(), this.toBuildStateMessage(notification));
    }

    private String toBuildStateMessage(AbstractChainAction.Notification notification) {
        String result = this.i18nResolver.getText("msteams.status.unknown");
        switch (notification) {
            case JOB: {
                result = this.i18nResolver.getText("msteams.status.in.progress");
                break;
            }
            case STARTED: {
                result = this.i18nResolver.getText("msteams.status.started");
                break;
            }
            case FINISHED: {
                result = this.i18nResolver.getText("msteams.status.finished");
            }
        }
        return result;
    }

    private String getResponsibleAuthors(ResultsSummary resultsSummary) {
        Set authors = resultsSummary.getUniqueAuthors();
        if (authors != null && !authors.isEmpty()) {
            List userNames = authors.stream().map(Author::getFullName).collect(Collectors.toList());
            return String.join((CharSequence)", ", userNames);
        }
        return "";
    }

    private JSONObject getAuthorsFact(String authors) throws JSONException {
        JSONObject authorsFact = new JSONObject();
        authorsFact.put("name", (Object)this.i18nResolver.getText("msteams.responsible.users"));
        authorsFact.put("value", (Object)authors);
        return authorsFact;
    }

    private void putFromChannelFact(JSONArray facts, String channel) throws JSONException {
        if (channel != null && channel.length() > 0) {
            JSONObject fact = new JSONObject();
            fact.put("name", (Object)this.i18nResolver.getText("msteams.from"));
            fact.put("value", (Object)channel);
            facts.put((Object)fact);
        }
    }
}

