
<html>
    <head>
        <title>Look & Feel Templates</title>
        <meta name="decorator" content="atl.general">

        <script>
	        <#include "*/js/lookandfeeltemplate.js">;
	        <#include "*/js/changedImplForOneTime2FAInfo.js">;
            function validateForm() {
                const questionListToValidate=[];
                for(let i=0;i<=10;i++)
                {
                    if(questionListToValidate.includes(document.getElementById("question_"+i).value))
                    {
                        require('aui/flag')({
                            title: 'Problem while saving Security Question',
                            type: 'error',
                            close: 'manual',
                            body: '<p>Make sure every question is different. Please check question number ' +(i+1)+ ' and ' +((questionListToValidate.indexOf(document.getElementById("question_"+i).value))+1)+ '  </p>'
                        });
                        return false;
                    }else{
                        questionListToValidate.push(document.getElementById("question_"+i).value);
                    }
                }
            }
        </script>

        <style>
            :root {
                --background-color: #f5f5f5;
            }
            html[data-color-mode='dark'] {
                --background-color: #343434;
            }
            .subsection_title {
                        font-size: 18px;
                        margin: auto 0;
                        padding-bottom: 1rem;
                        width: 100%;
                        border-bottom: 2px solid #0065ff;
                }

        	h4 {
        		display: block;
        		margin: 30px 65px 0px;
        		font-weight: bold;
        	}

            .aui-page-panel-content{
                padding: 0px !important;
            }

            .aui-page-panel{
                margin: 0px !important;
                border: 0px solid #dfe1e6;
            }

            .labelClass {
                width: 150px !important;
                margin-left: -160px !important;
            }

            .card{
                border: 2px;
                border-style: solid;
                box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
                transition: 0.3s;
            }

            /* On mouse-over, add a deeper shadow */
            .card:hover {
                box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
            }

            /* Add some padding inside the card container */
            .container {
                padding: 2px 16px;
            }
            .card-body{
                margin: 15px;
            }

            .aui-dialog2-header-main {
                max-width : 100%;
            }

            .aui-message:first-child {
                margin-right: 0px;
            }
            #contentTable td {
                border-bottom: 1px solid #ddd;
            }

        </style>
	</head>

	<body>
    <#include "*/header.ftl" parse=true>

        <#assign googleAuthenticatorIcon = req.contextPath + "/download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/GoogleAuthenticator.png">
        <input type="hidden" id="googleAuthenticatorIconId" value="${googleAuthenticatorIcon}">

        <#assign otpOverEmailIcon = req.contextPath + "/download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/OtpOverEmail.png">
        <input type="hidden" id="otpOverEmailIconId" value="${otpOverEmailIcon}">

        <#assign otpOverSmsIcon = req.contextPath + "/download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/OtpOverSms.png">
        <input type="hidden" id="otpOverSmsIconId" value="${otpOverSmsIcon}">

        <#assign webAuthnIcon = req.contextPath + "/download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/webAuthentication.png">
        <input type="hidden" id="webAuthnIconId" value="${webAuthnIcon}">

        <#assign securityQuestionIcon = req.contextPath + "/download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/SecurityQuestion.png">
        <input type="hidden" id="securityQuestionIconId" value="${securityQuestionIcon}">

        <#assign backupCodeIcon = req.contextPath + "/download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/BackupCode.png">
        <input type="hidden" id="backupCodeIconId" value="${backupCodeIcon}">

        <#assign pushNotificationIcon = req.contextPath + "/download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/PushNotification.png">
        <input type="hidden" id="pushNotificationIconId" value="${pushNotificationIcon}">

        <#assign hardwareTokenIcon = req.contextPath + "/download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/HardwareToken.png">
        <input type="hidden" id="hardwareTokenIconId" value="${hardwareTokenIcon}">

    <div class="tabs-pane active-pane" id="settings"  role="tabpanel" >
        <#if (pageAccessType.equals("read"))>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>You only have read access of this page, no configuration will be saved!</p>
            </div>
        </#if>
        <h2>Looks & Feel Templates</h2>
        <hr class="header"/>
        <div>
            <form id="settings-form" class="aui long-label" onsubmit="return validateForm()" action="" method="POST">
                <input type="hidden" name="settingsSubmitted" value="true"/>
                <input type="hidden" name="atl_token" value="${xsrfToken}" />
                <div style="position: sticky;top: 0;float: right;" id="descriptionBox" name="descriptionBox">
                    <table name="contentTable" id="contentTable" style=" width: 280px; box-shadow: 3px 3px 3px #e6e6fa;">
                        <tr>
                            <td colspan="2" style="padding:5px; background-color: var(--background-color); border-radius: 4px; "><b>NOTE:</b> Use the below variables if you want to display your....</td>
                        <tr>

                        <tr style="background-color: var(--background-color);">
                            <td style="padding:7px"><b>$username:</b></td>
                            <td>Username of the user.</td>
                        </tr>

                        <tr style="background-color: var(--background-color);">
                            <td style="padding-left:7px"><b>$email:</b></td>
                            <td style="padding-top:5px; padding-bottom:5px;">Email of the user.</td>
                        </tr>

                        <tr style="background-color: var(--background-color);">
                            <td style="padding-left:7px"><b>$logoutUrl:</b></td>
                            <td style="padding-top:7px; padding-bottom:5px">URL to terminate session.</td>
                        </tr>

                        <tr style="background-color: var(--background-color);">
                            <td style="padding:7px"><b>$expiryTime:</b></td>
                            <td style="padding-top:6px; padding-bottom:3px">Expiry time of locked user. (Only available for Locked User Template)</td>
                        </tr>

                        <tr>
                            <td colspan="2" style="padding:5px; background-color: var(--background-color); border-radius: 4px; "><b>NOTE:</b> Leave template section empty, to set template to default.</td>
                        <tr>

                    </table>
                </div>
                <div style="width: 75%">
                    <table class="mo-aui" style="width:100%">
                    <tbody>
                        <tr>
                            <td width="73%">

                                <div id="mobileAuthenticatorTemplateDiv">
                                    <div style="display: flex;align-content: center;">
                                        <img id="imgGoogleAuthenticator" style="height: 60px !important;line-height: 80px; padding-right: 10px;">
                                        <h3 class="subsection_title">Mobile Authenticator</h3>
                                    </div>
                                    <div class="field-group">
                                        <label>Configure Mobile Authenticator : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="configureGoogleAuthenticatorTemplate" name="configureGoogleAuthenticatorTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${configureGoogleAuthenticatorTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-configure-google-authenticator" onclick="showTestChanges('configureGoogleAuthenticatorTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to configure Mobile Authentication app for the first time.
                                        </div>
                                        <div name="warningDiv" id="warningDiv" class="aui-message aui-message-warning" style="width: 338px;">
                                            <p class="title">
                                                <strong>Do not edit the divs with below ids</strong>
                                            </p>
                                            <ul>
                                                <li>
                                                    <p>
                                                        google-authenticator-secondary-div</p>
                                                </li>
                                                <li>
                                                    <p>
                                                        my-Modal</p>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Validate Mobile Authenticator : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="validateGoogleAuthenticatorTemplate" name="validateGoogleAuthenticatorTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${validateGoogleAuthenticatorTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-validate-google-authenticator" onclick="showTestChanges('validateGoogleAuthenticatorTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to validate Mobile Authentication app.
                                        </div>
                                        <div name="warningDiv" id="warningDiv" class="aui-message aui-message-warning" style="width: 338px;">
                                            <p class="title">
                                                <strong>Do not edit the div with below id</strong>
                                            </p>
                                            <ul>
                                                <li>
                                                    <p>
                                                        validate-otp</p>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div id="securityQuestionTemplateDiv">
                                    <div style="display: flex;align-content: center;">
                                        <img id="imgSecurityQuestion" style="height: 60px !important;line-height: 80px; padding-right: 10px;">
                                        <h3 class="subsection_title">Security Question</h3>
                                    </div>
                                    <br>
                                    <div class="field-group">
                                        <label>Customizable Security Questions: </label>
                                    </div>
                                    <#assign loopCount = 0>
                                    <#foreach securityQuestion in securityQuestionsList>
                                        <div class="field-group">
                                            <#assign Count = loopCount + 1>
                                            <label>${Count} :</label>
                                            <input class="text long-field" required type="text" id="question_${loopCount}" name="question_${loopCount}" value="${securityQuestion}" placeholder="${securityQuestion}"/>
                                        </div>
                                        <#assign loopCount = loopCount + 1>
                                    </#foreach>
                                    <div class="field-group">
                                        <label>Configure Security Question : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="configureSecurityQuestionTemplate" name="configureSecurityQuestionTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${configureSecurityQuestionTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-configure-security-question" onclick="showTestChanges('configureSecurityQuestionTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to configure Security Question app for the first time.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Validate Security Question : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="validateSecurityQuestionTemplate" name="validateSecurityQuestionTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${validateSecurityQuestionTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-validate-security-question" onclick="showTestChanges('validateSecurityQuestionTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to validate Security Question app.
                                        </div>
                                        <div name="warningSecurityQuestionMappingDiv" id="warningSecurityQuestionMappingDiv" class="aui-message aui-message-warning" style="width:338px;">
                                            <p class="title">
                                                <strong>Do not edit the div with below id</strong>
                                            </p>
                                            <ul>
                                                <li>
                                                    <p>
                                                        security-Question-Mapping-Div</p>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div id="otpOverEmailTemplateDiv">
                                    <div style="display: flex;align-content: center;">
                                        <img id="imgOtpOverEmail" style="height: 60px !important;line-height: 80px; padding-right: 10px;">
                                        <h3 class="subsection_title">OTP Over Email</h3>
                                    </div>
                                    <div class="field-group">
                                        <label>Configure OTP Over Email : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="configureOtpOverEmailTemplate" name="configureOtpOverEmailTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${configureOtpOverEmailTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-configure-otp-over-email" onclick="showTestChanges('configureOtpOverEmailTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to configure OTP Over Email app for the first time.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Validate OTP Over Email : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="validateOtpOverEmailTemplate" name="validateOtpOverEmailTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${validateOtpOverEmailTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-validate-otp-over-email" onclick="showTestChanges('validateOtpOverEmailTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to validate OTP Over Email app.
                                        </div>
                                        <div name="warningOtpCode" id="warningOtpCode" class="aui-message aui-message-warning" style="width: 338px;">
                                            <p class="title">
                                                <strong>Do not edit the div with below id</strong></p>
                                            <ul>
                                                <li>
                                                    <p>
                                                        otp-Code</p>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div id="hardwareTokenTemplateDiv">
                                    <div style="display: flex;align-content: center;">
                                        <img id="imgHardwareToken" style="height: 60px !important;line-height: 80px; padding-right: 10px;">
                                        <h3 class="subsection_title">Yubikey Hardware Token</h3>
                                    </div>
                                    <div class="field-group">
                                        <label>Configure Yubikey Hardware Token : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="configureU2FHardwareTokenTemplate" name="configureU2FHardwareTokenTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${configureU2FHardwareTokenTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-configure-hardware-token" onclick="showTestChanges('configureU2FHardwareTokenTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to configure Yubikey Hardware Token for the first time.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Validate Yubikey Hardware Token : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="validateU2FHardwareTokenTemplate" name="validateU2FHardwareTokenTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${validateU2FHardwareTokenTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-validate-hardware-token" onclick="showTestChanges('validateU2FHardwareTokenTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to validate Yubikey Hardware Token.
                                        </div>
                                        <div name="warningHardwareToken" id="warningHardwareToken" class="aui-message aui-message-warning" style="width: 338px;">
                                            <p class="title">
                                                <strong>Do not edit the div with below id</strong></p>
                                            <ul>
                                                <li>
                                                    <p>hardware-token-main</p>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div id="webAuthnAs2faMethodTemplateDiv">
                                    <div style="display: flex;align-content: center;">
                                        <img id="imgWebAuthn" style="height: 60px !important;line-height: 80px; padding-right: 10px;">
                                        <h3 class="subsection_title">Web Authentication</h3>
                                    </div>
                                    <div class="field-group">
                                        <label>Configure Web Authentication: </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="configureWebAuthenticationTemplate" name="configureWebAuthenticationTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${configureWebAuthenticationTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-configure-Web-Authentication" onclick="showTestChanges('configureWebAuthenticationTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to configure Web Authentication for the first time.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Validate Web Authentication : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="validateWebAuthenticationTemplate" name="validateWebAuthenticationTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${validateWebAuthenticationTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-validate-Web-Authentication" onclick="showTestChanges('validateWebAuthenticationTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to validate Web Authentication.
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div id="otpOverSMSTemplateDiv">
                                    <div style="display: flex;align-content: center;">
                                        <img id="imgOtpOverSms" style="height: 60px !important;line-height: 80px; padding-right: 10px;">
                                        <h3 class="subsection_title">OTP over SMS</h3>
                                    </div>
                                    <div class="field-group">
                                        <label>Configure OTP over SMS : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                <textarea id="configureOtpOverSmsTemplate" name="configureOtpOverSmsTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                          cols="64" rows="4">${configureOtpOverSmsTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-configure-otp-over-sms" onclick="showTestChanges('configureOtpOverSmsTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to configure OTP over SMS for the first time.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Validate OTP over SMS : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                <textarea id="validateOtpOverSmsTemplate" name="validateOtpOverSmsTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                          cols="64" rows="4">${validateOtpOverSmsTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-validate-otp-over-sms" onclick="showTestChanges('validateOtpOverSmsTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to validate OTP over SMS.
                                        </div>
                                        <div name="warning-validate-otp-sms" id="warning-validate-otp-sms" class="aui-message aui-message-warning" style="width: 338px;">
                                            <p class="title">
                                                <strong>Do not edit the div with below id</strong>
                                            </p>
                                            <ul>
                                                <li>
                                                    <p>
                                                        otp-Code</p>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div id="duoPushNotificationTemplateDiv">
                                    <div style="display: flex;align-content: center;">
                                        <img id="imgPushNotification" style="height: 60px !important;line-height: 80px; padding-right: 10px;">
                                        <h3 class="subsection_title">Duo Push Notification</h3>
                                    </div>
                                    <div class="field-group">
                                        <label>Configure Duo Push Notification : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="configureDuoPushNotificationTemplate" name="configureDuoPushNotificationTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${configureDuoPushNotificationTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-configure-duo-push-notification" onclick="showTestChanges('configureDuoPushNotificationTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to configure Duo Push Notification for the first time.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Validate Duo Push Notification : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="validateDuoPushNotificationTemplate" name="validateDuoPushNotificationTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${validateDuoPushNotificationTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-validate-duo-push-notification" onclick="showTestChanges('validateDuoPushNotificationTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to validate Duo Push Notification.
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div id="backupCodeTemplateDiv">
                                    <div style="display: flex;align-content: center;">
                                        <img id="imgBackupCode" style="height: 60px !important;line-height: 80px; padding-right: 10px;">
                                        <h3 class="subsection_title">Backup Code</h3>
                                    </div>
                                    <div class="field-group">
                                        <label>Configure Backup Code : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="configureBackupCodeTemplate" name="configureBackupCodeTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${configureBackupCodeTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-configure-backup-code" onclick="showTestChanges('configureBackupCodeTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to configure Backup Code app for the first time.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Validate Backup Code : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="validateBackupCodeTemplate" name="validateBackupCodeTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${validateBackupCodeTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-validate-backup-code" onclick="showTestChanges('validateBackupCodeTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user is trying to validate Backup Code app.
                                        </div>
                                        <div name="warningBackupCodeOtp" id="warningBackupCodeOtp" class="aui-message aui-message-warning" style="width: 338px;">
                                            <p class="title">
                                                <strong>Do not edit the div with below id</strong></p>
                                            <ul>
                                                <li>
                                                    <p>
                                                        backup-Code-Otp</p>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div id="otherTemplateDiv">
                                    <h3 class="subsection_title">Other Templates</h3>
                                    <div class="field-group">
                                        <label>Welcome Message Template : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="welcomeMessageTemplate" name="welcomeMessageTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${welcomeMessageTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-welcome-message" onclick="showTestChanges('welcomeMessageTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render, when user logs into the server, before 2FA is configured.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Inline Registration 2FA Method List Template : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                <textarea id="inlineRegistration_2faMethodListTemplate" name="inlineRegistration_2faMethodListTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                          cols="64" rows="4">${inlineRegistration_2faMethodListTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-inlineRegistration_2faMethodListTemplate-message" onclick="showTestChanges('inlineRegistration_2faMethodListTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render when the user logs into the server and has to choose between multiple 2FA methods for configuration.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Inline Registration Backup Method List Template : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                <textarea id="inlineRegistration_backupMethodListTemplate" name="inlineRegistration_backupMethodListTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                          cols="64" rows="4">${inlineRegistration_backupMethodListTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-inlineRegistration_backupMethodListTemplate-message" onclick="showTestChanges('inlineRegistration_backupMethodListTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render when the user logs into the server and has to choose between multiple backup methods for configuration after configuring the primary method.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Inline Registration Remaining 2FA Method List Template : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                <textarea id="inlineRegistration_remaining2faMethodsListTemplate" name="inlineRegistration_remaining2faMethodsListTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                          cols="64" rows="4">${inlineRegistration_remaining2faMethodsListTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-inlineRegistration_remaining2faMethodsListTemplate-message" onclick="showTestChanges('inlineRegistration_remaining2faMethodsListTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render when the user has configured his 2FA for the first time and is asked whether they wish to configure additional enabled 2FA methods.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Validate 2FA Method List Template : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                <textarea id="validate_2faMethodListTemplate" name="validate_2faMethodListTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                          cols="64" rows="4">${validate_2faMethodListTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-validate_2faMethodListTemplate-message" onclick="showTestChanges('validate_2faMethodListTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render when the user logs into the server and has to choose between multiple 2FA methods for validation.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Locked Users Template : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="lockedUsersTemplate" name="lockedUsersTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${lockedUsersTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-locked-users-template" onclick="showTestChanges('lockedUsersTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render when user is Locked and can't get access to the server.
                                        </div>
                                    </div>
                                    <div class="field-group">
                                        <label>Blocklist IP Template : </label>
                                        <table>
                                            <tr>
                                                <td>
                                                    <textarea id="blocklistIpTemplate" name="blocklistIpTemplate" class="textarea long-field" style="font-family:Courier New;font-size: 12px;"
                                                        cols="64" rows="4">${blocklistIpTemplate?html}</textarea>
                                                </td>
                                                <td style="padding: 25px;">
                                                    <input type="button" id="test-blacklist-ip-template" onclick="showTestChanges('blocklistIpTemplate')" value="Preview" class="aui-button" style="width:75px;" />
                                                </td>
                                            </tr>
                                        </table>
                                        <div class="description" style="padding-left: 4px;">
                                            This page will render when an IP address is blocked.
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div name="restoreToDefault" id="restoreToDefault" class="aui-message aui-message-info">
                                    <p class="title">
                                        <strong>
                                            Leave template section empty, to set template to default.
                                        </strong>
                                    </p>
                                </div>
                            <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                                <div class="field-group">
                                    <input type="submit" value="Save" class="aui-button aui-button-primary" style="width: 150px;"/>
                                </div>
                            </#if>
                            </td>

                        </tr>
                    </tbody>
                    </table>
                </div>
            </form>
        </div>


    </div>
    </div>
    </section>
</body>
</html>