<html>
<head>
    <title>Knowledge Base</title>
    <meta name="decorator" content="atl.general" />

    <script>
        AJS.$(function () {
            AJS.$(".aui-nav li").removeClass("aui-nav-selected");
            AJS.$("#KNOWLEDGEBASE").addClass("aui-nav-selected");
        });

        function alterKnowledgeBaseView(viewName) {
            document.querySelectorAll('.view-section').forEach(section => {
                section.classList.remove('active');
            });

            ['setupGuide_tab', 'demoVideo_tab', 'useCase_tab', 'handbook_tab'].forEach(id => {
                const tab = document.getElementById(id);
                if (tab) {
                    tab.classList.remove('aui-nav-selected');
                }
            });

            document.getElementById(viewName + 'View').classList.add('active');
            document.getElementById(viewName + '_tab').classList.add('active');
            document.getElementById(viewName + '_tab').classList.add('aui-nav-selected');
        }

        document.addEventListener('DOMContentLoaded', function() {
            alterKnowledgeBaseView('setupGuide');
        });
    </script>

    <style>
        <#include "*/css/MoTwoFactorKnowledgebase.css" />
    </style>
</head>

<body>
<#include "*/header.ftl" parse=true />

<div style="padding: 10px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif; background: ${backgroundPrimary!};">
    <div id="mo2fa-configure" class="aui-tabs horizontal-tabs" role="application">
        <nav class="aui-navgroup aui-navgroup-horizontal">
            <div class="aui-navgroup-inner" style="padding: 0px !important;">
                <div class="aui-navgroup-primary">
                    <div id="2FA-navigation-links" style="font-size: 17px">
                        <ul class="aui-nav">
                            <li id="setupGuide_tab" onclick="alterKnowledgeBaseView('setupGuide')">
                                <a id="card1" href="#" style="outline: none; box-shadow: none;">
                                    <span></span>&nbsp;<strong>Setup Guide/ Video</strong>
                                </a>
                            </li>
                            <li id="demoVideo_tab" onclick="alterKnowledgeBaseView('demoVideo')">
                                <a id="card2" href="#" style="outline: none; box-shadow: none;">
                                    <span></span>&nbsp;<strong>Demo Videos</strong>
                                </a>
                            </li>
                            <li id="useCase_tab" onclick="alterKnowledgeBaseView('useCase')">
                                <a id="card3" href="#" style="outline: none; box-shadow: none;">
                                    <span></span>&nbsp;<strong>Use Case Articles</strong>
                                </a>
                            </li>
                            <li id="handbook_tab">
                                <a href="https://developers.miniorange.com/docs/atlassian/2fa/overview?_gl=1*1wnkl5i*_gcl_au*MjYxNDA0MDM5LjE3NDc4MDcyNDU.*_ga*ODk3OTEzMTc4LjE3NDc4MDcyMDQ.*_ga_CR5T2LG2WB*czE3NDg1OTA0NTgkbzE2JGcxJHQxNzQ4NTkwNTI2JGo1MyRsMCRoMTM2NTI2MjM3MA..*_ga_EZQF54NCSZ*czE3NDg1OTA0NTgkbzE2JGcxJHQxNzQ4NTkwNTI2JGo1MyRsMCRoNTA1MjUwOTky"
                                   target="_blank" style="outline: none; box-shadow: none;">
                                    &nbsp;<strong>Handbook</strong>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div>
</div>

<#-- Setup Guide and Video View Section in FTL -->
<div id="setupGuideView" class="view-section active"><br>
    <div style="display: flex; gap: 50px; align-items: flex-start;">
        <!-- Setup Guide Section -->
        <div style="flex: 1;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; gap: 12px;">
                <div style="display: flex; align-items: center; gap: 8px;">
                    <svg width="16" height="22" viewBox="0 0 16 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3.86857 11.427H12.1314V10.2842H3.86857V11.427ZM3.86857 14.5916H12.1314V13.4487H3.86857V14.5916ZM3.86857 17.7573H8.70286V16.6145H3.86857V17.7573ZM1.84571 21.3607C1.32 21.3607 0.881143 21.1847 0.529143 20.8327C0.177143 20.4807 0.000761905 20.0415 0 19.515V2.63502C0 2.10931 0.176381 1.67045 0.529143 1.31845C0.881905 0.96645 1.32114 0.790069 1.84686 0.789307H10.8571L16 5.93216V19.515C16 20.0407 15.824 20.48 15.472 20.8327C15.12 21.1855 14.6804 21.3615 14.1531 21.3607H1.84571ZM10.2857 6.50359V1.93216H1.84686C1.67086 1.93216 1.50933 2.00531 1.36229 2.15159C1.21524 2.29788 1.1421 2.45902 1.14286 2.63502V19.515C1.14286 19.6903 1.216 19.8514 1.36229 19.9985C1.50857 20.1455 1.66971 20.2186 1.84571 20.2179H14.1543C14.3295 20.2179 14.4907 20.1447 14.6377 19.9985C14.7848 19.8522 14.8579 19.6906 14.8571 19.5139V6.50359H10.2857Z" fill="#0052CC"/>
                    </svg>
                    <h3 style="font-size: 20px; color: var(--text-primary); margin: 0;">Setup Guide</h3>
                </div>
            </div>
            <div class="horizontalLine"></div>

            <#-- Documentation Content -->
            <#assign documentationContent = [
            {
            "title": "How to Set Up Two-Factor Authentication (2FA) for Bamboo.",
            "description": "The miniOrange Two-Factor Authentication (2FA) app is designed to help you enhance security for your Bamboo. In this comprehensive guide, we will navigate you through the step-by-step process of configuring 2FA for Bamboo. By the end of this walkthrough, you will have fortified your platform with an additional layer of security, safeguarding your registered end-users.",
            "link": "https://www.miniorange.com/atlassian/two-factor-authentication-2fa-for-bamboo"
            }
            ] />

            <div style="display: grid; grid-template-columns: 1fr; gap: 24px;">
                <#list documentationContent as content>
                    <div class="mo2fa-card-bg">
                        <div style="display: flex; gap: 8px; margin-bottom: 16px;">
                            <span style="padding: 4px 8px; background: var(--tag-background); border-radius: 3px; font-size: 12px; color: var(--text-secondary); font-weight: bold;">2FA</span>
                        </div>
                        <h3 style="font-size: 16px; color: var(--text-primary); margin: 0 0 12px 0;">${content.title}</h3>
                        <p style="font-size: 14px; color: var(--text-secondary); margin: 0 0 16px 0;">${content.description}</p>
                        <div style="display: flex; align-items: center; gap: 8px; font-size: 14px;">
                            <a href="${content.link}" target="_blank" style="color: var(--accent-color); text-decoration: none; display: flex; align-items: center; gap: 4px;">
                                <span class="aui-icon aui-icon-small aui-iconfont-shortcut"></span> &nbsp; View Document<br>
                            </a>
                            <br><br>
                        </div>
                    </div>
                </#list>
            </div>
        </div>

        <!-- Setup Video Section -->
        <div style="flex: 1;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                <div style="display: flex; align-items: center; gap: 8px;">
                    <svg width="22" height="23" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="none">
                        <path fill="#0000FF" fill-rule="evenodd" d="M5 5a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3v-1.586l2.293 2.293A1 1 0 0 0 22 16V8a1 1 0 0 0-1.707-.707L18 9.586V8a3 3 0 0 0-3-3H5z" clip-rule="evenodd"/>
                    </svg>
                    <h3 style="font-size: 20px; color: var(--text-primary); margin: 0;">Setup Video</h3>
                </div>
            </div>
            <div class="horizontalLine"></div>

            <#assign setupVideoContent = [
            {
            "src": "download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/2FA-setupVideo.webp",
            "description": "Bamboo Two Factor Authentication | Secure Bamboo with miniOrange.",
            "link": "https://www.youtube.com/watch?v=XscesyxzuFU"
            }
            ] />

            <div style="display: grid; grid-template-columns: 1fr; gap: 16px;">
                <#list setupVideoContent as content>
                    <a href="${content.link}" target="_blank" style="text-decoration: none; display: block; color: inherit;">
                        <div style="border: 1px solid var(--border-color); border-radius: 4px; overflow: hidden; background: var(--card-background);">
                            <div style="position: relative;">
                                <img class="hover-imgIcon" src="${req.contextPath}/${content.src}" alt="${content.description}">
                            </div>
                            <div style="padding: 10px;">
                                <p style="font-weight: bold; font-size: 15px; color: var(--text-primary); margin: 0 0 12px 0; line-height: 1.4;">
                                    ${content.description}
                                </p>
                            </div>
                        </div>
                    </a>
                </#list>
            </div>
        </div>
    </div>
</div>


<div id="demoVideoView" class="view-section">
    <div class="video-section">
        <div style="display: flex; justify-content: space-between; align-items: center; margin: 5px;">
            <div style="display: flex; align-items: center; gap: 8px;padding: 10px;">
                <svg width="22" height="23" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="none">
                    <path fill="#0000FF" fill-rule="evenodd" d="M5 5a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3v-1.586l2.293 2.293A1 1 0 0 0 22 16V8a1 1 0 0 0-1.707-.707L18 9.586V8a3 3 0 0 0-3-3H5z" clip-rule="evenodd"/>
                </svg>
                <h3 style="font-size: 20px; color: var(--text-primary); margin: 0;">See our plugin and its features in action</h3>
            </div>
        </div>
        <div class="horizontalLine"></div>

        <#assign demoVideoContent = [
        {
        "src": "download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/2FA-setupVideo.webp",
        "description": "How to Setup miniOrange 2FA for Atlassian",
        "link": "https://youtu.be/EorouAGaUe0"
        },
        {
        "src": "download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/2FA-bruteForceProtection.webp",
        "description": "Block Brute Force Attacks on 2FA",
        "link": "https://youtu.be/4oenczWKCaU"
        },
        {
        "src": "download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/2FA-IPBaseAccess.webp",
        "description": "Secure Atlassian Apps with IP Restrictions.",
        "link": "https://youtu.be/OzkK5Cvc1L4?si=D-QbqUvjoGxtIoQb"
        },
        {
        "src": "download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/2FA-utilityFeatures.webp",
        "description": "Enhance Atlassian Experience with Utility Features",
        "link": "https://youtu.be/PmHkJvdeaFw?si=2olG3m9hVFKOfHWj"
        },
        {
        "src": "download/resources/com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource/images/2FA-userManagement.webp",
        "description": "Manage Users & Track 2FA Activity in Atlassian",
        "link": "https://youtu.be/bDO02kRrhz0?si=iue9nAn0lmEbular"
        }
        ] />

        <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 16px;">
            <#list demoVideoContent as content>
                <a href="${content.link}" target="_blank" style="text-decoration: none; display: block; color: inherit;">
                    <div style="border: 1px solid var(--border-color); border-radius: 4px; overflow: hidden; background: var(--card-background);">
                        <div style="position: relative;">
                            <img class="hover-imgIcon" src="${req.contextPath}/${content.src}" alt="${content.description}">
                        </div>
                        <div style="padding: 12px;">
                            <p style="font-weight: bold; font-size: 15px; color: var(--text-primary); margin: 0 0 12px 0; line-height: 1.4;">
                                ${content.description}
                            </p>
                        </div>
                    </div>
                </a>
            </#list>
        </div>
    </div>
</div>


<div id="useCaseView" class="view-section">
    <div class="video-section">
        <div class="horizontalLine"></div>

        <#assign useCaseContent = [
        {
        "feature": "IP Base Access",
        "title": "IP-Based access rules on 2FA to secure Atlassian Apps",
        "description": "A smart 2FA solution that bypasses authentication for trusted IPs while enforcing 2FA for external access, ensuring strong security and a seamless login experience.",
        "link": "https://www.miniorange.com/atlassian/ip-based-2fa-access-atlassian-apps"
        },
        {
        "feature": "Multilingual Support",
        "title": "Multilingual Support with Custom Templates for easy 2FA",
        "description": "A flexible 2FA solution that supports multiple authentication methods, multilingual setup, and branded login pages—enabling secure, user-friendly onboarding for diverse global teams.",
        "link": "https://www.miniorange.com/atlassian/multilingual-2fa-custom-templates-atlassian"
        },
        {
        "feature": "One-time 2FA",
        "title": "One-time 2FA to Secure all Crowd-Connected Atlassian Apps.",
        "description": "A centralized 2FA approach that eliminates redundant prompts across Crowd-connected apps, supports seamless SSO-based access, and enables shared OTP secrets across Jira, Confluence, Crowd, Bamboo and Bitbucket—enhancing security while improving user experience.",
        "link": "https://www.miniorange.com/atlassian/one-time-2fa-crowd-atlassian-apps"
        },
        {
        "feature": "2FA on Git Commands",
        "title": "How to Secure Your Git Commands with 2FA for Bitbucket",
        "description": "A seamless 2FA solution that enforces authentication on GIT commands (push, pull, clone) in Bitbucket using Duo push and email verification—enhancing security without disrupting developer workflows.",
        "link": "https://www.miniorange.com/atlassian/secure-git-commands-2fa-bitbucket"
        }
        ] />

        <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px;">
            <#list useCaseContent as content>
                <div class="mo2fa-card-bg">
                    <div style="display: flex; gap: 8px; margin-bottom: 16px;">
                        <span style="padding: 4px 8px; background: var(--tag-background); border-radius: 3px; font-size: 12px; color: var(--text-secondary); font-weight: bold;">
                            ${content.feature}
                        </span>
                    </div>
                    <h3 style="font-size: 16px; color: var(--text-primary); margin: 0 0 12px 0;">
                        ${content.title}
                    </h3>
                    <p style="font-size: 14px; color: var(--text-secondary); margin: 0 0 16px 0;">
                        ${content.description}
                    </p>
                    <div style="display: flex; align-items: center; gap: 8px; font-size: 14px;">
                        <a href="${content.link}" target="_blank" style="color: var(--accent-color); text-decoration: none; display: flex; align-items: center; gap: 4px;">
                            <span class="aui-icon aui-icon-small aui-iconfont-shortcut"></span> &nbsp; View Document
                        </a>
                    </div>
                </div>
            </#list>
        </div>
    </div>
</div>





</div>
</section>
</div>
</body>

</html>
