function performActionChange(selectedAction) {
    console.log("Calling performActionChange For : "+selectedAction);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/view/moapi",
        timeout: 0,
        data: {
            "action": "ChangeUserManagementSelectedAction",
            "selectedAction": selectedAction
        },
        type: "POST",
        success: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        error: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        async: true
    });
}

function performEnable2FAForUser(response, username) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        document.getElementById("tr"+username).style = "";
        var html = "<a onclick=\"return disable2FAForUser('"+username+"')\">Disable 2FA</a>";
        document.getElementById("span"+username).innerHTML = html;
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for user : '+username+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2fa for user : '+username+'</p>'
        });
    }
}

function getCSSVariableValue(variableName) {
    return getComputedStyle(document.documentElement).getPropertyValue(variableName).trim();
}

function performDisable2FAForUser(response, username) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        var bgcolor = getCSSVariableValue('--background-color');
        document.getElementById("tr" + username).style.background = bgcolor;
        var html = "<a onclick=\"return enable2FAForUser('"+username+"')\">Enable 2FA</a>";
        document.getElementById("span"+username).innerHTML = html;
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for user : '+username+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2fa for user : '+username+'</p>'
        });
    }
}

function performReset2FAForUser(response, username) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
         if (document.getElementById("resetspan"+username)) {
            document.getElementById("resetspan"+username).innerHTML = "";
         }
         require('aui/flag')({
             title: 'Resetting 2FA',
             type: 'success',
             close: 'auto',
             body: '<p>Successfully Reset 2FA for user : '+username+'</p>'
         });
    } else {
         require('aui/flag')({
             title: 'Resetting 2FA',
             type: 'error',
             close: 'auto',
             body: '<p>Issue with resetting 2fa for user : '+username+'</p>'
         });
    }
}

function enable2FAForUser(username) {
    console.log("Calling enable2FAForUser");
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for User : '+username+' in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForUser",
            "username": username
        },
        type: "POST",
        success: function (response) {
            performEnable2FAForUser(response, username);
        },
        error: function (response) {
            performEnable2FAForUser(response, username);
        },
        async: true
    });
}

function disable2FAForUser(username) {
    console.log("Calling disable2FAForUser");
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for User : '+username+' in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForUser",
            "username": username
        },
        type: "POST",
        success: function (response) {
            performDisable2FAForUser(response, username);
        },
        error: function (response) {
            performDisable2FAForUser(response, username);
        },
        async: true
    });
}

function reset2FAForUser(username) {
    console.log("Calling reset2FAForUser for user : "+username);
    require('aui/flag')({
        title: 'Resetting 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Resetting 2FA for User : '+username+' in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Reset2faForUser",
            "username": username
        },
        type: "POST",
        success: function (response) {
            performReset2FAForUser(response, username);
        },
        error: function (response) {
            performReset2FAForUser(response, username);
        },
        async: true
    });
}

function enable2faForAllUsers() {
    console.log("Calling enable2faForAllUsers");
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for All Users in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForAllUsers"
        },
        type: "POST",
        success: function (response) {
            performEnable2faForAllUsers(response);
        },
        error: function (response) {
            performEnable2faForAllUsers(response);
        },
        async: true
    });
}

function performEnable2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
             title: 'Enabling 2FA',
             type: 'success',
             close: 'auto',
             body: '<p>Successfully Enabled 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
             title: 'Enabling 2FA',
             type: 'error',
             close: 'auto',
             body: '<p>Issue with Enabling 2FA for All Users</p>'
        });
    }
}

function disable2faForAllUsers() {
    console.log("Calling disable2faForAllUsers");
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for All Users in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForAllUsers"
        },
        type: "POST",
        success: function (response) {
            performDisable2faForAllUsers(response);
        },
        error: function (response) {
            performDisable2faForAllUsers(response);
        },
        async: true
    });
}

function performDisable2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
             title: 'Disabling 2FA',
             type: 'success',
             close: 'auto',
             body: '<p>Successfully Disabled 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
             title: 'Disabling 2FA',
             type: 'error',
             close: 'auto',
             body: '<p>Issue with Disabling 2FA for All Users</p>'
        });
    }
}

function reset2faForAllUsers() {
    console.log("Calling reset2faForAllUsers");
    require('aui/flag')({
        title: 'Resetting 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Resetting 2FA for All Users in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Reset2faForAllUsers"
        },
        type: "POST",
        success: function (response) {
            performReset2faForAllUsers(response);
        },
        error: function (response) {
            performReset2faForAllUsers(response);
        },
        async: true
    });
}

function performReset2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
             title: 'Resetting 2FA',
             type: 'success',
             close: 'auto',
             body: '<p>Successfully Reset 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
             title: 'Resetting 2FA',
             type: 'error',
             close: 'auto',
             body: '<p>Issue with Resetting 2FA for All Users</p>'
        });
    }
}

function toggleAllUsers() {
    var isChecked = document.getElementById("selectAllUsers").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value - 1;

    for (var i=startIndex;i<=endIndex;i++) {
        document.getElementById("selectedUser"+i).checked = isChecked;
    }
}

function toggleAllGroups() {
    var isChecked = document.getElementById("selectAllGroups").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value - 1;

    for (var i=startIndex;i<=endIndex;i++) {
        document.getElementById("selectedGroup"+i).checked = isChecked;
    }
}

function toggleAllLockedUsers() {
    var isChecked = document.getElementById("selectAllLockedUsers").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value - 1;

    for (var i=startIndex;i<=endIndex;i++) {
        document.getElementById("selectedLockedUser"+i).checked = isChecked;
    }
}

function performBulk2faAction() {
    var action = document.getElementById("bulk2faAction");
    console.log("Action : "+action.value);
    if (action.value =="") {
        document.getElementById("bulk2faAction").style.borderColor = "red";
        alert("Please select valid Bulk Action");
    } else {
        document.getElementById("bulk2faAction").style.borderColor = "";
        console.log("Selected Action : "+action.value);
        var startIndex = document.getElementById("startIndex").value;
        var endIndex = document.getElementById("endIndex").value - 1;

        switch (action.value) {
            case "Enable 2FA For Selected Users":
                enable2faForSelectedUsers(startIndex, endIndex);
                break;
            case "Disable 2FA For Selected Users":
                disable2faForSelectedUsers(startIndex, endIndex);
                break;
            case "Reset 2FA For Selected Users":
                reset2faForSelectedUsers(startIndex, endIndex);
                break;

            case "Enable 2FA For All Users":
                enable2faForAllUsers();
                break;
            case "Disable 2FA For All Users":
                disable2faForAllUsers();
                break;
            case "Reset 2FA For All Users":
                reset2faForAllUsers();
                break;
            case "Enable 2FA For Selected Groups":
                enable2faForSelectedGroups(startIndex, endIndex);
                break;
            case "Disable 2FA For Selected Groups":
                disable2faForSelectedGroups(startIndex, endIndex);
                break;
            case "Enable 2FA For All Groups":
                enable2faForAllGroups();
                break;
            case "Disable 2FA For All Groups":
                disable2faForAllGroups();
                break;
            case "Remove Selected Locked Users":
                removeSelectedLockedUsers(startIndex, endIndex);
                break;
            case "Remove All Locked Users":
                removeAllLockedUsers();
                break;
        }
    }
}

function performDisable2FAForSelectedGroups(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for Selected Groups.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2FA for Selected Group.</p>'
        });
    }
}

function disable2faForSelectedGroups(startIndex, endIndex) {
    console.log("Calling disable2faForSelectedGroups");
    var isGroupSelected = false;
    var selectedGroups = new Array();

    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedGroup"+i).checked;
        if (isChecked == true) {
            isGroupSelected = true;
            selectedGroups.push(document.getElementById("selectedGroup"+i).value);
        }
    }
    if (isGroupSelected == true) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Disabling 2FA for Selected Groups in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Disable2faForSelectedGroups",
                "selectedGroups":selectedGroups
            },
            type: "POST",
            success: function (response) {
                performDisable2FAForSelectedGroups(response);
            },
            error: function (response) {
                performDisable2FAForSelectedGroups(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
             title: 'Disabling 2FA',
             type: 'error',
             close: 'auto',
             body: '<p>No Group is selected. Please select valid Groups.</p>'
        });
    }
}

function performEnable2FAForSelectedGroups(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for Selected Groups.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2FA for Selected Group.</p>'
        });
    }
}

function enable2faForSelectedGroups(startIndex, endIndex) {
    console.log("Calling enable2faForSelectedGroups");
    var isGroupSelected = false;
    var selectedGroups = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedGroup"+i).checked;
        if (isChecked == true) {
            isGroupSelected = true;
            selectedGroups.push(document.getElementById("selectedGroup"+i).value);
        }
    }

    if (isGroupSelected == true) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Enabling 2FA for Selected Groups in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Enable2faForSelectedGroups",
                "selectedGroups":selectedGroups
            },
            type: "POST",
            success: function (response) {
                performEnable2FAForSelectedGroups(response);
            },
            error: function (response) {
                performEnable2FAForSelectedGroups(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
             title: 'Enabling 2FA',
             type: 'error',
             close: 'auto',
             body: '<p>No Group is selected. Please select valid Groups.</p>'
        });
    }
}

function performReset2FAForSelectedUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Reset 2FA for Selected Users.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with resetting 2fa for Selected Users.</p>'
        });
    }
}

function reset2faForSelectedUsers(startIndex, endIndex) {
    console.log("Calling reset2faForSelectedUsers");

    var isCustomerSelected = false;
    var selectedUsers = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedUser"+i).checked;
        if (isChecked == true) {
            isCustomerSelected = true;
            selectedUsers.push(document.getElementById("selectedUser"+i).value);
        }
    }

    if (isCustomerSelected == true) {
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Resetting 2FA for Selected Users in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Reset2faForSelectedUsers",
                "selectedUsers":selectedUsers
            },
            type: "POST",
            success: function (response) {
                performReset2FAForSelectedUsers(response);
            },
            error: function (response) {
                performReset2FAForSelectedUsers(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
             title: 'Resetting 2FA',
             type: 'error',
             close: 'auto',
             body: '<p>No user is selected. Please select valid user.</p>'
        });
    }
}

function performDisable2FAForSelectedUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for Selected Users.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2fa for Selected Users.</p>'
        });
    }
}

function disable2faForSelectedUsers(startIndex, endIndex) {
    console.log("Calling disable2faForSelectedUsers");

    var isCustomerSelected = false;
    var selectedUsers = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedUser"+i).checked;
        if (isChecked == true) {
            isCustomerSelected = true;
            selectedUsers.push(document.getElementById("selectedUser"+i).value);
        }
    }

    if (isCustomerSelected == true) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Disabling 2FA for Selected Users in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Disable2faForSelectedUsers",
                "selectedUsers":selectedUsers
            },
            type: "POST",
            success: function (response) {
                performDisable2FAForSelectedUsers(response);
            },
            error: function (response) {
                performDisable2FAForSelectedUsers(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
             title: 'Disabling 2FA',
             type: 'error',
             close: 'auto',
             body: '<p>No user is selected. Please select valid user.</p>'
        });
    }
}

function performEnable2FAForSelectedUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for Selected Users.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2fa for Selected Users.</p>'
        });
    }
}

function enable2faForSelectedUsers(startIndex, endIndex) {
    console.log("Calling enable2faForSelectedUsers");
    var isCustomerSelected = false;
    var selectedUsers = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedUser"+i).checked;
        if (isChecked == true) {
            isCustomerSelected = true;
            selectedUsers.push(document.getElementById("selectedUser"+i).value);
        }
    }

    if (isCustomerSelected == true) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Enabling 2FA for Selected Users in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Enable2faForSelectedUsers",
                "selectedUsers":selectedUsers
            },
            type: "POST",
            success: function (response) {
                performEnable2FAForSelectedUsers(response);
            },
            error: function (response) {
                performEnable2FAForSelectedUsers(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
             title: 'Enabling 2FA',
             type: 'error',
             close: 'auto',
             body: '<p>No user is selected. Please select valid user.</p>'
        });
    }
}

function performEnable2FAForGroup(response, groupname) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        document.getElementById("tr"+groupname).style = "";
        var html = "<a onclick=\"return disable2FAForGroup('"+groupname+"')\">Disable 2FA</a>";
        document.getElementById("span"+groupname).innerHTML = html;

        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for Group : '+groupname+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2fa for Group : '+groupname+'</p>'
        });
    }
}

function performDisable2FAForGroup(response, groupname) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        var bgcolor = getCSSVariableValue('--background-color');
        document.getElementById("tr" + groupname).style.background = bgcolor;
        var html = "<a onclick=\"return enable2FAForGroup('"+groupname+"')\">Enable 2FA</a>";
        document.getElementById("span"+groupname).innerHTML = html;

        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for Group : '+groupname+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2fa for Group : '+groupname+'</p>'
        });
    }
}

function enable2faForAllGroups() {
    console.log("Calling enable2faForAllGroups");
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for All Group in background. You can still access Bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForAllGroups"
        },
        type: "POST",
        success: function (response) {
            performEnable2faForAllGroups(response);
        },
        error: function (response) {
            performEnable2faForAllGroups(response);
        },
        async: true
    });
}

function performEnable2faForAllGroups(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
             title: 'Enabling 2FA',
             type: 'success',
             close: 'auto',
             body: '<p>Successfully Enable 2FA for All Groups</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2fa for user : '+username+'</p>'
        });
    }
}

function disable2faForAllGroups() {
    console.log("Calling disable2faForAllGroups");
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for All Group in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForAllGroups"
        },
        type: "POST",
        success: function (response) {
            performDisable2faForAllGroups(response);
        },
        error: function (response) {
            performDisable2faForAllGroups(response);
        },
        async: true
    });
}

function performDisable2faForAllGroups(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
             title: 'Disabling 2FA',
             type: 'success',
             close: 'auto',
             body: '<p>Successfully Disable 2FA for All Groups</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Disabling 2fa for All Groups.</p>'
        });
    }
}

function enable2FAForGroup(groupname) {
    console.log("Calling enable2FAForGroup");
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for Group : '+groupname+' in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForGroup",
            "groupname": groupname
        },
        type: "POST",
        success: function (response) {
            performEnable2FAForGroup(response, groupname);
        },
        error: function (response) {
            performEnable2FAForGroup(response, groupname);
        },
        async: true
    });
}

function disable2FAForGroup(groupname) {
    console.log("Calling disable2FAForGroup");
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for Group : '+groupname+' in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForGroup",
            "groupname": groupname
        },
        type: "POST",
        success: function (response) {
            performDisable2FAForGroup(response, groupname);
        },
        error: function (response) {
            performDisable2FAForGroup(response, groupname);
        },
        async: true
    });
}

function removeLockedUser(username) {
    console.log("Calling disable2FAForGroup");
    require('aui/flag')({
        title: 'Locked User',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Removing Locked user : '+username+' from list in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "RemoveLockedUser",
            "username": username
        },
        type: "POST",
        success: function (response) {
            performRemoveLockedUser(response, username);
        },
        error: function (response) {
            performRemoveLockedUser(response, username);
        },
        async: true
    });
}

function performRemoveLockedUser(response, username) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Locked User',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed Locked User '+username+' from list.</p>'
        });

        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Locked User',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Removing Locked user '+username+' from list.</p>'
        });
    }
}

function removeSelectedLockedUsers(startIndex, endIndex) {
    console.log("Calling removeSelectedLockedUsers");
    var isUserSelected = false;
    var selectedLockedUserList = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedLockedUser"+i).checked;
        if (isChecked == true) {
            isUserSelected = true;
            selectedLockedUserList.push(document.getElementById("selectedLockedUser"+i).value);
        }
    }

    if (isUserSelected == true) {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Removing Selected Locked Users in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "RemoveSelectedLockedUsers",
                "selectedLockedUserList":selectedLockedUserList
            },
            type: "POST",
            success: function (response) {
                performRemoveSelectedLockedUsers(response);
            },
            error: function (response) {
                performRemoveSelectedLockedUsers(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
             title: 'Locked Users',
             type: 'error',
             close: 'auto',
             body: '<p>No User is selected. Please select valid the Users.</p>'
        });
    }
}

function performRemoveSelectedLockedUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed selected Locked User from list.</p>'
        });

        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Removing Locked Users from list.</p>'
        });
    }
}

function removeAllLockedUsers() {
    require('aui/flag')({
        title: 'Locked Users',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Removing All Locked Users in background. You can still access Bamboo, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "RemoveAllLockedUsers"
        },
        type: "POST",
        success: function (response) {
            performRemoveAllLockedUsers(response);
        },
        error: function (response) {
            performRemoveAllLockedUsers(response);
        },
        async: true
    });
}

function performRemoveAllLockedUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed All Locked Users from list.</p>'
        });

        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Removing All Locked Users from list.</p>'
        });
    }
}

function exportUsers() {
    if(document.getElementById("isLicenseEmpty").value == "true"){
        require('aui/flag')({
            title: 'Export Users',
            type: 'error',
            close: 'auto',
            body: '<p>No license found for app. Export Users functionality will not work unless app license is applied.</p>'
        });
    } else{
        var action;
        if (document.getElementById("userSearchFilterAllUsers").selected == true) {
            action = "AllUsers";
        } else if (document.getElementById("userSearchFilterEnabledUsers").selected == true) {
            action = "EnabledUsers";
        } else if (document.getElementById("userSearchFilterConfiguredUsers").selected == true) {
            action = "ConfiguredUsers";
        } else {
            action = "DisabledUsers";
        }
        window.location.href = document.getElementById("exportUsersUrlId").value+"?action="+action;
    }
}

function exportGroups() {
    if(document.getElementById("isLicenseEmpty").value == "true"){
        require('aui/flag')({
            title: 'Export Groups',
            type: 'error',
            close: 'auto',
            body: '<p>No license found for app. Export Groups functionality will not work unless app license is applied.</p>'
        });
    } else{
        var action;
        if (document.getElementById("groupSearchFilterAllGroups").selected == true) {
            action = "AllGroups";
        } else {
            action = "EnabledGroups";
        }
        window.location.href = document.getElementById("exportGroupsUrlId").value+"?action="+action;
    }
}

function openCloseElemenet(elementId){
  document.getElementById(elementId).classList.toggle("showElement");
}

function displayUserManagementSettings() {
    console.log("Call that");
    AJS.dialog2("#user_details_setting").show();
}

function closeUserManagementSettings() {
        AJS.dialog2("#user_details_setting").hide();
}
AJS.$(function() {
    AJS.$("#sendEmailAfterReset2fa").click(function () {
        if (this.checked) {
            AJS.$("#reset2faEmailTemplate").prop('disabled', false);
        } else {
            AJS.$("#reset2faEmailTemplate").prop('disabled', true);
        }
    });
});
