<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
            <#include "*/js/userdetails.js">;
            <#include "*/js/changedImplForOneTime2FAInfo.js">;
            AJS.$(document).ready(function() {
                AJS.$(".aui-nav li").removeClass("aui-nav-selected");
                AJS.$("#USERDETAILS").addClass("aui-nav-selected");

                if (AJS.$("#excludeUsersFromGroup").length > 0 ) {
                    AJS.$("#excludeUsersFromGroup").auiSelect2({
                        placeholder: 'Select the Bamboo Groups',
                        ajax: {
                            url: AJS.contextPath() + '/plugins/servlet/twofactor/view/moapi',
                            data: function (params) {
                                var query = {
                                    search: params,
                                    action: 'fetchGroups'
                                }
                                return query;
                            },
                            results: function (data, page) {
                                return {
                                    results: data.results
                                };
                            },

                        },
                        multiple: true
                    });
                    var excludeGroups = [];

                     <#foreach group in excludeGroupsList>
                        var groupName = '${group}';
                        excludeGroups.push({
                            "id": groupName,
                            "text": groupName
                        });
                     </#foreach>

                     AJS.$("#excludeUsersFromGroup").auiSelect2('data', excludeGroups);
                }
            });
        </script>

        <style type="text/css">
            <#include "*/css/userdetails.css">;
        </style>

	</head>

	<body>
    <#include "*/header.ftl" parse=true>
    <div class="tabs-pane active-pane" id="settings"  role="tabpanel" >
        <#if (pageAccessType.equals("read"))>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>You only have read access of this page, no configuration will be saved!</p>
            </div>
        </#if>
        <h2>User Management</h2>
        <nav class="aui-navgroup aui-navgroup-horizontal" id="min_topmenu">
            <div class="aui-navgroup-inner">
                <div id="navbar" class="aui-navgroup-primary">
                    <div class="tab tab-config">
                        <ul class="aui-nav">
                            <li>
                                <a class="tablinks ${(userManagementSelectedAction == "UserAction")?then('active', '')}" onclick="performActionChange('UserAction')">2FA for Users</a>
                            </li>
                            <li>
                                <a class="tablinks ${(userManagementSelectedAction == "GroupAction")?then('active', '')}" onclick="performActionChange('GroupAction')">2FA for Groups</a>
                            </li>
                            <li>
                                <a class="tablinks ${(userManagementSelectedAction == "LockedUserAction")?then('active', '')}" onclick="performActionChange('LockedUserAction')">Locked Users Accounts</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
        <br>

        <#if (userManagementSelectedAction == "UserAction")>
            <div id="userDetailsDiv">
                <div class="aui-message aui-message-info">
                    <p id="user-action-main-inst" >
                        You can perform 2FA action like Enabling/Disabling/Resetting 2FA for particular users using the 2FA For User action.</br>
                        You can follow the below steps for applying the 2FA actions for any Users.
                    </p>

                    <ol>
                        <li>Search user by name for which you want to perform <b>Enable/Disable/Reset 2FA</b>.</li>
                        <li>Click on <b>Enable 2FA/Disable 2FA/Reset 2FA</b> link of the respective user.</li>
                    </ol>
                    <br>
                    <div class="description"> Note: The counts for Total Users, 2FA Enabled Users, and 2FA Configured Users are calculated by considering both Active and Inactive users.  </div>
                </div>

                <form id="userdetails-user-form" class="aui long-label" action="" method="POST">
                    <input type="hidden" name="atl_token" value="${xsrfToken}" />
                    <input type="hidden" name="userDetailsSubmitted" value="true"/>
                    <input type="hidden" name="exportUsersUrl" id="exportUsersUrlId" value="${exportUsersUrl}"/>
                    <input type="hidden" name="isLicenseEmpty" id="isLicenseEmpty" ${(!settings.isLicenseDefined())?then('value="true"', 'value="false"')}/>

                    <div class ="field-group">
                        <table style="width:100%; margin-left:-230px;" name="2faUserDetails" id="2faUserDetails" >
                            <tbody>
                            <tr>
                                <td width="41%">
                                    <label for="totalLicensedUsers"> Total Users : </label>
                                    <span style="margin-top: 5px;"> ${totalUsersInBamboo}</span>
                                </td>
                                <td width="35%">
                                    <label for="total2faEnabledUsers"> 2FA Enabled Users : </label>
                                    <span style="margin-top: 5px;">${total2faEnabledUsers}</span>
                                </td>
                                <td>
                                    <label for="total2faConfiguredUsers">2FA Configured Users : </label>
                                    <span style="margin-top: 5px;">${total2faConfiguredUsers}</span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <br>
                    <br>

                    <div class ="field-group" style="padding-left: 20px;">
                        <p style="margin-left: 6px;">
                    <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                        <label>Bulk 2FA Action :&nbsp;</label>
                        <select class="select" name="bulk2faAction" id="bulk2faAction" class="bulk2faAction" style="width: 155px;">
                            <option value="">Select Bulk Action</option>
                            <optgroup label="Selected Users">
                                <option value="Enable 2FA For Selected Users">Enable 2FA</option>
                                <option value="Disable 2FA For Selected Users">Disable 2FA</option>
                                <option value="Reset 2FA For Selected Users">Reset 2FA</option>
                            </optgroup>
                            <optgroup label="All Users">
                                <option value="Enable 2FA For All Users">Enable 2FA</option>
                                <option value="Disable 2FA For All Users">Disable 2FA</option>
                                <option value="Reset 2FA For All Users">Reset 2FA</option>
                            </optgroup>
                        </select>&nbsp;
                        <input type='button' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return performBulk2faAction()"/>
                    </#if>
                        <label for="userSearchFilter" <#if (pageAccessType != "" && pageAccessType == "readwrite")> style="margin-left:60px;" </#if> >Apply search on :</label>
                        <select class="select" name="userSearchFilter" id="userSearchFilter" class="userSearchFilter" style="width: 160px;">
                           <option id="userSearchFilterAllUsers" value="AllUsers" ${(userSearchFilter == "AllUsers")?then('selected', '')}>All Users</option>
                           <option id="userSearchFilterEnabledUsers" value="EnabledUsers" ${(userSearchFilter == "EnabledUsers")?then('selected', '')}>2FA Enabled Users</option>
                           <option id="userSearchFilterDisabledUsers" value="DisabledUsers" ${(userSearchFilter == "DisabledUsers")?then('selected', '')}>2FA Disabled Users</option>
                           <option id="userSearchFilterConfiguredUsers" value="ConfiguredUsers" ${(userSearchFilter == "ConfiguredUsers")?then('selected', '')}>2FA Configured Users</option>
                        </select>&nbsp;
                        <select class="select" name="userStatusFilter" id="userStatusFilter" class="userStatusFilter" style="width: 160px;">
                            <option id="userStatusFilterActiveUsers" value="ActiveUsers" ${(userStatusFilter == "ActiveUsers")?then('selected','')}>Active Users</option>
                            <option id="userStatusFilterInActiveUsers" value="InActiveUsers" ${(userStatusFilter == "InActiveUsers")?then('selected','')} >Inactive Users</option>
                            <option id="userStatusFilterAllUsers" value="AllUsers" ${(userStatusFilter == "AllUsers")?then('selected','')} >All Users</option>
                        </select>&nbsp;
                        <input type="text"  id="usernameSearchKeyword" name="usernameSearchKeyword" value="${usernameSearchKeyword}" placeholder="Enter username/email" class="text long-field" style="width: 200px"/>
                        <input type='submit' value='Search' id='search-username-button' style="margin-left:2px;" class="aui-button aui-button-primary"/>&nbsp;

                        <a class="aui-button" onclick="exportUsers()" resolved="" style="height:30px; border:aliceblue; float: right;">
                            <span class="aui-icon aui-icon-small aui-iconfont-devtools-pull-request"></span>&nbsp;Export
                        </a>
                        </p>

                        <#if (currentPageUsersList.size() > 0)>
                            <hr class="header"/>
                            <table class="aui" style="table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th id="number" style="width:5%;">
                                        <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                                            <input type="checkbox" value="true" name="selectAllUsers" id="selectAllUsers" onclick="return toggleAllUsers()"/> &nbsp;
                                        </#if>
                                            #
                                        </th>
                                        <th id="username" style="width:24%;">Username</th>
                                        <th id="email" style="width:20%">Email</th>
                                        <th id="fullname" style="width:24%">Full name</th>
                                        <th id="action" style="width:15%">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <input type="hidden" value="${startIndex}" id="startIndex"/>
                                    <#assign loopCount = startIndex>
                                    <#foreach username in currentPageUsersList>
                                        <#assign trId = "tr"+username>
                                        <tr id="${trId}"
                                            <#if (enable2FAForUserList.contains(username) != true)>
                                                style="background-color: #f5f5f5;"
                                            </#if>
                                        >
                                            <td headers="number">
                                                <#assign selectedUserId = "selectedUser"+loopCount>
                                                <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                                                <input type="checkbox" value="${username}" name="selectedUser" id="${selectedUserId}"/> &nbsp;
                                                </#if>
                                                ${loopCount}
                                            </td>

                                            <#if (username.length() >= 40)>
                                                <#assign tdId = "td_username_"+loopCount >
                                                <td headers="username" id="${tdId}" class="hideElement" onclick="openCloseElemenet('${tdId}')">${username}</td>
                                            <#else>
                                                <td headers="username">${username}</td>
                                            </#if>
                                            <#if (userData.get(emailListIndex).get(username).length() >= 40)>
                                                <#assign tdId = "td_email_"+loopCount >
                                                <td headers="email" id="${tdId}" class="hideElement" onclick="openCloseElemenet('${tdId}')">${userData.get(emailListIndex).get(username)}</td>
                                            <#else>
                                                <td headers="email">${userData.get(emailListIndex).get(username)}</td>
                                            </#if>
                                            <#if (userData.get(fullNameListIndex).get(username).length() >= 40)>
                                                <#assign tdId = "td_fullname_" + loopCount>
                                                <td headers="fullname" id="${tdId}" class="hideElement" onclick="openCloseElemenet('${tdId}')">${userData.get(fullNameListIndex).get(username)}</td>
                                            <#else>
                                                <td headers="fullname">${userData.get(fullNameListIndex).get(username)}</td>
                                            </#if>
                                            <td headers="action">
                                                <p>
                                                    <#if (enable2FAForUserList.contains(username))>
                                                        <#assign spanId = "span"+username>
                                                        <span id="${spanId}">
                                                            <a onclick="return disable2FAForUser('${username}')">Disable 2FA</a>
                                                        </span>
                                                    <#else>
                                                        <#assign spanId = "span"+username>
                                                        <span id="${spanId}">
                                                            <a onclick="return enable2FAForUser('${username}')">Enable 2FA</a>
                                                        </span>
                                                    </#if>
                                                    <#if (configured2FAUserList.contains(username))>
                                                        <#assign resetSpanId = "resetspan"+username>
                                                        <span id="${resetSpanId}">
                                                        &nbsp;|&nbsp;
                                                        <a onclick="return reset2FAForUser('${username}')">Reset 2FA</a>
                                                        </span>
                                                    </#if>
                                                </p>
                                            </td>
                                        </tr>
                                        <#assign loopCount = loopCount + 1>
                                    </#foreach>
                                    <input type="hidden" value="${loopCount}" id="endIndex"/>
                                </tbody>
                            </table>
                            </br>
                            <table style="width:100%">
                                <tr>
                                    <td>
                                        <p>Displaying users <strong>${startIndex}</strong> to
                                        <#if (totalUsers < endIndex)>
                                            <strong>${totalUsers}</strong>
                                        <#else>
                                            <strong>${endIndex}</strong>
                                        </#if>
                                        of <strong>${totalUsers}</strong>.</p>
                                    </td>
                                    <td>
                                        <#if (totalUsers > numberOfRecordsPerPage)>
                                            <ol class="aui-nav aui-nav-pagination" style="float: right;">
                                                <#if (selectedPage != 1)>
                                                    <#assign prevStartIndex = startIndex - numberOfRecordsPerPage>
                                                    <#assign prevEndIndex = endIndex - numberOfRecordsPerPage>
                                                    <li class="aui-nav-previous"><a href="userdetails.action?usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}&statusFilter=${userStatusFilter}"> First</a></li>
                                                    <li class="aui-nav-previous"><a href="userdetails.action?startIndex=${prevStartIndex}&endIndex=${prevEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}&statusFilter=${userStatusFilter}">&lt;&lt; Prev</a></li>
                                                </#if>

                                                <#assign loopCount = 1>
                                                <#assign Startloopdisplay = selectedPage + 3>
                                                <#assign Endloopdisplay = selectedPage - 3>


                                                <#foreach currentPage in numberOfPagesList>
                                                    <#assign currentPageEndIndex = loopCount * numberOfRecordsPerPage>
                                                    <#assign currentPageStartIndex = currentPageEndIndex - numberOfRecordsPerPage + 1>
                                                    <#if (selectedPage == loopCount)>
                                                        <li class="aui-nav-selected"><b><u>${loopCount}</u></b></li>
                                                    <#else>
                                                            <#if ( loopCount >= Endloopdisplay  && selectedPage >= loopCount )>
                                                                <li>
                                                                        <li>
                                                                            <a href="userdetails.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}&statusFilter=${userStatusFilter}">${loopCount}</a>
                                                                        </li>
                                                                </li>
                                                            <#elseif (loopCount <= Startloopdisplay  && selectedPage <= loopCount )>
                                                                <li>
                                                                        <li>
                                                                            <a href="userdetails.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}&statusFilter=${userStatusFilter}">${loopCount}</a>
                                                                        </li>
                                                                </li>
                                                            </#if>
                                                    </#if>
                                                    <#assign loopCount = loopCount + 1>
                                                </#foreach>

                                                <#if (selectedPage != numberOfPagesList.size())>
                                                    <#assign nextStartIndex = startIndex + numberOfRecordsPerPage>
                                                    <#assign nextEndIndex = endIndex + numberOfRecordsPerPage>
                                                        <li class="aui-nav-next"><a href="userdetails.action?startIndex=${nextStartIndex}&endIndex=${nextEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}&statusFilter=${userStatusFilter}">Next &gt;&gt;</a></li>
                                                        <#if (totalUsers % 20==0)>
                                                            <#assign lastIndexStart = totalUsers - 20>
                                                        <#else>
                                                            <#assign lastIndexStart = totalUsers - totalUsers%20>
                                                        </#if>
                                                        <#assign lastIndexEnd = lastIndexStart + 20>
                                                        <#assign lastIndexStart = lastIndexStart + 1>
                                                        <li class="aui-nav-next"><a href="userdetails.action?startIndex=${lastIndexStart}&endIndex=${lastIndexEnd}&usernameSearchKeywordUrl=${usernameSearchKeyword}&searchFilter=${userSearchFilter}&statusFilter=${userStatusFilter}">Last </a></li>
                                                </#if>
                                            </ol>
                                        </#if>
                                    </td>
                                </tr>
                            </table>
                        <#else>
                            <hr class="header"/>
                            <table class="aui">
                                <thead>
                                    <tr>
                                        <th id="number">#</th>
                                        <th id="username">Username</th>
                                        <th id="email">Email</th>
                                        <th id="fullname">Full name</th>
                                        <th id="action">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="5">
                                            <p style="width:100%" align="center">
                                                No user record found.
                                            </p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </#if>
                    </div>
                </form>
            </div> <!--End of USER Details Div -->
        <#elseif (userManagementSelectedAction == "GroupAction")>
            <div id="groupDetailsDiv">
                <div class="aui-message aui-message-info">
                    <p id="user-action-main-inst">
                        You can perform 2FA action like Enabling/Disabling 2FA for particular Groups using the 2FA for Group action.</br>
                        You can follow the below steps for applying the 2FA actions for any Groups.
                    </p>

                    <ol>
                        <li>Search Group by name for which you want to perform <b>Enable/Disable 2FA</b>.</li>
                        <li>Click on <b>Enable 2FA/Disable 2FA</b> link of the respective group for Enabling/Disabling the 2FA for all the users from the Group.</li>
                    </ol>
                </div>

                <form id="details-group-form-1" class="aui long-label" action="" method="POST">
                    <input type="hidden" name="atl_token" value="${xsrfToken}" />
                    <input type="hidden" name="groupDetailsSubmitted" value="true"/>
                    <input type="hidden" name="currentForm" value="Form2"/>
                    <input type="hidden" name="exportGroupsUrl" id="exportGroupsUrlId" value="${exportGroupsUrl}"/>
                        <input type="hidden" name="isLicenseEmpty" id="isLicenseEmpty" ${(!settings.isLicenseDefined())?then('value="true"', 'value="false"')}/>

                    <div id="excludeGroups">
                        <h3 class="subsection_title">Skip 2FA for Groups</h3>
                        <div class ="field-group" style="margin-top:10px;">
                            <label for="excludeGroups">Skip 2FA for Groups :</label>
                            <input class="select long-field" name="excludeGroups" id="excludeUsersFromGroup" style="width: 270px" placeholder="Enter Group name">
                            </input>&nbsp;
                            <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                            <div style="margin-top: -33px;margin-left: 290px;">
                                <input type="submit" value="Apply" id="search-group-button" class="aui-button aui-button-primary" resolved="">
                            </div>
                            </#if>
                            <div class="description">It will never ask for the 2FA from the users of the selected Group(s).<br>
                            </div>
                        </div>
                    </div>
                    <br>
                </form>

                <div id="enableDisbale2fa">
                    <h3 class="subsection_title">Enable/Disable 2FA for Groups</h3>
                    <form id="details-group-form" class="aui long-label" action="" method="POST">
                        <input type="hidden" name="atl_token" value="${xsrfToken}" />
                        <input type="hidden" name="groupDetailsSubmitted" value="true"/>
                        <input type="hidden" name="currentForm" value="Form1"/>
                        <input type="hidden" name="exportGroupsUrl" id="exportGroupsUrlId" value="${exportGroupsUrl}"/>
                        <input type="hidden" name="isLicenseEmpty" id="isLicenseEmpty" ${(!settings.isLicenseDefined())?then('value="true"', 'value="false"')}/>

                        <div class ="field-group" style="margin-top:10px;">
                            <label for="total2faEnabledGroups">2FA Enabled Groups : </label>
                            <p style="margin-top: 5px;">${total2faEnabledGroups}</p>
                        </div>
                        <br>

                        </br>

                        <div class ="field-group" style="padding-left: 20px;">
                            <p>
                            <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                                <label>Bulk 2FA Action :&nbsp;</label>
                                <select class="select" name="bulk2faAction" id="bulk2faAction" class="bulk2faAction" style="width: 155px;">
                                    <option value="">Select Bulk Action</option>
                                    <optgroup label="Selected Groups">
                                        <option value="Enable 2FA For Selected Groups">Enable 2FA</option>
                                        <option value="Disable 2FA For Selected Groups">Disable 2FA</option>
                                    </optgroup>
                                    <optgroup label="All Groups">
                                        <option value="Enable 2FA For All Groups">Enable 2FA</option>
                                        <option value="Disable 2FA For All Groups">Disable 2FA</option>
                                    </optgroup>
                                </select>&nbsp;
                                <input type='button' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return performBulk2faAction()"/>
                            </#if>
                                <label for="groupSearchFilter" <#if (pageAccessType != "" && pageAccessType == "readwrite")> style="margin-left:75px;" </#if>>Apply search on :</label>
                                <select class="select" name="groupSearchFilter" id="groupSearchFilter" class="groupSearchFilter" style="width: 200px;">
                                    <#if (groupSearchFilter == "AllGroups")>
                                        <option id="groupSearchFilterAllGroups" value="AllGroups" selected>All Groups</option>
                                    <#else>
                                        <option id="groupSearchFilterAllGroups" value="AllGroups">All Groups</option>
                                    </#if>

                                    <#if (groupSearchFilter == "EnabledGroups")>
                                        <option id="groupSearchFilterEnabledGroups" value="EnabledGroups" selected>2FA Enabled Groups</option>
                                    <#else>
                                        <option id="groupSearchFilterEnabledGroups" value="EnabledGroups">2FA Enabled Groups</option>
                                    </#if>
                                </select>&nbsp;
                                <input type="text"  id="groupSearchKeyword" name="groupSearchKeyword" value="${groupSearchKeyword}" placeholder="Enter Group name" class="text long-field" style="width: 200px"/>
                                <input type='submit' value='Search' id='search-group-button' style="margin-left:2px;" class="aui-button aui-button-primary"/>

                                <a class="aui-button" onclick="exportGroups()" resolved="" style="height:30px; border:aliceblue; float: right;">
                                    <span class="aui-icon aui-icon-small aui-iconfont-devtools-pull-request"></span>&nbsp;Export
                                </a>
                            </p>

                            <#if (currentPageGroupsList.size() > 0)>
                                <hr class="header"/>
                                <table class="aui">
                                    <thead>
                                        <tr>
                                            <th id="number">
                                            <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                                                <input type="checkbox" value="true" name="selectAllGroups" id="selectAllGroups" onclick="return toggleAllGroups()"/> &nbsp;
                                            </#if>
                                                #
                                            </th>
                                            <th id="groupname">Group Name</th>
                                            <th id="action">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <input type="hidden" value="${startIndex}" id="startIndex"/>
                                        <#assign loopCount = startIndex>
                                        <#foreach groupname in currentPageGroupsList>
                                            <#assign trId = "tr"+groupname>
                                            <tr id="${trId}"
                                                <#if (!enable2FAForGroupList.contains(groupname))>
                                                    style="background-color: #f5f5f5;"
                                                </#if>
                                            >
                                                <td headers="number">
                                                    <#assign selectedGroupId = "selectedGroup"+loopCount>
                                                    <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                                                    <input type="checkbox" value="${groupname}" name="selectedGroup" id="${selectedGroupId}"/> &nbsp;
                                                    </#if>
                                                    ${loopCount}
                                                </td>
                                                <td headers="groupname">${groupname}</td>
                                                <td headers="action">
                                                    <p>
                                                        <#if (enable2FAForGroupList.contains(groupname))>
                                                            <#assign spanId = "span"+groupname>
                                                            <span id="${spanId}">
                                                                <a onclick="return disable2FAForGroup('${groupname}')">Disable 2FA</a>
                                                            </span>
                                                        <#else>
                                                            <#assign spanId = "span"+groupname>
                                                            <span id="${spanId}">
                                                                <a onclick="return enable2FAForGroup('${groupname}')">Enable 2FA</a>
                                                            </span>
                                                        </#if>
                                                    </p>
                                                </td>
                                            </tr>
                                            <#assign loopCount = loopCount + 1>
                                        </#foreach>
                                        <input type="hidden" value="${loopCount}" id="endIndex"/>
                                    </tbody>
                                </table>
                                </br>
                                <table style="width:100%">
                                    <tr>
                                        <td>
                                            <p>Displaying groups <strong>${startIndex}</strong> to
                                            <#if (totalGroups < endIndex)>
                                                <strong>${totalGroups}</strong>
                                            <#else>
                                                <strong>${endIndex}</strong>
                                            </#if>
                                            of <strong>${totalGroups}</strong>.</p>
                                        </td>
                                        <td>
                                            <#if (totalGroups > numberOfRecordsPerPage)>
                                                <ol class="aui-nav aui-nav-pagination" style="float: right;">
                                                    <#if (selectedPage != 1)>
                                                        <#assign prevStartIndex = startIndex - numberOfRecordsPerPage>
                                                        <#assign prevEndIndex = endIndex - numberOfRecordsPerPage>
                                                        <li class="aui-nav-previous"><a href="userdetails.action?groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}"> First</a></li>
                                                        <li class="aui-nav-previous"><a href="userdetails.action?startIndex=${prevStartIndex}&endIndex=${prevEndIndex}&groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}">&lt;&lt; Prev</a></li>
                                                    </#if>

                                                    <#assign loopCount = 1>
                                                    <#assign Startloopdisplay = selectedPage + 3>
                                                    <#assign Endloopdisplay = selectedPage - 3>

                                                    <#foreach currentPage in numberOfPagesList>
                                                        <#assign currentPageEndIndex = loopCount * numberOfRecordsPerPage>
                                                        <#assign currentPageStartIndex = currentPageEndIndex - numberOfRecordsPerPage + 1>
                                                        <#if (selectedPage == loopCount)>
                                                            <li class="aui-nav-selected"><b><u>${loopCount}</u></b></li>
                                                        <#else>
                                                            <#if (loopCount >= Endloopdisplay  && selectedPage >= loopCount )>
                                                                <li>
                                                                    <li>
                                                                        <a href="userdetails.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}">${loopCount}</a>
                                                                    </li>
                                                                </li>
                                                                <#elseif (loopCount <= Startloopdisplay  && selectedPage <= loopCount )>
                                                                <li>
                                                                    <li>
                                                                        <a href="userdetails.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}">${loopCount}</a>
                                                                    </li>
                                                                </li>
                                                            </#if>
                                                        </#if>
                                                        <#assign loopCount = loopCount + 1>
                                                    </#foreach>

                                                    <#if (selectedPage != numberOfPagesList.size())>
                                                        <#assign nextStartIndex = startIndex + numberOfRecordsPerPage>
                                                        <#assign nextEndIndex = endIndex + numberOfRecordsPerPage>
                                                        <li class="aui-nav-next"><a href="userdetails.action?startIndex=${nextStartIndex}&endIndex=${nextEndIndex}&groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}">Next &gt;&gt;</a></li>
                                                        <#if (totalGroups % 20==0)>
                                                            <#assign lastIndexStart = totalGroups - 20>
                                                        <#else>
                                                            <#assign lastIndexStart = totalGroups - totalGroups%20>
                                                        </#if>
                                                            <#assign lastIndexEnd = lastIndexStart +20>
                                                            <#assign lastIndexStart = lastIndexStart + 1>
                                                            <li class="aui-nav-next"><a href="userdetails.action?startIndex=${lastIndexStart}&endIndex=${lastIndexEnd}&groupSearchKeywordUrl=${groupSearchKeyword}&searchFilter=${groupSearchFilter}">Last </a></li>
                                                    </#if>
                                                </ol>
                                            </#if>
                                        </td>
                                    </tr>
                                </table>
                            <#else>
                                <div class ="field-group" style="padding-left: 92px;">
                                    <hr class="header"/>
                                    <table class="aui">
                                        <thead>
                                            <tr>
                                                <th id="number">#</th>
                                                <th id="groupname">Group Name</th>
                                                <th id="action">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td colspan="3">
                                                    <p style="width:100%" align="center">
                                                        No group record found.
                                                    </p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </#if>
                        </div>
                    </form>
                    <br>
                </div>
                <hr class="header" />
            </div> <!--End of GROUP Details Div -->
        <#else>
            <div id="lockedUserDetailsDiv">
                <div class="aui-message aui-message-info">
                    <p id="user-action-main-inst">
                        This section allows you to manage locked users.</br>
                        You can follow the below steps for unlocking the user.
                    </p>

                    <ol>
                        <li>Search User by username for which you want to Unlock.</li>
                        <li>Click on <b>Unlock</b> action against the respective User to Unlock the user.</li>
                    </ol>
                </div>

                <form id="locked-userdetails-form" class="aui long-label" action="" method="POST">
                    <input type="hidden" name="atl_token" value="${xsrfToken}" />
                    <input type="hidden" name="lockedUserDetailsSubmitted" value="true"/>

                    <div class ="field-group" style="margin-left:-74px">
                        <label for="userSearch">Search for Username :</label>
                        <input type="text"  id="usernameSearchKeyword" name="usernameSearchKeyword" value="${usernameSearchKeyword}"
                               placeholder="Enter username" class="text long-field" style="width: 200px"/>&nbsp;&nbsp;
                        <input type='submit' value='Search' id='search-user-button' style="margin-left:2px;" class="aui-button aui-button-primary"/>
                    </div>
                    </br>

                    <#if (currentPageLockedUserDetails.size() > 0)>
                        <div class ="field-group" style="padding-left: 20px;">
                            <p>
                            <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                                <label>Bulk 2FA Action :&nbsp;</label>
                                <select class="select" name="bulk2faAction" id="bulk2faAction" class="bulk2faAction" style="width: 200px;">
                                    <option value="">Select Bulk Action</option>
                                    <optgroup label="Selected Users">
                                        <option value="Remove Selected Locked Users">Remove</option>
                                    </optgroup>
                                    <optgroup label="All Users">
                                        <option value="Remove All Locked Users">Remove</option>
                                    </optgroup>
                                </select>&nbsp;
                                <input type='button' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return performBulk2faAction()"/>&nbsp;
                            </#if>
                            </p>
                            <hr class="header"/>
                            <table class="aui" style="table-layout: fixed;">
                                <thead>
                                    <tr>
                                        <th id="number" style="width:5%;">
                                        <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                                            <input type="checkbox" value="true" name="selectAllLockedUsers" id="selectAllLockedUsers" onclick="return toggleAllLockedUsers()"/> &nbsp;
                                        </#if>
                                            #
                                        </th>
                                        <th id="username" style="width:45%">Username</th>
                                        <th id="expiryDate" style="width:20%;">Locking Expiry Date</th>
                                        <th id="ipAddress" style="width:10%;">IP Address</th>
                                        <th id="action" style="width:15%;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <input type="hidden" value="${startIndex}" id="startIndex"/>
                                    <#assign loopCount = startIndex>
                                    <#foreach username in currentPageLockedUserDetails.keySet()>
                                        <#assign trId = "tr"+username>
                                        <tr id="${trId}">
                                            <td headers="number">
                                                <#assign selectedLockedUserId = "selectedLockedUser"+loopCount>
                                                <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                                                <input type="checkbox" value="${username}" name="selectedLockedUser" id="${selectedLockedUserId}"/> &nbsp;
                                                </#if>
                                                ${loopCount}
                                            </td>
                                            <#if (username.length() >= 40)>
                                                <#assign tdId = "td_username_"+ loopCount>
                                                <td headers="username" id="${tdId}" class="hideElement" onclick="openCloseElemenet('${tdId}')">${username}</td>
                                            <#else>
                                                <td headers="username">${username}</td>
                                            </#if>
                                            <#assign rowValue = currentPageLockedUserDetails.get(username)>
                                            <#assign count = 0>
                                            <#list rowValue?split("=====") as fieldValue>
                                                <#if fieldValue != "">
                                                    <#if count == 0>
                                                        <td headers="expiryDate">${fieldValue}</td>
                                                    <#else>
                                                        <td headers="ipAddress">${fieldValue}</td>
                                                    </#if>
                                                    <#assign count = count + 1>
                                                </#if>
                                            </#list>
                                            <td headers="action">
                                                <p>
                                                    <span>
                                                        <a onclick="return removeLockedUser('${username}')">Remove</a>
                                                    </span>
                                                </p>
                                            </td>
                                        </tr>
                                        <#assign loopCount = loopCount + 1>
                                    </#foreach>
                                    <input type="hidden" value="${loopCount}" id="endIndex"/>
                                </tbody>
                            </table>
                            </br>
                            <table style="width:100%">
                                <tr>
                                    <td>
                                        <p>Displaying Users <strong>${startIndex}</strong> to
                                        <#if (lockedUserDetails.size() < endIndex)>
                                            <strong>${lockedUserDetails.size()}</strong>
                                        <#else>
                                            <strong>${endIndex}</strong>
                                        </#if>
                                        of <strong>${lockedUserDetails.size()}</strong>.</p>
                                    </td>
                                    <td>
                                        <#if (lockedUserDetails.size() > numberOfRecordsPerPage)>
                                            <ol class="aui-nav aui-nav-pagination content-navigation">
                                                <#if (selectedPage != 1)>
                                                    <#assign prevStartIndex = startIndex - numberOfRecordsPerPage>
                                                    <#assign prevEndIndex = endIndex - numberOfRecordsPerPage>
                                                    <li class="aui-nav-previous"><a href="userdetails.action?startIndex=${prevStartIndex}&endIndex=${prevEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeywordUrl}-">&lt;&lt; Prev</a></li>
                                                </#if>

                                                <#assign loopCount = 1>

                                                <#foreach currentPage in numberOfPagesList>
                                                    <#assign currentPageEndIndex = loopCount * numberOfRecordsPerPage>
                                                    <#assign currentPageStartIndex = currentPageEndIndex - numberOfRecordsPerPage + 1>
                                                    <#if (selectedPage == loopCount)>
                                                        <li class="aui-nav-selected"><b><u>${loopCount}</u></b></li>
                                                    <#else>
                                                        <li><a href="userdetails.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeywordUrl}">${loopCount}</a></li>
                                                    </#if>
                                                    <#assign loopCount = loopCount + 1>
                                                </#foreach>

                                                <#if (selectedPage != numberOfPagesList.size())>
                                                    <#assign nextStartIndex = startIndex + numberOfRecordsPerPage>
                                                    <#assign nextEndIndex = endIndex + numberOfRecordsPerPage>
                                                    <li class="aui-nav-next"><a href="userdetails.action?startIndex=${nextStartIndex}&endIndex=${nextEndIndex}&usernameSearchKeywordUrl=${usernameSearchKeywordUrl}">Next &gt;&gt;</a></li>
                                                </#if>
                                            </ol>
                                        </#if>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    <#else>
                        <div class ="field-group" style="padding-left: 20px;">
                            <hr class="header"/>
                            <table class="aui">
                                <thead>
                                    <tr>
                                        <th id="number">#</th>
                                        <th id="username">Username</th>
                                        <th id="expiryDate">Locking Expiry Date</th>
                                        <th id="ipAddress">IP Address</th>
                                        <th id="action">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="5">
                                            <p style="width:100%" align="center">
                                                No user record found.
                                            </p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </#if>
                </form>
            </div> <!--End of LOCKED Details Div -->
        </#if>
    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>

