(function ($) {
    var url = window.location.href;

    if (url.indexOf("/userlogin") > 0
        || url.indexOf("/inlineregistration_") > 0
        || url.indexOf("/validate_") > 0) {

        if (ReadCookie("DEVICEDETAILS") != "") {
            deleteCookie("DEVICEDETAILS");
        }

        var
            a = getUserAgent(),
            b = getBrowser(),
            c = getOS(),
            d = getScreenPrint(),   //this contains details about screen resolution - it will not be added to the fingerprint
            e = getPlugins(),
            f = isJava(),
            g = getAppCodeName(),
            h = getLanguages(),
            k = isCookie(),
            l = getTimeZone(),
            m = getLanguage(),
            n = isCanvas();

        var fingerprint =
                a +"||" +
                b +"||" +
                c +"||" +
                e +"||" +
                f +"||" +
                g +"||" +
                h +"||" +
                k +"||" +
                l +"||" +
                m +"||" +
                n;
        fingerprint = fingerprint.replace(/[^\x00-\x7F]/g,"");
        setCookie("DEVICEDETAILS", fingerprint);
    }

    // a/0
    function getUserAgent() {
        return replaceAll(window.navigator.userAgent, ";", ":");
    };

    function escapeRegExp(string){
        return string.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    }

    function replaceAll(str, term, replacement) {
      return str.replace(new RegExp(escapeRegExp(term), 'g'), replacement);
    }

    // b/1
    function getBrowser() {
        var nAgt = window.navigator.userAgent;
        var browserName = "";
        // In Opera 15+, the true version is after "OPR/"
        if ((verOffset=nAgt.indexOf("OPR/"))!=-1) {
         browserName = "Opera";
        }
        // In older Opera, the true version is after "Opera" or after "Version"
        else if ((verOffset=nAgt.indexOf("Opera"))!=-1) {
         browserName = "Opera";
        }
        else if ((verOffset=nAgt.indexOf("Edg"))!=-1) {
         browserName = "Microsoft Edge";
        }
        // In MSIE, the true version is after "MSIE" in userAgent
        else if ((verOffset=nAgt.indexOf("MSIE"))!=-1 || (verOffset=nAgt.indexOf("Trident/"))!=-1) {
         browserName = "Microsoft Internet Explorer";
        }
        // In Chrome, the true version is after "Chrome"
        else if ((verOffset=nAgt.indexOf("Chromium"))!=-1) {
         browserName = "Chromium";
        }// In Chrome, the true version is after "Chrome"
        else if ((verOffset=nAgt.indexOf("Chrome"))!=-1) {
         browserName = "Chrome";
        }
        // In Safari, the true version is after "Safari" or after "Version"
        else if ((verOffset=nAgt.indexOf("Safari"))!=-1) {
         browserName = "Safari";
        }
        // In Firefox, the true version is after "Firefox"
        else if ((verOffset=nAgt.indexOf("Firefox"))!=-1) {
         browserName = "Firefox";
        }
        // In most other browsers, "name/version" is at the end of userAgent
        else if ( (nameOffset=nAgt.lastIndexOf(' ')+1) <
                  (verOffset=nAgt.lastIndexOf('/')) )
        {
            browserName = nAgt.substring(nameOffset,verOffset);
            fullVersion = nAgt.substring(verOffset+1);
            if (browserName.toLowerCase()==browserName.toUpperCase()) {
                browserName = navigator.appName;
            }
        }

        if (browserName === "") {
            browserName = "undefined";
        } else {
            if ((verOffset=nAgt.indexOf("Android"))!=-1) {
             browserName = browserName + "(Android)";
            } else if ((verOffset=nAgt.indexOf("iPhone"))!=-1) {
             browserName = browserName + "(iPhone)";
            }
        }

        // trim the fullVersion string at semicolon/space if present
        return browserName;
    };

    // c/2
    function getOS() {
        var appVersion = window.navigator.appVersion;
        var Name = "";
        if (appVersion.indexOf("Win") != -1) Name = "Windows OS";
        if (appVersion.indexOf("Mac") != -1) Name = "MacOS";
        if (appVersion.indexOf("X11") != -1) Name = "UNIX OS";
        if (appVersion.indexOf("Linux") != -1) Name = "Linux OS";
        return Name;
    };

    // d/3
    function getScreenPrint() {
        return "Current Resolution: " + getCurrentResolution()
        + ", Available Resolution: " + getAvailableResolution()
        + ", Color Depth: " + getColorDepth()
        + ", Device XDPI: " + getDeviceXDPI()
        + ", Device YDPI: " + getDeviceYDPI();
    };

    function getColorDepth() {
        return screen.colorDepth;
    };

    function getCurrentResolution() {
        return screen.width + "x" + screen.height;
    };

    function getAvailableResolution() {
        return screen.availWidth +
            "x" + screen.availHeight;
    };

    function getDeviceXDPI() {
        return screen.deviceXDPI;
    }

    function getDeviceYDPI() {
        return screen.deviceYDPI;
    }

    // e/4
    function getPlugins() {
        for (var a = "", b = 0; b < navigator.plugins.length; b++)
            a = b == navigator.plugins.length - 1 ? a + navigator.plugins[b].name : a + (navigator.plugins[b].name + ", ");
        return a
    };

    // f/5
    function isJava() {
        return navigator.javaEnabled();
    }

    // g/6
    function getAppCodeName() {
        return navigator.appCodeName;
    }

    // h/7
    function getLanguages() {
        for (var a = "", b = 0; b < navigator.languages.length; b++)
            a = b == navigator.languages.length - 1 ? a + navigator.languages[b] : a + (navigator.languages[b] + ", ");
        return a
    }

    // i/8
    function getVendor() {
        return navigator.vendor;
    }

    // j/9
    function getSessionStorageLength() {
        return sessionStorage.length;
    }

    // k/10
    function isCookie() {
        return navigator.cookieEnabled;
    }

    // l/11
    function getTimeZone() {
        return String(String(new Date).split("(")[1]).split(")")[0];
    }

    // m/12
    function getLanguage() {
        return navigator.language;
    }

    // n/13
    function isCanvas() {
        var a = document.createElement("canvas");
        return !(!a.getContext || !a.getContext("2d"));
    }

    function ReadCookie(cname) {
        //alert(cname);
        var name = cname + "=";
        var decodedCookie = document.cookie;
        var ca = decodedCookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                //alert(" found");
                return c.substring(name.length, c.length);
            }
        }
        //alert("not found");
        return "";
    }

    function deleteCookie(name) {
        document.cookie = name + '=;expires=Thu, 01 Jan 1970 00:00:01 GMT;';
    }

    function setCookie(key, value) {
        var d = new Date();
        if (AJS.contextPath() == "") {
            document.cookie = key+"="+value+";max-age="+30*24*60*60+";path=/"+";secure";
        } else {
            document.cookie = key+"="+value+";max-age="+30*24*60*60+";path="+AJS.contextPath()+";secure";
        }
    }
})(AJS.$ || jQuery);