<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
            <#include "*/js/advancesettings.js">;
            <#include "*/js/changedImplForOneTime2FAInfo.js">;
        </script>

        <style>
            <#include "*/css/advancesettings.css">;
        </style>
	</head>

	<body>
	<#include "*/header.ftl" parse=true>
    <div class="tabs-pane active-pane" id="settings"  role="tabpanel" >
        <#if (pageAccessType.equals("read"))>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>You only have read access of this page, no configuration will be saved!</p>
            </div>
        </#if>
        <#if (showWarningMssg == true)>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>Some of the configurations from <b>Access to Plugin Pages</b> are not saved!</p>
            </div>
        </#if>
        <h2>Advanced Options</h2>
        <hr class="header"/>

        <form id="settings-form" class="aui long-label" action="" method="POST">
            <input type="hidden" name="settingsSubmitted" value="true"/>
            <input type="hidden" name="atl_token" value="${xsrfToken}" />

            <div id="authenticationSpecificMethod">
                <h3 class="subsection_title"> User Flow Configurations </h3>
                <div class="field-group" style="padding-left: 250px;">
                    <aui-toggle id="allowToReconfigureMethod" value="true" label="Allow to reconfigure" name="allowToReconfigureMethod"
                            ${(allowToReconfigureMethod == true)?then('checked="true"', '')}></aui-toggle>
                    <span style="height:16px; width: 16px">&nbsp;Allow to reconfigure/reset 2FA method</span>
                    <div class="description">
                        If this option is enabled, user will be able to reconfigure the configured 2FA method.
                    </div>
                </div>
                <br>
                <div class="field-group" style="padding-left: 250px;">
                    <aui-toggle id="enableEnforceCurrentMethod" value="true" onclick="validateEnforcePrimaryMethod()"
                                label="Enforce primary method" name="enableEnforceCurrentMethod"
                            ${(enableEnforceCurrentMethod == true)?then('checked="true"', '')}></aui-toggle>
                    <span style="height:16px; width: 16px">&nbsp;Enforce Current/Primary Method for User</span>
                    <div class="description">
                        With this option, admin can forcefully set the primary method for user. So the users are always redirected to the selected 2fa method for validation.
                    </div>
                </div>

                    <div id="primaryMethodForUserDiv" ${(enableEnforceCurrentMethod != true)?then('style="display:none"', '')}>
                        <div class="field-group" style="padding-left: 250px;">
                            <label>Primary method for user : </label>
                            <table style="width: 100%;">
                                <tr>
                                    <td style="width: 20%;">
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodGoogleAuthenticator"
                                               value="GoogleAuthenticator" ${(primaryMethodForUser == "GoogleAuthenticator")?then('checked="true"', '')} />
                                        <label for="primaryMethodGoogleAuthenticator">Mobile Authenticator</label>
                                    </td>

                                    <td style="width: 25%;">
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodHardwareToken"
                                               value="YubikeyHardwareTokenAsU2F" ${(primaryMethodForUser == "YubikeyHardwareTokenAsU2F")?then('checked="true"', '')} />
                                        <label for="primaryMethodHardwareToken">Yubikey Hardware Token(U2F)</label>
                                    </td>

                                    <td style="width: 25%;">
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryDuoPushNotification"
                                               value="DuoPushNotification" ${(primaryMethodForUser == "DuoPushNotification")?then('checked="true"', '')} />
                                        <label for="primaryDuoPushNotification">Duo Push Notification</label>
                                    </td>


                                </tr>
                                <tr>
                                    <td>
                                        <br>
                                    </td>
                                </tr>
                                <tr>

                                    <td style="width: 20%;">
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodWebAuthn" value="WebAuthn"
                                                ${(primaryMethodForUser == "WebAuthn")?then('checked="true"', '')} />
                                        <label for="primaryMethodWebAuthn">Web Authentication</label>
                                    </td>

                                    <td style="width: 15%;">
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodOtpOverEmail" value="OtpOverEmail"
                                                ${(primaryMethodForUser == "OtpOverEmail")?then('checked="true"', '')} />
                                        <label for="primaryMethodOtpOverEmail">OTP Over Email</label>
                                    </td>

                                    <td style="width: 15%;">
                                            <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodOtpOverSms" value="OtpOverSms"
                                                    ${(primaryMethodForUser == "OtpOverSms")?then('checked="true"', '')} />
                                        <label for="primaryMethodOtpOverSms">OTP Over SMS</label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <br>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="width: 20%;">
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodSecurityQuestion" value="SecurityQuestion"
                                                ${(primaryMethodForUser == "SecurityQuestion")?then('checked="true"', '')} />
                                        <label for="primaryMethodSecurityQuestion">Security Question</label>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                <br>
                <div class="field-group" style="padding-left: 250px;">
                    <aui-toggle id="showRemaining2FAMethodsAfterConfiguration" value="true" label="show remaining methods" name="showRemaining2FAMethodsAfterConfiguration"
                            ${(showRemaining2FAMethodsAfterConfiguration == true)?then('checked="true"', '')}></aui-toggle>
                    <span style="height:16px; width: 16px">&nbsp;&nbsp;Show Remaining 2FA Method After Configuration/Inline Registration</span>
                    <div class="description">
                        If this is enabled then after successfully configuring one primary and backup method, the end users will see all the remaining 2FA methods(enabled by admin)
                        and they can configure multiple methods.
                    </div>
                </div>
                <br>
                <div class="field-group" style="padding-left: 250px;">
                    <aui-toggle id="showAllConfiguredMethodsDirectly" value="true" onclick="validateShowAllConfigureMethod()" label="show all configured methods" name="showAllConfiguredMethodsDirectly"
                            ${(showAllConfiguredMethodsDirectly == true)?then('checked="true"', '')}></aui-toggle>
                    <span style="height:16px; width: 16px">&nbsp;Show All Configured Methods to User for 2FA Validation</span>
                    <div class="description">
                        If user has configured multiple 2FA methods then, with this option, user will see the list of all configured 2FA methods which are enabled by admin while logging in and user can choose
                        any 2FA method for validation. If this option is disabled then user will be redirected to user's primary 2FA method for validation.
                    </div>
                </div>
            </div>
            <br><br>

            <div id="bruteForceSettingsDiv">
                <h3 class="subsection_title">Brute Force Protection</h3>
                <div class="field-group">
                    <aui-toggle id="enableBruteForceProtection" value="true" label="Enable BruteForce Protection" name="enableBruteForceProtection"
                            ${(enableBruteForceProtection == true)?then('checked="true"', '')}></aui-toggle>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Brute Force Protection for Bamboo
                    </span>
                    <div class="description">The Enable Brute force checkbox allows you to restrict Bamboo access based on the number of Invalid Login Attempts.<br>NOTE: The addon's Brute Force Protection won't be effective when Yubikey Hardware Token/Web Authentication is used as a Primary 2FA method.</div>
                </div>

                <div class="field-group">
                    <label for="bruteForceNumberOfAttempts">Number of Attempts : </label>
                    <input type="number" id="bruteForceNumberOfAttempts" name="bruteForceNumberOfAttempts"
                          value="${bruteForceNumberOfAttempts}" class="text" min="1" max="10" style="width: 80px;"
                            ${(enableBruteForceProtection != true)?then('disabled', '')} />
                    <div class="description">Select the number of invalid login attempts to lock the user account.</div>
                </div>

                <div class="field-group">
                    <label>User Locked out Period : </label>
                    <table>
                    <tr>
                    <td>
                        <select class="select" id="bruteForceTimeInterval" name="bruteForceTimeInterval" ${(enableBruteForceProtection != true)?then('disabled', '')} style="width: 110px;">
                        <option value="15 minutes" <#if bruteForceTimeInterval.equals("15 minutes")>selected </#if>>15 Minutes</option>
                        <option value="30 minutes" <#if bruteForceTimeInterval.equals("30 minutes")>selected </#if>>30 Minutes</option>
                        <option value="1 hour" <#if bruteForceTimeInterval.equals("1 hour")>selected </#if>>1 Hour</option>
                        <option value="5 hours" <#if bruteForceTimeInterval.equals("5 hours")>selected </#if>>5 Hours</option>
                        <option value="1 day" <#if bruteForceTimeInterval.equals("1 day")>selected </#if>>1 Day</option>
                        <option value="7 days" <#if bruteForceTimeInterval.equals("7 days")>selected </#if>>7 Days</option>
                        <option value="custom" <#if bruteForceTimeInterval.equals("custom")>selected </#if>>Custom</option>
                    </select>
                    </td>

                    <td>
                        <input type="number" id="bruteForceCustomTimeDuration" name="bruteForceCustomTimeDuration"
                              value="${bruteForceCustomTimeDuration}" class="text" min="1" ${(bruteForceTimeInterval.equals("custom"))?then('style="width: 80px; display:block"', 'style="width: 80px; display:none"')} <#if enableBruteForceProtection != true> disabled </#if> />
                    </td>

                    <td>
                        <select class="select" id="bruteForceCustomTimeInterval" name="bruteForceCustomTimeInterval" ${(bruteForceTimeInterval.equals("custom"))?then('style="width: 80px; display:block"', 'style="width: 80px; display:none"')} <#if enableBruteForceProtection != true> disabled </#if>>
                        <option value="minutes" <#if bruteForceCustomTimeInterval.equals("minutes")>selected </#if>>Minutes</option>
                        <option value="hours" <#if bruteForceCustomTimeInterval.equals("hours")>selected </#if>>Hours</option>
                        <option value="days" <#if bruteForceCustomTimeInterval.equals("days")>selected </#if>>Days</option>
                        </select>
                    </td>
                    </tr>
                    </table>
                    <div class="description">Once this time is expired, the user will be able to login to Bamboo again.</div>
                </div>
                    <div class="field-group">
                        <label for="emailTemplateBruteForce">Blocked Email Template : </label>
                        <textarea id="emailTemplateBruteForce" name="emailTemplateBruteForce" class="textarea long-field" style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false" ${(enableBruteForceProtection != true)?then('disabled', '')}>${emailTemplateBruteForce}</textarea>
                        <div class="description">You can customize email template sent to user. Use variable $$ipaddress$$ to add ipaddress in template</div>
                    </div>
            </div>

            <br>
            <div id="multiLingualSupportDiv">
                <h3 style="font-size: 18px; margin: auto 0; padding-bottom: 1rem;width: 100%;border-bottom: 2px solid #0065ff; margin-bottom: 20px;">Multilingual Support</h3>
                <div class="field-group">
                    <aui-toggle id="multiLingualSupportToggleId" value="true" label="Enable Multilingual Support" name="multiLingualSupportToggle"
                        ${(multiLingualSupportToggle == true)?then('checked="true"', '')}></aui-toggle>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Multilingual Support for Users
                    </span>
                    <div class="description">By enabling this feature,  users will be able to select their preferred language on all 2FA plugin pages.
                    <br>
                        <b>NOTE</b>: If your end-user base primarily uses only one specific language, you can customize templates from the <a href="twofactor.lookandfeeltemplates.jspa" target="_blank">Look & Feel Templates</a> tab. However, if your end users belongs from different regions and speak different languages then use this feature.
                    </div>

                </div>

            </div>



            <br>
            <div id="rememberMeDeviceSettingsDiv">
                <h3 class="subsection_title">Remember My Device</h3>

                <div class="field-group">
                    <aui-toggle id="enableRememberMeDevice" value="true" label="Enable Remember Me" name="enableRememberMeDevice" ${(enableRememberMeDevice == true)?then('checked="true"', '')}></aui-toggle>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Remember My Device for Users
                    </span>
                    <div class="description">The Remember My Device checkbox allows you to ignore 2FA check if the user is trying to log in from the same device.</div>
                </div>

                <div class="field-group">
                    <label for="rememberMeDeviceDuration">Expiry Time (in Days) : </label>
                    <input type="number" id="rememberMeDeviceDuration" name="rememberMeDeviceDuration"
                          value="${rememberMeDeviceDuration}" class="text" min="1" max="365" style="width: 80px;" ${(enableRememberMeDevice != true)?then('disabled', '')} />
                    <div class="description">Once the time has expired, the device information for that user will be clear.</div>
                </div>
                <div class="field-group">
                    <aui-toggle id="allowUserSpecificRememberMeDeviceDuration" value="true" label="Enable Remember Me" name="allowUserSpecificRememberMeDeviceDuration"  ${(enableRememberMeDevice != true)?then('disabled', '')} ${(allowUserSpecificRememberMeDeviceDuration == true)?then('checked="true"', '')} ></aui-toggle>
                    <span style="height:16px; width: 16px">&nbsp;
                        Allow end users to change the expiry time.
                    </span>
                </div>
            </div>

            <br><br>
            <div id="urlFilterSettingsDiv">
                <h3 class="subsection_title">Skip 2FA for APIs running in backend</h3>

                <div class="field-group">
                    <label for="skip2faUrls"> URLs for the backend APIs: </label>
                    <table class="aui" style="width:70%;">
                        <thead>
                        <tr style="background-color: #F4F5F7; border-top: 1px solid #DFE1E6;">
                            <th id="urls">
                                <input type="text"  id="skip2faUrls" name="skip2faUrls" value="" placeholder="profile/userProfile.action" style="box-shadow: none;height: 35px !important;" class="text long-field" />
                            </th>
                            <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                            <th id="actionButton" style="float:right;">
                                <input type="submit" id="settings-form-submit" value="Add" class="aui-button aui-button-primary" style="width: 70px; margin-top: 3px;"/>
                            </th>
                            </#if>
                        </tr>
                        </thead>
                        <tbody>
                        <#foreach entry in skip2FAForGivenUrlList>
                            <tr>
                                <td headers="urls">
                                    ${entry}
                                </td>

                                <td headers="actionButton">
                                    <input type="button" id="settings-form-submit" value="Delete" class="aui-button" style="width: 70px; float:right;" onclick="return removeSkip2FAUrl('${entry}')"/>
                                </td>
                            </tr>
                        </#foreach>
                        </tbody>
                    </table>
                    <div class="description">Enter the semicolon separated relative URLs(or part of the URLs) for the APIs which will run in the backend
                        for which you want to skip the 2FA verification
                    </div>
                </div>
            </div>


            <br><br>
            <div id="oneTime2FAInCrowdAuthenticationSetup">
                <h3 class="subsection_title">One-time 2FA validation in Crowd authentication setups </h3>
                <div class="field-group">

                    <#if (isCrowdAuthenticationEnabled == false)>
                        <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                            <p class="title">
                                <strong>Warning!</strong>
                            </p>
                            <p>This feature can only be enabled if authentication is done via Crowd.
                            </p>
                        </div>
                    </#if>
                    <br>
                    <aui-toggle id="enableOneTime2fa" value="true" label="bypass 2fa After Crowd SSO"
                            ${(isCrowdAuthenticationEnabled == false)?then('disabled', '')} name="enableOneTime2fa"
                            ${(enableOneTime2fa == true)?then('checked="true"', '')}></aui-toggle>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable this to allow one time 2FA when users login to multiple applications via Crowd Authentication.
                    </span>
                    <br><br>
                </div>

                <div class="field-group">
                    <label for="keyProvidedByCrowdSso">Crowd SSO Domain : </label>
                        <input type="text" id="bypass2FACookieDomain" name="bypass2FACookieDomain" value="${bypass2FACookieDomain}" class="text long-field"
                        oninput="validateDomain(this.value)"    placeholder="Enter the Crowd SSO Domain" ${(enableOneTime2fa != true)?then('disabled', '')} />
                        <p id="domainResult"><p>
                    <div class="description">Enter the same domain mentioned in the SSO domain field under General options in Crowd. </div>

                    <div class="description">2FA will be verified in first application and it will be skipped in all other apps.
                        <br>
                        Note: For this feature to work, this option must be enabled in 2FA app on all Crowd connected applications.
                    </div>
                </div>

                <div class="field-group" id="oneTime2FASecretKeyDiv" ${(enableOneTime2fa != true)?then('style="display:none"', '')}>
                    <label for="secretKeyForOneTime2FAValidation">Secret Key : </label>
                    <input type="text" id="secretKeyForOneTime2FAValidation" name="secretKeyForOneTime2FAValidation" value="${secretKeyForOneTime2FAValidation}" class="text long-field"
                            placeholder="Enter the secret key" /> &nbsp;
                    <span class="aui-icon aui-icon-small aui-iconfont-refresh" role="img" aria-label="Reset secret key" title="Reset secret key" onclick="resetSecretKey()" style="cursor: pointer;" ></span>
                    <span class="aui-lozenge aui-lozenge-subtle aui-lozenge-new">New</span>
                    <div class="description">With this key, 2FA will be verified in first application and it will be skipped in all other apps.
                        <br>
                        Note: For this feature to work, enter the same key in 2FA app on all Crowd connected applications. For robust security, we suggest you refresh the key periodically.
                    </div>
                </div>
            </div>

            <br>
            <div id="disable2faForSsoUsers">
                <h3 class="subsection_title">Skip 2FA on SSO</h3>
                <div class="field-group">
                    <label for="ignore2FAAfterSso">Skip 2FA for Bamboo SSO Users :</label>
                        <aui-toggle id="ignore2FAAfterSso" value="true" label="skip 2fa for bamboo sso" name="ignore2FAAfterSso"
                                ${(ignore2FAAfterSso == true)?then('checked="true"', '')}></aui-toggle>
                            &nbsp; Enable this to skip the 2FA if users login via SSO.
                </div>
                <div class="field-group">
                    <label for="ssoLoginUrl">Bamboo SSO Login URL : </label>
                    <input type="text" id="ssoLoginUrl" name="ssoLoginUrl" value="${ssoLoginUrl}" class="text long-field"
                            placeholder="Comma Separated SSO Login Or Callback URL"  <#if ignore2FAAfterSso != true> disabled </#if> />
                    <div class="description">Add comma separated Single Sign on URL (SAML) or Callback URL(OAuth/OpenID) from your SSO provider.</div>
                </div>
                <br>
                <div class="field-group">
                    <label for="crowdSsoEnabled">Skip 2FA for Crowd SSO Users :</label>
                        <aui-toggle id="crowdSsoEnabled" value="true" label="Enable Crowd sso" name="crowdSsoEnabled" ${(crowdSsoEnabled == true)?then('checked="true"', '')}></aui-toggle>
                        &nbsp; Enable this to skip 2FA of users if they login via SSO using miniOrange Crowd SAML addon and Bamboo Crowd connector.
                </div>
                <div class="field-group">
                    <label for="keyProvidedByCrowdSso">Secret Key Provided by Crowd SSO : </label>
                    <input type="text" id="keyProvidedByCrowdSso" name="keyProvidedByCrowdSso" value="${keyProvidedByCrowdSso}" class="text long-field"
                        placeholder="Enter a key provided by miniOrange Crowd addon" <#if (crowdSsoEnabled != true)> disabled </#if>/>
                    <div class="description">Add the Secret key provided by the miniOrange Crowd addon.</div>
                </div>
                <div class="field-group">
                    <label for="keyProvidedByCrowdSso">Crowd SSO Cookie Name : </label>
                    <input type="text" id="crowdSsoCookieName" name="crowdSsoCookieName" value="${crowdSsoCookieName}" class="text long-field"
                        placeholder="Enter a Crowd SSO Cookie Name" <#if crowdSsoEnabled != true> disabled </#if>/>
                    <div class="description">Add the Crowd SSO Cookie name.</div>
                </div>
            </div>
            <br>
            <div id="PluginPagesAccessManager">
                <h3 style="font-size: 18px; margin: auto 0; padding-bottom: 1rem;width: 100%;border-bottom: 2px solid #0065ff; margin-bottom: 20px;">Access to Plugin Pages</h3>
                <input type="hidden" name="totalGroupsWithAdminPagesAccessConfigs" id="totalGroupsWithAdminPagesAccessConfigs" value="${totalGroupsWithAdminPagesAccessConfigs}"/>
                <div class="field-group">
                    <div style="font-weight: 500;" for="AccessToAdminsPage">
                        Grant non-admin users access to plugin configuration pages :
                    </div>
                    <br>
                    <input type="button" class="aui-button aui-button-primary" id="" name="" onclick="addAccessManagerField()" value="Add New Access"/>
                    <br><br>
                        <div id="AccessManagerContainer">
                            <#if (!groupsWithAdminPagesAccess.isEmpty())>

                                <#assign cnt = 0>
                                <#foreach page in groupsWithAdminPagesAccess.keySet()>
                                    <div>
                                        <select class="select" name="PageName_${cnt}" id="PageName_${cnt}" style="vertical-align: super; width: 150px;">
                                            <option value="" disabled selected>Select Page</option>
                                            <option value="Basic_Configuration"<#if (page.contains("Basic_Configuration"))> selected </#if>>Basic Configuration</option>
                                            <option value="Advanced_Settings" <#if (page.contains("Advanced_Settings"))> selected </#if>>Advanced Options</option>
                                            <option value="User_Management" <#if (page.contains("User_Management"))> selected </#if>>User Management</option>
                                            <option value="Audit_Logs" <#if (page.contains("Audit_Logs"))> selected </#if>>Audit Logs</option>
                                            <option value="IP_Restriction" <#if (page.contains("IP_Restriction"))> selected </#if>>IP Restriction</option>
                                            <option value="LookAndFeel" <#if (page.contains("LookAndFeel"))> selected </#if>>Look and Feel templates</option>
                                            <option value="TroubleShooting" <#if (page.contains("TroubleShooting"))> selected </#if>>TroubleShooting</option>
                                        </select> &nbsp;&nbsp;
                                        <input class="select long-field" name="includeGroups_${cnt}" id="includeGroups_${cnt}" style="width: 200px; vertical-align: bottom;" placeholder="Enter Group name" value="${groupsWithAdminPagesAccess.get(page)}"></input> &nbsp;&nbsp;
                                        <select class="select" name="AccessType_${cnt}" id="AccessType_${cnt}" style="vertical-align: super; width: 150px;">
                                            <option value="" disabled selected>Select Access type</option>
                                            <option value="read" <#if (page.contains("read"))> selected </#if>>VIEW</option>
                                            <option value="readwrite" <#if (page.contains("readwrite"))> selected </#if>>EDIT</option>
                                        </select> &nbsp;&nbsp;
                                        <input type="button" class="aui-button aui-button-primary" id="removePageAccessManagerField" name="removePageAccessManagerField" style="vertical-align: bottom;" onclick="removeAccessManagerField(this,cnt)" value="Remove"/>
                                    </div>
                                    <br>
                                    <#assign cnt = cnt+1>
                                </#foreach>
                            </#if>
                        </div>
                    </div>
                </div>
            <br>
           <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                <div class="field-group" style="padding-left: 250px;">
                    <input type="submit" id="settings-form-submit" value="Save" class="aui-button aui-button-primary" style="width: 150px;"/>
                </div>
           </#if>
        </form>
    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>