<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
            <#include "*/js/auditlog.js">;
        </script>

        <style type="text/css">
            <#include "*/css/auditlog.css">;
        </style>
    </head>
    <body>
    <#include "*/header.ftl" parse=true>
     <br>
    <div class="tabs-pane active-pane" id="settings"  role="tabpanel" >
        <#if (pageAccessType.equals("read"))>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>You only have read access of this page, no configuration will be saved!</p>
            </div>
        </#if>
        <h2>Audit Logs</h2>
        <hr class="header"/>
        <div class="tabs-pane active-pane" id="settings" role="tabpanel" >
            <nav class="aui-navgroup aui-navgroup-horizontal" id="min_topmenu">
                <div class="aui-navgroup-inner">
                    <div id="navbar" class="aui-navgroup-primary">
                        <div class="tab tab-config">
                            <ul class="aui-nav">
                                <li>
                                    <#if auditLogSelectedAction == "EndUserAuditLogAction">
                                    <a class="tablinks active" onclick="performActionChange('EndUserAuditLogAction')">End User's Audit Logs</a>
                                    <#else>
                                    <a class="tablinks" onclick="performActionChange('EndUserAuditLogAction')">End User's Audit Logs</a>
                                    </#if>
                                </li>
                                <li>
                                    <#if auditLogSelectedAction == "AdminsAuditLogAction">
                                    <a class="tablinks active" onclick="performActionChange('AdminsAuditLogAction')">Admin's Audit Logs</a>
                                    <#else>
                                    <a class="tablinks" onclick="performActionChange('AdminsAuditLogAction')">Admin's Audit Logs</a>
                                    </#if>
                                </li>
                            </ul>
                        </div>

                    </div>
                    <div style="float: right">
                    <#if (pageAccessType != "" && pageAccessType == "readwrite")>
                        <#if auditLogSelectedAction == "EndUserAuditLogAction">
                        <span class="aui-icon aui-icon-large aui-iconfont-trash" title="Clear Audit Logs" style="cursor:pointer;" onclick="clearAuditLogs('EndUsersLogs')"></span>
                        <span class="aui-icon aui-icon-large aui-iconfont-settings"  title="Advanced Settings" style="cursor:pointer;" onclick="displayAuditLogSettings()"></span>
                        <#else>
                        <span class="aui-icon aui-icon-large aui-iconfont-trash" title="Clear Audit Logs" style="cursor:pointer;" onclick="clearAuditLogs('AdminsLogs')"></span>
                        </#if>
                    </#if>
                    </div>
                </div>
            </nav>
        </div>

    <#if auditLogSelectedAction == "EndUserAuditLogAction">

        <br>
        <div class="field-group">
            <div class="aui-message aui-message-info">
                <p>To enhance the performance of our app we have changed the implementation of storing the Audit logs since the version 1.0.18 . So from now onwards you will only see the new logs on this tab. Additionally, if you want to access the old 2FA audit logs then you can download them from
                    <a  onclick="exportOldLogs()"  style="text-decoration: none;"><u>here.</u></a>
                </p>

                <p>
                    Note: We have enabled the "Auto Delete Audit logs" functionality, which will automatically delete the audit logs which are older than <strong> ${daysForInfo} </strong> days. However you can configure the number of days as you need.
                </p>
            </div>
        </div>
        <form id="auditlog-user-form" class="aui long-label" action="" method="POST">
            <input type="hidden" name="auditLogsUserDetailsSubmitted" value="true"/>
            <input type="hidden" name="exportAuditLogsUrl" id="exportAuditLogsUrlId" value="${exportAuditLogsUrl}"/>
            <input type="hidden" name="atl_token" value="${xsrfToken}" />
            <input type="hidden" id="currentIndex"name="currentIndex" value="1">

            <div class ="field-group" style="padding-left: 40px;">
                <div style="display: flex;align-items: center;gap: 5px;">
                    Filter Logs :&nbsp;

                    <input type="text"  id="auditLogUsernameSearchKeyword" name="auditLogUsernameSearchKeyword" value="${auditLogUsernameSearchKeyword}" placeholder="Enter Username" class="text long-field" style="width: 155px; height: 33px;"/>&nbsp;
                    <input type="text"  id="auditLogIpSearchKeyword" name="auditLogIpSearchKeyword" value="${auditLogIpSearchKeyword}" placeholder="Enter IP Address" class="text long-field" style="width: 155px; height: 33px;"/>&nbsp;

                    <select class="select" name="filterUsersByAction" id="filterUsersByAction" class="filterUsers" style="width: 250px;">
                    <option value="" disabled>Select Action</option>
                        <option value="All Actions" <#if (filterUsersByAction.equals("All Actions"))>selected="true" </#if>>All Actions</option>
                        <option value="Login Successful" <#if (filterUsersByAction.equals("Login Successful"))>selected="true" </#if>>Login Successful</option>
                        <option value="Login Failed" <#if (filterUsersByAction.equals("Login Failed"))>selected="true" </#if>>Login Failed</option>
                        <option value="2FA Configuration Successful" <#if (filterUsersByAction.equals("2FA Configuration Successful"))>selected="true" </#if>>2FA Configuration Successful</option>
                        <option value="2FA Configuration Failed" <#if (filterUsersByAction.equals("2FA Configuration Failed"))>selected="true" </#if>>2FA Configuration Failed</option>
                        <option value="Temporarily Locked" <#if (filterUsersByAction.equals("Temporarily Locked"))>selected="true" </#if>>Temporarily Locked</option>
                        <option value="Skipped 2FA (Remembered Device)" <#if filterUsersByAction.equals("Skipped 2FA (Remembered Device)")> selected </#if>>Skipped 2FA (Remembered Device)</option>
                        <option value="Skipped 2FA (Based on group)" <#if filterUsersByAction.equals("Skipped 2FA (Based on group)")> selected </#if>>Skipped 2FA (Based on group)</option>
                        <option value="Skipped 2FA (Whitelisted IP)" <#if filterUsersByAction.equals("Skipped 2FA (Whitelisted IP)")>selected </#if>>Skipped 2FA (Whitelisted IP)</option>
                        <option value="Skipped 2FA (on SSO)" <#if filterUsersByAction.equals("Skipped 2FA (on SSO)")>selected </#if>>Skipped 2FA (on SSO)</option>
                        <option value="Skipped 2FA (on Crowd SSO)" <#if filterUsersByAction.equals("Skipped 2FA (on Crowd SSO)")>selected </#if>>Skipped 2FA (on Crowd SSO)</option>
                        <option value="Skipped 2FA (One time 2FA)" <#if (filterUsersByAction.equals("Skipped 2FA (One time 2FA)"))>selected </#if>>Skipped 2FA (One time 2FA)</option>
                    </select>&nbsp;

                    <select class="select" name="filterUsersByPeriod" id="filterUsersByPeriod" class="filterUsers" style="width: 155px; height: 33px;">
                        <option value="" disabled>Select Log Period</option>
                        <option value="All Days" <#if (filterUsersByPeriod.equals("All Days"))>selected="true" </#if>>All Days</option>
                        <option value="1" <#if (filterUsersByPeriod.equals("1"))>selected="true" </#if>>Last 1 Days</option>
                        <option value="7" <#if (filterUsersByPeriod.equals("7"))>selected="true" </#if>>Last 7 Days</option>
                        <option value="30" <#if (filterUsersByPeriod.equals("30"))>selected="true" </#if>>Last 30 Days</option>
                        <option value="180" <#if (filterUsersByPeriod.equals("180"))>selected="true" </#if>>Last 180 Days</option>
                    </select>&nbsp;

                    <input type='submit' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return DisplayFilterSpecificLogs()"/>

                    <input type='submit' value='Reset' id='perform-action-button' class="aui-button aui-button-primary" style="margin-left:2px" onclick="return resetAuditLogsFilters()"/>&nbsp;

                    <a class="aui-button" onclick="exportLogs(false)" resolved="" style="float: right; margin-left: 120px">
                        <span class="aui-icon aui-icon-small aui-iconfont-devtools-pull-request"></span>&nbsp;Export
                    </a>
                </div>
                    <hr class="header"/>
                    <#if (moLogEntitesHashMap.size()>0)>
                        <table class="aui" style="table-layout: fixed;">
                            <thead>
                                <tr>
                                    <th id="number" style="width:3%;">Sr.No</th>
                                    <th id="username">Username</th>
                                    <th id="loginTimeAndDate" style="width:15%;">Date</th>
                                    <th id="ip" style="width:10%;">IP Address</th>
                                    <th id="action" style="width:15%;">Action</th>
                                    <th id="loginmethod">2FA Method </th>
                                </tr>
                            </thead>
                            <tbody>
                                <input type="hidden" value="$startIndex" id="startIndex"/>
                                    <#assign loopCount = start + 1>
                                    <#foreach moLogEntityHash in moLogEntitesHashMap>
                                    <#assign trId = "tr"+moLogEntityHash.get("user")>
                                    <tr id="${trId}">
                                        <td> ${loopCount}</td>
                                        <#if (moLogEntityHash.get("user").length() >= 40)>
                                            <#assign tdId = "td_username_"+loopCount >
                                            <td id="${tdId}" class="hideElement" onclick="openCloseElemenet('${tdId}')"> ${moLogEntityHash.get("user")}</td>
                                        <#else>
                                            <td> ${moLogEntityHash.get("user")}</td>
                                        </#if>
                                        <td> ${moLogEntityHash.get("dateTime")}</td>
                                        <td> ${moLogEntityHash.get("ipAddress")}</td>
                                        <td> ${moLogEntityHash.get("action")}</td>
                                        <td> ${moLogEntityHash.get("type")}</td>
                                    </tr>
                                    <#assign loopCount = loopCount + 1>
                                </#foreach>
                                <input type="hidden" value="${loopCount}" id="endIndex"/>
                            </tbody>
                        </table>
                        </br>

                        <table style="width:100%">
                            <tr>
                                    <td>
                                        <#assign end = start + moLogEntitesHashMap.size()>
                                        <#assign start = start + 1>
                                        <p>Displaying logs <strong>${start}</strong> to
                                                <strong>${end}</strong>
                                            of <strong>${totalLogs}</strong>.
                                        </p>
                                    </td>

                                    <#if (lastIndex > 1)>
                                        <ol class="aui-nav aui-nav-pagination" style="float:right;cursor:pointer">
                                            <#if (start > 20)>
                                                <li class="aui-nav-first"><a onclick=changeAuditIndex("1","auditlog-user-form")>First</a></li>
                                                <li class="aui-nav-previous"><a onclick=changeAuditIndex('${prevIndex}',"auditlog-user-form")>Prev</a></li>
                                            </#if>
                                            <#list startIndex..endIndex as index>
                                                <#if (index == currentIndex)>
                                                    <li><a onclick= changeAuditIndex('${index}',"auditlog-user-form")><strong>${index}</strong></a></li>
                                                <#else>
                                                    <li><a onclick= changeAuditIndex('${index}',"auditlog-user-form")>${index}</a></li>
                                                </#if>
                                            </#list>
                                            <#if (lastIndex - startIndex > 4)>
                                                <#assign jumpIndex = endIndex + 1>
                                                <li class="aui-nav-truncation"><a onclick=changeAuditIndex('${jumpIndex}',"auditlog-user-form") id="pagination-truncation">&hellip;</a></li>
                                            </#if>
                                            <#if (end!=totalLogs)>
                                                <li class="aui-nav-next"><a onclick=changeAuditIndex('${nextIndex}',"auditlog-user-form")>Next</a></li>
                                                <li class="aui-nav-last"><a onclick=changeAuditIndex('${lastIndex}',"auditlog-user-form")>Last</a></li>
                                            </#if>
                                        </ol>
                                    </#if>
                            </tr>
                        </table>
                    <#else>
                        <table class="aui">
                            <thead>
                                <tr>
                                    <th id="number">Sr.No</th>
                                    <th id="username">Username</th>
                                    <th id="loginTimeAndDate">Date</th>
                                    <th id="ip">IP Address</th>
                                    <th id="action">Action</th>
                                    <th id="loginmethod">2FA Method </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="6">
                                        <p style="width:100%" align="center">
                                            No user record found.
                                        </p>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </#if>
            </div>
        </form>
        <#include "*/auditlogsetting.ftl" >
    <#else>
        <form id="adminsAuditlog-user-form" class="aui long-label" action="" method="POST">
            <input type="hidden" name="adminsAuditLogsDetailsSubmitted" value="true"/>
            <input type="hidden" id="currentIndex" name="currentIndex" value="1">
            <input type="hidden" name="exportAuditLogsUrl" id="exportAuditLogsUrlId" value="${exportAuditLogsUrl}"/>
            <input type="hidden" name="atl_token" value="${xsrfToken}" />

            <div class ="field-group" style="padding-left: 40px;">
                <div style="display: flex;align-items: center;gap: 5px;">
                    Filter Logs :&nbsp;
                    <select class="select" name="filterUsersByAdminsAction" id="filterUsersByAdminsActionId" class="filterUsers" style="width: 250px;">
                        <option value="" disabled>Select Action</option>
                        <option value="All Actions" <#if (filterUsersByAdminsAction.equals("All Actions"))>selected </#if>>All Actions</option>
                        <option value="2FA Method Enabled" <#if (filterUsersByAdminsAction.equals("2FA Method Enabled"))>selected </#if>>2FA Method Enabled</option>
                        <option value="Backup Method Enabled" <#if (filterUsersByAdminsAction.equals("Backup Method Enabled"))>selected </#if>>Backup Method Enabled</option>
                        <option value="Method Disabled" <#if (filterUsersByAdminsAction.equals("Method Disabled"))>selected </#if>>Method Disabled</option>
                        <option value="Method Settings Updated" <#if (filterUsersByAdminsAction.equals("Method Settings Updated"))>selected </#if>>Method Settings Updated</option>
                        <option value="2FA Enabled" <#if (filterUsersByAdminsAction.equals("2FA Enabled"))>selected </#if>>2FA Enabled</option>
                        <option value="2FA Reset" <#if (filterUsersByAdminsAction.equals("2FA Reset"))>selected </#if>>2FA Reset</option>
                        <option value="2FA Disabled" <#if (filterUsersByAdminsAction.equals("2FA Disabled"))>selected </#if>>2FA Disabled</option>
                        <option value="Unlocked User" <#if (filterUsersByAdminsAction.equals("Unlocked User"))>selected </#if>>Unlocked User</option>
                        <option value="2FA Activated" <#if (filterUsersByAdminsAction.equals("2FA Activated"))>selected </#if>>2FA Activated</option>
                        <option value="2FA Deactivated" <#if (filterUsersByAdminsAction.equals("2FA Deactivated"))>selected </#if>>2FA Deactivated</option>
                        <option value="Updated Skip 2FA Groups" <#if (filterUsersByAdminsAction.equals("Updated Skip 2FA Groups"))>selected </#if>>Updated Skip 2FA Groups</option>
                        <option value="Exported All Users" <#if (filterUsersByAdminsAction.equals("Exported All Users"))>selected </#if>>Exported All Users</option>
                        <option value="Exported Disabled Users" <#if (filterUsersByAdminsAction.equals("Exported Disabled Users"))>selected </#if>>Exported Disabled Users</option>
                        <option value="Exported Enabled Users" <#if (filterUsersByAdminsAction.equals("Exported Enabled Users"))>selected </#if>>Exported Enabled Users</option>
                        <option value="Exported Configured Users" <#if (filterUsersByAdminsAction.equals("Exported Configured Users"))>selected </#if>>Exported Configured Users</option>
                        <option value="Exported All Groups" <#if (filterUsersByAdminsAction.equals("Exported All Groups"))>selected </#if>>Exported All Groups</option>
                        <option value="Exported 2FA Enabled Groups" <#if (filterUsersByAdminsAction.equals("Exported 2FA Enabled Groups"))>selected </#if>>Exported 2FA Enabled Groups</option>
                        <option value="Added IP for Whitelisting" <#if (filterUsersByAdminsAction.equals("Added IP for Whitelisting"))>selected </#if>>Added IP for Whitelisting</option>
                        <option value="Added IP for Blocking" <#if (filterUsersByAdminsAction.equals("Added IP for Blocking"))>selected </#if>>Added IP for Blocking</option>
                        <option value="Removed IP for Whitelisting" <#if (filterUsersByAdminsAction.equals("Removed IP for Whitelisting"))>selected </#if>>Removed IP for Whitelisting</option>
                        <option value="Removed IP for blocking" <#if (filterUsersByAdminsAction.equals("Removed IP for blocking"))>selected </#if>>Removed IP for blocking</option>
                        <option value="Updated Request header in IP Restctions" <#if (filterUsersByAdminsAction.equals("Updated Request header in IP Restctions"))>selected </#if>>Updated Request header in IP Restctions</option>
                        <option value="Enabled Enforce current method" <#if (filterUsersByAdminsAction.equals("Enabled Enforce current method"))>selected </#if>>Enabled Enforce current method</option>
                        <option value="Disabled Enforce current method" <#if (filterUsersByAdminsAction.equals("Disabled Enforce current method"))>selected </#if>>Disabled Enforce current method</option>
                        <option value="Enabled Allow to Reconfigure 2fa method" <#if (filterUsersByAdminsAction.equals("Enabled Allow to Reconfigure 2fa method"))>selected </#if>>Enabled Allow to Reconfigure 2fa method</option>
                        <option value="Disabled Allow to Reconfigure 2fa method" <#if (filterUsersByAdminsAction.equals("Disabled Allow to Reconfigure 2fa method"))>selected </#if>>Disabled Allow to Reconfigure 2fa method</option>
                        <option value="Enabled  Show all configured methods to user" <#if (filterUsersByAdminsAction.equals("Enabled  Show all configured methods to user"))>selected </#if>>Enabled  Show all configured methods to user</option>
                        <option value="Disabled show all configured methods to user" <#if (filterUsersByAdminsAction.equals("Disabled show all configured methods to user"))>selected </#if>>Disabled show all configured methods to user</option>
                        <option value="Enabled Show Remaining 2fa methods after configuration" <#if (filterUsersByAdminsAction.equals("Enabled Show Remaining 2fa methods after configuration"))>selected </#if>>Enabled Show Remaining 2fa methods after configuration</option>
                        <option value="Disabled Show Remaining 2fa methods after configuration" <#if (filterUsersByAdminsAction.equals("Disabled Show Remaining 2fa methods after configuration"))>selected </#if>>Disabled Show Remaining 2fa methods after configuration</option>
                        <option value="Enabled Brute Force Protection" <#if (filterUsersByAdminsAction.equals("Enabled Brute Force Protection"))>selected </#if>>Enabled Brute Force Protection</option>
                        <option value="Disabled Brute Force Protection" <#if (filterUsersByAdminsAction.equals("Disabled Brute Force Protection"))>selected </#if>>Disabled Brute Force Protection</option>
                        <option value="Enabled Remember My Device" <#if (filterUsersByAdminsAction.equals("Enabled Remember My Device"))>selected </#if>>Enabled Remember My Device</option>
                        <option value="Disabled Remember My Device" <#if (filterUsersByAdminsAction.equals("Disabled Remember My Device"))>selected </#if>>Disabled Remember My Device</option>
                        <option value="Added Skip 2FA for API" <#if (filterUsersByAdminsAction.equals("Added Skip 2FA for API"))>selected </#if>>Added Skip 2FA for API</option>
                        <option value="Removed Skip 2FA for API" <#if (filterUsersByAdminsAction.equals("Removed Skip 2FA for API"))>selected </#if>>Removed Skip 2FA for API</option>
                        <option value="Enabled one Time 2FA Validation" <#if (filterUsersByAdminsAction.equals("Enabled one Time 2FA Validation"))>selected </#if>>Enabled one Time 2FA Validation</option>
                        <option value="Disabled one Time 2FA Validation" <#if (filterUsersByAdminsAction.equals("Disabled one Time 2FA Validation"))>selected </#if>>Disabled one Time 2FA Validation</option>
                        <option value="Updated Skip 2FA on SSO" <#if (filterUsersByAdminsAction.equals("Updated Skip 2FA on SSO"))>selected </#if>>Updated Skip 2FA on SSO</option>
                        <option value="Updated Look and Feel Tab" <#if (filterUsersByAdminsAction.equals("Updated Look and Feel Tab"))>selected </#if>>Updated Look and Feel Tab</option>
                        <option value="Updated Security Questions" <#if (filterUsersByAdminsAction.equals("Updated Security Questions"))>selected </#if>>Updated Security Questions</option>
                        <option value="Updated Audit Log settings" <#if (filterUsersByAdminsAction.equals("Updated Audit Log settings"))>selected </#if>>Updated Audit Log settings</option>
                        <option value="Updated Security Questions" <#if (filterUsersByAdminsAction.equals("Updated Security Questions"))>selected </#if>>Updated Security Questions</option>
                        <option value="Auto Delete Audit logs initiated" <#if (filterUsersByAdminsAction.equals("Auto Delete Audit logs initiated"))>selected </#if>>Auto Delete Audit logs initiated</option>
                        <option value="Updated Access to plugins Pages" <#if (filterUsersByAdminsAction.equals("Updated Access to plugins Pages"))>selected </#if>>Updated Access to plugins Pages</option>
                        <option value="Cleared Admin's Audit Logs" <#if (filterUsersByAdminsAction.equals("Cleared Admin's Audit Logs"))>selected </#if>>Cleared Admin's Audit Logs</option>
                        <option value="Enabled Multilingual Support for Users" <#if (filterUsersByAdminsAction.equals("Enabled Multilingual Support for Users"))>selected </#if>>Enabled Multilingual Support for Users</option>
                        <option value="Disabled Multilingual Support for Users" <#if (filterUsersByAdminsAction.equals("Disabled Multilingual Support for Users"))>selected </#if>>Disabled Multilingual Support for Users</option>
                        <option value="Enabled 2FA on REST API calls" <#if (filterUsersByAdminsAction.equals("Enabled 2FA on REST API calls"))>selected </#if>>Enabled 2FA on REST API calls</option>
                        <option value="Disabled 2FA on REST API calls" <#if (filterUsersByAdminsAction.equals("Disabled 2FA on REST API calls"))>selected </#if>>Disabled 2FA on REST API calls</option>
                        <option value="Enabled Redirection Based on Absolute URL" <#if (filterUsersByAdminsAction.equals("Enabled Redirection Based on Absolute URL"))>selected </#if>>Enabled Redirection Based on Absolute URL</option>
                        <option value="Disabled Redirection Based on Absolute URL" <#if (filterUsersByAdminsAction.equals("Disabled Redirection Based on Absolute URL"))>selected </#if>>Disabled Redirection Based on Absolute URL</option>
                        <option value="Exported Old Audit Logs" <#if (filterUsersByAdminsAction.equals("Exported Old Audit Logs"))>selected </#if>>Exported Old Audit Logs</option>
                        <option value="Exported Admin Audit Logs" <#if (filterUsersByAdminsAction.equals("Exported Admin Audit Logs"))>selected </#if>>Exported Admin Audit Logs</option>
                        <option value="Exported End User Audit Logs" <#if (filterUsersByAdminsAction.equals("Exported End User Audit Logs"))>selected </#if>>Exported End User Audit Logs</option>
                        <option value="Cleared End User's Audit Logs" <#if (filterUsersByAdminsAction.equals("Cleared End User's Audit Logs"))>selected </#if>>Cleared End User's Audit Logs</option>
                    </select>
                    &nbsp;&nbsp;
                    <input type="text"  id="performedOnSearchKeyword" name="performedOnSearchKeyword" value="${performedOnSearchKeyword}" placeholder="Performed On" class="text long-field" style="width: 130px; height: 33px;"/>&nbsp;
                    <input type="text"  id="performedBySearchKeyword" name="performedBySearchKeyword" value="${performedBySearchKeyword}" placeholder="Performed By" class="text long-field" style="width: 130px; height: 33px;"/>&nbsp;

                    <select class="select" name="filterUsersByPeriod" id="filterUsersByPeriod" class="filterUsers" style="width: 155px; height: 33px;">
                        <option value="" disabled>Select Log Period</option>
                        <option value="All Days" <#if (filterUsersByPeriod.equals("All Days"))>selected </#if>>All Days</option>
                        <option value="1" <#if (filterUsersByPeriod.equals("1"))>selected </#if>>Last 1 Day</option>
                        <option value="7" <#if (filterUsersByPeriod.equals("7"))>selected </#if>>Last 7 Days</option>
                        <option value="30" <#if (filterUsersByPeriod.equals("30"))>selected </#if>>Last 30 Days</option>
                        <option value="180" <#if (filterUsersByPeriod.equals("180"))>selected </#if>>Last 180 Days</option>
                    </select>&nbsp;
                    <input type="text"  id="moreDetailsSearchKeyword" name="moreDetailsSearchKeyword" value="${moreDetailsSearchKeyword}" placeholder="Details" class="text long-field" style="width: 155px; height: 33px;"/>&nbsp;


                    <input type='submit' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return DisplayFilterSpecificAdminsLogs()"/>

                    <input type='submit' value='Reset' id='perform-action-button' class="aui-button aui-button-primary" style="margin-left:2px" onclick="return resetAdminsAuditLogsFilters()"/>&nbsp;

                    <a class="aui-button" onclick="exportAdminsAuditLogs(false)" resolved="" style="float: right;">
                        <span class="aui-icon aui-icon-small aui-iconfont-devtools-pull-request"></span>&nbsp;Export
                    </a>
                </div>
                <hr class="header"/>
                <#if (moLogEntitesHashMap.size()>0)>

                <table class="aui" style="table-layout: fixed;">
                    <thead>
                    <tr>
                        <th id="number" style="width: 3%;">Sr.No</th>
                        <th id="action" style="width: 16%;">Action</th>
                        <th id="username" style="width: 16%;">Performed On</th>
                        <th id="username" style="width: 16%;">Performed By</th>
                        <th id="loginTimeAndDate" style="width: 16%;">Date</th>
                        <th id="ip">More Details</th>
                    </tr>
                    </thead>
                    <tbody>
                    <input type="hidden" value="${startIndex}" id="startIndex"/>
                    <#assign loopCount = start+1>
                    <#foreach moLogEntitityHash in moLogEntitesHashMap >
                    <#assign trId = "tr"+ loopCount>
                    <tr id="${trId}">
                        <td> ${loopCount}</td>
                        <#assign tdId = "td_username_"+loopCount>
                        <td>${moLogEntitityHash.get("action")}</td>
                        <td id="${tdId}" class="hideElement" onclick="openCloseElemenet('${tdId}')"> ${moLogEntitityHash.get("performedOn")}</td>
                        <td id="${tdId}" class="hideElement" onclick="openCloseElemenet('${tdId}')"> ${moLogEntitityHash.get("performedBy")}</td>
                        <td> ${moLogEntitityHash.get("dateTime")}</td>
                        <td>
                            <#foreach moreDetails in moLogEntitityHash.get("details")>
                             ${moreDetails}
                            <br>
                            </#foreach>
                        </td>
                    </tr>
                    <#assign loopCount = loopCount + 1>
                    </#foreach>
                    <input type="hidden" value="${loopCount}" id="endIndex"/>
                    </tbody>
                </table>
                </br>

                <table style="width:100%">
                    <tr>
                        <td>
                            <#assign end = start+moLogEntitesHashMap.size()>
                            <#assign start = start+1>
                            <p>Displaying logs <strong>${start}</strong> to
                                <strong>${end}</strong>
                                of <strong>${totalLogs}</strong>.
                            </p>
                        </td>

                        <#if (lastIndex > 1 && totalLogs>20)>
                        <ol class="aui-nav aui-nav-pagination" style="float:right;cursor:pointer">

                            <#if (start>20)>
                            <li class="aui-nav-first"><a onclick=changeAuditIndex("1","adminsAuditlog-user-form")>First</a></li>
                            <li class="aui-nav-previous"><a onclick=changeAuditIndex("${prevIndex}","adminsAuditlog-user-form")>Prev</a></li>
                            </#if>
                            <#list startIndex..endIndex as index>
                               <#if (index == currentIndex)>
                               <li><a onclick= changeAuditIndex('${index}',"adminsAuditlog-user-form")><strong>${index}</strong></a></li>
                               <#else>
                               <li><a onclick= changeAuditIndex('${index}',"adminsAuditlog-user-form")>${index}</a></li>
                               </#if>
                            </#list>
                            <#if (lastIndex - startIndex > 4 )>
                            <#assign jumpIndex = endIndex + 1>
                            <li class="aui-nav-truncation"><a onclick=changeAuditIndex("${jumpIndex}","adminsAuditlog-user-form") id="pagination-truncation">&hellip;</a></li>
                            </#if>
                            <#if (end!=totalLogs)>
                            <li class="aui-nav-next"><a onclick=changeAuditIndex("${nextIndex}","adminsAuditlog-user-form")>Next</a></li>
                            <li class="aui-nav-last"><a onclick=changeAuditIndex("${lastIndex}","adminsAuditlog-user-form")>Last</a></li>
                            </#if>
                        </ol>
                        </#if>
                        </td>
                    </tr>
                </table>
                <#else>
                <table class="aui">
                    <thead>
                    <tr>
                        <th id="number">Sr.No</th>
                        <th id="action">Action</th>
                        <th id="username">Performed On</th>
                        <th id="username">Performed By</th>
                        <th id="loginTimeAndDate">Date</th>
                        <th id="ip">View More Details</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td colspan="6">
                            <p style="width:100%" align="center">
                                No Audit Logs found.
                            </p>
                        </td>
                    </tr>
                    </tbody>
                </table>
                </#if>
            </div>
        </form>
    </#if>
    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>