<div id="current2faProvidesDiv">
    <h3 style="margin-left: 10px;">Available 2FA methods</h3>
    <input type="hidden" name="minio_token" id="minio_token" value="${minio_token}"/>

    <#assign configuredGoogleAuthenticator = false>
    <#assign configuredOtpOverEmail = false>
    <#assign configuredOtpOverSms = false>
    <#assign configuredSecurityQuestion = false>
    <#assign configuredBackupCode = false>
    <#assign configuredU2FHardwareToken = false>
    <#assign configuredWebAuthn = false>
    <#assign configuredDuoPushNotification = false>

    <#assign remainingMethods = totalConfiguredMethods>
    <#list 1..3 as count>
        <#assign loopCount = 0>
        <#if (remainingMethods >= 3)>
        <div class="aui-group" style="width: 87%;margin-left: 10%;">
        <#elseif (remainingMethods == 2)>
        <div class="aui-group" style="width: 58%;margin-left: 10%;">
        <#else>
        <div class="aui-group" style="width: 29%;margin-left: 10%;">
        </#if>

        <#if (loopCount < 3 && shouldShowGoogleAuthenticator == true && configuredGoogleAuthenticator == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredGoogleAuthenticator = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div  style="width: 100%;">
                    <div class="card-body">
                        <b>Mobile Authenticator</b>
                        <#if (currentDefault2faMethod == "GoogleAuthenticator")>
                            <span class="aui-lozenge aui-lozenge-success" style="float: right;">Primary</span>
                        </#if>
                        <br><br>
                        <table>
                            <tr>
                                <td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img class="imgIcon" id="imgGoogleAuthenticator" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>
                                <td>
                                    In this method, user needs to enter 6 digit passcode generated by Mobile Authenticator app.
                                    <br><br><br>
                                    <#if (googleAuthenticatorConfigured == true)>
                                        <p style="margin-top:-20px;">Your Secret Key is <b>${secretKey}</b></p>
                                    </#if>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <#if (googleAuthenticatorConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                                <button id="google-authenticator-reset-button" class="aui-button" >Reset</button>
                            <#else>
                                <button id="reset-button" class="aui-button" disabled>Reset</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "GoogleAuthenticator")>
                                <button id="setGoogleAuthenticatorAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                        <#else>
                            <button id="google-authenticator-configuration" class="aui-button" >Configure</button>
                        </#if>
                    </div>
                </div>
            </div>
        </#if>

        <#if (loopCount < 3 && shouldShowU2FHardwareToken == true && configuredU2FHardwareToken == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredU2FHardwareToken = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div  style="width: 100%;">
                    <div class="card-body">
                        <b>Yubikey Hardware Token</b>
                        <#if (currentDefault2faMethod == "YubikeyHardwareTokenAsU2F") >
                            <span class="aui-lozenge aui-lozenge-success" style="float: right;">Primary</span>
                        </#if>
                        <br><br>
                        <table>
                            <tr>
                                <td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img class="imgIcon" id="imgHardwareToken" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>
                                <td>
                                    In this method, user needs to insert a security key & touch it.
                                    <br><br><br>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <#if (u2fHardwareTokenConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                                <button id="u2f-hardware-token-reset-button" class="aui-button" >Reset</button>
                            <#else>
                                <button id="reset-button" class="aui-button" disabled>Reset</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "YubikeyHardwareTokenAsU2F") >
                                <button id="setU2FHardwareTokenAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                        <#else>
                            <button id="u2f-hardware-token-configuration" class="aui-button">Configure</button>
                        </#if>
                    </div>
                </div>
            </div>
        </#if>

          <#if (loopCount < 3 && shouldShowDuoPushNotification == true && configuredDuoPushNotification == false)>
                    <#assign remainingMethods = remainingMethods - 1>
                    <#assign configuredDuoPushNotification = true>
                    <#assign loopCount = loopCount + 1>
                    <div class="aui-item">
                        <div  style="width: 100%;">
                            <div class="card-body">
                                <b>Duo Push Notification</b>
                                 <#if (currentDefault2faMethod == "DuoPushNotification") >
                                    <span class="aui-lozenge aui-lozenge-success" style="float: right;">Primary</span>
                                </#if>
                                <br><br>
                                <table>
                                    <tr>
                                        <td style="width: 30%;">
                                            <div style="width: 48px;float:left;">
                                                <img class="imgIcon" id="imgPushNotification" style="width: 80px;height: 100px !important;line-height: 80px;">
                                            </div>
                                        </td>
                                        <td>
                                            In this method, user receives a notification on his mobile which he needs to APPROVE | DENY.
                                            <br><br><br>
                                        </td>
                                    </tr>
                                </table>
                                <br>
                                <#if (duoPushNotificationConfigured == true)>
                                    <#if (allowToReconfigureMethod == true)>
                                        <button id="duo-push-notification-reset-button" class="aui-button" >Reset</button>
                                    <#else>
                                        <button id="reset-button" class="aui-button" disabled>Reset</button>
                                    </#if>

                                    <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "DuoPushNotification") >
                                        <button id="setDuoPushNotificationAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                                    </#if>
                                <#else>
                                    <button id="duo-push-notification-configuration" class="aui-button">Configure</button>
                                </#if>
                            </div>
                        </div>
                    </div>
          </#if>


        <#if (loopCount < 3 && shouldShowWebAuthn == true && configuredWebAuthn == false)>

                <#assign remainingMethods = remainingMethods - 1>
                <#assign configuredWebAuthn = true>
                <#assign loopCount = loopCount + 1>
                <div class="aui-item">
                    <div  style="width: 100%;">
                        <div class="card-body">
                            <b>Web Authentication</b>
                            <#if (currentDefault2faMethod == "WebAuthn")>
                                <span class="aui-lozenge aui-lozenge-success" style="float: right;">Primary</span>
                            </#if>
                            <br><br>
                            <table>
                                <tr>
                                    <td style="width: 30%;">
                                        <div style="width: 48px;float:left;">
                                            <img class="imgIcon" id="imgWebAuthn" style="width: 80px;height: 100px !important;line-height: 80px;">
                                        </div>
                                    </td>
                                    <td>
                                        In this method, user can use the system's built-in authentication methods.
                                        <br><br><br>
                                    </td>
                                </tr>
                            </table>
                            <br>
                            <#if (webAuthnConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                            <button id="web-authn-edit-button" class="aui-button" >Edit</button>
                            <#else>
                            <button id="edit-button" class="aui-button" disabled>Edit</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "WebAuthn")>
                            <button id="setWebAuthnAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                            <#elseif (u2fHardwareTokenConfigured == false)>
                            <button id="web-authn-configuration" class="aui-button">Configure</button>
                            <#else>
                            <button id="web-authn-configuration" disabled class="aui-button">Configure</button>
                            </#if>
                        </div>
                    </div>
                </div>
        </#if>


        <#if (loopCount < 3 && shouldShowOtpOverEmail == true && configuredOtpOverEmail == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredOtpOverEmail = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div  style="width: 100%;">
                    <div class="card-body">
                        <b>OTP Over Email</b>
                        <#if (currentDefault2faMethod == "OtpOverEmail")>
                            <span class="aui-lozenge aui-lozenge-success" style="float: right;">Primary</span>
                        </#if>
                        <br><br>
                        <table>
                            <tr>
                                <td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img class="imgIcon" id="imgOtpOverEmail" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>
                                <td>
                                    In this method, user needs to enter the OTP received on the email.
                                    <br><br><br>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <#if (otpOverEmailConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                                <button id="otp-over-email-reset-button" class="aui-button" >Reset</button>
                            <#else>
                                <button id="reset-button" class="aui-button" disabled>Reset</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "OtpOverEmail")>
                                <button id="setOtpOverEmailAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                        <#else>
                            <button id="otp-over-email-configuration" class="aui-button">Configure</button>
                        </#if>
                    </div>
                </div>
            </div>
        </#if>

        <#if (loopCount < 3 && shouldShowOtpOverSms == true && configuredOtpOverSms == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredOtpOverSms = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div  style="width: 100%;">
                    <div class="card-body">
                        <b>OTP Over SMS</b>
                        <#if (currentDefault2faMethod == "OtpOverSms")>
                            <span class="aui-lozenge aui-lozenge-success" style="float: right;">Primary</span>
                        </#if>
                        <br><br>
                        <table>
                            <tr>
                                <td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img class="imgIcon" id="imgOtpOverSms" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>
                                <td>
                                    In this method, user needs to enter the OTP received via SMS on his mobile.
                                    <br><br><br>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <#if (otpOverSmsConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                                <button id="otp-over-sms-reset-button" class="aui-button" >Reset</button>
                            <#else>
                                <button id="reset-button" class="aui-button" disabled>Reset</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "OtpOverSms")>
                                <button id="setOtpOverSmsAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                        <#else>
                            <button id="otp-over-sms-configuration" class="aui-button">Configure</button>
                        </#if>
                    </div>
                </div>
            </div>
        </#if>

        <#if (loopCount < 3 && shouldShowSecurityQuestion == true && configuredSecurityQuestion == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredSecurityQuestion = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div  style="width: 100%;">
                    <div class="card-body">
                        <b>Security Question</b>
                        <#if (currentDefault2faMethod == "SecurityQuestion")>
                            <span class="aui-lozenge aui-lozenge-success" style="float: right;">Primary</span>
                        </#if>
                        <br><br>
                        <table>
                            <tr>
                                <td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img class="imgIcon" id="imgSecurityQuestion" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>
                                <td>
                                    In this method, user needs to answer the security questions to access Bamboo.
                                    <br><br><br>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <#if (securityQuestionConfigured == true)>
                            <#if (allowToReconfigureMethod == true)>
                                <button id="security-question-reset-button" class="aui-button" >Reset</button>
                            <#else>
                                <button id="reset-button" class="aui-button" disabled>Reset</button>
                            </#if>

                            <#if (enableEnforceCurrentMethod != true && currentDefault2faMethod != "SecurityQuestion")>
                                <button id="setSecurityQuestionAsDefault2fa" class="aui-button" style="float: right;" resolved="">Set as Primary</button>
                            </#if>
                        <#else>
                            <button id="security-question-configuration" class="aui-button" >Configure</button>
                        </#if>
                    </div>
                </div>
            </div>
        </#if>

        <#if (loopCount < 3 && shouldShowBackupCode == true && configuredBackupCode == false)>
            <#assign remainingMethods = remainingMethods - 1>
            <#assign configuredBackupCode = true>
            <#assign loopCount = loopCount + 1>
            <div class="aui-item">
                <div  style="width: 100%;">
                    <div class="card-body">
                        <b>Backup Code (Backup Method)</b>
                        <br><br>
                        <table>
                            <tr>
                                <td style="width: 30%;">
                                    <div style="width: 48px;float:left;">
                                        <img class="imgIcon" id="imgBackupCode" style="width: 80px;height: 100px !important;line-height: 80px;">
                                    </div>
                                </td>
                                <td>
                                    In this method, user needs to provide the Backup Code to access Bamboo.
                                    <br><br><br>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <button id="backup-code-show-button" class="aui-button">Show Details</button>
                    </div>
                </div>
            </div>
        </#if>
        </div>
        <#assign count = count - 1>
    </#list>
</div>

<section id="configure-google-authenticator-dialog" class="aui-dialog2 aui-layer" data-aui-modal="true" role="dialog" aria-hidden="true" style="max-width:800px; max-height:850px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - MOBILE AUTHENTICATOR</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;max-height: 100%;">
        <form id="google-authenticator-configuration-form" class="aui" action="" method="POST" style="text-align: center;">
            <input type="hidden" name="atl_token" value="${xsrfToken}" />
            <#if (googleAuthenticatorConfigured == true)>
                <div class="aui-message aui-message-info" id="successMessageGoogleAuthenticator">
                    <p>
                       You have already configured Mobile Authenticator successfully.
                    </p>
                    <p>
                       You can use the below details for reconfiguring it on other device.
                    </p>
                </div>
            </#if>

            <div id="google-authenticator-secondary-div" name="google-authenticator-secondary-div">
                <p>Please scan the QR code using any authenticator app and enter the OTP below.</p>
                <p>Don't know how to configure Mobile authenticator, refer to this
                <a href="https://miniorange.com/atlassian/user-guide-for-2fa#section-configure-mobile-authenticator" target="_blank">User Guide</a> </p>
                <br>

                <div class="aui-group">
                    <img style="max-width: 180px;" src="data:image/jpg;base64,${qrcode}" />
                </div>

                <div class="aui-group">
                    <p>Your Secret Key is <b>${secretKey}</b><br></p>
                </div>
                <#if (shareSecretKey == true)>
                    <div class="aui-message aui-message-info" style="margin-left:20%; width:405px;">
                            Already configured Mobile Authenticator on other Atlassian App?
                            <br>
                            <a href="#" onclick="enableRegistrationUsingOwnSecretKey()">Click here</a> to use same passcode.
                    </div>
                </#if>
                <br>
                <hr>

                <div class="aui-group">
                    <label>Enter verification code as shown in the mobile app</label>&nbsp;
                    <input class="text" id="qrCodeOtp" name="qrCodeOtp" type="text" value=""
                    style="width: 75%;" autocomplete="off"/>
                </div>
                <br/>

                <div class="aui-group" style="text-align:center;">
                    <input class="aui-button aui-button-primary" id="google-authenticator-form-submit" name="Validate"
                    type="submit" value="Validate Code"/>
                    <button id="google-authenticator-form-close" class="aui-button">Close</button>
                </div>
            </div>
            <div name="google-authenticator-own-secret-key-secondary-div" id="google-authenticator-own-secret-key-secondary-div" style="text-align: center; display:none;">
            <p>Enter the Secret Key and the OTP associated with your existing account to register. </p>

            <div class="aui-message aui-message-info">
                 <p>Don't know your Secret Key? Check the <b>Two Factor Configuration</b> tab under the User Profile icon of the application where you have already registered with this 2FA method.</p>
            </div>

            <div class="aui-group" style="margin-left: 28px;">
                <label>Enter a known secret key</label>&nbsp;
                <input class="text" id="ownSecretKey" name="ownSecretKey" type="text" value="" style="width: 75%;" autocomplete="off"/>
            </div>

            <div class="aui-group" style="margin-left: -55px;">
                <label>Enter verification code as shown in the mobile app</label>&nbsp;
                <input class="text" id="otpUsingOwnSecretKey" name="otpUsingOwnSecretKey" type="text" value=""  style="width: 75%;" autocomplete="off"/>
            </div>

            <br/>
            <div style="margin-left: -25px;">
                Don't have a secret key?<a href="#" onclick="enableRegistrationUsingQrCode()"> scan a QR Code </a>to register.&nbsp;&nbsp;
                <br><br>
                <input class="aui-button aui-button-primary" id="mo-2fa-inline-registration-form-submit" name="Validate" type="submit" value="Validate Code" style="margin-top: -5px" />
                <button id="google-authenticator-form-close_2" class="aui-button">Close</button>
            </div>
        </div>
        </form>
        <footer class="aui-dialog2-footer" id="showAfterSuccessGoogleAuthenticator" style="display:none">
            <div class="aui-dialog2-footer-actions">
                <button id="google-authenticator-form-close_1" class="aui-button">Close</button>
            </div>
        </footer>
    </div>
</section>

<section id="configure-security-question-dialog" class="aui-dialog2 aui-layer" data-aui-modal="true" role="dialog" aria-hidden="true" style="max-width:800px; max-height:800px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - SECURITY QUESTIONS</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;">
        <form id="security-question-configuration-form" class="aui" action="" method="POST">
            <input type="hidden" name="atl_token" value="${xsrfToken}" />
            <#if (securityQuestionConfigured == true)>
                <div class="aui-message aui-message-info" id="successMessageSecurityQuestion">
                    <p>
                       You have already configured Security Question successfully.
                    </p>
                </div>
            </#if>

            <p>Please choose any 3 unique security questions and enter your answer in the corresponding text boxes.<br>
                At the time of login, you will be asked any two questions to verify your identity.</p>
            <br>
            <#assign loopCount = 0>
            <table style="width: 100%;">
                <thead>
                    <tr>
                        <th id="question-number"></th>
                        <th id="select-question">Question</th>
                        <th id="enter-answer">Answer</th>
                    </tr>
                </thead>
                <tbody>
                    <#foreach questionNumber in securityQuestionNumber>
                        <tr>
                            <td headers="question-number" class="table-label" style="padding-top: 10px;padding-bottom: 10px;">${questionNumber}:</td>
                            <td headers="select-question" style="padding-top: 10px;padding-bottom: 10px;">
                                <select class="select" name="question_${loopCount}" id="question_${loopCount}" class="securityquestions" required style="max-width: 100%;">
                                    <#foreach question in questionList>
                                        <option value="${question}">
                                            ${question}
                                        </option>
                                    </#foreach>
                                </select>
                            </td>
                            <td headers="enter-answer" style="padding-top: 10px;padding-bottom: 10px;">
                                <input class="text" id="answer_${loopCount}" name="answer_${loopCount}" type="text" value="" placeholder="Your Answer" required autocomplete="off"/>
                            </td>
                        </tr>
                        <#assign loopCount = loopCount + 1>
                    </#foreach>
                    <tr>
                        <td headers="question-number" class="table-label" style="padding-top: 10px;padding-bottom: 10px;">Question 3:</td>
                        <td headers="select-question" style="padding-top: 10px;padding-bottom: 10px;">
                            <input class="text" id="custom_question" name="custom_question" type="text" value="" placeholder="Type a custom question" required style="max-width: 100%;" autocomplete="off"/>
                        </td>
                        <td headers="enter-answer" style="padding-top: 10px;padding-bottom: 10px;">
                            <input class="text" id="custom_answer" name="custom_answer" type="text" value="" placeholder="Your Answer" required autocomplete="off"/>
                        </td>
                    </tr>
                </tbody>
            </table>
            <br/>
            <div style="margin-left: 81%;">
                <input class="aui-button aui-button-primary" id="otp-validate-form-submit" name="Submit" type="submit" value="Submit" resolved=""/>
                <button id="security-question-form-close" class="aui-button" resolved="">Close</button>
            </div>
        </form>

        <footer class="aui-dialog2-footer" id="showAfterSuccessSecurityQuestion" style="display:none">
            <div class="aui-dialog2-footer-actions">
                <button id="security-question-form-close_1" class="aui-button">Close</button>
            </div>
        </footer>
    </div>
</section>

<section id="configure-backup-code-dialog" class="aui-dialog2 aui-layer" data-aui-modal="true" role="dialog" aria-hidden="true" style="max-width:800px; max-height:800px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - BACKUP CODE</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;">
        <#if (backupCodeConfigured == true && shouldShowBackupCodeWarning == true)>
            <div class="aui-message aui-message-warning" id="warningBackupCodeUsed">
        <#else>
            <div class="aui-message aui-message-warning" id="warningBackupCodeUsed" style="display:none">
        </#if>
                <p>
                   You have used all the Backup Codes. Please click on "Change Backup Code" to generate new Backup Codes.
                </p>
            </div>

        <div class="aui-message aui-message-success" id="successMessageBackupCodeChange" style="display:none">
            <p>
               Successfully changed the Backup Code.
            </p>
        </div>
        <div class="aui-message aui-message-success" id="successMessageBackupCodeEnabled" style="display:none">
            <p>
               Successfully enable the Backup Code.
            </p>
        </div>
        <div class="aui-message aui-message-success" id="successMessageBackupCodeDisable" style="display:none">
            <p>
               Successfully disable the Backup Code.
            </p>
        </div>

        <form id="backup-code-configuration-form" class="aui" action="" method="POST">
            <input type="hidden" name="atl_token" value="${xsrfToken}" />
            <div class="aui-message aui-message-info">
                <p>These are emergency one time backup codes that you can use to get access to your account. It can be used when you are not able to login using two factor.</p>
                <#if (backupCodeConfigured == true)>
                <div id="backup-code-enabled-info-div">
                <#else>
                <div id="backup-code-enabled-info-div" style="display:none">
                </#if>
                    <p>Click "Download Backup Code" button to download the Backup Code & click "Change Backup Code" button to change the current Backup Code.</p>
                    <p>Click "Disable Backup Code" button disable the Backup Code method for your account.</p>
                </div>

                <#if (backupCodeConfigured != true)>
                <div id="backup-code-enable-info-div">
                <#else>
                <div id="backup-code-enable-info-div" style="display:none">
                </#if>
                    <p>You haven't enabled Backup Code for your account. Please click "Enable Backup Code" button to enabled it for your account.</p>
                </div>
            </div>
            <br>
            <#if (backupCodeConfigured == true)>
            <div id="backup-code-enabled-div">
            <#else>
            <div id="backup-code-enabled-div" style="display:none">
            </#if>
                <input class="aui-button" id="backup-code-download" name="DownloadBackupCode" type="button" value="Download Backup Code" onclick="window.location.href = '${downloadBackupCodeUrl}';"/>

                <#if (allowToReconfigureMethod == true)>
                    <input class="aui-button" id="backup-code-change" name="ChangeBackupCode" type="button" value="Change Backup Code" style="margin-left: 17%;"/>
                <#else>
                    <input class="aui-button" id="backup-change" name="ChangeBackupCode" type="button" value="Change Backup Code" style="margin-left: 17%;" disabled/>
                </#if>

                <#if (allowToReconfigureMethod == true)>
                    <input class="aui-button" id="backup-code-disable" name="DisableBackupCode" type="button" value="Disable Backup Code" style="float: right;"/>
                <#else>
                    <input class="aui-button" id="backup-disable" name="DisableBackupCode" type="button" value="Disable Backup Code" style="float: right;" disabled/>
                </#if>
            </div>

            <#if (backupCodeConfigured != true)>
            <div id="backup-code-enable-div">
            <#else>
            <div id="backup-code-enable-div" style="display:none">
            </#if>
                <input class="aui-button" id="backup-code-enable" name="Enable" type="button" value="Enable Backup Code" />
            </div>
        </form>
        <hr class="header"/>
        <div class="aui-dialog2-footer-actions">
            <button id="backup-code-form-close_1" class="aui-button">Close</button>
        </div>
    </div>
</section>

<section id="configure-otp-over-email-dialog" class="aui-dialog2 aui-layer" data-aui-modal="true" role="dialog" aria-hidden="true" style="max-width:400px; max-height:850px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - OTP OVER EMAIL</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;max-height: 100%;">
        <#if (smtpConfigured == false)>
            <div class="aui-message aui-message-warning">
                <p>
                   As Bamboo's mail server is not configured yet. So won't be able to enable OTP Over Email as 2FA method.
                    You need to <a onclick="RedirectToMailServer('/admin/viewMailServer.action')"><b>configure</b></a> Bamboo's mail server to use OTP over Email as 2FA.
                </p>
            </div>
        <#else>
            <form id="otp-over-email-configuration-form" class="aui" action="" method="POST">
                <input type="hidden" name="atl_token" value="${xsrfToken}" />
                <div id="otp-over-email-enable-button-div">
                    <input class="aui-button" id="otp-over-email-enable" name="Enable" type="button" value="Enable OTP Over Email" />
                    <br><br>
                </div>

                <div id="otp-over-email-configuration-div" style="display:none">
                    <div class="aui-group">
                        <label>Enter OTP</label>&nbsp;
                        <input class="text" id="otpCode" name="otpCode" type="text" value="" autofocus required autocomplete="off"/>
                        <div class="aui-group" id="idResendOtpDiv">
                            <p><a href="#">Resend OTP</a></p>
                        </div>
                    </div>

                    <div class="aui-group" style="margin-left:35%">
                        <input class="aui-button aui-button-primary" id="otp-over-email-form-submit" name="Validate" type="submit" value="Validate"/>
                        <button id="otp-over-email-form-close" class="aui-button">Close</button>
                    </div>
                </div>
            </form>
        </#if>

        <footer class="aui-dialog2-footer" id="showAfterSuccessOtpOverEmail" style="display:block">
            <div class="aui-dialog2-footer-actions">
                <button id="otp-over-email-form-close_1" class="aui-button">Close</button>
            </div>
        </footer>
    </div>
</section>

<section id="webauthn-config-dialog" class="aui-dialog2 aui-layer aui-dialog2-medium" role="dialog" data-aui-modal="true" aria-hidden="true" style="margin-top:-55px;">
    <div class="aui-dialog2-content" id="card-details" style="overflow: hidden;max-height: 100%; min-height: 50%;">

        <#if (isSslSetup == false)>
        <header class="aui-dialog2-header" style="margin-top:-15px; height:50px;">
            <h2 class="aui-dialog2-header-main">Web Authentication</h2>
        </header>
        <div class="aui-message aui-message-warning">
            <p>SSL is not setup on your Bamboo instance. So you will not be able to setup Web Authentication.</p>
        </div>
        <br>
        <#else>

        <div id="differentiate-web-authn-methods-info" style="display:none;">
            <header class="aui-dialog2-header" style="margin-top:-15px; height:50px;">
                <h2 class="aui-dialog2-header-main">WebAuthn User Configuration</h2>
            </header>

            <div class="aui-message aui-message-warning">
                <p>
                    <b>NOTE:</b> Windows Hello PIN won't work in Chrome/Edge browser's Incognito tabs.
                </p>
            </div>

            <#if (displayEndUserReconfigurationPage == false)>
            <div class="aui-message aui-message-info" style="margin-top:10px;">
                <p class="title">
                    Register system's built-in authenticator.
                </p>
                <p>
                    Register system's built-in authenticators like Windows Hello, Security keys, Apple's FaceID/TouchID or biometrics to login in Bamboo using system credentials.
                </p>
                <p>
                    Don't know how to configure Web Authentication, refer to this
                    <a href="https://miniorange.com/atlassian/user-guide-for-2fa#section-configure-Web-Authentication" target="_blank" style="text-decoration: none;">User Guide</a>.
                </p>
            </div>
            <#else>
            <div class="aui-message aui-message-info" style="margin-top:10px;">
                <p class="title">
                    Register system's built-in authenticator.
                </p>
                <p>
                    Register system's built-in authenticators like Windows Hello, Security keys, Apple's FaceID/TouchID or biometrics to login in Bamboo using system credentials.
                </p>
                <p>
                    Don't know how to configure Web Authentication, refer to this
                    <a href="https://miniorange.com/atlassian/user-guide-for-2fa#section-configure-Web-Authentication" target="_blank" style="text-decoration: none;">User Guide</a>.
                </p>
            </div>
            </#if>
            <br>
            <button id="configure-webAuthn-as-second-factor-button" onclick="registerNewSystemAuthenticator('${attestationType}', '${authenticatorType}','${userVerification}','${residentKey}')" class="aui-button aui-button-primary" style="margin-left:20%; margin-top:-5px;" >Configure WebAuthn as 2nd factor of authentication</button>
        </div>

        <div id = "user_config" style="display:none;">
            <header class="aui-dialog2-header" style="margin-top:-15px; height:50px;">
                <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - Web Authentication</h2>
            </header>

            <div class="aui-message aui-message-warning">
                <p>
                    <b>NOTE:</b> Windows Hello PIN won't work in Chrome/Edge browser's Incognito tabs.
                </p>
            </div>

            <div class="aui-message aui-message-info" style="margin-top:10px;">
                <p>
                    Register system's built-in authenticator to login in Bamboo using system credentials.
                </p>
                <p>
                    Don't know how to configure Web Authentication, refer to this
                    <a href="https://miniorange.com/atlassian/user-guide-for-2fa#section-configure-Web-Authentication" target="_blank" style="text-decoration: none;">User Guide</a>.
                </p>
            </div>
            <br>
            <div style="margin-top:-5px;">
                <button id="register_new_credential_for_webauthn2fa" onclick="registerAdditionalAuthenticator('${attestationType}', '${authenticatorType}','${userVerification}','${residentKey}')" class="aui-button aui-button-primary" style="margin-left:4em;">Register New Credentials</button>
                <button id="clear_previous_credential" class="aui-button" style="margin-left:5em;">Clear Previous Credentials</button>
            </div>
        </div>

        <div id ="clear_register_warning"  style="display:none; transition: opacity 2s linear, transform 2s linear;opacity: 1;">
            <div class="aui-message aui-message-warning warning shadowed">
                <p id="user-action-main-inst">
                    <b>Are you sure you want to delete the previously registered system authenticator?</b>
                    <br/>
                    <br/>
                    If you clear your previous credentials you won't be able to use Web Authentication as a 2FA method for logging in to Bamboo.
                </p>
            </div>
            <div style="margin-top:1em;">
                <button id="confirm_clear" class="aui-button aui-button-primary" onclick="confirm_clear('${currentLoggedInUser}')"  style="margin-left:14em;">Confirm</button>
                <button id="back_to_credential_clear" class="aui-button" style="margin-left:1em;">Cancel</button>
            </div>
        </div>

        <div id ="wait_div" style="display:none; transition: opacity 2s linear, transform 2s linear;opacity: 1; margin-top:-10px;">
            <div id="waiting_form">
                <div class="aui-message aui-message-info">
                    <span>Please wait for the prompt...</span>
                </div>
                <div class="mospinner" style="display: flex; flex-direction: column; align-items: center; justify-content: center;">
                    <aui-spinner size="large"></aui-spinner>
                </div>
            </div>
        </div>

        <div id="err_div" style="display:none; transition: opacity 2s linear, transform 2s linear;opacity: 1;">
            <div class="aui-message aui-message-error">
                <p class="title">
                    <strong>Error Occurred!</strong>
                </p>
                <p id="err_div_msg">Please contact your administrator.</p>
            </div>
        </div>

        <div id="succ_div_config" style="display:none; transition: opacity 2s linear, transform 2s linear;opacity: 1;">
            <div class="aui-message aui-message-success success shadowed">
                <p class="title">
                    <strong>Success!</strong>
                </p>
                <p id="succ_div_msg">You successfully registered new authenticator.</p>
            </div>
        </div>
        </#if>
    </div>

    <footer class="aui-dialog2-footer" id="closeWebAuthnPopup">
        <div class="aui-dialog2-footer-actions">
            <button id="webauthn-config-close" class="aui-button">Close</button>
        </div>
    </footer>


</section>



<section id="configure-u2f-hardware-token-dialog" class="aui-dialog2 aui-layer aui-dialog2-medium" data-aui-modal="true" role="dialog" aria-hidden="true" style="width:550px; max-height:850px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - Yubikey Hardware Token(U2F)</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;max-height: 100%;">
        <form id="u2f-hardware-token-configuration-form" class="aui" action="" method="POST" onsubmit="return false;">
        <input type="hidden" name="atl_token" value="${xsrfToken}" />
            <#if (u2fHardwareTokenConfigured == true)>
                <div class="aui-message aui-message-info" id="successMessageHardwareToken">
                    <p>
                       You have already configured Yubikey Hardware Token(U2F) successfully.
                    </p>
                </div>
            </#if>
            <#if (isSslSetup == true)>
                <div id="hardware-token-main-div">
                    <div class="aui-message aui-message-info">
                        <p>Perform the below steps to configure the Yubikey Hardware Token(U2F) as your 2FA method.</p>
                    </div>

                    <p>
                        Step 1: Insert your <b>Hardware Token(Yubikey)</b> into a USB port.</br></br>
                        Step 2: Click on <b>Configure</b> button to configure your Yubikey Hardware Token.</br></br>
                        Step 3: When the Yubikey starts blinking, press the gold disc for further configuration.
                    </p>
                </div>
            <#else>
                <div id="hardware-token-main-div">
                    <div class="aui-message aui-message-warning">
                        <p>SSL is not setup on your Bamboo instance. So you will not be able to setup Yubikey Hardware Token(U2F).</p>
                    </div>
                    <br>
                </div>
            </#if>

            <div id="hardware-token-touch-key-div" style="display:none">
                <img class="imgIcon" id="imgYubikeyTokenTouch" style="width: 100%;height: 100% !important;line-height: 80px;">
            </div>

            <div class="aui-group" style="margin-left:35%">
                <#if (isSslSetup == true)>
                   <!-- <input class="aui-button aui-button-primary" id="u2f-hardware-token-form-submit" name="Configure U2F"
                    type="button" value="Configure U2F" /> -->
                    <input class="aui-button aui-button-primary" onclick="registerYubikeyToken('${attestationType}', '${authenticatorType}','${userVerification}','${residentKey}')" id="register_new_credential" name="Configure WebAuthn"
                                type="button" value="Configure"/>
                </#if>
                <button id="u2f-hardware-token-form-close" class="aui-button">Close</button>
            </div>
        </form>
        <footer class="aui-dialog2-footer" id="showAfterSuccessHardwareToken" style="display:none">
            <div class="aui-dialog2-footer-actions">
                <button id="u2f-hardware-token-form-close_1" class="aui-button">Close</button>
            </div>
        </footer>
    </div>
</section>

<section id="configure-otp-over-sms-dialog" class="aui-dialog2 aui-layer" data-aui-modal="true" role="dialog" aria-hidden="true" style="max-width:400px; max-height:850px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - OTP OVER SMS</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;max-height: 100%;">
        <#if (smsGatewayConfigured == false)>
            <div class="aui-message aui-message-warning">
                <p>
                   SMS Gateway is not configured yet. So you won't be able to enable OTP Over SMS as 2FA method. </br>
                    Go to the <a onclick="RedirectToBasicConfigurationPage()"><b>Basic Configurations</b></a> tab of the plugin and click on the <span class="aui-icon aui-icon-small aui-iconfont-settings"></span> icon to configure the SMS Gateway.
                </p>
            </div>
        <#else>
            <form id="otp-over-sms-configuration-form" class="aui" action="" method="POST">
                <input type="hidden" name="atl_token" value="${xsrfToken}" />
                <div id="idInfoMessage" class="aui-message aui-message-info">
                    <p>Enter your mobile number(with country code) and click on <b>Send OTP</b> button.
                    Then enter the OTP received on your mobile to configure OTP over SMS as a 2FA method.</p>
                </div>

                <div id="otp-over-sms-mobile-number-div">
                    <br>
                    <div class="aui-group">
                        <label>Enter Mobile: </label>&nbsp;
                        <input class="text" id="countryCode" name="countryCode" type="text" value="+1" style="width: 40px;" />&nbsp;
                        <input class="text" id="mobileNumber" name="mobileNumber" type="text" value="" style="width: 120px;" />
                        <button class="aui-button aui-button-primary" type="button" id="sendOtpOverSmsButton" style="float:right">Send OTP</button>
                    </div>
                    <br>
                </div>
                <div id="otp-over-sms-enter-otp-div" style="display:none">
                    <div class="aui-group">
                        <label>Enter OTP</label>&nbsp;
                        <input class="text" id="otpCode_sms" name="otpCode_sms" type="text" value="" autocomplete="off"/>
                        <div class="aui-group" id="idResendOtpOnSmsDiv" style="display:none">
                            <p><a href="#">Resend OTP</a></p>
                        </div>
                    </div>

                    <div class="aui-group" style="text-align: center;">
                        <input class="aui-button aui-button-primary" id="otp-over-sms-form-submit" type="button" name="Validate" value="Validate"/>
                        <button id="otp-over-sms-form-close" class="aui-button">Close</button>
                    </div>
                </div>
            </form>
        </#if>

        <footer class="aui-dialog2-footer" id="showAfterSuccessOtpOverSms" style="display:block">
            <div class="aui-dialog2-footer-actions">
                <button id="otp-over-email-form-close_1" class="aui-button">Close</button>
            </div>
        </footer>
    </div>
</section>

<section id="configure-duo-push-notification-dialog" class="aui-dialog2 aui-layer" data-aui-modal="true" role="dialog" aria-hidden="true" style="max-width:500px; max-height:850px" >
    <header class="aui-dialog2-header">
        <h2 class="aui-dialog2-header-main">CONFIGURE 2FA - DUO PUSH NOTIFICATION</h2>
    </header>
    <div class="aui-dialog2-content" style="overflow: hidden;max-height: 100%;">
        <#if (duoPushNotificationSettingsConfigured == false)>
            <div class="aui-message aui-message-warning">
                <p>
                   Push Notification configuration details are not yet configured. Go to the <a href="advancedsettings.action"><b>Advanced Settings</b></a> tab of the plugin to configure it.
                </p>
            </div>
        <#else>
            <form id="duo-push-notification-configuration-form" class="aui" action="" method="POST">
                <input type="hidden" name="atl_token" value="${xsrfToken}" />
                <div id="duo-push-notification-enable-button-div">
                    <input class="aui-button" id="duo-push-notification-enable" name="Enable" type="button" value="Enable Duo Push Notification" />
                    <br><br>
                </div>

                <div id="duo-push-notification-configuration-div" style="display:none">
                    <#if (duoPushNotificationEnrollPortalUrl == "")>
                        <div class="aui-message aui-message-error">
                            <p>
                               Issue with generating Duo Push Notification Enroll URL. Please try again later.
                            </p>
                        </div>
                    <#elseif (duoPushNotificationEnrollPortalUrl == "ENROLLED")>
                        <div class="aui-message aui-message-info" id="duo-push-notification-info-div">
                            <p>
                               Looks like you already registered with DUO for push notification. <br>Please click on <b>Send Me Push Notification</b> button for validation.<br>
                            </p>
                        </div>
                    <#else>

                        <div id="idDuoPushNotificationEnrollPortalUrl" class="aui-message aui-message-info">
                            <p>
                                Use the below link for registering the device with DUO.
                            </p>
                            <p><a href="${duoPushNotificationEnrollPortalUrl}" target="_blank"><b>Click Here</b></a> to configure DUO Push Notification. Once done with registration, click on <b>Send Me Push Notification</b> button to verify details.</b></p>
                        </div>
                    </#if>
                    <div class="aui-group">
                        <#if (duoPushNotificationEnrollPortalUrl != "")>
                            <input class="aui-button aui-button-primary" id="duo-push-notification-form-submit" name="Send Me Push Notification" type="submit" value="Send Me Push Notification"/>
                        </#if>
                        <button id="duo-push-notification-form-close" class="aui-button">Close</button>
                    </div>
                </div>
            </form>
        </#if>

        <footer class="aui-dialog2-footer" id="showAfterSuccessDuoPushNotification" style="display:block">
            <div class="aui-dialog2-footer-actions">
                <button id="duo-push-notification-form-close_1" class="aui-button">Close</button>
            </div>
        </footer>
    </div>
</section>
