AJS.$(document).ready(function(){
    AJS.$(window).scrollTop(0);

    if(document.getElementById("isSslSetup").value === "true")
    {
        if(document.getElementById("idWebAuthn").checked === true)
        {
            document.getElementById("yubikeytoggleParentId").className = "for-toolTip";
            document.getElementById("yubikeytoggleParentId").setAttribute('data-tooltip','Web Authentication and Yubikey Hardware Token cannot be enabled simultaneously. Please select either of them.');
        }
        else{
            document.getElementById("yubikeytoggleParentId").classList.remove("for-toolTip");
            document.getElementById("yubikeytoggleParentId").removeAttribute("data-tooltip");
        }

        if(document.getElementById("idYubikeyHardwareTokenAsU2F").checked === true)
        {
            document.getElementById("webAuthntoggleParentId").className = "for-toolTip";
            document.getElementById("webAuthntoggleParentId").setAttribute('data-tooltip','Web Authentication and Yubikey Hardware Token cannot be enabled simultaneously. Please select either of them.');
        }
        else{
            document.getElementById("webAuthntoggleParentId").classList.remove("for-toolTip");
            document.getElementById("webAuthntoggleParentId").removeAttribute("data-tooltip");
        }
    }


    AJS.$("#mobileAuthenticatorDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#mobileAuthenticatorDivId").hide();
    });
    AJS.$("#webAuthnSettingsDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#webAuthnSettingsDivId").hide();
    });
    AJS.$("#otpOverEmailSettingsDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#otpOverEmailSettingsDivId").hide();
    });
    AJS.$("#otpOverSmsSettingsDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#otpOverSmsSettingsDivId").hide();
    });
    AJS.$("#duoPushNotificationDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#duoPushNotificationDivId").hide();
    });

});

AJS.$(document).ready(function() {
     AJS.$(window).scrollTop(0);
     AJS.$(".aui-nav li").removeClass("aui-nav-selected");
     AJS.$("#CONFIGURE2FA").addClass("aui-nav-selected");
     AJS.$('input').css("box-shadow","none");

    AJS.$(document).on('change', '#smsGateway', function () {
        if(AJS.$("#smsGateway").val() == "miniOrange Gateway"){
            AJS.$("#custom_gateway_div").hide();
            AJS.$("#miniorange_gateway_div").show();
        }else{
            AJS.$("#miniorange_gateway_div").hide();
            AJS.$("#custom_gateway_div").show();
        }
    });
    AJS.$(document).on("change", "#idYubikeyHardwareTokenAsU2F", function () {
        if(document.getElementById("idYubikeyHardwareTokenAsU2F").checked === true)
        {
            document.getElementById("webAuthntoggleParentId").className = "for-toolTip";
            document.getElementById("webAuthntoggleParentId").setAttribute('data-tooltip','Web Authentication and Yubikey Hardware Token cannot be enabled simultaneously. Please select either of them.');
        }
        else{
            document.getElementById("webAuthntoggleParentId").classList.remove("for-toolTip");
            document.getElementById("webAuthntoggleParentId").removeAttribute("data-tooltip");
        }
    });

    AJS.$(document).on("change", "#idWebAuthn", function () {
        if(document.getElementById("idWebAuthn").checked === true)
        {
            document.getElementById("yubikeytoggleParentId").className = "for-toolTip";
            document.getElementById("yubikeytoggleParentId").setAttribute('data-tooltip','Web Authentication and Yubikey Hardware Token cannot be enabled simultaneously. Please select either of them.');
        }
        else{
            document.getElementById("yubikeytoggleParentId").classList.remove("for-toolTip");
            document.getElementById("yubikeytoggleParentId").removeAttribute("data-tooltip");
        }
    });

     var totalCount = '${total2faEnabledUsers}';
     var enableTwoFactor = '${enableTwoFactorString}';
     if(enableTwoFactor == "true" && totalCount <= 0) {
         require('aui/flag')({
             title: 'Two Factor Configuration',
             type: 'warning',
             close: 'manual',
             body: '<p>Two Factor Authentication is disabled for users.<br>Please navigate to the <strong>User Management</strong> tab to enable 2FA for users. Otherwise, 2FA will not work.</p>'
         });
     }

     var configuredMethods = '${totalMethodsConfiguredByUser}';
     if(enableTwoFactor == 'true' && configuredMethods <= 0) {
         require('aui/flag')({
             title: 'Two Factor Authentication',
             type: 'info',
             close: 'auto',
             body: '<p>2FA is enabled but no method is configured. If you do not configure it, you will be prompted to configure it during login.</p>'
         });
     }
    setMethodIcons();
});

function saveMobileAuthnSettings() {
    console.log(document.getElementById("appLabel").value);
    console.log(document.getElementById("showSupportedAppPopup").checked);
    console.log(document.getElementById("enableShareSecretKey").checked);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "ConfigureMobileAuthnSettings",
            "appLabel": document.getElementById("appLabel").value,
            "showSupportedAppPopup": document.getElementById("showSupportedAppPopup").checked,
            "enableShareSecretKey": document.getElementById("enableShareSecretKey").checked
        },
        type: "POST",
        success: function (response) {
            console.log("success");
            if (response.status === 200){
                window.onbeforeunload = null;
                AJS.$(document).on('click', "#mobileAuthenticator-form", function (e) {
                    e.preventDefault();
                });
                window.location.href = window.location.pathname;
            }
        },
        error: function (response) {
            if (response.status === 200){
                window.onbeforeunload = null;
                AJS.$(document).on('click', "#mobileAuthenticator-form", function (e) {
                    e.preventDefault();
                });
                window.location.href = window.location.pathname;
            }
        },
        async: true
    });
}

function previewTemplate(templateId) {
    var templateValue = document.getElementById(templateId).value;
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/testtemplatechanges",
        timeout: 0,
        data: {
            "templatePage": templateValue
        },
        type: "POST",
        success: function (response) {
        },
        error: function (response) {
        }
    });
    var url = AJS.contextPath() + '/plugins/servlet/twofactor/testtemplatechanges';
    var myWindow = window.open(url, "Test Template Changes", "width=1000, height=500");
}

function confirmEnableOrDisable2FAForSoftware() {
    var dialog = new AJS.Dialog({
        width: 500,
        height: 150,
        id: "confirm-dialog",
        closeOnOutsideClick: true
    });

    console.log("status="+document.getElementById("enableTwoFactor").checked);
    if (!document.getElementById("enableTwoFactor").checked) {
        dialog.addPanel("Panel 1", "<p>Are you sure you want to <b>Enable 2FA for bamboo Server</b>?</p>", "panel-body");
        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            console.log("inside enable yes");
            enable2faForSoftware();
        });
        dialog.addLink("No", function (dialog) {
            dialog.hide();
            console.log("inside enable no");
            AJS.$("#enableTwoFactor").prop("checked", false);
        }, "#");

        dialog.show();
    }
    else {
        dialog.addPanel("Panel 1", "<p>Are you sure you want to <b>Disable 2FA for bamboo Software</b>?</p>", "panel-body");
        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            console.log("inside disable yes");
            disable2faForSoftware();
        });
        dialog.addLink("No", function (dialog) {
            dialog.hide();
            console.log("inside disable no");
            AJS.$("#enableTwoFactor").prop("checked", true);
        }, "#");

        dialog.show();
    }
}

function enable2faForSoftware() {
    console.log("Calling enable2faForSoftware");
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForSoftware"
        },
        type: "POST",
        success: function (response) {
            performEnable2faForSoftware(response);
        },
        error: function (response) {
            performEnable2faForSoftware(response);
        },
        async: true
    });
}

function performEnable2faForSoftware(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA for bamboo Software',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully enabled 2FA for bamboo Software.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA for bamboo Software',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2FA for bamboo Software.</p>'
        });
    }
}

function disable2faForSoftware() {
    console.log("Calling disable2faForSoftware");
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForSoftware"
        },
        type: "POST",
        success: function (response) {
            performDisable2faForSoftware(response);
        },
        error: function (response) {
            performDisable2faForSoftware(response);
        },
        async: true
    });
}

function performDisable2faForSoftware(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA for bamboo Software',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully disabled 2FA for bamboo Software.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA for bamboo Software',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2FA for bamboo Software.</p>'
        });
    }
}


function confirmEnableOrDisable2FAForAllUsers() {
    var dialog = new AJS.Dialog({
        width: 500,
        height: 150,
        id: "confirm-dialog",
        closeOnOutsideClick: true
    });

    console.log("status="+document.getElementById("enable2FAForAllUsers").checked);
    if (!document.getElementById("enable2FAForAllUsers").checked) {
        dialog.addPanel("Panel 1", "<p>Are you sure you want to <b>Enable 2FA for all users</b>?</p>", "panel-body");
        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            console.log("inside enable yes");
            enable2faForAllUsers();
        });
        dialog.addLink("No", function (dialog) {
            dialog.hide();
            console.log("inside enable no");
            AJS.$("#enable2FAForAllUsers").prop("checked", false);
        }, "#");

        dialog.show();
    }
    else {
        dialog.addPanel("Panel 1", "<p>Are you sure you want to <b>Disable 2FA for all users</b>?</p>", "panel-body");
        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            console.log("inside disable yes");
            disable2faForAllUsers();
        });
        dialog.addLink("No", function (dialog) {
            dialog.hide();
            console.log("inside disable no");
            AJS.$("#enable2FAForAllUsers").prop("checked", true);
        }, "#");

        dialog.show();
    }
}

function enable2faForAllUsers() {
    console.log("Calling enable2faForAllUsers");
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently enabling 2FA for All Users in background. You can still access bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForAllUsers"
        },
        type: "POST",
        success: function (response) {
            performEnable2faForAllUsers(response);
        },
        error: function (response) {
            performEnable2faForAllUsers(response);
        },
        async: true
    });
}

function performEnable2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully enabled 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2FA for All Users</p>'
        });
    }
}

function disable2faForAllUsers() {
    console.log("Calling disable2faForAllUsers");
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for All Users in background. You can still access bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForAllUsers"
        },
        type: "POST",
        success: function (response) {
            performDisable2faForAllUsers(response);
        },
        error: function (response) {
            performDisable2faForAllUsers(response);
        },
        async: true
    });
}

function performDisable2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully disabled 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2FA for All Users</p>'
        });
    }
}


function saveToggleButton(val){

    var enabled = document.getElementById(val).checked;
    var main = false;
    if(!val.includes("BackupCode"))
    {
        if(document.getElementById(val).checked) {
            AJS.$("#"+val+"Backup").prop('disabled', false);
            AJS.$("#"+val+"Main").prop('disabled', false);

        } else {
            AJS.$("#"+val+"Backup").prop('disabled', true);
            AJS.$("#"+val+"Main").prop('disabled', true);
            AJS.$("#"+val+"Backup").prop('checked', false);
            AJS.$("#"+val+"Main").prop('checked', false);

        }

        if(enabled === true)
        {
            AJS.$("#"+val+"Main").prop('checked', true);
            main=true;
        }
    }else{
        if(document.getElementById(val).checked) {
            AJS.$("#"+val+"Backup").prop('disabled', false);
        } else {
            AJS.$("#"+val+"Backup").prop('disabled', true);
            AJS.$("#"+val+"Backup").prop('checked', false);
        }
        if(enabled === true)
        {
            AJS.$("#"+val+"Backup").prop('checked', true);
            main=false;
        }
    }
    var selectedMethod = val;

    if(val.includes("WebAuthn") || val.includes("YubikeyHardwareToken")){
        if(enabled)
        {
            if(val.includes("WebAuthn"))
            {
                AJS.$("#idYubikeyHardwareTokenAsU2F").prop('disabled', true);
            }else{
                AJS.$("#idWebAuthn").prop('disabled', true);
            }
        }else{
            if(val.includes("WebAuthn"))
            {
                AJS.$("#idYubikeyHardwareTokenAsU2F").prop('disabled', false);
            }else{
                AJS.$("#idWebAuthn").prop('disabled', false);
            }
        }
    }

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "SavedMethodSettings",
            "selectedMethod": selectedMethod,
            "enabled": enabled,
            "Main":main
        },
        type: "POST",
        success: function (response) {
            methodHead = document.getElementById(response.methodName+"Heading").innerHTML;
            console.log(methodHead);
            if(enabled)
            {
                require('aui/flag')({
                    title: 'Enabling 2FA Method',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Successfully Enabled : '+methodHead+' as a '+ response.type+ '</p>'
                });
            }else{
                if(response.disablingLast2FAMethod===true)
                {
                    require('aui/flag')({
                        title: 'Disabling 2FA Method',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Please select at least 1 2FA method for User.</p>'
                    });
                    setTimeout(function() {
                        location.reload();
                    }, 3000);
                }else{
                    require('aui/flag')({
                        title: 'Disabling 2FA Method',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Disabled : '+methodHead+ '</p>'
                    });
                }


            }
        },
        error: function (response) {
            methodHead = document.getElementById(response.methodName+"Heading").innerHTML;
            if(enabled)
            {
                require('aui/flag')({
                    title: 'Error while Enabling 2FA Method',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Error while enabling '+methodHead+ '</p>'
                });
            }
        },
        async: true
    });
}

function hoverOut(val){
    document.getElementById(val+"Icon").style.color = "";
    document.getElementById(val+"Icon").style.textShadow = "";

}
function hoverIn(val){
    document.getElementById(val+"Icon").style.color = "#0065ff";
    document.getElementById(val+"Icon").style.textShadow = "2px 2px 8px #348bff";

}

function saveRadioButton(val){
    var selectedMethod = val;
    var enabled = true;
    var Main = val.includes("Main");
    console.log("main :"+Main);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "SavedMethodSettings",
            "selectedMethod": selectedMethod,
            "enabled": enabled,
            "Main": Main,
            "FromRadio" : true
        },
        type: "POST",
        success: function (response) {
            methodHead = document.getElementById(response.methodName+"Heading").innerHTML;
            if(response.enablingBackupWithout2FA===true)
            {
                require('aui/flag')({
                    title: 'Enabling 2FA Method',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Error while enabling '+methodHead+' as a '+ response.type+ ' as no 2FA method is enabled. '+ '</p>'
                });
                setTimeout(function() {
                    location.reload();
                }, 3000);

            }else{
                if(enabled)
                {
                    require('aui/flag')({
                        title: 'Enabling 2FA Method',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Enabled : '+methodHead+' as a '+ response.type+ '</p>'
                    });
                }
            }

        },
        error: function (response) {
            methodHead = document.getElementById(response.methodName+"Heading").innerHTML;
            if(enabled)
            {
                require('aui/flag')({
                    title: 'Error while Enabling 2FA Method',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Error while enabling '+methodHead+ '</p>'
                });
            }
        },
        async: true
    });
}

function redirectTo(divId){
    if(divId.includes("excludeGroups"))
    {
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/userdetails.action"+"?userManagementSelectedAction=GroupAction"+"#"+divId);
    }else if(divId.includes("usermanagement")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/userdetails.action"+"?userManagementSelectedAction=UserAction");
    }else if(divId.includes("disable2faForSsoUsers")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/advancedsettings.action#"+divId);
    }else if(divId.includes("IpRestriction")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/adaptiveauthentication.action");
    }else if(divId.includes("configure2fabyuser")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/"+divId);
    }else if(divId.includes("oneTime2FAInCrowdAuthenticationSetup")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/advancedsettings.action#"+divId);
    }else if(divId.includes("securityQuestionTemplateDiv")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/lookandfeeltemplates.action#"+divId);
    }else if(divId.includes("mail") || divId.includes("viewMailServer")){
        window.open(AJS.contextPath() +divId);
    }
}
function openCloseElemenet(elementId) {
    document.getElementById(elementId).classList.toggle("arrow_rotate");
}
function displaySettings(divId) {
    console.log("divID :"+divId);
    AJS.dialog2("#"+divId).show();
}

function setMethodIcons() {
    var googleAuthenticatorIcon = document.getElementById("googleAuthenticatorIconId").value;
    document.getElementById("imgGoogleAuthenticator").src = googleAuthenticatorIcon;
    document.getElementById("imgGoogleAuthenticatorPopup").src = googleAuthenticatorIcon;

    var otpOverEmailIconIcon = document.getElementById("otpOverEmailIconId").value;
    document.getElementById("imgOtpOverEmail").src = otpOverEmailIconIcon;
    document.getElementById("imgOtpOverEmailPopup").src = otpOverEmailIconIcon;

    var otpOverSmsIcon = document.getElementById("otpOverSmsIconId").value;
    document.getElementById("imgOtpOverSms").src = otpOverSmsIcon;
    document.getElementById("imgOtpOverSmsPopup").src = otpOverSmsIcon;

    var securityQuestionIcon = document.getElementById("securityQuestionIconId").value;
    document.getElementById("imgSecurityQuestion").src = securityQuestionIcon;

    var backupCodeIcon = document.getElementById("backupCodeIconId").value;
    document.getElementById("imgBackupCode").src = backupCodeIcon;

    var hardwareTokenIcon = document.getElementById("hardwareTokenIconId").value;
    document.getElementById("imgHardwareToken").src = hardwareTokenIcon;

    var webAuthenticationIcon = document.getElementById("webAuthnIconId").value;
    document.getElementById("imgWebAuthn").src = webAuthenticationIcon;
    document.getElementById("imgWebAuthnPopup").src = webAuthenticationIcon;

    var pushNotificationIcon = document.getElementById("pushNotificationIconId").value;
    document.getElementById("imgPushNotification").src = pushNotificationIcon;
    document.getElementById("imgPushNotificationPopup").src = pushNotificationIcon;
}

AJS.$(function () {
    var showWelcomePrompt = '${showWelcomePromptString}';
    if (showWelcomePrompt == "true"){
        AJS.dialog2("#intro_for_new_users_dialog").show();
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/admin/moapi",
            timeout: 0,
            data: {
            "action":"disableWelcomePrompt"
         },
         type: "POST",
         async: true,
         success: function (response) {
            console.log("SUCCESS");
         },
         error: function (response) {
            console.log("ERROR");
         }

        });
    }
    AJS.$("#intro_for_new_users_dialog_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#intro_for_new_users_dialog").hide();
    });
});