(function ($) {
    var url = window.location.href;
    if (url.split("?")[0].match(/\/twofactor/i)) {
        AJS.$('#main.aui-page-panel').addClass("pad1");
    }


    AJS.$(document).on('click','#enableRememberMeDevice',function() {
        if(this.checked) {
            AJS.$("#rememberMeDeviceDuration").prop('disabled', false);
        } else {
            AJS.$("#rememberMeDeviceDuration").prop('disabled', true);
        }
    });

    AJS.$(document).on('click','#autoDeleteAuditLogs',function() {
        if(this.checked) {
            AJS.$("#autoDeleteLogsAfterDays").prop('disabled', false);
            AJS.$("#nextdeletionscheduler").show("slow");
        }
        else {
            AJS.$("#autoDeleteLogsAfterDays").prop('disabled', true);
            AJS.$("#nextdeletionscheduler").hide("slow");
        }
    });

    AJS.$(document).on('click','#enableBruteForceProtection',function() {
        if(this.checked) {
            AJS.$("#bruteForceNumberOfAttempts").prop('disabled', false);

            AJS.$("#bruteForceTimeInterval").prop('disabled', false);
            AJS.$("#bruteForceCustomTimeInterval").prop('disabled', false);
            AJS.$("#bruteForceCustomTimeDuration").prop('disabled', false);
            AJS.$("#emailTemplateBruteForce").prop('disabled', false);
        } else {
            AJS.$("#bruteForceNumberOfAttempts").prop('disabled', true);

            AJS.$("#bruteForceTimeInterval").prop('disabled', true);
            AJS.$("#bruteForceCustomTimeInterval").prop('disabled', true);
            AJS.$("#bruteForceCustomTimeDuration").prop('disabled', true);
            AJS.$("#emailTemplateBruteForce").prop('disabled', true);
        }

        performBruteForceTimeInterval();
    });

    AJS.$(document).on('click','#enableEnforceCurrentMethod',function() {
        if(this.checked) {
            AJS.$("#primaryMethodForUserDiv").show("slow");
        } else {
            AJS.$("#primaryMethodForUserDiv").hide("slow");
        }
    });

    AJS.$(document).on('change','#bruteForceTimeInterval',function() {
        performBruteForceTimeInterval();
    });

    function performBruteForceTimeInterval() {
        if (AJS.$("#bruteForceTimeInterval").val() == "custom") {
            AJS.$("#bruteForceCustomTimeInterval").show();
            AJS.$("#bruteForceCustomTimeDuration").show();
            AJS.$("#bruteForceCustomTimeDuration").prop("required", true);
        } else {
            AJS.$("#bruteForceCustomTimeInterval").hide();
            AJS.$("#bruteForceCustomTimeDuration").hide();
            AJS.$("#bruteForceCustomTimeDuration").prop("required", false);
        }
    }

    AJS.$(document).on('click','#google-authenticator-configuration',function() {
        AJS.dialog2("#configure-google-authenticator-dialog").show();
    });

    AJS.$(document).on('click','#google-authenticator-form-close',function() {
        AJS.dialog2("#configure-google-authenticator-dialog").hide();
        window.location.href = window.location.pathname;
    });

    AJS.$(document).on('click','#google-authenticator-form-close_1',function() {
        AJS.dialog2("#configure-google-authenticator-dialog").hide();
        window.location.href = window.location.pathname;
    });
    AJS.$(document).on('click','#google-authenticator-form-close_2',function() {
        AJS.dialog2("#configure-google-authenticator-dialog").hide();
        window.location.href = window.location.pathname;
    });

    AJS.$(document).on('click','#google-authenticator-reset-button',function() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "method": "GoogleAuthenticator",
                "action": "Reset"
            },
            type: "POST",
            success: function (response) {
                if (response.status == 200) {
                    var currentLocation = window.location.pathname;
                    currentLocation = currentLocation + "?reset=success&method=GoogleAuthenticator";
                    window.location.href = currentLocation;
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    var currentLocation = window.location.pathname;
                    currentLocation = currentLocation + "?reset=success&method=GoogleAuthenticator";
                    window.location.href = currentLocation;
                }
            }
        });
    });


    AJS.$(document).on('submit', '#google-authenticator-configuration-form', function(e) {
        e.preventDefault();
        AJS.$("#idErrorMessage").remove();
        var otp = AJS.$("#qrCodeOtp").val();
        var ownSecretKey = AJS.$("#ownSecretKey").val();
        var otpForOwnSecretKey = AJS.$("#otpUsingOwnSecretKey").val();
        console.log("OTP : "+otp);
        console.log("ownSecretKey : "+ownSecretKey);
        console.log("otpForOwnSecretKey : "+otpForOwnSecretKey);
        if (ownSecretKey != "" && ownSecretKey != null) {
            if (otpForOwnSecretKey === "" || isValidNumber(otpForOwnSecretKey) == false) {
                var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid OTP code. (Make sure that your mobile time is synced to your network time.)</span></div>';
                AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                AJS.$("#ownSecretKey").val("");
                AJS.$("#otpUsingOwnSecretKey").val("");
            }
            else {
                AJS.$.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
                    data: {
                        "method": "GoogleAuthenticator",
                        "otp":"",
                        "ownSecretKey":ownSecretKey,
                        "otpForOwnSecretKey":otpForOwnSecretKey
                    },
                    type: "POST",
                    success: function (response) {
                        AJS.$("#idErrorMessage").remove();
                        if (response.status == 200) {
                            var html = '<div id="idSuccessMessage" class="aui-message aui-message-success success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Mobile Authenticator.</p></div>';
                            AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                            AJS.$("#google-authenticator-configuration-form").remove();
                            AJS.$("#google-authenticator-reset-div").remove();
                            AJS.$("#showAfterSuccessGoogleAuthenticator").show();
                            AJS.$('#google-authenticator-form-close_1').focus();
                        } else {
                            AJS.$("#successMessageGoogleAuthenticator").remove();
                            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid OTP code. (Make sure that your mobile time is synced to your network time.)</span></div>';
                            AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                            AJS.$("#ownSecretKey").val("");
                            AJS.$("#otpUsingOwnSecretKey").val("");
                        }
                    },
                    error: function (response) {
                        AJS.$("#idErrorMessage").remove();
                        if (response.status == 200) {
                            var html = '<div id="idSuccessMessage" class="aui-message aui-message-success success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Mobile Authenticator.</p></div>';
                            AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                            AJS.$("#google-authenticator-configuration-form").remove();
                            AJS.$("#google-authenticator-reset-div").remove();
                            AJS.$("#showAfterSuccessGoogleAuthenticator").show();
                            AJS.$('#google-authenticator-form-close_1').focus();
                        } else {
                            AJS.$("#successMessageGoogleAuthenticator").remove();
                            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid OTP code. (Make sure that your mobile time is synced to your network time.)</span></div>';
                            AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                            AJS.$("#ownSecretKey").val("");
                            AJS.$("#otpUsingOwnSecretKey").val("");
                        }
                    }
                });
            }
        }
        else if (otpForOwnSecretKey != "") {
            if (ownSecretKey === "" || ownSecretKey == null)  {
                var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter a valid Secret Key.</span></div>';
                AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                AJS.$("#ownSecretKey").val("");
                AJS.$("#otpUsingOwnSecretKey").val("");
            }
            else if (isValidNumber(otpForOwnSecretKey) == false) {
                var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid OTP code. (Make sure that your mobile time is synced to your network time.)</span></div>';
                AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                AJS.$("#ownSecretKey").val("");
                AJS.$("#otpUsingOwnSecretKey").val("");
            }
            else {
                AJS.$.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
                    data: {
                        "method": "GoogleAuthenticator",
                        "otp":"",
                        "ownSecretKey":ownSecretKey,
                        "otpForOwnSecretKey":otpForOwnSecretKey
                    },
                    type: "POST",
                    success: function (response) {
                        AJS.$("#idErrorMessage").remove();
                        if (response.status == 200) {
                            var html = '<div id="idSuccessMessage" class="aui-message aui-message-success success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Mobile Authenticator.</p></div>';
                            AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                            AJS.$("#google-authenticator-configuration-form").remove();
                            AJS.$("#google-authenticator-reset-div").remove();
                            AJS.$("#showAfterSuccessGoogleAuthenticator").show();
                            AJS.$('#google-authenticator-form-close_1').focus();
                        } else {
                            AJS.$("#successMessageGoogleAuthenticator").remove();
                            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid OTP code. (Make sure that your mobile time is synced to your network time.)</span></div>';
                            AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                            AJS.$("#ownSecretKey").val("");
                            AJS.$("#otpUsingOwnSecretKey").val("");
                        }
                    },
                    error: function (response) {
                        AJS.$("#idErrorMessage").remove();
                        if (response.status == 200) {
                            var html = '<div id="idSuccessMessage" class="aui-message aui-message-success success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Mobile Authenticator.</p></div>';
                            AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                            AJS.$("#google-authenticator-configuration-form").remove();
                            AJS.$("#google-authenticator-reset-div").remove();
                            AJS.$("#showAfterSuccessGoogleAuthenticator").show();
                            AJS.$('#google-authenticator-form-close_1').focus();
                        } else {
                            AJS.$("#successMessageGoogleAuthenticator").remove();
                            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid OTP code. (Make sure that your mobile time is synced to your network time.)</span></div>';
                            AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                            AJS.$("#ownSecretKey").val("");
                            AJS.$("#otpUsingOwnSecretKey").val("");
                        }
                    }
                });
            }
        }
        else if (otp === "" || isValidNumber(otp) == false) {
            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid OTP code. (Make sure that your mobile time is synced to your network time.)</span></div>';
            AJS.$(html).insertBefore("#google-authenticator-configuration-form");
        } else {
            AJS.$.ajax({
                url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
                data: {
                    "method": "GoogleAuthenticator",
                    "otp":otp,
                    "ownSecretKey":"",
                    "otpForOwnSecretKey":""
                },
                type: "POST",
                success: function (response) {
                        AJS.$("#idErrorMessage").remove();
                    if (response.status == 200) {
                        var html = '<div id="idSuccessMessage" class="aui-message aui-message-success success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Mobile Authenticator.</p></div>';
                        AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                        AJS.$("#google-authenticator-configuration-form").remove();
                        AJS.$("#google-authenticator-reset-div").remove();
                        AJS.$("#showAfterSuccessGoogleAuthenticator").show();
                        AJS.$('#google-authenticator-form-close_1').focus();
                    } else {
                        AJS.$("#qrCodeOtp").val("");
                        AJS.$("#successMessageGoogleAuthenticator").remove();
                        var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid OTP code. (Make sure that your mobile time is synced to your network time.)</span></div>';
                        AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                    }
                },
                error: function (response) {
                        AJS.$("#idErrorMessage").remove();
                    if (response.status == 200) {
                        var html = '<div id="idSuccessMessage" class="aui-message aui-message-success success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Mobile Authenticator.</p></div>';
                        AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                        AJS.$("#google-authenticator-configuration-form").remove();
                        AJS.$("#google-authenticator-reset-div").remove();
                        AJS.$("#showAfterSuccessGoogleAuthenticator").show();
                        AJS.$('#google-authenticator-form-close_1').focus();
                    } else {
                        AJS.$("#qrCodeOtp").val("");
                        AJS.$("#successMessageGoogleAuthenticator").remove();
                        var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid OTP code. (Make sure that your mobile time is synced to your network time.)</span></div>';
                        AJS.$(html).insertBefore("#google-authenticator-configuration-form");
                    }
                }
            });
        }
    });
    AJS.$(document).on('click','#security-question-configuration',function() {
        AJS.dialog2("#configure-security-question-dialog").show();
    });
    AJS.$(document).on('click','#security-question-form-close',function() {
        AJS.dialog2("#configure-security-question-dialog").hide();
        window.location.href = window.location.pathname;
    });
    AJS.$(document).on('click','#security-question-form-close_1',function() {
        AJS.dialog2("#configure-security-question-dialog").hide();
        window.location.href = window.location.pathname;
    });
    AJS.$(document).on('click','#security-question-reset-button',function() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "method": "SecurityQuestion",
                "action": "Reset"
            },
            type: "POST",
            success: function (response) {
                if (response.status == 200) {
                    var currentLocation = window.location.pathname;
                    currentLocation = currentLocation + "?reset=success&method=SecurityQuestion";
                    window.location.href = currentLocation;
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    var currentLocation = window.location.pathname;
                    currentLocation = currentLocation + "?reset=success&method=SecurityQuestion";
                    window.location.href = currentLocation;
                }
            }
        });
    });
    AJS.$(document).on('submit', '#security-question-configuration-form', function(e) {
        e.preventDefault();

        AJS.$("#idErrorMessage").remove();

//        var data = $("#security-question-configuration-form").serialize();
//        console.log("Data : "+data);
        var question_0 = AJS.$("#question_0").val();
        var answer_0 = AJS.$("#answer_0").val();
        var question_1 = AJS.$("#question_1").val();
        var answer_1 = AJS.$("#answer_1").val();
        var custom_question = AJS.$("#custom_question").val();
        var custom_answer = AJS.$("#custom_answer").val();

        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
            data: {
                "method": "SecurityQuestion",
                "question_0": question_0,
                "answer_0": answer_0,
                "question_1": question_1,
                "answer_1": answer_1,
                "custom_question": custom_question,
                "custom_answer": custom_answer
            },
            type: "POST",
            success: function (response) {
                AJS.$("#idErrorMessage").remove();
                if (response.status == 200) {
                    var html = '<div id="idSuccessMessage" class="aui-message aui-message-success success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Security Question.</p></div>';
                    AJS.$(html).insertBefore("#security-question-configuration-form");
                    AJS.$("#security-question-configuration-form").remove();
                    AJS.$("#showAfterSuccessSecurityQuestion").show();
                    AJS.$('#security-question-form-close_1').focus();
                } else {
                    AJS.$("#question_0").val("");
                    AJS.$("#answer_0").val("");
                    AJS.$("#question_1").val("");
                    AJS.$("#answer_1").val("");
                    AJS.$("#custom_question").val("");
                    AJS.$("#custom_answer").val("");
                    var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid question answers.</span></div>';
                    AJS.$(html).insertBefore("#security-question-configuration-form");
                }
            },
            error: function (response) {
                AJS.$("#idErrorMessage").remove();
                if (response.status == 200) {
                    var html = '<div id="idSuccessMessage" class="aui-message aui-message-success success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Security Question.</p></div>';
                    AJS.$(html).insertBefore("#security-question-configuration-form");
                    AJS.$("#security-question-configuration-form").remove();
                    AJS.$("#showAfterSuccessSecurityQuestion").show();
                    AJS.$('#security-question-form-close_1').focus();
                } else {
                    AJS.$("#question_0").val("");
                    AJS.$("#answer_0").val("");
                    AJS.$("#question_1").val("");
                    AJS.$("#answer_1").val("");
                    AJS.$("#custom_question").val("");
                    AJS.$("#custom_answer").val("");
                    var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><span>Please enter valid question answers.</span></div>';
                    AJS.$(html).insertBefore("#security-question-configuration-form");
                }
            }
        });
    });

    AJS.$(document).on('click','#backup-code-show-button',function() {
        AJS.dialog2("#configure-backup-code-dialog").show();
        AJS.$("#successMessageBackupCodeChange").hide();
        AJS.$("#successMessageBackupCodeDisable").hide();
        AJS.$("#successMessageBackupCodeEnabled").hide();
    });

    AJS.$(document).on('click','#backup-code-form-close_1',function() {
        AJS.dialog2("#configure-backup-code-dialog").hide();
    });

    AJS.$(document).on('click','#backup-code-enable',function() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "action": "EnableBackupCode"
            },
            type: "POST",
            success: function (response) {
                if (response.status == 200) {
                    AJS.$("#successMessageBackupCodeChange").hide();
                    AJS.$("#successMessageBackupCodeDisable").hide();
                    AJS.$("#warningBackupCodeUsed").hide();
                    AJS.$("#successMessageBackupCodeEnabled").show();
                    AJS.$("#backup-code-enable-info-div").hide();

                    AJS.$("#backup-code-enabled-div").show();
                    AJS.$("#backup-code-enabled-info-div").show();
                    AJS.$("#backup-code-enable-div").hide();
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    AJS.$("#successMessageBackupCodeChange").hide();
                    AJS.$("#successMessageBackupCodeDisable").hide();
                    AJS.$("#warningBackupCodeUsed").hide();
                    AJS.$("#successMessageBackupCodeEnabled").show();
                    AJS.$("#backup-code-enable-info-div").hide();

                    AJS.$("#backup-code-enabled-div").show();
                    AJS.$("#backup-code-enabled-info-div").show();
                    AJS.$("#backup-code-enable-div").hide();
                }
            }
        });
    });

    AJS.$(document).on('click','#backup-code-disable',function() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "action": "DisableBackupCode"
            },
            type: "POST",
            success: function (response) {
                if (response.status == 200) {
                    AJS.$("#successMessageBackupCodeChange").hide();
                    AJS.$("#successMessageBackupCodeEnabled").hide();
                    AJS.$("#warningBackupCodeUsed").hide();
                    AJS.$("#successMessageBackupCodeDisable").show();
                    AJS.$("#backup-code-enabled-info-div").hide();

                    AJS.$("#backup-code-enable-div").show();
                    AJS.$("#backup-code-enable-info-div").show();
                    AJS.$("#backup-code-enabled-div").hide();
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    AJS.$("#successMessageBackupCodeChange").hide();
                    AJS.$("#successMessageBackupCodeEnabled").hide();
                    AJS.$("#warningBackupCodeUsed").hide();
                    AJS.$("#successMessageBackupCodeDisable").show();
                    AJS.$("#backup-code-enabled-info-div").hide();

                    AJS.$("#backup-code-enable-div").show();
                    AJS.$("#backup-code-enable-info-div").show();
                    AJS.$("#backup-code-enabled-div").hide();
                }
            }
        });
    });

    AJS.$(document).on('click','#backup-code-change',function() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "action": "ChangeBackupCode"
            },
            type: "POST",
            success: function (response) {
                if (response.status == 200) {
                    AJS.$("#successMessageBackupCodeEnabled").hide();
                    AJS.$("#successMessageBackupCodeDisable").hide();
                    AJS.$("#warningBackupCodeUsed").hide();
                    AJS.$("#successMessageBackupCodeChange").show();

                    AJS.$("#backup-code-enable-div").hide();
                    AJS.$("#backup-code-enable-info-div").hide();

                    AJS.$("#backup-code-enabled-info-div").show();
                    AJS.$("#backup-code-enabled-div").show();
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    AJS.$("#successMessageBackupCodeEnabled").hide();
                    AJS.$("#successMessageBackupCodeDisable").hide();
                    AJS.$("#warningBackupCodeUsed").hide();
                    AJS.$("#successMessageBackupCodeChange").show();

                    AJS.$("#backup-code-enable-div").hide();
                    AJS.$("#backup-code-enable-info-div").hide();

                    AJS.$("#backup-code-enabled-info-div").show();
                    AJS.$("#backup-code-enabled-div").show();
                }
            }
        });
    });

    AJS.$(document).on('click','#otp-over-sms-configuration',function() {
        console.log("otp-over-sms-configuration button clicked");
        AJS.dialog2("#configure-otp-over-sms-dialog").show();
    });

    AJS.$(document).on('click','#otp-over-sms-form-close',function() {
        AJS.dialog2("#configure-otp-over-sms-dialog").hide();
        window.location.href = window.location.pathname;
    });

    AJS.$(document).on('click','#otp-over-sms-form-close_1',function() {
        AJS.dialog2("#configure-otp-over-sms-dialog").hide();
        window.location.href = window.location.pathname;
    });

    AJS.$(document).on('click','#sendOtpOverSmsButton',function() {
        sendOtpOverSms(false);
    });

    AJS.$(document).on('click','#otp-over-sms-reset-button',function() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "method": "OtpOverSms",
                "action": "Reset"
            },
            type: "POST",
            success: function (response) {
                if (response.status == 200) {
                    var currentLocation = window.location.pathname;
                    currentLocation = currentLocation + "?reset=success&method=OtpOverSms";
                    window.location.href = currentLocation;
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    var currentLocation = window.location.pathname;
                    currentLocation = currentLocation + "?reset=success&method=OtpOverSms";
                    window.location.href = currentLocation;
                }
            }
        });
    });

    AJS.$(document).on('click','#idResendOtpOnSmsDiv',function() {
        sendOtpOverSms(true);
    });

    AJS.$(document).on('click','#otp-over-sms-form-submit',function() {
//        e.preventDefault();
        var otp = AJS.$("#otpCode_sms").val();
        var countryCode = AJS.$("#countryCode").val();
        var mobileNumber = AJS.$("#mobileNumber").val();
        AJS.$("#idInfoMessage").remove();
        AJS.$("#idWarningMessage").remove();
        AJS.$("#idErrorMessage").remove();
        AJS.$("#idSuccessMessage").remove();
        console.log("OTP : "+otp);
        if (otp === "" || isValidNumber(otp) == false) {
            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p class="title"><strong>Error!</strong></p><p>Please enter valid OTP.</p></div>';
            AJS.$(html).insertBefore("#otp-over-sms-configuration-form");
        } else {
            AJS.$.ajax({
                url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
                data: {
                    "method": "OtpOverSms",
                    "otp": otp,
                    "countryCode": countryCode,
                    "mobileNumber": mobileNumber
                },
                type: "GET",
                success: function (response) {
                    if (response.status == 200) {
                        var html = '<div id="idSuccessMessage" class="aui-message aui-message-success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured OTP Over SMS.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-sms-configuration-form");

                        AJS.$("#showAfterSuccessOtpOverSms").show();
                        AJS.$("#otp-over-sms-configuration-form").hide();

                        AJS.$('#otp-over-sms-form-close_1').focus();
                    } else {
                        var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p class="title"><strong>Error!</strong></p><p>Invalid OTP Entered. Please enter the valid OTP.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-sms-configuration-form");
                    }
                },
                error: function (response) {
                    if (response.status == 200) {
                        var html = '<div id="idSuccessMessage" class="aui-message aui-message-success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured OTP Over SMS.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-sms-configuration-form");

                        AJS.$("#showAfterSuccessOtpOverSms").show();
                        AJS.$("#otp-over-sms-configuration-form").hide();

                        AJS.$('#otp-over-sms-form-close_1').focus();
                    } else {
                        var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p class="title"><strong>Error!</strong></p><p>Invalid OTP Entered. Please enter the valid OTP.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-sms-configuration-form");
                    }
                }
            });
        }
    });

    function sendOtpOverSms(isResend){
//        e.preventDefault();

        var countryCode = AJS.$("#countryCode").val();
        var mobileNumber = AJS.$("#mobileNumber").val();
        var countryCodeForValidation = countryCode.replace("+",'');
        var curCsrfToken = AJS.$("#minio_token").val();
        countryCodeForValidation = countryCodeForValidation.replace("-",'');

        if(countryCode == ""){
            AJS.$("#idErrorMessage").remove();
            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p>Country code cannot be blank.</p></div>';
            AJS.$(html).insertBefore("#otp-over-sms-mobile-number-div");
        } else if(mobileNumber == ""){
            AJS.$("#idErrorMessage").remove();
            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p>Mobile number cannot be blank.</p></div>';
            AJS.$(html).insertBefore("#otp-over-sms-mobile-number-div");
        } else if(isNaN(countryCodeForValidation) || countryCodeForValidation == "") {
            AJS.$("#idErrorMessage").remove();
            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p>Enter a valid Country code.</p></div>';
            AJS.$(html).insertBefore("#otp-over-sms-mobile-number-div");
        } else if(isNaN(mobileNumber)) {
            AJS.$("#idErrorMessage").remove();
            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p>Enter a valid Mobile number.</p></div>';
            AJS.$(html).insertBefore("#otp-over-sms-mobile-number-div");
        }  else{
            if(isResend == false){
                AJS.$("#idInfoMessage").remove();
            } else{
                AJS.$("#idInfoMessage").hide();
            }
            AJS.$("#idWarningMessage").remove();
            AJS.$("#idErrorMessage").remove();
            AJS.$("#idSuccessMessage").remove();

            AJS.$("#showAfterSuccessOtpOverSms").hide();
            AJS.$("#otp-over-sms-enter-otp-div").hide();

            var html = '<div id="idLoadingDiv"><div class="aui-message aui-message-info"><p>Please wait we are sending OTP to your mobile.</p></div>';
            html += '<div style="margin-left: 140px;"><p><aui-spinner size="large"></aui-spinner></p></div></div>';
            AJS.$(html).insertBefore("#otp-over-sms-mobile-number-div");

            AJS.$.ajax({
                url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
                type: "POST",
                data: {
                    "action": "SendOtpOverSms",
                    "countryCode": countryCode,
                    "mobileNumber": mobileNumber,
                    "csrf_token" : curCsrfToken
                },
                success: function (response) {
                    handleSendOtpOverSmsResponse(response, isResend);
                },
                error: function (response) {
                    handleSendOtpOverSmsResponse(response, isResend);
                }
            });
        }
    }

    function handleSendOtpOverSmsResponse(response, isResend){
        AJS.$("#idLoadingDiv").remove();
        AJS.$("#otp-over-sms-enter-otp-div").show();
        AJS.$("#otpCode_sms").required = "true";
        document.getElementById("sendOtpOverSmsButton").disabled = true;
        if (response.status == 200) {
            if (isResend == true) {
                AJS.$("#idInfoMessage").show();
            } else {
//                var html = '<div id="idInfoMessage" class="aui-message aui-message-info"><p>We have sent the OTP on your mobile number. Please validate it to configure OTP Over SMS as a 2FA method.</p><p>If you haven\'t receive OTP yet, please click on Resend OTP link.</p></div>';
                var html = '<div id="idInfoMessage" class="aui-message aui-message-info"><p>We have sent the OTP on your mobile number. Please validate it to configure OTP Over SMS as a 2FA method.</p></div>';
                AJS.$(html).insertBefore("#otp-over-sms-mobile-number-div");
            }
        } else {
            if (isResend == true) {
                AJS.$("#idInfoMessage").remove();
            }
            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p>Issue with sending OTP to your mobile number</p></div>';
            AJS.$(html).insertBefore("#otp-over-sms-mobile-number-div");
        }
    }

    AJS.$(document).on('click','#web-authn-configuration',function() {
        AJS.dialog2("#webauthn-config-dialog").show();
        document.getElementById("differentiate-web-authn-methods-info").style.display="block";
    });

    AJS.$(document).on('click','#webauthn-config-close',function() {
        AJS.dialog2("#webauthn-config-dialog").hide();
        window.location.href = window.location.pathname;
    });

    AJS.$(document).on('click','#web-authn-edit-button',function() {
        AJS.dialog2("#webauthn-config-dialog").show();
        document.getElementById("differentiate-web-authn-methods-info").style.display="none";
        document.getElementById("user_config").style.display="block";
    });

    AJS.$(document).on('click','#clear_previous_credential',function() {
        document.getElementById("user_config").style.display="none";
        document.getElementById("clear_register_warning").style.display="block";
    });

    AJS.$(document).on('click','#back_to_credential_clear',function() {
        document.getElementById("user_config").style.display="block";
        document.getElementById("clear_register_warning").style.display="none";
     });

    AJS.$(document).on('keypress','#otp-over-sms-configuration-form',function() {
        var keyPressed = event.keyCode || event.which;
        if (keyPressed === 13) {
            console.log("enter clicked");
            event.preventDefault();
            return false;
        }
    });

    AJS.$(document).on('keypress','#mo-2fa-inline-registration-form',function() {
        var keyPressed = event.keyCode || event.which;
        if (keyPressed === 13) {
            console.log("enter clicked");
            event.preventDefault();
            return false;
        }
    });

    AJS.$(document).on('click','#otp-over-email-configuration',function() {
        AJS.dialog2("#configure-otp-over-email-dialog").show();
        var html = '<div id="idInfoMessage" class="aui-message aui-message-info"><p>Click on <b>Enable OTP Over Email</b> button to configure it as a 2FA method.</p></div>';
        AJS.$(html).insertBefore("#otp-over-email-configuration-form");
    });

    AJS.$(document).on('click','#otp-over-email-form-close',function() {
        AJS.dialog2("#configure-otp-over-email-dialog").hide();
        window.location.href = window.location.pathname;
    });

    AJS.$(document).on('click','#otp-over-email-form-close_1',function() {
        AJS.dialog2("#configure-otp-over-email-dialog").hide();
        window.location.href = window.location.pathname;
    });

    AJS.$(document).on('click','#otp-over-email-enable',function() {
        sendOtpOverEmail(false);
    });

    AJS.$(document).on('click','#otp-over-email-reset-button',function() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "method": "OtpOverEmail",
                "action": "Reset"
            },
            type: "POST",
            success: function (response) {
                if (response.status == 200) {
                    var currentLocation = window.location.pathname;
                    currentLocation = currentLocation + "?reset=success&method=OtpOverEmail";
                    window.location.href = currentLocation;
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    var currentLocation = window.location.pathname;
                    currentLocation = currentLocation + "?reset=success&method=OtpOverEmail";
                    window.location.href = currentLocation;
                }
            }
        });
    });

    AJS.$(document).on('click','#idResendOtpDiv',function() {
        sendOtpOverEmail(true);
    });

    AJS.$(document).on('submit', '#otp-over-email-configuration-form', function(e) {
        e.preventDefault();
        var otp = AJS.$("#otpCode").val();
        AJS.$("#idInfoMessage").remove();
        AJS.$("#idWarningMessage").remove();
        AJS.$("#idErrorMessage").remove();
        AJS.$("#idSuccessMessage").remove();
        console.log("OTP : "+otp);
        if (otp === "" || isValidNumber(otp) == false) {
            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p class="title"><strong>Error!</strong></p><p>Please enter valid OTP.</p></div>';
            AJS.$(html).insertBefore("#otp-over-email-configuration-form");
        } else {
            AJS.$.ajax({
                url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
                data: {
                    "method": "OtpOverEmail",
                    "otp":otp
                },
                type: "POST",
                success: function (response) {
                    if (response.status == 200) {
                        var html = '<div id="idSuccessMessage" class="aui-message aui-message-success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured OTP Over Email.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-email-configuration-form");

                        AJS.$("#showAfterSuccessOtpOverEmail").show();
                        AJS.$("#otp-over-email-configuration-form").hide();

                        AJS.$('#otp-over-email-form-close_1').focus();
                    } else {
                        AJS.$("#otpCode").val("");
                        var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p class="title"><strong>Error!</strong></p><p>Invalid OTP Entered. Please enter the valid OTP.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-email-configuration-form");
                    }
                },
                error: function (response) {
                    if (response.status == 200) {
                        var html = '<div id="idSuccessMessage" class="aui-message aui-message-success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured OTP Over Email.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-email-configuration-form");

                        AJS.$("#showAfterSuccessOtpOverEmail").show();
                        AJS.$("#otp-over-email-configuration-form").hide();

                        AJS.$('#otp-over-email-form-close_1').focus();
                    } else {
                        AJS.$("#otpCode").val("");
                        var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p class="title"><strong>Error!</strong></p><p>Invalid OTP Entered. Please enter the valid OTP.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-email-configuration-form");
                    }
                }
            });
        }
    });

    function sendOtpOverEmail(isResend) {
        AJS.$("#idInfoMessage").remove();
        AJS.$("#idWarningMessage").remove();
        AJS.$("#idErrorMessage").remove();
        AJS.$("#idSuccessMessage").remove();

        AJS.$("#otp-over-email-enable-button-div").hide();
        AJS.$("#showAfterSuccessOtpOverEmail").hide();
        AJS.$("#infoMessageEnableOtpOverEmail").hide();
        AJS.$("#otp-over-email-configuration-div").hide();

        var html = '<div id="idLoadingDiv"><div class="aui-message aui-message-info"><p>Please wait we are sending OTP to your email.</p></div>';
        html += '<div style="margin-left: 140px;"><p><aui-spinner size="large"></aui-spinner></p></div></div>';
        AJS.$(html).insertBefore("#otp-over-email-configuration-form");

        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "action": "SendOtpOverEmail"
            },
            type: "GET",
            success: function (response) {
                AJS.$("#idLoadingDiv").remove();
                AJS.$("#otp-over-email-configuration-div").show();
                if (response.status == 200) {
                    if (isResend == true) {
                        AJS.$("#idInfoMessage").remove();
                        var html = '<div id="idInfoMessage" class="aui-message aui-message-info"><p>We have resend the OTP on your email address. Please validate it to configure OTP Over Email as a 2FA method.</p><p>If you haven\'t receive OTP yet, please click on Resend OTP link.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-email-configuration-form");
                    } else {
                        var html = '<div id="idInfoMessage" class="aui-message aui-message-info"><p>We have send the OTP on your email address. Please validate it to configure OTP Over Email as a 2FA method.</p><p>If you haven\'t receive OTP yet, please click on Resend OTP link.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-email-configuration-form");
                    }
                } else {
                    var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p>Issue with sending OTP to your email</p></div>';
                    AJS.$(html).insertBefore("#otp-over-email-configuration-form");
                }
            },
            error: function (response) {
                AJS.$("#idLoadingDiv").remove();
                AJS.$("#otp-over-email-configuration-div").show();
                if (response.status == 200) {
                    if (isResend == true) {
                        AJS.$("#idInfoMessage").remove();
                        var html = '<div id="idInfoMessage" class="aui-message aui-message-info"><p>We have resend the OTP on your email address. Please validate it to configure OTP Over Email as a 2FA method.</p><p>If you haven\'t receive OTP yet, please click on Resend OTP link.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-email-configuration-form");
                    } else {
                        var html = '<div id="idInfoMessage" class="aui-message aui-message-info"><p>We have send the OTP on your email address. Please validate it to configure OTP Over Email as a 2FA method.</p><p>If you haven\'t receive OTP yet, please click on Resend OTP link.</p></div>';
                        AJS.$(html).insertBefore("#otp-over-email-configuration-form");
                    }
                } else {
                    var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p>Issue with sending OTP to your email</p></div>';
                    AJS.$(html).insertBefore("#otp-over-email-configuration-form");
                }
            }
        });
    }

    AJS.$(document).on('click','#u2f-hardware-token-configuration',function() {
        AJS.dialog2("#configure-u2f-hardware-token-dialog").show();
    });

    AJS.$(document).on('click','#u2f-hardware-token-form-close',function() {
        AJS.dialog2("#configure-u2f-hardware-token-dialog").hide();
        window.location.href = window.location.pathname;
    });

    AJS.$(document).on('click','#u2f-hardware-token-form-close_1',function() {
        AJS.dialog2("#configure-u2f-hardware-token-dialog").hide();
        window.location.href = window.location.pathname;
    });

    AJS.$(document).on('click','#u2f-hardware-token-reset-button',function() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "method": "YubikeyHardwareTokenAsU2F",
                "action": "Reset"
            },
            type: "POST",
            success: function (response) {
                if (response.status == 200) {
                    var currentLocation = window.location.pathname;
                    currentLocation = currentLocation + "?reset=success&method=YubikeyHardwareTokenAsU2F";
                    window.location.href = currentLocation;
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    var currentLocation = window.location.pathname;
                    currentLocation = currentLocation + "?reset=success&method=YubikeyHardwareTokenAsU2F";
                    window.location.href = currentLocation;
                }
            }
        });
    });

    AJS.$(document).on('click','#u2f-hardware-token-form-submit11',function() {
        AJS.$("#idInfoMessage").remove();
        AJS.$("#idWarningMessage").remove();
        AJS.$("#idErrorMessage").remove();
        AJS.$("#idSuccessMessage").remove();
        AJS.$("#hardware-token-main-div").hide();
        AJS.$("#u2f-hardware-token-form-submit").hide();
        AJS.$("#u2f-hardware-token-form-close").hide();
        AJS.$("#hardware-token-touch-key-div").show();
        AJS.$("#showAfterSuccessHardwareToken").show();

        require('aui/flag')({
            title: 'Configure Yubikey U2F',
            type: 'info',
            close: 'manual',
            body: '<p>Insert Your Security Key & Touch it.</p>'
        });

        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/mou2fhardwaretokenresource/1.0/mou2fresource/init_register",
            timeout: 0,
            type: "POST",
            dataType: "JSON",
            contentType: "application/json; charset=utf-8",
            cache: false,
            success: function (response) {
                registerYubikeyU2FHardwareToken(response);
            },
            error: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                AJS.$("#hardware-token-main-div").show();
                AJS.$("#u2f-hardware-token-form-submit").show();
                AJS.$("#u2f-hardware-token-form-close").show();
                AJS.$("#hardware-token-touch-key-div").hide();
                AJS.$("#showAfterSuccessHardwareToken").hide();

                require('aui/flag')({
                    title: 'Hardware Token U2F',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Issue with Configuring Hardware Token. Please check the logs.</p>'
                });

                var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p class="title"><strong>Error!</strong></p><p>Yubikey Hardware Token(U2F) registration fail.</p></div>';
                AJS.$(html).insertBefore("#u2f-hardware-token-configuration-form");
            }
        });
    });

    function registerYubikeyU2FHardwareToken(requestData) {
        console.log("Calling registerYubikeyU2FHardwareToken");
        u2f.register(
            requestData.appId,
            requestData.registerRequests,
            requestData.registeredKeys,
            function (data) {
                console.log(data);
                if (data.errorCode) {
                    console.log("Error Code : "+data.errorCode)
                    var a = document.getElementsByClassName("aui-flag");
                    for (var i=a.length-1;i>=0;i--) {
                        a[i].remove();
                    }

                    AJS.$("#hardware-token-main-div").show();
                    AJS.$("#u2f-hardware-token-form-submit").show();
                    AJS.$("#u2f-hardware-token-form-close").show();
                    AJS.$("#hardware-token-touch-key-div").hide();
                    AJS.$("#showAfterSuccessHardwareToken").hide();

                    switch (data.errorCode) {
                        case 4:
                            require('aui/flag')({
                                title: 'Hardware Token U2F',
                                type: 'error',
                                close: 'auto',
                                body: '<p>U2F device registration failed (error code 4)</p>'
                            });
                            break;

                        default:
                            require('aui/flag')({
                                title: 'Hardware Token U2F',
                                type: 'error',
                                close: 'auto',
                                body: '<p>U2F device registration failed (error code '+data.errorCode+')</p>'
                            });
                            break;
                    }

                    return;
                }

                yubikeyU2FRegisterActionSubmit(data);
            }
        );
    }

    function yubikeyU2FRegisterActionSubmit(data) {
        console.log("Calling yubikeyU2FRegisterActionSubmit");
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/mou2fhardwaretokenresource/1.0/mou2fresource/register_device",
            data: JSON.stringify({
                tokenResponse: JSON.stringify(data)
            }),
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            type: "POST",
            cache: false,
            success: function (data) {
                AJS.$.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
                    data: {
                        "method": "YubikeyHardwareTokenAsU2F"
                    },
                    type: "POST",
                    success: function (response) {
                        if (response.status == 200) {
                            console.log("Successfully Configured Yubikey hardware Token (U2F).");
                        } else {
                            console.log("Issue with configuring Yubikey hardware Token (U2F).");
                        }
                    },
                    error: function (response) {
                        if (response.status == 200) {
                            console.log("Successfully Configured Yubikey hardware Token (U2F).");
                        } else {
                            console.log("Issue with configuring Yubikey hardware Token (U2F).");
                        }
                    }
                });
                var html = '<div id="idSuccessMessage" class="aui-message aui-message-success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Hardware Token.</p></div>';
                AJS.$(html).insertBefore("#u2f-hardware-token-configuration-form");

                AJS.$("#showAfterSuccessHardwareToken").show();
                AJS.$("#u2f-hardware-token-configuration-form").hide();

                AJS.$('#u2f-hardware-token-form-close_1').focus();
            },
            error: function (code) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                AJS.$("#hardware-token-main-div").show();
                AJS.$("#u2f-hardware-token-form-submit").show();
                AJS.$("#u2f-hardware-token-form-close").show();
                AJS.$("#hardware-token-touch-key-div").hide();
                AJS.$("#showAfterSuccessHardwareToken").hide();

                require('aui/flag')({
                    title: 'Hardware Token U2F',
                    type: 'error',
                    close: 'auto',
                    body: '<p>U2F device registration failed ' +code+ '</p>'
                });

                var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p class="title"><strong>Error!</strong></p><p>Yubikey Hardware Token(U2F) registration fail.</p></div>';
                AJS.$(html).insertBefore("#u2f-hardware-token-configuration-form");
            }
        });
    }

    AJS.$(document).on('click','#setGoogleAuthenticatorAsDefault2fa',function() {
        require('aui/flag')({
            title: 'Mobile Authenticator',
            type: 'info',
            close: 'never',
            body: '<p>We are setting Mobile Authenticator as default 2FA.</p><p><aui-spinner size="large"></aui-spinner></p>'
        });
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "action": "SetAsDefault2fa",
                "method": "GoogleAuthenticator"
            },
            type: "POST",
            success: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Mobile Authenticator',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully set Mobile Authenticator as default 2fa.</p>'
                    });
                } else {
                    require('aui/flag')({
                        title: 'Mobile Authenticator',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with setting Mobile Authenticator as default 2fa.</p>'
                    });
                }

                setTimeout(function() {
                    window.location.href = window.location.pathname;
                }, 2000);
            },
            error: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Mobile Authenticator',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully set Mobile Authenticator as default 2fa.</p>'
                    });
                } else {
                    require('aui/flag')({
                        title: 'Mobile Authenticator',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with setting Mobile Authenticator as default 2fa.</p>'
                    });
                }

                setTimeout(function() {
                    window.location.href = window.location.pathname;
                }, 2000);
            }
        });
    });

    AJS.$(document).on('click','#setOtpOverSmsAsDefault2fa',function() {
        require('aui/flag')({
            title: 'OTP over SMS',
            type: 'info',
            close: 'never',
            body: '<p>We are setting OTP Over SMS as default 2FA.</p><p><aui-spinner size="large"></aui-spinner></p>'
        });
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "action": "SetAsDefault2fa",
                "method": "OtpOverSms"
            },
            type: "POST",
            success: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'OTP Over SMS',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully set OTP Over SMS as default 2fa.</p>'
                    });
                } else {
                    require('aui/flag')({
                        title: 'OTP Over SMS',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with setting OTP Over SMS as default 2fa.</p>'
                    });
                }

                setTimeout(function() {
                    window.location.href = window.location.pathname;
                }, 2000);
            },
            error: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'OTP Over SMS',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully set OTP Over SMS as default 2fa.</p>'
                    });
                } else {
                    require('aui/flag')({
                        title: 'OTP Over SMS',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with setting OTP Over SMS as default 2fa.</p>'
                    });
                }

                setTimeout(function() {
                    window.location.href = window.location.pathname;
                }, 2000);
            }
        });
    });

    AJS.$(document).on('click','#setOtpOverEmailAsDefault2fa',function() {
        require('aui/flag')({
            title: 'OTP over Email',
            type: 'info',
            close: 'never',
            body: '<p>We are setting OTP Over Email as default 2FA.</p><p><aui-spinner size="large"></aui-spinner></p>'
        });
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "action": "SetAsDefault2fa",
                "method": "OtpOverEmail"
            },
            type: "POST",
            success: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'OTP Over Email',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully set OTP Over Email as default 2fa.</p>'
                    });
                } else {
                    require('aui/flag')({
                        title: 'OTP Over Email',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with setting OTP Over Email as default 2fa.</p>'
                    });
                }

                setTimeout(function() {
                    window.location.href = window.location.pathname;
                }, 2000);
            },
            error: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'OTP Over Email',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully set OTP Over Email as default 2fa.</p>'
                    });
                } else {
                    require('aui/flag')({
                        title: 'OTP Over Email',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with setting OTP Over Email as default 2fa.</p>'
                    });
                }

                setTimeout(function() {
                    window.location.href = window.location.pathname;
                }, 2000);
            }
        });
    });

    AJS.$(document).on('click','#setU2FHardwareTokenAsDefault2fa',function() {
        require('aui/flag')({
            title: 'Hardware Token',
            type: 'info',
            close: 'never',
            body: '<p>We are setting Hardware Token as default 2FA.</p><p><aui-spinner size="large"></aui-spinner></p>'
        });
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "action": "SetAsDefault2fa",
                "method": "YubikeyHardwareTokenAsU2F"
            },
            type: "POST",
            success: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Hardware Token',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully set Hardware Token as default 2fa.</p>'
                    });
                } else {
                    require('aui/flag')({
                        title: 'Hardware Token',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with setting Hardware Token as default 2fa.</p>'
                    });
                }

                setTimeout(function() {
                    window.location.href = window.location.pathname;
                }, 2000);
            },
            error: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Hardware Token',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully set Hardware Token as default 2fa.</p>'
                    });
                } else {
                    require('aui/flag')({
                        title: 'Hardware Token',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with setting Hardware Token as default 2fa.</p>'
                    });
                }

                setTimeout(function() {
                    window.location.href = window.location.pathname;
                }, 2000);
            }
        });
    });

    AJS.$(document).on('click','#setWebAuthnAsDefault2fa',function() {
            require('aui/flag')({
                title: 'Web Authentication as 2FA method',
                type: 'info',
                close: 'never',
                body: '<p>We are setting WebAuthn as default 2FA.</p><p><aui-spinner size="large"></aui-spinner></p>'
            });
            AJS.$.ajax({
                url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
                data: {
                    "action": "SetAsDefault2fa",
                    "method": "WebAuthn"
                },
                type: "POST",
                success: function (response) {
                    var a = document.getElementsByClassName("aui-flag");
                    for (var i=a.length-1;i>=0;i--) {
                        a[i].remove();
                    }

                    if (response.status == 200) {
                        require('aui/flag')({
                            title: 'Web Authentication',
                            type: 'success',
                            close: 'auto',
                            body: '<p>Successfully set WebAuthn as default 2fa.</p>'
                        });
                    } else {
                        require('aui/flag')({
                            title: 'Web Authentication',
                            type: 'error',
                            close: 'auto',
                            body: '<p>Issue with setting WebAuthn as default 2fa.</p>'
                        });
                    }

                    setTimeout(function() {
                        window.location.href = window.location.pathname;
                    }, 2000);
                },
                error: function (response) {
                    var a = document.getElementsByClassName("aui-flag");
                    for (var i=a.length-1;i>=0;i--) {
                        a[i].remove();
                    }

                    if (response.status == 200) {
                        require('aui/flag')({
                            title: 'Web Authentication',
                            type: 'success',
                            close: 'auto',
                            body: '<p>Successfully set WebAuthn as default 2fa.</p>'
                        });
                    } else {
                        require('aui/flag')({
                            title: 'Web Authentication',
                            type: 'error',
                            close: 'auto',
                            body: '<p>Issue with setting WebAuthn as default 2fa.</p>'
                        });
                    }

                    setTimeout(function() {
                        window.location.href = window.location.pathname;
                    }, 2000);
                }
            });
    });



    AJS.$(document).on('click','#setSecurityQuestionAsDefault2fa',function() {
        require('aui/flag')({
            title: 'Security Question',
            type: 'info',
            close: 'never',
            body: '<p>We are setting Security Question as default 2FA.</p><p><aui-spinner size="large"></aui-spinner></p>'
        });
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
            data: {
                "action": "SetAsDefault2fa",
                "method": "SecurityQuestion"
            },
            type: "POST",
            success: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Security Question',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully set Security Question as default 2fa.</p>'
                    });
                } else {
                    require('aui/flag')({
                        title: 'Security Question',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with setting Security Question as default 2fa.</p>'
                    });
                }

                setTimeout(function() {
                    window.location.href = window.location.pathname;
                }, 2000);
            },
            error: function (response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }

                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Security Question',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully set Security Question as default 2fa.</p>'
                    });
                } else {
                    require('aui/flag')({
                        title: 'Security Question',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with setting Security Question as default 2fa.</p>'
                    });
                }

                setTimeout(function() {
                    window.location.href = window.location.pathname;
                }, 2000);
            }
        });
    });

    function ReadCookie(cname) {
        //alert(cname);
        var name = cname + "=";
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                //alert(" found");
                return c.substring(name.length, c.length);
            }
        }
        return "";
    }

    function isValidNumber(number) {
        var digits = "0123456789";
        for (var i = 0; i < number.length; i++) {
          if (number.indexOf(number.charAt(i)) < 0) {
            return false;
          }
        }
        return true;
    }
})(AJS.$ || jQuery);

    function registerYubikeyToken(attestationType, authenticatorType, userVerification, residentKey) {

        AJS.$("#idInfoMessage").remove();
        AJS.$("#idWarningMessage").remove();
        AJS.$("#idErrorMessage").remove();
        AJS.$("#idSuccessMessage").remove();
        AJS.$("#hardware-token-main-div").hide();
        AJS.$("#u2f-hardware-token-form-submit").hide();
        AJS.$("#register_new_credential").hide();
        AJS.$("#u2f-hardware-token-form-close").hide();
        AJS.$("#hardware-token-touch-key-div").show();
        AJS.$("#showAfterSuccessHardwareToken").show();

        require('aui/flag')({
            title: 'Validate Yubikey WebAuthn',
            type: 'info',
            close: 'auto',
            body: '<p>Insert Your Security Key & Touch it.</p>'
        });

        setTimeout(function() {
            register1("","InlineConfig","yubikeyHardwareToken", attestationType, authenticatorType, userVerification, residentKey);
        }, 2000);
    }

       AJS.$(document).on('click','#duo-push-notification-enable',function() {
                getDuoPushNotificationQrCode();
            });

            function getDuoPushNotificationQrCode() {
                AJS.$("#idInfoMessage").remove();
                AJS.$("#idWarningMessage").remove();
                AJS.$("#idErrorMessage").remove();
                AJS.$("#idSuccessMessage").remove();

                AJS.$("#duo-push-notification-enable-button-div").hide();
                AJS.$("#showAfterSuccessDuoPushNotification").hide();
                AJS.$("#infoMessageEnableDuoPushNotification").hide();
                AJS.$("#duo-push-notification-configuration-div").hide();

                AJS.$("#duo-push-notification-configuration-div").show();
            }
            AJS.$(document).on('click','#duo-push-notification-reset-button',function() {
                AJS.$.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
                    data: {
                        "method": "DuoPushNotification",
                        "action": "Reset"
                    },
                    type: "POST",
                    success: function (response) {
                        if (response.status == 200) {
                            var currentLocation = window.location.pathname;
                            currentLocation = currentLocation + "?reset=success&method=DuoPushNotification";
                            window.location.href = currentLocation;
                        }
                    },
                    error: function (response) {
                        if (response.status == 200) {
                            var currentLocation = window.location.pathname;
                            currentLocation = currentLocation + "?reset=success&method=DuoPushNotification";
                            window.location.href = currentLocation;
                        }
                    }
                });
            });

            AJS.$(document).on('submit', '#duo-push-notification-configuration-form', function(e) {
                e.preventDefault();
                AJS.$("#idInfoMessage").remove();
                AJS.$("#idWarningMessage").remove();
                AJS.$("#idErrorMessage").remove();
                AJS.$("#idSuccessMessage").remove();
                AJS.$("#duo-push-notification-configuration-form").hide();
                var html = '<div id="idLoadingDiv"><div class="aui-message aui-message-info"><p>Please wait we are getting details from DUO.</p></div>';
                html += '<div style="margin-left: 185px;"><p><aui-spinner size="large"></aui-spinner></p></div></div>';
                AJS.$(html).insertBefore("#duo-push-notification-configuration-form");
                AJS.$("#showAfterSuccessDuoPushNotification").show();
                AJS.$.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
                    data: {
                        "method": "DuoPushNotification"
                    },
                    type: "POST",
                    success: function (response) {
                        AJS.$("#idLoadingDiv").remove();
                        if (response.status == 200) {
                            var html = '<div id="idSuccessMessage" class="aui-message aui-message-success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Duo Push Notification.</p></div>';
                            AJS.$(html).insertBefore("#duo-push-notification-configuration-form");

                            AJS.$('#duo-push-notification-form-close_1').focus();
                        } else {
                            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p class="title"><strong>Error!</strong></p><p>Issue with enabling Duo Push Notification.</p></div>';
                            html += '<div id="idInfoMessage" class="aui-message aui-message-info"><p>If already registered, click on <b>Send Me Push Notification</b> button to send authentication request again.</p></div>';
                            AJS.$(html).insertBefore("#duo-push-notification-configuration-form");
                            AJS.$("#duo-push-notification-configuration-form").show();
                            AJS.$("#duo-push-notification-info-div").hide();
                            AJS.$("#showAfterSuccessDuoPushNotification").hide();
                            AJS.$("#duo-push-notification-form-close").hide();
                        }
                    },
                    error: function (response) {
                        AJS.$("#idLoadingDiv").remove();
                        if (response.status == 200) {
                            var html = '<div id="idSuccessMessage" class="aui-message aui-message-success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Duo Push Notification.</p></div>';
                            AJS.$(html).insertBefore("#duo-push-notification-configuration-form");

                            AJS.$('#duo-push-notification-form-close_1').focus();
                        } else {
                            var html = '<div id="idErrorMessage" class="aui-message aui-message-error"><p class="title"><strong>Error!</strong></p><p>Issue with enabling Duo Push Notification.</p></div>';
                            html += '<div id="idInfoMessage" class="aui-message aui-message-info"><p>If already registered, click on <b>Send Me Push Notification</b> button to send authentication request again.</p></div>';
                            AJS.$(html).insertBefore("#duo-push-notification-configuration-form");
                            AJS.$("#duo-push-notification-configuration-form").show();
                            AJS.$("#duo-push-notification-info-div").hide();
                            AJS.$("#duo-showAfterSuccessDuoPushNotification").hide();
                            AJS.$("#duo-push-notification-form-close").hide();
                        }
                    }
                });
            });


        AJS.$(document).on('click','#duo-push-notification-configuration',function() {
            AJS.dialog2("#configure-duo-push-notification-dialog").show();
            var html = '<div id="idInfoMessage" class="aui-message aui-message-info"><p>Click on <b>Enable Duo Push Notification</b> button to configure it as a 2FA method.</p></div>';
            AJS.$(html).insertBefore("#duo-push-notification-configuration-form");
        });

        AJS.$(document).on('click','#duo-push-notification-form-close',function() {
            AJS.dialog2("#configure-duo-push-notification-dialog").hide();
            window.location.href = window.location.pathname;
        });

        AJS.$(document).on('click','#duo-push-notification-form-close_1',function() {
            AJS.dialog2("#configure-duo-push-notification-dialog").hide();
            window.location.href = window.location.pathname;
        });

            function registerNewSystemAuthenticator(attestationType, authenticatorType, userVerification, residentKey) {

                AJS.dialog2("#webauthn-config-dialog").show();
                document.getElementById("differentiate-web-authn-methods-info").style.display="block";
                AJS.$("#configure-webAuthn-as-second-factor-button").hide();
                AJS.$("#idInfoMessage").remove();
                AJS.$("#idWarningMessage").remove();
                AJS.$("#idErrorMessage").remove();
                AJS.$("#idSuccessMessage").remove();

                require('aui/flag')({
                    title: 'Configure WebAuthn as 2FA method',
                    type: 'info',
                    close: 'auto',
                    body: '<p>Register your system authenticator.</p>'
                });

                document.getElementById("wait_div").style.display="block";
                setTimeout(function() {
                    register1("","InlineConfig","webAuthentication",attestationType, authenticatorType, userVerification, residentKey);
                }, 2000);
            }

            function registerAdditionalAuthenticator(attestationType, authenticatorType, userVerification, residentKey) {

                AJS.$("#idInfoMessage").remove();
                AJS.$("#idWarningMessage").remove();
                AJS.$("#idErrorMessage").remove();
                AJS.$("#idSuccessMessage").remove();
                AJS.$("#register_new_credential_for_webauthn2fa").hide();
                AJS.$("#clear_previous_credential").hide();

                require('aui/flag')({
                    title: 'Configure WebAuthn as 2FA method',
                    type: 'info',
                    close: 'auto',
                    body: '<p>Register your system authenticator.</p>'
                });

                document.getElementById("wait_div").style.display="block";
                setTimeout(function() {
                    register1("","InlineConfig","webAuthentication", attestationType, authenticatorType, userVerification, residentKey);
                }, 2000);
            }

            function registerNewSystemAuthenticatorByInlineRegistration(attestationType, authenticatorType, userVerification, residentKey) {

                AJS.$("#idInfoMessage").remove();
                AJS.$("#idWarningMessage").remove();
                AJS.$("#idErrorMessage").remove();
                AJS.$("#idSuccessMessage").remove();
                AJS.$("#2fa-inline-webauthn-2fa-method-registration-form-submit").hide();
                AJS.$("#logoutLink").hide();

                document.getElementById("wait_div").style.display="block";
                setTimeout(function() {
                    register1("","login","webAuthentication", attestationType, authenticatorType, userVerification, residentKey);
                }, 2000);
            }

            function authenticateWebAuthn(username, methodUnderConsideration) {
                AJS.$("#2fa-validate-form-submit").hide();
                AJS.$("#showOtherMethods").hide();
                AJS.$("#logoutLink").hide();
                document.getElementById("wait_div").style.display="block";
                setTimeout(function() {
                    authenticate1(username, methodUnderConsideration);
                }, 2000);
            }

            function registerYubikeyToken(attestationType, authenticatorType, userVerification, residentKey) {

                AJS.$("#idInfoMessage").remove();
                AJS.$("#idWarningMessage").remove();
                AJS.$("#idErrorMessage").remove();
                AJS.$("#idSuccessMessage").remove();
                AJS.$("#hardware-token-main-div").hide();
                AJS.$("#u2f-hardware-token-form-submit").hide();
                AJS.$("#register_new_credential").hide();
                AJS.$("#u2f-hardware-token-form-close").hide();
                AJS.$("#hardware-token-touch-key-div").show();
                AJS.$("#showAfterSuccessHardwareToken").show();

                require('aui/flag')({
                    title: 'Validate Yubikey Hardware Token',
                    type: 'info',
                    close: 'auto',
                    body: '<p>Insert Your Security Key & Touch it.</p>'
                });

                setTimeout(function() {
                    register1("","InlineConfig","yubikeyHardwareToken", attestationType, authenticatorType, userVerification, residentKey);
                }, 2000);
            }

            function confirm_clear(username) {

                var flag=0;
                document.getElementById("clear_register_warning").style.display="none";
                document.getElementById("wait_div").style.display="block";
                AJS.$.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/webAuthn/MoSecureUtil",

                    async : false,
                    data: {
                        "action"   : "ResetWebAuthnForUser",
                        "username" : username
                    },
                    type: "POST",
                    error: function (response) {
                        console.log("Get configuration response status : ERROR");
                        document.getElementById("err_div").style.display="block";
                        document.getElementById("wait_div").style.display="none";
                        return false;
                    },
                    success: function (response) {
                        flag=1;
                        document.getElementById("succ_div_config").style.display="block";
                        document.getElementById("succ_div_msg").innerHTML="You successfully removed your previous authenticator.";
                        document.getElementById("wait_div").style.display="none";

                    }
                });
                if(flag==1){
                        AJS.$.ajax({
                            url: AJS.contextPath() + "/plugins/servlet/twofactor/user/moapi",
                            data: {
                                "action": "clear_previous_credentials_for_webAuthn"
                            },
                            type: "POST",
                            success: function (response) {
                            }

                        });
                }else{
                    console.log("error while resting webauthn");
                }


            }


