<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
            <#include "*/js/configure.js">;
        </script>
        
        <style>
            <#include "*/css/configure.css">;
        </style>
	</head>

	<body>
	<#include "*/header.ftl" parse=true>
    <#include "*/mobileAuthenticator.ftl" parse=true>
    <#include "*/otpOverSmsSettings.ftl" parse=true>
    <#include "*/otpOverEmailSettings.ftl" parse=true>
    <#include "*/duoPushNotificationSettings.ftl" parse=true>
    <#include "*/webAuthnSettings.ftl" parse=true>

	<#assign googleAuthenticatorIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "GoogleAuthenticator.png" >
    <input type="hidden" id="googleAuthenticatorIconId" value="${googleAuthenticatorIcon}">

    <#assign otpOverEmailIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "OtpOverEmail.png" >
    <input type="hidden" id="otpOverEmailIconId" value="${otpOverEmailIcon}">

    <#assign otpOverSmsIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "OtpOverSms.png" >
    <input type="hidden" id="otpOverSmsIconId" value="${otpOverSmsIcon}">

    <#assign securityQuestionIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "SecurityQuestion.png" >
    <input type="hidden" id="securityQuestionIconId" value="${securityQuestionIcon}">

    <#assign backupCodeIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "BackupCode.png" >
    <input type="hidden" id="backupCodeIconId" value="${backupCodeIcon}">

    <#assign hardwareTokenIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "HardwareToken.png" >
    <input type="hidden" id="hardwareTokenIconId" value="${hardwareTokenIcon}">

    <#assign webAuthnIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "webAuthentication.png" >
    <input type="hidden" id="webAuthnIconId" value="${webAuthnIcon}">

    <#assign yubikeyTokenTouchIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "YubikeyHardwareToken.gif" >
    <input type="hidden" id="yubikeyTokenTouchIconId" value="${yubikeyTokenTouchIcon}">

    <#assign pushNotificationIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "PushNotification.png" >
    <input type="hidden" id="pushNotificationIconId" value="${pushNotificationIcon}">

    <input type="hidden" id="isSslSetup" value=${(isSslSetup == true)?then('"true"', '"false"')}>

    <input type="hidden" id="showWelcomePrompt" value=${(showWelcomePrompt == true)?then('"true"', '"false"')}>

    <div class="tabs-pane active-pane" id="settings"  role="tabpanel" >
        <h2>
            Basic Configurations
        </h2>
        <hr class="header"/>
        <br>
        <div class="field-group" style="padding-left: 145px;">
            <#include "*/welcomePrompt.ftl" parse=true>
        </div>
        <div>
            <div>
                <h2 class="subsection_title">Step 1: Choose 2FA methods for end users</h2>
                <br>
                <div class="description" >
                    In this step, you can choose which 2FA methods are available to all your end users and which methods they can setup as backup methods.<br>
                    To explore the advanced settings related to the 2FA methods, click on the settings <span class="aui-icon aui-icon-small aui-iconfont-settings"></span> option available at the top right corner of the card of that specific method.
                </div>
                <br>
            </div>

            <div class="cards_row_1">

                <section class="auth_card">
                    <div class="top_sec">
                        <h2 id="GoogleAuthenticatorHeading">Mobile Authenticator
                        </h2>

                        <span class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right; cursor: pointer;"
                              onclick="displaySettings('mobileAuthenticatorDivId')">
                        </span>
                    </div>
                    <span class="desc_sec">
                        <div class="card_icon">
                              <img id="imgGoogleAuthenticator" width="90px">
                        </div>
                        <div class="card_desc">User needs to enter 6 digit passcode generated by Mobile Authenticator app.

                        </div>
                    </span>

                    <div class="bottom_sec">
                        <aui-toggle id="idGoogleAuthenticator" value="true" label="Enable GoogleAuthenticator"
                                    onchange="saveToggleButton(this.id)" name="twoFactorForMobileAuthn"
                                    ${(twoFactorForMobileAuthn == true)?then('checked="true"', '')} ></aui-toggle>
                        <div class="radio_buttons">
                            <input class="radio" type="radio" name="mobileAuthnFilter" id="idGoogleAuthenticatorMain"
                                   onclick="saveRadioButton(this.id)"
                                ${(twoFactorForMobileAuthn != true)?then('disabled','')}
                                    ${(twoFactorMethodForUserList.contains("GoogleAuthenticator"))?then('checked="true"', '')}
                            value="main" resolved="" style="box-shadow: none;"> 2FA Method
                            <input class="radio" type="radio" name="mobileAuthnFilter" id="idGoogleAuthenticatorBackup" onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForMobileAuthn != true)?then('disabled','')}
                                    ${(backupMethodForUserList.contains("GoogleAuthenticator"))?then('checked="true"', '')}
                                   value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                        </div>
                    </div>
                </section>
                <section class="auth_card">
                    <div class="top_sec">
                        <h2 id="YubikeyHardwareTokenAsU2FHeading">Yubikey Hardware Token
                        </h2>

                    </div>
                    <span class="desc_sec">
                    <div class="card_icon">
                       <img id="imgHardwareToken" width="90px">
                    </div>
                    <div class="card_desc">User needs to insert a security key & touch it.

                    </div>
                </span>

                    <div class="bottom_sec">
                        <div id="yubikeytoggleParentId" <#if (isSslSetup == false)> class="for-toolTip"  data-tooltip="SSL is not setup on your Bamboo instance.
                        So you will not be able to setup Yubikey Hardware Token." </#if>>
                            <aui-toggle id="idYubikeyHardwareTokenAsU2F" value="true" label="Enable YubikeyHardwareTokenAsU2F"
                                        onchange="saveToggleButton(this.id)" name="twoFactorForYubikey"
                                    ${(isSslSetup == false || twoFactorForWebAuthn == true )?then('disabled', '')}
                                    ${(twoFactorForYubikey == true)?then('checked="true"', '')}>
                            </aui-toggle>

                        </div>
                        <div class="radio_buttons">
                            <input class="radio" type="radio" name="HardwareTokenFilter" id="idYubikeyHardwareTokenAsU2FMain"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForYubikey != true)?then('disabled', '')}
                                    ${(twoFactorMethodForUserList.contains("YubikeyHardwareTokenAsU2F"))?then('checked="true"', '')}
                            value="main" resolved="" style="box-shadow: none;"> 2FA Method
                            <input class="radio" type="radio" name="HardwareTokenFilter" id="idYubikeyHardwareTokenAsU2FBackup"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForYubikey != true)?then('disabled', '')}
                                    ${(backupMethodForUserList.contains("YubikeyHardwareTokenAsU2F"))?then('checked="true"', '')}
                            value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                        </div>
                    </div>

                </section>
                <section class="auth_card">
                    <div class="top_sec">
                        <h2 id="DuoPushNotificationHeading">Duo Push Notification
                        </h2>
                        <span id="idDuoPushNotificationIcon" class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right;cursor: pointer;"
                              onclick="displaySettings('duoPushNotificationDivId')">
                    </span>
                    </div>
                    <span class="desc_sec">
                    <div class="card_icon">
                          <img id="imgPushNotification" width="90px">
                    </div>
                    <div class="card_desc"> Users will receive a mobile notification and can choose to APPROVE or DENY.
                    </div>
                </span>

                    <div class="bottom_sec">
                        <div <#if (duoPushNotificationSettingsConfigured == false)> class="for-toolTip"  data-tooltip="Push Notification configuration details are not yet configured." </#if>>
                            <aui-toggle id="idDuoPushNotification" value="true" label="Enable DuoPushNotification" onchange="saveToggleButton(this.id)"
                                    ${(duoPushNotificationSettingsConfigured == false)?then('disabled onmouseover="hoverIn(this.id)" onmouseout="hoverOut(this.id)"', '')}
                                        name="twoFactorForDuopush"
                                ${(twoFactorForDuopush == true)?then('checked="true"', '')}></aui-toggle>
                        </div>
                        <div class="radio_buttons">
                            <input class="radio" type="radio"  name="PushNotificationFilter" id="idDuoPushNotificationMain"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForDuopush != true)?then('disabled', '')}
                                    ${(twoFactorMethodForUserList.contains("DuoPushNotification"))?then('checked="true"', '')}
                            value="main" resolved="" style="box-shadow: none;"> 2FA Method
                            <input class="radio" type="radio" name="PushNotificationFilter" id="idDuoPushNotificationBackup"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForDuopush != true)?then('disabled', '')}
                                    ${(backupMethodForUserList.contains("DuoPushNotification"))?then('checked="true"', '')}
                            value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                        </div>
                    </div>

                </section>
            </div>

            <div class="cards_row_1">

                <section class="auth_card">
                    <div class="top_sec">
                        <h2 id="WebAuthnHeading">Web Authentication
                        </h2>
                        <span id="idWebAuthnIcon" class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right;cursor: pointer;"
                              onclick="displaySettings('webAuthnSettingsDivId')">
                    </span>
                    </div>
                    <span class="desc_sec">
                    <div class="card_icon">
                          <img id="imgWebAuthn" width="90px">
                    </div>
                    <div class="card_desc">User can use the system's built-in authentication methods.

                    </div>
                </span>

                    <div class="bottom_sec">
                        <div id="webAuthntoggleParentId" <#if (isSslSetup == false)> class="for-toolTip"  data-tooltip="SSL is not setup on your Bamboo instance. So you will not be able to setup Web Authentication." </#if>>
                            <aui-toggle id="idWebAuthn" value="true" label="Enable WebAuthn" onchange="saveToggleButton(this.id)"
                                    ${(isSslSetup == false || twoFactorForYubikey == true )?then('disabled', '')}
                                    name="twoFactorForWebAuthn"
                                    ${(twoFactorForWebAuthn == true)?then('checked="true"', '')}>
                            </aui-toggle>
                        </div>
                        <div class="radio_buttons">
                            <input class="radio" type="radio" name="WebAuthnFilter" id="idWebAuthnMain"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForWebAuthn != true)?then('disabled', '')}
                                    ${(twoFactorMethodForUserList.contains("WebAuthn"))?then('checked="true"', '')}
                                    value="main" resolved="" style="box-shadow: none;"> 2FA Method
                            <input class="radio" type="radio" name="WebAuthnFilter" id="idWebAuthnBackup"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForWebAuthn != true)?then('disabled', '')}
                                    ${(backupMethodForUserList.contains("WebAuthn"))?then('checked="true"', '')}
                                    value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                        </div>
                    </div>

                </section>
                <section class="auth_card">
                    <div class="top_sec">
                        <h2 id="OtpOverEmailHeading">OTP Over Email
                        </h2>
                        <span id="idOtpOverEmailIcon" class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right;cursor: pointer;"
                              onclick="displaySettings('otpOverEmailSettingsDivId')" >
                    </span>
                    </div>
                    <span class="desc_sec">
                <div class="card_icon">
                   <img id="imgOtpOverEmail" width="90px">
                </div>
                <div class="card_desc">User needs to enter the OTP received on the email.

                </div>
            </span>

                    <div class="bottom_sec">
                        <div <#if (smtpConfigured == false)> class="for-toolTip"  data-tooltip=" As Bamboo's mail server is not configured yet. So won't be able to enable OTP Over Email as a 2FA method." </#if>>
                            <aui-toggle id="idOtpOverEmail" value="true" label="Enable OtpOverEmail" onchange="saveToggleButton(this.id)"
                                    ${(smtpConfigured == false)?then('disabled', '')}
                                    name="twoFactorForOtpOverEmail"
                                    ${(twoFactorForOtpOverEmail == true)?then('checked="true"', '')}></aui-toggle>

                        </div>
                        <div class="radio_buttons">
                            <input class="radio" type="radio" name="OtpOverEmailFilter" id="idOtpOverEmailMain"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForOtpOverEmail != true)?then('disabled', '')}
                                    ${(twoFactorMethodForUserList.contains("OtpOverEmail"))?then('checked="true"', '')}
                                value="main" resolved="" style="box-shadow: none;"> 2FA Method
                            <input class="radio" type="radio" name="OtpOverEmailFilter" id="idOtpOverEmailBackup"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForOtpOverEmail != true)?then('disabled', '')}
                                    ${(backupMethodForUserList.contains("OtpOverEmail"))?then('checked="true"', '')}
                                    value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                        </div>
                    </div>

                </section>
                <section class="auth_card">
                    <div class="top_sec">
                        <h2 id="OtpOverSmsHeading">OTP Over SMS
                        </h2>
                        <span id="idOtpOverSmsIcon" class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right;cursor: pointer;"
                              onclick="displaySettings('otpOverSmsSettingsDivId')">
                    </span>
                    </div>
                    <span class="desc_sec">
                <div class="card_icon">
                      <img id="imgOtpOverSms" width="90px">
                </div>
                <div class="card_desc">User needs to enter the OTP received via SMS on his/her mobile.
                </div>
            </span>

                    <div class="bottom_sec">
                        <div <#if (smsGatewayConfigured == false)> class="for-toolTip"  data-tooltip="SMS Gateway is not configured yet. So you won't be able to enable OTP Over SMS as 2FA method." </#if>>
                            <aui-toggle id="idOtpOverSms" value="true" label="Enable OtpOverSms" name="twoFactorForOtpOverSms" onchange="saveToggleButton(this.id)"
                                ${(smsGatewayConfigured == false)?then('disabled onmouseover="hoverIn(this.id)" onmouseout="hoverOut(this.id)"', '')}
                                ${(twoFactorForOtpOverSms == true)?then('checked="true"', '')}
                            </aui-toggle>
                        </div>
                        <div class="radio_buttons">
                            <input class="radio" type="radio" name="OtpOverSmsFilter" id="idOtpOverSmsMain"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForOtpOverSms != true)?then('disabled', '')}
                                    ${(twoFactorMethodForUserList.contains("OtpOverSms"))?then('checked="true"', '')}
                                    value="main" resolved="" style="box-shadow: none;"> 2FA Method
                            <input class="radio" type="radio" name="OtpOverSmsFilter" id="idOtpOverSmsBackup"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForOtpOverSms != true)?then('disabled', '')}
                                    ${(backupMethodForUserList.contains("OtpOverSms"))?then('checked="true"', '')}
                                    value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                        </div>
                    </div>

                </section>
            </div>

            <div class="cards_row_1">

                <section class="auth_card">
                    <div class="top_sec">
                        <h2 id="SecurityQuestionHeading">Security Question
                        </h2>
                        <span class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right; cursor: pointer;" onclick="redirectTo('securityQuestionTemplateDiv')"></span>
                    </div>
                    <span class="desc_sec">
                        <div class="card_icon">
                              <img id="imgSecurityQuestion" width="90px">
                        </div>
                        <div class="card_desc">User needs to answer the security questions to access Bamboo.

                        </div>
                    </span>

                    <div class="bottom_sec">
                        <aui-toggle id="idSecurityQuestion" value="true" label="Enable SecurityQuestion" onchange="saveToggleButton(this.id)" name="twoFactorForsecurityQuestion"
                                    ${(twoFactorForsecurityQuestion == true)?then('checked="true"', 'false')}></aui-toggle>
                        <div class="radio_buttons">
                            <input class="radio" type="radio" name="securityQuestionFilter" id="idSecurityQuestionMain"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForsecurityQuestion != true)?then('disabled','')}
                                   ${(twoFactorMethodForUserList.contains("SecurityQuestion"))?then('checked="true"', 'false')}
                                   value="main" resolved="" style="box-shadow: none;"> 2FA Method
                            <input class="radio" type="radio" name="securityQuestionFilter" id="idSecurityQuestionBackup"
                                   onclick="saveRadioButton(this.id)"
                                    ${(twoFactorForsecurityQuestion != true)?then('disabled','')}
                                   ${(backupMethodForUserList.contains("SecurityQuestion"))?then('checked="true"', 'false')}
                                   value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                        </div>
                    </div>
                </section>
                <section class="auth_card">
                    <div class="top_sec">
                        <h2 id="BackupCodeHeading">Backup Code
                        </h2>
                    </div>
                    <span class="desc_sec">
                        <div class="card_icon">
                           <img id="imgBackupCode" width="90px">
                        </div>
                        <div class="card_desc">User needs to provide the Backup Code to access Bamboo.

                        </div>
                    </span>

                    <div class="bottom_sec">
                        <aui-toggle id="idBackupCode" value="true" label="Backup Code" name="twoFactorForBackup" onchange="saveToggleButton(this.id)"
                                ${(twoFactorForBackup==true)?then('checked="true"', '')}>
                        </aui-toggle>
                        <div class="radio_buttons">
                            <input class="radio" type="radio" name="BackupCodeFilter" id="idBackupCodeBackup"
                                    ${(twoFactorForBackup != true)?then('disabled', '')}
                                    ${(backupMethodForUserList.contains("BackupCode"))?then('checked="true"', '')}
                                    value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                        </div>
                    </div>

                </section>
            </div>

        </div>

        <br><br>
        <div id="methodsForUser">
            <div>
                <h2 class="subsection_title">Step 2: Select users to enforce 2FA</h2>
                <div class="description" style="margin-top:5px;">
                    In this step, you can choose the users who will be asked to verify 2FA after they login.
                </div>
            </div>
            <br>
            <div class="field-group" >
                <aui-toggle id="enable2FAForAllUsers" value="true" label="Enable 2FA For All Users" onclick="confirmEnableOrDisable2FAForAllUsers()" name="enable2FAForAllUsers"
                        ${(enable2FAForAllUsers==true)?then('checked="true"', '')}>
                </aui-toggle>
                <span style="height:16px; width: 16px">&nbsp;
                <b>2FA/MFA for All users (Existing + Newly created)</b>
            </span>
                <div class="description" style="padding-left: 74px;margin-top:5px;">
                    You can use this option to enable 2FA for all the existing users.
                    <br>If this option is enabled then 2FA will get automatically enabled for all newly created users as well.
                </div>
            </div>
            <br>
            <div class="field-group" >

                <div class="aui-message aui-message-info">
                    <input id="infoForCommonConfigurations" type="checkbox" class="panel">
                    <label for="infoForCommonConfigurations" style="margin-top: -11px;" class="panel-title" onclick="openCloseElemenet('openclosearrorw')">
                        <div class="arrow" id="openclosearrorw" name="arrow_rotate" style="margin-top: 3px; left: 40px;">➕</div>
                        Not sure how to set up? <b>Click here</b> to check out our commonly used configurations.
                    </label>
                    <div class="panel-content">
                        <p>
                            Here are some of the commonly used user configurations.
                        </p>
                        <div id="valid-configuration-recommendation" style="margin-top:10px;">
                            <ol>
                                <li>
                                    If you want to enforce 2FA for all the users in your organization then just enable the above toggle button.
                                </li>
                                <li>
                                    If you want that 2FA should only be asked to some specific users or users of some specific groups then use the settings provided in <a onclick="redirectTo('usermanagement')"><b>User Management tab</b></a>.
                                    <br>You can enable/disable 2FA for users/groups both individually and in bulk.
                                </li>
                                <li>
                                    If you want to enforce 2FA verification to all users except some users (for eg: admins) then,
                                    <br>enable the above toggle and then add the admin group(s) to <a onclick="redirectTo('excludeGroups')"><b>Skip 2FA for Groups</b></a> feature in User Management tab.
                                </li>
                                <li>
                                    If you want to skip 2FA verification of users coming from some trusted IPs then use IP whitelisting feature in <a onclick="redirectTo('IpRestriction')"><b>IP Restrictions</b></a>.
                                </li>
                                <li>
                                    If some of your users are logging in via single sign on and 2FA is already handled by the IDP then, eradicate the muliple 2FA verifications issue by using <a onclick="redirectTo('disable2faForSsoUsers')"><b>Skip 2FA on SSO</b></a> feature.
                                </li>
                                <li>
                                    If you have multiple Atlassian applications connected via Crowd and want your users to perform 2FA only once on any one application and skip it on the rest then enable <a onclick="redirectTo('oneTime2FAInCrowdAuthenticationSetup')"><b>One-time 2FA validation in Crowd authentication setups</b></a> feature.
                                </li>
                            </ol>
                            <p>
                                If you have some other requirement then please reach out to us <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2/group/6" target="_blank"><b>here</b></a> and we can assist you in configuring the plugin.
                            </p>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <br><br>
        <div id="enableTwoFactorForDiv">
            <div>
                <h2 class="subsection_title">Step 3: Enable 2FA</h2>
            </div>
            <br>
            <div class="field-group" >
                <table style="width: 100%;">
                    <tbody>
                    <tr>
                        <td>
                            <aui-toggle id="enableTwoFactor" value="true" label="Enable 2fa for bamboo" name="enableTwoFactor" onclick="confirmEnableOrDisable2FAForSoftware()"
                                    ${(enableTwoFactor==true)?then('checked="true"', '')}>
                            </aui-toggle>
                            <span style="height:16px; width: 16px">&nbsp;
                                2FA for Bamboo
                            </span>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <br><br>
        <div class="setupForMe">
            <h2>Setup 2FA for my account</h2>
            <div class="description" style="margin-top:5px;">
                You can try configuring different 2FA methods for your own account (${adminEmail}) from <a onclick="redirectTo('/configure2fabyuser')"><b>here</b></a>.
            </div>
        </div>

    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>