AJS.$(document).ready(function() {
     AJS.$(window).scrollTop(0);
     AJS.$(".aui-nav li").removeClass("aui-nav-selected");
     AJS.$("#ADAPTIVEAUTHENTICATION").addClass("aui-nav-selected");
     AJS.$('input').css("box-shadow","none");
});

function performActionChange(selectedAction) {
    console.log("Calling performActionChange For : "+selectedAction);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
        timeout: 0,
        data: {
            "action": "ChangeIpManagementSelectedAction",
            "selectedAction": selectedAction
        },
        type: "POST",
        success: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        error: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        async: true
    });
}

function removeWhitelistIp(ipAddress, ipAddressMessage)  {
    console.log("Calling removeWhitelistIp For : "+ipAddress);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
        timeout: 0,
        data: {
            "action": "RemoveWhitelistIp",
            "ipAddress": ipAddress,
            "ipAddressMessage": ipAddressMessage
        },
        type: "POST",
        success: function (response) {
            performRemoveWhitelistIp(response, ipAddress);
        },
        error: function (response) {
            performRemoveWhitelistIp(response, ipAddress);
        },
        async: true
    });
}

function performRemoveWhitelistIp(response, ipAddress) {
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Whitelist IP',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed IP : '+ipAddress+'</p>'
        });
        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Whitelist IP',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with removing IP : '+ipAddress+'</p>'
        });
    }
}

function removeBlacklistIp(ipAddress, ipAddressMessage) {
    console.log("Calling removeBlacklistIp For : "+ipAddress);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
        timeout: 0,
        data: {
            "action": "RemoveBlacklistIp",
            "ipAddress": ipAddress,
            "ipAddressMessage": ipAddressMessage
        },
        type: "POST",
        success: function (response) {
            performRemoveBlacklistIp(response, ipAddress);
        },
        error: function (response) {
            performRemoveBlacklistIp(response, ipAddress);
        },
        async: true
    });
}

function performRemoveBlacklistIp(response, ipAddress) {
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Blacklist IP',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed IP : '+ipAddress+'</p>'
        });
        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Blacklist IP',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with removing IP : '+ipAddress+'</p>'
        });
    }
}

function toggleAllWhitelistIps() {
    var isChecked = document.getElementById("selectAllWhitelistIps").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value - 1;

    for (var i=startIndex;i<=endIndex;i++) {
        document.getElementById("selectedWhitelistIp"+i).checked = isChecked;
    }
}

function toggleAllBlacklistIps() {
    var isChecked = document.getElementById("selectAllBlacklistIps").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value - 1;

    for (var i=startIndex;i<=endIndex;i++) {
        document.getElementById("selectedBlacklistIp"+i).checked = isChecked;
    }
}

function performBulkIpAction() {
    var action = document.getElementById("bulkIpAction");
    console.log("Action : "+action.value);
    if (action.value =="") {
        document.getElementById("bulkIpAction").style.borderColor = "red";
        alert("Please select valid Bulk Action");
    } else {
        document.getElementById("bulkIpAction").style.borderColor = "";
        console.log("Selected Action : "+action.value);
        var startIndex = document.getElementById("startIndex").value;
        var endIndex = document.getElementById("endIndex").value - 1;
        switch (action.value) {
            case "Delete Selected Whitelist IPs":
                deleteSelectedWhitelistIps(startIndex, endIndex);
                break;
            case "Delete All Whitelist IPs":
                deleteAllWhitelistIps();
                break;
            case "Delete Selected Blacklist IPs":
                deleteSelectedBlacklistIps(startIndex, endIndex);
                break;
            case "Delete All Blacklist IPs":
                deleteAllBlacklistIps();
                break;
        }
    }
}

function deleteSelectedWhitelistIps(startIndex, endIndex) {
    console.log("Calling deleteSelectedWhitelistIps");
    var isIpSelected = false;
    var selectedWhitelistIps = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedWhitelistIp"+i).checked;
        if (isChecked == true) {
            isIpSelected = true;
            selectedWhitelistIps.push(document.getElementById("selectedWhitelistIp"+i).value);
        }
    }

    if (isIpSelected == true) {
        require('aui/flag')({
            title: 'Removing IPs',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Removing Selected IPs Whitelist in background. You can still access Bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
            timeout: 0,
            data: {
                "action": "RemoveSelectedWhitelistIps",
                "selectedWhitelistIps":selectedWhitelistIps
            },
            type: "POST",
            success: function (response) {
                performDeleteSelectedWhitelistIps(response);
            },
            error: function (response) {
                performDeleteSelectedWhitelistIps(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
             title: 'Removing IPs',
             type: 'error',
             close: 'auto',
             body: '<p>No IP is selected. Please select valid IP.</p>'
        });
    }
}

function performDeleteSelectedWhitelistIps(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Removing IPs',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed selected IPs from Whitelist.</p>'
        });

        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Removing IPs',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Removing IPs from Whitelist.</p>'
        });
    }
}


function deleteSelectedBlacklistIps(startIndex, endIndex) {
    console.log("Calling deleteSelectedBlacklistIps");
    var isIpSelected = false;
    var selectedBlacklistIps = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedBlacklistIp"+i).checked;
        if (isChecked == true) {
            isIpSelected = true;
            selectedBlacklistIps.push(document.getElementById("selectedBlacklistIp"+i).value);
        }
    }

    if (isIpSelected == true) {
        require('aui/flag')({
            title: 'Removing IPs',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Removing Selected Blacklist IPs in background. You can still access Bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
            timeout: 0,
            data: {
                "action": "RemoveSelectedBlacklistIps",
                "selectedBlacklistIps":selectedBlacklistIps
            },
            type: "POST",
            success: function (response) {
                performDeleteSelectedBlacklistIps(response);
            },
            error: function (response) {
                performDeleteSelectedBlacklistIps(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
             title: 'Removing IPs',
             type: 'error',
             close: 'auto',
             body: '<p>No IP is selected. Please select valid IP.</p>'
        });
    }
}

function performDeleteSelectedBlacklistIps(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Removing IPs',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed selected IPs from Blacklist.</p>'
        });

        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Removing IPs',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Removing IPs from Blacklist.</p>'
        });
    }
}

function deleteAllWhitelistIps() {
    console.log("Calling deleteAllWhitelistIps");
    require('aui/flag')({
        title: 'Removing IPs',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Removing All Whitelist IPs in background. You can still access Bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
        timeout: 0,
        data: {
            "action": "RemoveAllWhitelistIps"
        },
        type: "POST",
        success: function (response) {
            performRemoveAllWhitelistIps(response);
        },
        error: function (response) {
            performRemoveAllWhitelistIps(response);
        },
        async: true
    });
}

function performRemoveAllWhitelistIps(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Removing IPs',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed All IPs from Whitelist.</p>'
        });

        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Removing IPs',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Removing All IPs from Whitelist.</p>'
        });
    }
}

function deleteAllBlacklistIps() {
    console.log("Calling deleteAllBlacklistIps");
    require('aui/flag')({
        title: 'Removing IPs',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Removing All Blacklist IPs in background. You can still access Bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
        timeout: 0,
        data: {
            "action": "RemoveAllBlacklistIps"
        },
        type: "POST",
        success: function (response) {
            performRemoveAllBlacklistIps(response);
        },
        error: function (response) {
            performRemoveAllBlacklistIps(response);
        },
        async: true
    });
}

function performRemoveAllBlacklistIps(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Removing IPs',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed All IPs from Blacklist.</p>'
        });

        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Removing IPs',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Removing All IPs from Blacklist.</p>'
        });
    }
}