<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
	        AJS.$(document).ready(function() {
	             AJS.$(window).scrollTop(0);
	             AJS.$(".aui-nav li").removeClass("aui-nav-selected");
	             AJS.$("#CONFIGURE2FA").addClass("aui-nav-selected");
	             AJS.$('input').css("box-shadow","none");

	             var totalCount = ${total2faEnabledUsers};
                 var enableTwoFactor = '${enableTwoFactorString}';
                 if(enableTwoFactor == "true" && totalCount <= 0) {
                     require('aui/flag')({
                         title: 'Two Factor Configuration',
                         type: 'warning',
                         close: 'manual',
                         body: '<p>Two Factor Authentication is disabled for users.<br>Please navigate to the <strong>User Management</strong> tab to enable 2FA for users. Otherwise, 2FA will not work.</p>'
                     });
                 }

                 var configuredMethods = '${totalMethodsConfiguredByUser}';
                 if(enableTwoFactor == 'true' && configuredMethods <= 0) {
                     require('aui/flag')({
                         title: 'Two Factor Authentication',
                         type: 'info',
                         close: 'auto',
                         body: '<p>2FA is enabled but no method is configured. If you do not configure it, you will be prompted to configure it during login.</p>'
                     });
                 }

                setMethodIcons();
	        });

	        function setMethodIcons() {
	            var googleAuthenticatorIcon = document.getElementById("googleAuthenticatorIconId").value;
	            document.getElementById("imgGoogleAuthenticator").src = googleAuthenticatorIcon;

	            var otpOverEmailIconIcon = document.getElementById("otpOverEmailIconId").value;
	            document.getElementById("imgOtpOverEmail").src = otpOverEmailIconIcon;

	            var otpOverSmsIcon = document.getElementById("otpOverSmsIconId").value;
	            document.getElementById("imgOtpOverSms").src = otpOverSmsIcon;

	            var securityQuestionIcon = document.getElementById("securityQuestionIconId").value;
	            document.getElementById("imgSecurityQuestion").src = securityQuestionIcon;

	            var backupCodeIcon = document.getElementById("backupCodeIconId").value;
	            document.getElementById("imgBackupCode").src = backupCodeIcon;

	            var hardwareTokenIcon = document.getElementById("hardwareTokenIconId").value;
	            document.getElementById("imgHardwareToken").src = hardwareTokenIcon;

	            var webAuthenticationIcon = document.getElementById("webAuthnIconId").value;
                document.getElementById("imgWebAuthn").src = webAuthenticationIcon;

	            var yubikeyTokenTouchIcon = document.getElementById("yubikeyTokenTouchIconId").value;
	            document.getElementById("imgYubikeyTokenTouch").src = yubikeyTokenTouchIcon;

	            var pushNotificationIcon = document.getElementById("pushNotificationIconId").value;
                document.getElementById("imgPushNotification").src = pushNotificationIcon;
	        }

	        function validateShowAllConfigureMethod() {
	            if (AJS.$("#showAllConfiguredMethodsDirectly")[0].checked === true) {
	                AJS.$("#enableEnforceCurrentMethod").prop("checked", false);
	                AJS.$("#primaryMethodForUserDiv").hide();
	            }
	        }

	        function validateEnforcePrimaryMethod() {
                if (AJS.$("#enableEnforceCurrentMethod")[0].checked === true) {
                    AJS.$("#showAllConfiguredMethodsDirectly").prop("checked", false);
                }
	        }
            function enableRegistrationUsingQrCode() {
                console.log("calling enableRegistrationUsingQrCode");
                AJS.$("#ownSecretKey").val("");
                AJS.$("#otpUsingOwnSecretKey").val("");
                AJS.$("#google-authenticator-own-secret-key-secondary-div").hide();
                AJS.$("#google-authenticator-secondary-div").show();
            }
            function enableRegistrationUsingOwnSecretKey() {
                console.log("calling enableRegistrationUsingOwnSecretKey");
                AJS.$("#qrCodeOtp").val("");
                AJS.$("#google-authenticator-secondary-div").hide();
                AJS.$("#google-authenticator-own-secret-key-secondary-div").show();
            }
	        AJS.$(function () {
	            var showWelcomePrompt = '${showWelcomePromptString}';
                if (showWelcomePrompt == "true"){
                    AJS.dialog2("#intro_for_new_users_dialog").show();
                    jQuery.ajax({
                        url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
                        timeout: 0,
                        data: {
                        "action":"disableWelcomePrompt"
                     },
                     type: "POST",
                     async: true,
                     success: function (response) {
                        console.log("SUCCESS");
                     },
                     error: function (response) {
                        console.log("ERROR");
                     }

                    });
                }
                AJS.$("#intro_for_new_users_dialog_close_button").click(function(e) {
                    e.preventDefault();
                    AJS.dialog2("#intro_for_new_users_dialog").hide();
                });
            });
        </script>
        
        <style>
        	h4 {
        		display: block;
        		margin: 30px 65px 0px;
        		font-weight: bold;
        	}

        	.aui-page-panel-content{
                padding: 0px !important;
            }

            .aui-page-panel{
                margin: 0px !important;
                border: 0px solid #dfe1e6;
            }

            .labelClass {
                width: 150px !important;
                margin-left: -160px !important;
            }

            .card{
                border: 2px;
                border-style: solid;
                box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
                transition: 0.3s;
            }

            /* On mouse-over, add a deeper shadow */
            .card:hover {
                box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
            }

            /* Add some padding inside the card container */
            .container {
                padding: 2px 16px;
            }
            .card-body{
                margin: 15px;
            }

            .aui-dialog2-header-main {
                max-width : 100%;
            }

            .aui-message:first-child {
                margin-right: 0px;
            }

        </style>
	</head>

	<body>
	<#include "*/header.ftl" parse=true>

	<#assign googleAuthenticatorIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "GoogleAuthenticator.png" >
    <input type="hidden" id="googleAuthenticatorIconId" value="${googleAuthenticatorIcon}">

    <#assign otpOverEmailIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "OtpOverEmail.png" >
    <input type="hidden" id="otpOverEmailIconId" value="${otpOverEmailIcon}">

    <#assign otpOverSmsIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "OtpOverSms.png" >
    <input type="hidden" id="otpOverSmsIconId" value="${otpOverSmsIcon}">

    <#assign securityQuestionIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "SecurityQuestion.png" >
    <input type="hidden" id="securityQuestionIconId" value="${securityQuestionIcon}">

    <#assign backupCodeIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "BackupCode.png" >
    <input type="hidden" id="backupCodeIconId" value="${backupCodeIcon}">

    <#assign hardwareTokenIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "HardwareToken.png" >
    <input type="hidden" id="hardwareTokenIconId" value="${hardwareTokenIcon}">

    <#assign webAuthnIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "webAuthentication.png" >
    <input type="hidden" id="webAuthnIconId" value="${webAuthnIcon}">

    <#assign yubikeyTokenTouchIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "YubikeyHardwareToken.gif" >
    <input type="hidden" id="yubikeyTokenTouchIconId" value="${yubikeyTokenTouchIcon}">

    <#assign pushNotificationIcon = webResourceManager.getStaticPluginResource("com.miniorange.twofactor.bamboo-twofactor:twofactor.plugin.images.resource", "images/") + "PushNotification.png" >
    <input type="hidden" id="pushNotificationIconId" value="${pushNotificationIcon}">

    <div class="tabs-pane active-pane" id="settings"  role="tabpanel" >
        <h2>Two Factor Settings
            <a style="float: right; margin-right: 1%;" class="aui-button aui-button-primary"
                href="https://www.youtube.com/watch?v=XscesyxzuFU" target="_blank">
                <span class="aui-icon aui-icon-small aui-iconfont-video-filled"></span>&nbsp; Video guide </a>

            <a style="float: right; margin-right: 1%;" class="aui-button aui-button-primary"
                href="https://plugins.miniorange.com/two-factor-authentication-2fa-for-bamboo" target="_blank">
                <span class="aui-icon aui-icon-small aui-iconfont-settings"></span>&nbsp; Setup guide </a>
        </h2>
        <hr class="header"/>
        <br>
        <div class="field-group" style="padding-left: 145px;">
        <#include "*/welcomePrompt.ftl" parse=true>
            <span style="vertical-align:middle;">
                <label class="switch" style="vertical-align:middle;">
                    <#if (enableTwoFactor == true)>
                        <input form="settings-form" type="checkbox" id="enableTwoFactor" value="true" name="enableTwoFactor"
                           checked="true"/>
                        <span class="slider round"></span>
                    <#else>
                        <input form="settings-form" type="checkbox" id="enableTwoFactor" value="true" name="enableTwoFactor"/>
                        <span class="slider round"></span>
                    </#if>
                </label>
                <span style="height:16px; width: 16px">&nbsp;
                    Enable 2 Factor Authentication for Bamboo users
                </span>
            </span>
        </div>

        <br><br>
        <#include "*/configurable2famethodlist.ftl" parse=true>

        <form id="settings-form" class="aui long-label" action="" method="POST">
            <input type="hidden" name="settingsSubmitted" value="true"/>
            <input type="hidden" name="atl_token" value="${xsrfToken}" />

            <br><br>
            <div id="methodsForUser">
                <h3>2FA methods For User</h3>
                <div class="field-group" style="padding-left: 145px;">
                    <table style="width: 100%;">
                        <tr>
                            <td style="width: 20%;">
                                <span style="vertical-align:middle;">
                                    <label class="switch" style="vertical-align:middle;">
                                        <#if (twoFactorMethodForUserList.contains("GoogleAuthenticator"))>
                                            <input type="checkbox" value="GoogleAuthenticator" id="idGoogleAuthenticator" name="twoFactorMethodForUser" checked="true" >
                                            <span class="slider round"></span>
                                        <#else>
                                            <input type="checkbox" value="GoogleAuthenticator" id="idGoogleAuthenticator" name="twoFactorMethodForUser" >
                                            <span class="slider round"></span>
                                        </#if>
                                    </label>
                                    <span style="height:16px; width: 16px">
                                        &nbsp;Mobile Authenticator
                                </span>
                            </td>
                            <td style="width: 25%;">
                                <span style="vertical-align:middle;">
                                    <label class="switch" style="vertical-align:middle;">
                                        <#if (twoFactorMethodForUserList.contains("YubikeyHardwareTokenAsU2F"))>
                                            <input type="checkbox" value="YubikeyHardwareTokenAsU2F" id="idHardwareToken" name="twoFactorMethodForUser" checked="true" >
                                            <span class="slider round"></span>
                                        <#else>
                                            <input type="checkbox" value="YubikeyHardwareTokenAsU2F" id="idHardwareToken" name="twoFactorMethodForUser" >
                                            <span class="slider round"></span>
                                        </#if>
                                    </label>
                                    <span style="height:16px; width: 16px">
                                        &nbsp;Yubikey Hardware Token(U2F)
                                </span>
                            </td>
                            <td style="width: 25%;">
                                <span style="vertical-align:middle;">
                                    <label class="switch" style="vertical-align:middle;">
                                        <#if (twoFactorMethodForUserList.contains("DuoPushNotification"))>
                                            <input type="checkbox" value="DuoPushNotification" id="idPushNotification" name="twoFactorMethodForUser" checked="true" >
                                            <span class="slider round"></span>
                                        <#else>
                                            <input type="checkbox" value="DuoPushNotification" id="idPushNotification" name="twoFactorMethodForUser" >
                                            <span class="slider round"></span>
                                        </#if>
                                    </label>
                                    <span style="height:16px; width: 16px">
                                        &nbsp;Duo Push Notification
                                </span>
                            </td>
                        </tr>
                        <tr>
                        <td>
                            <br>
                        </td>
                        </tr>
                        <tr>
                            <td style="width: 20%;">
                                <span style="vertical-align:middle;">
                                    <label class="switch" style="vertical-align:middle;">
                                        <#if (twoFactorMethodForUserList.contains("WebAuthn"))>
                                            <input type="checkbox" value="WebAuthn" id="idWebAuthn" name="twoFactorMethodForUser" checked="true" >
                                            <span class="slider round"></span>
                                        <#else>
                                            <input type="checkbox" value="WebAuthn" id="idWebAuthn" name="twoFactorMethodForUser" >
                                            <span class="slider round"></span>
                                        </#if>
                                    </label>
                                <span style="height:16px; width: 16px">
                                    &nbsp;Web Authentication
                                </span>
                            </td>
                            <td style="width: 17%;">
                                <span style="vertical-align:middle;">
                                    <label class="switch" style="vertical-align:middle;">
                                        <#if (twoFactorMethodForUserList.contains("OtpOverEmail"))>
                                            <input type="checkbox" value="OtpOverEmail" id="idOtpOverEmail" name="twoFactorMethodForUser" checked="true" >
                                            <span class="slider round"></span>
                                        <#else>
                                            <input type="checkbox" value="OtpOverEmail" id="idOtpOverEmail" name="twoFactorMethodForUser" >
                                            <span class="slider round"></span>
                                        </#if>
                                    </label>
                                    <span style="height:16px; width: 16px">
                                        &nbsp;OTP Over Email
                                </span>
                            </td>
                            <td style="width: 16%;">
                                <span style="vertical-align:middle;">
                                    <label class="switch" style="vertical-align:middle;">
                                        <#if (twoFactorMethodForUserList.contains("OtpOverSms"))>
                                            <input type="checkbox" value="OtpOverSms" id="idOtpOverSms" name="twoFactorMethodForUser" checked="true" >
                                            <span class="slider round"></span>
                                        <#else>
                                            <input type="checkbox" value="OtpOverSms" id="idOtpOverSms" name="twoFactorMethodForUser" >
                                            <span class="slider round"></span>
                                        </#if>
                                    </label>
                                    <span style="height:16px; width: 16px">
                                        &nbsp;OTP Over SMS
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 20%;">
                                <span style="vertical-align:middle;">
                                    <label class="switch" style="vertical-align:middle;">
                                        <#if (twoFactorMethodForUserList.contains("SecurityQuestion"))>
                                            <input type="checkbox" value="SecurityQuestion" id="idSecurityQuestion" name="twoFactorMethodForUser" checked="true" >
                                            <span class="slider round"></span>
                                        <#else>
                                            <input type="checkbox" value="SecurityQuestion" id="idSecurityQuestion" name="twoFactorMethodForUser" >
                                            <span class="slider round"></span>
                                        </#if>
                                    </label>
                                    <span style="height:16px; width: 16px">
                                        &nbsp;Security Question
                                </span>
                            </td>
                        </tr>
                    </table>
                </div>
                <br>
                <div class="field-group" style="padding-left: 200px;">
                    <#if (allowToReconfigureMethod == true)>
                        <input type="checkbox" id="allowToReconfigureMethod" value="true" name="allowToReconfigureMethod"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="allowToReconfigureMethod" value="true" name="allowToReconfigureMethod"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;Allow to reconfigure/reset 2FA method</span>
                    <div class="description">
                        If this option is enabled, user will be able to reconfigure the configured 2FA method.
                    </div>
                </div>
                <br>
                <div class="field-group" style="padding-left: 200px;">
                    <#if (enableEnforceCurrentMethod == true)>
                        <input type="checkbox" id="enableEnforceCurrentMethod" onclick="validateEnforcePrimaryMethod()" value="true" name="enableEnforceCurrentMethod"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="enableEnforceCurrentMethod" onclick="validateEnforcePrimaryMethod()" value="true" name="enableEnforceCurrentMethod"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;Enforce Current/Primary Method for User</span>
                    <div class="description">
                        With this option, admin can forcefully set the primary method for user. So the users are always redirected to the selected 2fa method for validation.
                    </div>
                </div>

                <#if (enableEnforceCurrentMethod == true)>
                <div id="primaryMethodForUserDiv">
                <#else>
                <div id="primaryMethodForUserDiv" style="display:none">
                </#if>
                    <div class="field-group" style="padding-left: 200px;">
                        <label>Primary method for user : </label>
                        <table style="width: 100%;">
                            <tr>
                                <td style="width: 20%;">
                                    <#if (primaryMethodForUser == "GoogleAuthenticator")>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodGoogleAuthenticator" value="GoogleAuthenticator" checked="checked" />
                                    <#else>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodGoogleAuthenticator" value="GoogleAuthenticator" />
                                    </#if>
                                    <label for="primaryMethodGoogleAuthenticator">Mobile Authenticator</label>
                                </td>

                                <td style="width: 25%;">
                                    <#if (primaryMethodForUser == "YubikeyHardwareTokenAsU2F")>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodHardwareToken" value="YubikeyHardwareTokenAsU2F" checked="checked" />
                                    <#else>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodHardwareToken" value="YubikeyHardwareTokenAsU2F" />
                                    </#if>
                                    <label for="primaryMethodHardwareToken">Yubikey Hardware Token(U2F)</label>
                                </td>

                                <td style="width: 25%;">
                                    <#if (primaryMethodForUser == "DuoPushNotification")>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryDuoPushNotification" value="DuoPushNotification" checked="checked" />
                                    <#else>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryDuoPushNotification" value="DuoPushNotification" />
                                    </#if>
                                    <label for="primaryDuoPushNotification">Duo Push Notification</label>
                                </td>


                            </tr>
                            <tr>
                                <td>
                                    <br>
                                </td>
                            </tr>
                            <tr>

                                <td style="width: 20%;">
                                    <#if (primaryMethodForUser == "WebAuthn")>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodWebAuthn" value="WebAuthn" checked="checked" />
                                    <#else>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodWebAuthn" value="WebAuthn" />
                                    </#if>
                                    <label for="primaryMethodWebAuthn">Web Authentication</label>
                                </td>

                                <td style="width: 16%;">
                                    <#if (primaryMethodForUser == "OtpOverEmail")>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodOtpOverEmail" value="OtpOverEmail" checked="checked" />
                                    <#else>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodOtpOverEmail" value="OtpOverEmail" />
                                    </#if>
                                    <label for="primaryMethodOtpOverEmail">OTP Over Email</label>
                                </td>

                                <td style="width: 16%;">
                                    <#if (primaryMethodForUser == "OtpOverSms")>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodOtpOverSms" value="OtpOverSms" checked="checked" />
                                    <#else>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodOtpOverSms" value="OtpOverSms" />
                                    </#if>
                                    <label for="primaryMethodOtpOverSms">OTP Over SMS</label>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <br>
                                </td>
                            </tr>
                            <tr>
                                 <td style="width: 25%;">
                                    <#if (primaryMethodForUser == "SecurityQuestion")>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodSecurityQuestion" value="SecurityQuestion" checked="checked" />
                                    <#else>
                                        <input class="radio" type="radio" name="primaryMethodForUser" id="primaryMethodSecurityQuestion" value="SecurityQuestion" />
                                    </#if>
                                    <label for="primaryMethodSecurityQuestion">Security Question</label>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <br>
                <div class="field-group" style="padding-left: 200px;">
                    <#if (showRemaining2FAMethodsAfterConfiguration == true)>
                        <input type="checkbox" id="showRemaining2FAMethodsAfterConfiguration" value="true" name="showRemaining2FAMethodsAfterConfiguration"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="showRemaining2FAMethodsAfterConfiguration" value="true" name="showRemaining2FAMethodsAfterConfiguration"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;Show Remaining 2FA Method After Configuration/Inline Registration</span>
                    <div class="description">
                        If this is enabled then after successfully configuring one primary and backup method, the end users will see all the remaining 2FA methods(enabled by admin)
                        and they can configure multiple methods.
                    </div>
                </div>
                <br>
                <div class="field-group" style="padding-left: 200px;">
                    <#if (showAllConfiguredMethodsDirectly == true)>
                        <input type="checkbox" id="showAllConfiguredMethodsDirectly" onclick="validateShowAllConfigureMethod()" value="true" name="showAllConfiguredMethodsDirectly"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="showAllConfiguredMethodsDirectly" onclick="validateShowAllConfigureMethod()" value="true" name="showAllConfiguredMethodsDirectly"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;Show All Configured Methods to User for Validation</span>
                    <div class="description">
                        If user has configured multiple 2FA methods then, with this option, user will see the list of all configured 2FA methods while logging in and user can choose
                        any 2FA method for validation. If this option is disabled then user will be redirected to user's primary 2FA method for validation.
                    </div>
                </div>
            </div>

            <br><br>
            <div>
                <h3>Backup Method</h3>
                <div class="field-group" style="padding-left: 145px;">
                    <span style="vertical-align:middle;">
                        <label class="switch" style="vertical-align:middle;">
                            <#if (enableBackupMethod == true)>
                                <input type="checkbox" id="enableBackupMethod" value="true" name="enableBackupMethod"
                                   checked="true"/>
                                <span class="slider round"></span>
                            <#else>
                                <input type="checkbox" id="enableBackupMethod" value="true" name="enableBackupMethod"/>
                                <span class="slider round"></span>
                            </#if>
                        </label>
                        <span style="height:16px; width: 16px">
                            &nbsp;Enable Backup Method For Bamboo users
                    </span>
                </div>

                <div id="backupMethodDiv">
                    <div class="field-group" style="padding-left: 200px;">
                        <table style="width: 100%;">
                            <tr>
                                <td style="width: 25%;">
                                    <#if (backupMethodForUserList.contains("SecurityQuestion"))>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" checked="true" value="SecurityQuestion"
                                               id="backupMethodForUser"/>
                                    <#else>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" value="SecurityQuestion"
                                               id="backupMethodForUser"/>
                                    </#if>
                                    <span>Security Question</span>
                                </td>

                                <td style="width: 25%;">
                                    <#if (backupMethodForUserList.contains("OtpOverEmail"))>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" checked="true" value="OtpOverEmail"
                                               id="backupMethodForUser"/>
                                    <#else>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" value="OtpOverEmail"
                                               id="backupMethodForUser"/>
                                    </#if>
                                    <span>OTP Over Email</span>
                                </td>

                                <td style="width: 25%;">
                                    <#if (backupMethodForUserList.contains("OtpOverSms"))>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" checked="true" value="OtpOverSms"
                                               id="backupMethodForUser"/>
                                    <#else>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" value="OtpOverSms"
                                               id="backupMethodForUser"/>
                                    </#if>
                                    <span>OTP Over SMS</span>
                                </td>

                                <td style="width: 25%;">
                                    <#if (backupMethodForUserList.contains("BackupCode"))>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" checked="true" value="BackupCode"
                                               id="backupMethodForUser"/>
                                    <#else>
                                        <input class="checkbox" type="checkbox" name="backupMethodForUser" value="BackupCode"
                                               id="backupMethodForUser"/>
                                    </#if>
                                    <span>Backup Code</span>
                                </td>

                                <td style="width: 25%;">
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            <div class="field-group">
                </br>
                <input type="submit" id="settings-form-submit" value="Save" class="aui-button aui-button-primary" style="width: 150px;"/>
            </div>
        </form>
    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>