<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
	        AJS.$(document).ready(function() {
	             AJS.$(".aui-nav li").removeClass("aui-nav-selected");
	             AJS.$("#ADVANCEDSETTINGS").addClass("aui-nav-selected");
	             AJS.$('input').css("box-shadow","none");

                AJS.$(document).on('change', '#smsGateway', function () {
                    if(AJS.$("#smsGateway").val() == "miniOrange Gateway"){
                        AJS.$("#custom_gateway_div").hide();
                        AJS.$("#miniorange_gateway_div").show();
                    }else{
                        AJS.$("#miniorange_gateway_div").hide();
                        AJS.$("#custom_gateway_div").show();
                    }
                });

                AJS.$(document).on('click','#bypass2faAfterCrowdSso',function() {
                    if(this.checked) {
                        AJS.$("#bypass2FACookieDomain").prop('disabled', false);
                    } else {
                        AJS.$("#bypass2FACookieDomain").prop('disabled', true);
                    }
                });
	        });
             AJS.$(document).on('click','#ignore2FAAfterSso',function() {
                    if(this.checked) {
                        AJS.$("#ssoLoginUrl").prop('disabled', false);
                    } else {
                        AJS.$("#ssoLoginUrl").prop('disabled', true);
                    }
                });
                AJS.$(document).on('click','#crowdSsoEnabled',function(){
                    if(this.checked){
                        AJS.$("#keyProvidedByCrowdSso").prop('disabled', false);
                        AJS.$("#crowdSsoCookieName").prop('disabled', false);
                    }else{
                        AJS.$("#keyProvidedByCrowdSso").prop('disabled', true);
                        AJS.$("#crowdSsoCookieName").prop('disabled', true);
                    }
                });
        </script>

        <style>
        	h4 {
        		display: block;
        		margin: 30px 65px 0px;
        		font-weight: bold;
        	}

            .aui-page-panel-content{
                padding: 0px !important;
            }

        	.aui-page-panel{
                margin: 0px !important;
                border: 0px solid #dfe1e6;
            }

            .labelClass {
                width: 150px !important;
                margin-left: -160px !important;
            }

            .card{
                border: 2px;
                border-style: solid;
                box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
                transition: 0.3s;
            }

            /* On mouse-over, add a deeper shadow */
            .card:hover {
                box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
            }

            /* Add some padding inside the card container */
            .container {
                padding: 2px 16px;
            }
            .card-body{
                margin: 15px;
            }

            .aui-dialog2-header-main {
                max-width : 100%;
            }

            .aui-message:first-child {
                margin-right: 0px;
            }

        </style>
	</head>

	<body>
	<#include "*/header.ftl" parse=true>
    <div class="tabs-pane active-pane" id="settings"  role="tabpanel" >
        <h2>Advanced Settings</h2>
        <hr class="header"/>

        <form id="settings-form" class="aui long-label" action="" method="POST">
            <input type="hidden" name="settingsSubmitted" value="true"/>
            <input type="hidden" name="atl_token" value="${xsrfToken}" />

            <div id="bruteForceSettingsDiv">
                <h3>Brute Force Configuration</h3>

                <div class="field-group">
                    <#if enableBruteForceProtection == true>
                        <input type="checkbox" id="enableBruteForceProtection" value="true" name="enableBruteForceProtection"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="enableBruteForceProtection" value="true" name="enableBruteForceProtection"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Brute Force Protection for Bamboo
                    </span>
                    <div class="description">The Enable Brute force checkbox allows you to add restrict Bamboo access based on the number of Login Attempts.</div>
                </div>

                <div class="field-group">
                    <label for="bruteForceNumberOfAttempts">Number of Attempts : </label>
                    <#if enableBruteForceProtection == true>
                    <input type="number" id="bruteForceNumberOfAttempts" name="bruteForceNumberOfAttempts"
                          value="${bruteForceNumberOfAttempts}" class="text" min="1" max="10" style="width: 80px;" />
                    <#else>
                    <input type="number" id="bruteForceNumberOfAttempts" name="bruteForceNumberOfAttempts"
                          value="${bruteForceNumberOfAttempts}" class="text" min="1" max="10" style="width: 80px;" disabled/>
                    </#if>
                    <div class="description">Select the number of invalid login attempts to lock the user account.</div>
                </div>

                <div class="field-group">
                    <label>User Locked out Period : </label>
                    <table>
                    <tr>
                    <td>
                    <#if enableBruteForceProtection == true>
                        <select class="select" id="bruteForceTimeInterval" name="bruteForceTimeInterval" style="width: 110px;">
                    <#else>
                        <select class="select" id="bruteForceTimeInterval" name="bruteForceTimeInterval" disabled style="width: 110px;">
                    </#if>
                        <option value="15 minutes" <#if bruteForceTimeInterval.equals("15 minutes")>selected </#if>>15 Minutes</option>
                        <option value="30 minutes" <#if bruteForceTimeInterval.equals("30 minutes")>selected </#if>>30 Minutes</option>
                        <option value="1 hour" <#if bruteForceTimeInterval.equals("1 hour")>selected </#if>>1 Hour</option>
                        <option value="5 hours" <#if bruteForceTimeInterval.equals("5 hours")>selected </#if>>5 Hours</option>
                        <option value="1 day" <#if bruteForceTimeInterval.equals("1 day")>selected </#if>>1 Day</option>
                        <option value="7 days" <#if bruteForceTimeInterval.equals("7 days")>selected </#if>>7 Days</option>
                        <option value="custom" <#if bruteForceTimeInterval.equals("custom")>selected </#if>>Custom</option>
                    </select>
                    </td>

                    <td>
                    <#if bruteForceTimeInterval.equals("custom")>
                        <input type="number" id="bruteForceCustomTimeDuration" name="bruteForceCustomTimeDuration"
                              value="${bruteForceCustomTimeDuration}" class="text" min="1" style="width: 80px; display:block" <#if enableBruteForceProtection != true> disabled </#if> />
                    <#else>
                        <input type="number" id="bruteForceCustomTimeDuration" name="bruteForceCustomTimeDuration"
                              value="${bruteForceCustomTimeDuration}" class="text" min="1" style="width: 80px; display:none" <#if enableBruteForceProtection != true> disabled </#if> />
                    </#if>
                    </td>

                    <td>
                    <#if bruteForceTimeInterval.equals("custom")>
                        <select class="select" id="bruteForceCustomTimeInterval" name="bruteForceCustomTimeInterval" style="width: 100px;display:block" <#if enableBruteForceProtection != true> disabled </#if>>
                    <#else>
                        <select class="select" id="bruteForceCustomTimeInterval" name="bruteForceCustomTimeInterval" style="width: 100px;display:none" <#if enableBruteForceProtection != true> disabled </#if> >
                    </#if>
                        <option value="minutes" <#if bruteForceCustomTimeInterval.equals("minutes")>selected </#if>>Minutes</option>
                        <option value="hours" <#if bruteForceCustomTimeInterval.equals("hours")>selected </#if>>Hours</option>
                        <option value="days" <#if bruteForceCustomTimeInterval.equals("days")>selected </#if>>Days</option>
                        </select>
                    </td>
                    </tr>
                    </table>
                    <div class="description">Once this time is expired, the user will be able to login to Bamboo again.</div>
                </div>
                    <#if (smtpConfigured== true)>
                        <div class="field-group">
                        <label for="emailTemplateBruteForce">Blocked Email Template : </label>
                        <#if enableBruteForceProtection == true>
                            <textarea id="emailTemplateBruteForce" name="emailTemplateBruteForce" class="textarea long-field" style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false">${emailTemplateBruteForce}</textarea>
                        <#else>
                            <textarea id="emailTemplateBruteForce" name="emailTemplateBruteForce" class="textarea long-field" style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false" disabled>${emailTemplateBruteForce}</textarea>
                        </#if>
                        <div class="description">You can customize email template sent to user. Use variable $$ipaddress$$ to add ipaddress in template</div>
                        </div>
                    </#if>
            </div>

            <br><br>
            <div id="rememberMeDeviceSettingsDiv">
                <h3>Remember My Device</h3>

                <div class="field-group">
                    <#if (enableRememberMeDevice == true)>
                        <input type="checkbox" id="enableRememberMeDevice" value="true" name="enableRememberMeDevice"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="enableRememberMeDevice" value="true" name="enableRememberMeDevice"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;
                        Enable Remember My Device for Users
                    </span>
                    <div class="description">The Remember My Device checkbox allows you to ignore 2FA check if the user is trying to log in from the same device.</div>
                </div>

                <div class="field-group">
                    <label for="rememberMeDeviceDuration">Expiry Time (in Days) : </label>
                    <#if (enableRememberMeDevice == true)>
                    <input type="number" id="rememberMeDeviceDuration" name="rememberMeDeviceDuration"
                          value="${rememberMeDeviceDuration}" class="text" min="1" max="365" style="width: 80px;" />
                    <#else>
                    <input type="number" id="rememberMeDeviceDuration" name="rememberMeDeviceDuration"
                          value="${rememberMeDeviceDuration}" class="text" min="1" max="365" style="width: 80px;" disabled/>
                    </#if>
                    <div class="description">Once the time has expired, the device information for that user will be clear.</div>
                </div>
            </div>

            <br><br>
            <div id="urlFilterSettingsDiv">
                <h3>Skip 2FA for APIs running in backend</h3>

                <div class="field-group">
                    <label for="skip2faUrls"> URLs for the backend APIs: </label>
                    <input type="text" id="skip2faUrls" name="skip2faUrls" value="${skip2faUrls}" class="text long-field" />
                    <div class="description">Enter the semicolon separated relative URLs(or part of the URLs) for the APIs which will run in the backend
                        for which you want to skip the 2FA verification</div>
                </div>
            </div>


            <br><br>
             <h3 >One-time 2FA validation in Crowd authentication setups </h3>
             <div class="field-group">

                    <#if (allowByPass2faAfterCrowdSso == false)>
                        <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                            <p class="title">
                                <strong>Warning!</strong>
                            </p>
                            <p>This feature can only be enabled if authentication is done via Crowd.
                            </p>
                        </div>
                    </#if>

                    <input type="checkbox" id="bypass2faAfterCrowdSso" value="true" name="bypass2faAfterCrowdSso"
                           <#if (bypass2faAfterCrowdSso == true)> checked="true" </#if> <#if (allowByPass2faAfterCrowdSso == false)> disabled </#if>>
                            Enable this to allow one time 2FA when users login to multiple applications via Crowd Authentication.
                    <div class="description">2FA will be verified in first application and it will be skipped in all other apps.
                                            <br>
                                            Note: For this feature to work, this option must be enabled in 2FA app on all Crowd connected applications.
                    </div>
                     <label for="keyProvidedByCrowdSso">Crowd SSO Domain : </label>
                     <div>
                         <input type="text" id="bypass2FACookieDomain" name="bypass2FACookieDomain" value="${bypass2FACookieDomain}" class="text long-field"
                                placeholder="Enter the Crowd SSO Domain" <#if (bypass2faAfterCrowdSso != true)> disabled </#if>/>
                         <div class="description">Enter the parent domain for your Crowd deployment. Example: If your crowd domain is mycrowd.mycorp.com, </br>
                             then enter mycorp.com here. Leave this field empty if you want cookies to be set to the domain that requests are made to.</div>
                     </div>

             </div>

            <br><br>
            <div id="advancedSettingsDiv">
                <h3>Mobile Authenticator Settings</h3>
                <div class="field-group">
                    <label for="appLabel">Mobile Authenticator Label: </label>
                    <input type="text" id="appLabel" name="appLabel" value="${appLabel}" class="text long-field" />
                    <div class="description">You can name the authenticator application using Label</div>
                </div>

                <div class="field-group">
                    <#if (showSupportedAppPopup == true)>
                        <input type="checkbox" id="showSupportedAppPopup" value="true" name="showSupportedAppPopup"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="showSupportedAppPopup" value="true" name="showSupportedAppPopup"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;
                        Show supported mobile app popup directly during inline registration
                    </span>
                    <div class="description">If enabled, it will show the supported mobile app popup directly to the user during inline registration.</div>
                    <br>
                    <#if (enableShareSecretKey == true)>
                        <input type="checkbox" id="enableShareSecretKey" value="true" name="enableShareSecretKey"
                           checked="true"/>
                    <#else>
                        <input type="checkbox" id="enableShareSecretKey" value="true" name="enableShareSecretKey"/>
                    </#if>
                    <span style="height:16px; width: 16px">&nbsp;
                        Common passcode (OTP) across all Atlassian applications
                    </span>
                    <div class="description">
                        When enabled, same account in the Mobile Authenticator app can be used for all Atlassian applications.
                        <br>
                        NOTE: Users can use an existing account created in the Mobile Authenticator app, provided they have the secret key associated with that account.
                        <br> If enabled, we suggest you to have a generic and a common Mobile Authenticator Label across all Atlassian applications.
                    </div>
                </div>
            </div>

            <br><br>
            <div id="webAuthnSettingsDiv">
                    <h3>Web Authentication Settings</h3>

                    <br>

                    <div class="field-group">
                        <label>Attestation Type : </label>
                        <select class="select" id="attestationType" name="attestationType" style="width: 200px;">
                            <option value="none" <#if (attestationType.equals("none"))> selected </#if>>None</option>
                            <option value="direct" <#if (attestationType.equals("direct"))> selected </#if>>Direct</option>
                            <option value="indirect" <#if (attestationType.equals("indirect"))> selected </#if>>Indirect</option>
                        </select>
                        <div class="description">
                            Defining the semantics of attestation statements and their underlying trust models
                        </div>
                    </div>

                    <div class="field-group">
                        <label>Authenticator Type : </label>
                        <select class="select" id="authenticatorType" name="authenticatorType" style="width: 200px;">
                            <option value="unspecified" <#if (authenticatorType.equals("unspecified"))> selected </#if>>Unspecified</option>
                            <option value="cross-platform" <#if (authenticatorType.equals("cross-platform"))> selected </#if>>Cross-Platform</option>
                            <option value="platform" <#if (authenticatorType.equals("platform"))> selected </#if>>Platform (TPM)</option>
                        </select>
                        <div class="description">
                            Restrict the type of authenticators allowed for registration
                        </div>
                    </div>

                    <div class="field-group">
                        <label>User Verification : </label>
                        <select class="select" id="userVerification" name="userVerification" style="width: 200px;">
                            <option value="discouraged" <#if (userVerification.equals("discouraged"))> selected </#if>>Discouraged</option>
                            <option value="preferred" <#if (userVerification.equals("preferred"))> selected </#if>>Preferred</option>
                            <option value="required" <#if (userVerification.equals("required"))> selected </#if>>Required</option>
                        </select>
                        <div class="description">
                            User verification for login and registration operation
                        </div>
                    </div>

                    <div class="field-group">
                        <label>Register with Resident Key : </label>
                        <select class="select" id="residentKey" name="residentKey" style="width: 200px;">
                            <option value="false" <#if (residentKey.equals("false"))> selected </#if>>Not Required</option>
                            <option value="true" <#if (residentKey.equals("true"))> selected </#if>>Required</option>
                        </select>
                        <div class="description">
                            Allow logging in by proving a local PIN on the device
                        </div>
                    </div>

            </div>

            <br><br>
            <div id="otpOverEmailSettingsDiv">
                <h3>OTP Over Email Settings</h3>

                <#if (smtpConfigured == false)>
                    <div class="field-group">
                        <div class="aui-message aui-message-warning">
                            <p class="title">
                                <strong>Warning!</strong>
                            </p>
                            <p>As Bamboo's mail server is not configured yet, add-on will not send any mails.
                            You need to configure Bamboo's mail server to use OTP over Email as 2FA.</p>
                            </p>
                        </div>
                    </div>
                </#if>

                <div class="field-group">
                 <label for="emailSubject">Email Subject: </label>
                    <input type="text" id="emailSubject" name="emailSubject" value="${emailSubject}" class="text long-field" />
                    <br><br>
                    <label for="emailTemplate">Email Template/Body : </label>
                    <textarea name="emailTemplate" class="textarea long-field"
                        style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false">${emailTemplate}</textarea>
                    <div class="description">You need to write <b>$$username$$</b> and <b>$$otp$$</b> where you wish to place username & generated otp in this template respectively.</div>
                </div>

                <div class="field-group">
                    <label for="otpLength">OTP Length : </label>
                    <input type="number" id="otpLength" name="otpLength"
                          value="${otpLength}" class="text" min="4" max="8" style="width: 80px;" />
                    <div class="description">Enter the length of OTP. (The OTP length can vary from 4 to 8 characters)</div>
                </div>

                <div class="field-group">
                    <label for="otpValidityDuration">OTP Validity Duration (In Minutes) : </label>
                    <input type="number" id="otpValidityDuration" name="otpValidityDuration"
                          value="${otpValidityDuration}" class="text" min="1" max="10" style="width: 80px;" />
                    <div class="description">Once the time has expired, the OTP will consider as a Invalid.</div>
                </div>
            </div>

            <br><br>
            <div id="otpOverSmsSettingsDiv">
                <h3>OTP Over SMS Settings</h3>

                <div class="field-group">
                    <label for="smsGatewayOptions">SMS Gateway:</label>
                    <select class="select" name="smsGateway" id="smsGateway">
                        <#foreach options in smsGatewayOptions>
                            <option value="${options}" <#if smsGateway.equals(options)>selected </#if> >${options} </option>
                        </#foreach>
                    </select>
                </div>

                <div id="miniorange_gateway_div" <#if (smsGateway == "Custom Gateway")> style="display:none" </#if>>
                    <div class="field-group">
                        <label for="customerKey">Customer Key : </label>
                        <input type="text" id="customerKey" name="customerKey" value="${customerKey}"
                               placeholder="Enter the Customer Key" class="text long-field" />
                    </div>

                    <div class="field-group">
                        <label for="apiKey">Customer API Key : </label>
                        <input type="text" id="apiKey" name="apiKey" value="${apiKey}"
                               placeholder="Enter the API Key" class="text long-field" />
                    </div>
                </div>

                <div id="custom_gateway_div" <#if (smsGateway == "miniOrange Gateway")> style="display:none" </#if>>
                    <#assign hashPhoneString = '##phone##'>
                    <#assign hashMessageString = '##message##'>

                    <div class="field-group">
                        <label for="smsGatewayUrl">SMS Gateway URL : </label>
                        <textarea name="smsGatewayUrl" class="textarea long-field"
                            style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false">${smsGatewayUrl}</textarea>
                        <div class="description">
                            Enter the SMS gateway URL in the field above in order to be able to send OTPs to the user's phone.<br>
                            You need to write <b>${hashPhoneString}</b> and <b>${hashMessageString}</b> where you wish to place phone number & the SMS message respectively.
                        </div>
                    </div>

                    <div class="field-group">
                        <label for="smsTemplate">SMS Template : </label>
                        <textarea name="smsTemplate" class="textarea long-field"
                            style="font-family:Courier New;font-size: 12px;" cols="64" rows="4" spellcheck="false">${smsTemplate}</textarea>
                        <div class="description">
                            This OTP over SMS will be sent in the above format to the user.<br>
                            You need to write <b>$$username$$</b> and <b>$$otp$$</b> where you wish to place username & generated otp in this template respectively.
                        </div>
                    </div>
                </div>
            </div>

            <br><br>
                <div id="pushNotificationSettingsDiv">
                    <h3>Duo Push Notification Settings</h3>
                    <br>

                    <div class="field-group">
                        <label for="duoPushNotificationIntegrationKey">Integration Key: </label>
                        <input type="text" id="duoPushNotificationIntegrationKey" name="duoPushNotificationIntegrationKey" value="${duoPushNotificationIntegrationKey}" class="text long-field" />
                        <div class="description">Add Integration key from Duo.</div>
                    </div>

                    <div class="field-group">
                        <label for="duoPushNotificationSecretKey">Secret Key: </label>
                        <input type="text" id="duoPushNotificationSecretKey" name="duoPushNotificationSecretKey" value="${duoPushNotificationSecretKey}" class="text long-field" />
                        <div class="description">Add Secret key from Duo.</div>
                    </div>

                    <div class="field-group">
                        <label for="duoPushNotificationHostName">Host Name: </label>
                        <input type="text" id="duoPushNotificationHostName" name="duoPushNotificationHostName" value="${duoPushNotificationHostName}" class="text long-field" />
                        <div class="description">Add Hostname from Duo like <b>api-abcd.duosecurity.com</b>. Do not add https in hostname.</div>
                    </div>
                </div>
                <div id="disable2faForSsoUsers">
                    <h3>Skip 2FA on SSO</h3>
                    <div class="field-group">
                        <label for="ignore2FAAfterSso">Skip 2FA for Bamboo SSO Users :</label>
                        <#if (ignore2FAAfterSso == true)>
                            <input type="checkbox" id="ignore2FAAfterSso" value="true" name="ignore2FAAfterSso"
                                checked="true"/>
                        <#else>
                            <input type="checkbox" id="ignore2FAAfterSso" value="true" name="ignore2FAAfterSso"/>
                        </#if>
                                &nbsp; Enable this to skip the 2FA if users login via SSO.
                    </div>
                    <div class="field-group">
                        <label for="ssoLoginUrl">Bamboo SSO Login URL : </label>
                        <input type="text" id="ssoLoginUrl" name="ssoLoginUrl" value="${ssoLoginUrl}" class="text long-field"
                                placeholder="Comma Separated SSO Login Or Callback URL"  <#if ignore2FAAfterSso != true> disabled </#if> />
                        <div class="description">Add comma separated Single Sign on URL (SAML) or Callback URL(OAuth/OpenID) from your SSO provider.</div>
                    </div>
                    <br>
                    <div class="field-group">
                        <label for="crowdSsoEnabled">Skip 2FA for Crowd SSO Users :</label>
                        <#if (crowdSsoEnabled == true)>
                            <input type="checkbox" id="crowdSsoEnabled" value="true" name="crowdSsoEnabled"
                                 checked = "true"/>
                        <#else>
                            <input type="checkbox" id="crowdSsoEnabled" value="true" name="crowdSsoEnabled"/>
                        </#if>
                               &nbsp; Enable this to skip 2FA of users if they login via SSO using miniOrange Crowd SAML addon and Bamboo Crowd connector.
                    </div>
                    <div class="field-group">
                        <label for="keyProvidedByCrowdSso">Secret Key Provided by Crowd SSO : </label>
                        <input type="text" id="keyProvidedByCrowdSso" name="keyProvidedByCrowdSso" value="${keyProvidedByCrowdSso}" class="text long-field"
                            placeholder="Enter a key provided by miniOrange Crowd addon" <#if (crowdSsoEnabled != true)> disabled </#if>/>
                        <div class="description">Add the Secret key provided by the miniOrange Crowd addon.</div>
                    </div>
                    <div class="field-group">
                        <label for="keyProvidedByCrowdSso">Crowd SSO Cookie Name : </label>
                        <input type="text" id="crowdSsoCookieName" name="crowdSsoCookieName" value="${crowdSsoCookieName}" class="text long-field"
                            placeholder="Enter a Crowd SSO Cookie Name" <#if crowdSsoEnabled != true> disabled </#if>/>
                        <div class="description">Add the Crowd SSO Cookie name.</div>
                    </div>
                </div>

            <div class="field-group">
                </br>
                <input type="submit" id="settings-form-submit" value="Save" class="aui-button aui-button-primary" style="width: 150px;"/>
            </div>
        </form>
    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>