
function register(response,isUsernamePassed,origin, attestationType, authenticatorType, userVerification, residentKey){
console.log("response is :- ");
console.log(response);
console.log("response.username is :-" + response.username);
console.log("response.methodUnderConsideration = "+response.methodUnderConsideration);
console.log("attestationType = "+attestationType);
console.log("authenticatorType = "+authenticatorType);
console.log("userVerification = "+userVerification);
console.log("residentKey = "+residentKey);

// 2FA method -- Yubikey Hardware Token
if (response.methodUnderConsideration == "yubikeyHardwareToken") {
    var RawId;
    registerPlatformAuthenticator(response, isUsernamePassed,origin, attestationType, authenticatorType, userVerification, residentKey).then(credential => {
    var RawId;
    const publicKeyCredential = {};
    var username="";
        if(!((typeof isUsernamePassed == 'undefined') || (isUsernamePassed == null))) {
            username = isUsernamePassed;
        }

        if ('id' in credential) {
          publicKeyCredential.id = credential.id;
        }
        if ('type' in credential) {
          publicKeyCredential.type = credential.type;
        }
        if ('rawId' in credential) {
          publicKeyCredential.rawId = binToStr(credential.rawId);
          _fetch(AJS.contextPath() + '/plugins/servlet/webAuthn/DataStore', {
                "action":"setRawId",
                "rawId" : publicKeyCredential.rawId,
                "username" : username
          }).then(response => {
          var rawId = response.rawId;
              console.log("RawId is :- " + rawId);
          });
        }

        const response = {};
        response.clientDataJSON = binToStr(credential.response.clientDataJSON);
        response.attestationObject = binToStr(credential.response.attestationObject);

        // Check for included extensions
        if (credential.getClientExtensionResults) {
          publicKeyCredential.extensions = credential.getClientExtensionResults();
          if (credential.getClientExtensionResults().uvm != null) {
            publicKeyCredential.uvm = serializeUvm(credential.getClientExtensionResults().uvm);
          }
        }

        // Check if transports are included in the registration response.
        if (credential.response.getTransports) {
          response.transports = credential.response.getTransports();
        }

        console.log("Public key is :- ");
        console.log(publicKeyCredential);
        console.log("Response is :- ");
        console.log(response);

        publicKeyCredential.response = response;

        return _fetch( AJS.contextPath() + '/plugins/servlet/webAuthn/MoSaveCredentials', {
          data: JSON.stringify(publicKeyCredential),
          "username" : username,
          "origin" : origin
        });
     }).then(response => {

        console.log(response)

        console.log("origin is :- " + origin);
        var data="";

        if(origin==="login"){
            document.forms["mo-2fa-inline-registration-form"].submit();
        }
        else{
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
            data: {
                "method": "YubikeyHardwareTokenAsU2F",
                "isWebAuthn": "true"
            },
            type: "POST",
            success: function (response) {
                if (response.status == 200) {
                    console.log("Successfully configured Yubikey Hardware Token.");
                } else {
                    console.log("Issue with configuring Yubikey Hardware Token.");
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    console.log("Successfully configured Yubikey Hardware Token.");
                } else {
                    console.log("Issue with configuring Yubikey Hardware Token.");
                }
            }
        });
        var html = '<div id="idSuccessMessage" class="aui-message aui-message-success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Hardware Token.</p></div>';
        AJS.$(html).insertBefore("#u2f-hardware-token-configuration-form");

        AJS.$("#showAfterSuccessHardwareToken").show();
        AJS.$("#u2f-hardware-token-configuration-form").hide();

        AJS.$('#u2f-hardware-token-form-close_1').focus();

        }
        return true;
     }).catch(err => {
        console.log("Error occurred in register Catch:- " + err);
         var errMsg1 = String(err);

         var a = document.getElementsByClassName("aui-flag");
         for (var i=a.length-1;i>=0;i--) {
             a[i].remove();
         }
         require('aui/flag')({
             title: 'Error!',
             type: 'error',
             close: 'auto',
             body: errMsg1 + " : " + response.rpId
         });

        if(origin==="login"){
            AJS.$("#hardware-token-main-div").show();
            AJS.$("#hardware-token-touch-key-div").hide();
        }
        else{
         AJS.$("#hardware-token-main-div").show();
         AJS.$("#register_new_credential").show();
         AJS.$("#u2f-hardware-token-form-close").show();
         AJS.$("#hardware-token-touch-key-div").hide();
         AJS.$("#showAfterSuccessHardwareToken").hide();
        }
        return false;
     });
}
else {
    // 2FA method - Web Authentication
    var RawId;
    registerPlatformAuthenticator(response, isUsernamePassed, origin, attestationType, authenticatorType, userVerification, residentKey).then(credential => {

    var RawId;
    const publicKeyCredential = {};
    var username="";
        if(!((typeof isUsernamePassed == 'undefined') || (isUsernamePassed == null))) {
            username = isUsernamePassed;
        }

        if ('id' in credential) {
          publicKeyCredential.id = credential.id;
        }
        if ('type' in credential) {
          publicKeyCredential.type = credential.type;
        }
        if ('rawId' in credential) {
          publicKeyCredential.rawId = binToStr(credential.rawId);
          _fetch(AJS.contextPath() + '/plugins/servlet/webAuthn/DataStore', {
                "action":"setRawId",
                "rawId" : publicKeyCredential.rawId,
                "username" : username
          }).then(response => {
          var rawId = response.rawId;
              console.log("RawId is :- " + rawId);
          });
        }

        const response = {};
        response.clientDataJSON = binToStr(credential.response.clientDataJSON);
        response.attestationObject = binToStr(credential.response.attestationObject);

        // Check for included extensions
        if (credential.getClientExtensionResults) {
          publicKeyCredential.extensions = credential.getClientExtensionResults();
          if (credential.getClientExtensionResults().uvm != null) {
            publicKeyCredential.uvm = serializeUvm(credential.getClientExtensionResults().uvm);
          }
        }

        // Check if transports are included in the registration response.
        if (credential.response.getTransports) {
          response.transports = credential.response.getTransports();
        }

        console.log("Public key is :- ");
        console.log(publicKeyCredential);
        console.log("Response is :- ");
        console.log(response);

        publicKeyCredential.response = response;

        return _fetch( AJS.contextPath() + '/plugins/servlet/webAuthn/MoSaveCredentials', {
          data: JSON.stringify(publicKeyCredential),
          "username" : username,
          "origin" : origin
        });
     }).then(response => {

        console.log("response = "+response);

        console.log("origin is :- " + origin);
        var data="";

        if(origin==="login"){
            document.forms["mo-2fa-inline-registration-form-web-authn"].submit();
        }
        else{
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
            data: {
                "method": "WebAuthn"
            },
            type: "POST",
            success: function (response) {
                if (response.status == 200) {
                    console.log("Successfully Configured Web Authentication as a 2FA method.");
                } else {
                    console.log("Issue with configuring Web Authentication as a 2FA method.");
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    console.log("Successfully Configured Web Authentication as a 2FA method.");
                } else {
                    console.log("Issue with configuring Web Authentication as a 2FA method.");
                }
            }
        });
        var html2 = '<div id="idSuccessMessage" class="aui-message aui-message-success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Web Authentication as a 2FA method.</p></div>';
        var html1 = '<header class="aui-dialog2-header" style="height:50px;"><h2 class="aui-dialog2-header-main">CONFIGURE 2FA - Web Authentication</h2></header>';

        AJS.dialog2("#webauthn-config-dialog").show();
        AJS.$(html1).insertBefore("#card-details");
        AJS.$(html2).insertBefore("#differentiate-web-authn-methods-info");
        document.getElementById("differentiate-web-authn-methods-info").style.display="none";
        document.getElementById("user_config").style.display="none";
        AJS.$('#webauthn-config-close').focus();
        console.log("Success!");
        document.getElementById("wait_div").style.display="none";
        }
        return true;
     }).catch(err => {
        console.log("Error occured in register Catch:- " + err);
         var errMsg1 = String(err);

         var a = document.getElementsByClassName("aui-flag");
         for (var i=a.length-1;i>=0;i--) {
             a[i].remove();
         }
         require('aui/flag')({
             title: 'Error!',
             type: 'error',
             close: 'auto',
             body: errMsg1 + " : " + response.rpId
         });

        if(origin==="login"){
            document.getElementById("wait_div").style.display="none";
            AJS.$("#mo-2fa-inline-registration-form-web-authn").show();
            AJS.$("#2fa-inline-webauthn-2fa-method-registration-form-submit").show();
            AJS.$("#logoutLink").show();
        }
        else{
            document.getElementById("wait_div").style.display="none";
            AJS.$("#configure-webAuthn-as-second-factor-button").show();
            AJS.$("#register_new_credential_for_webauthn2fa").show();
            AJS.$("#clear_previous_credential").show();
        }
        return false;
     });
    }
}

function register1(username,origin, methodUnderConsideration, attestationType, authenticatorType, userVerification, residentKey){
    if (methodUnderConsideration == "yubikeyHardwareToken") {
        if(origin==="login"){
            console.log("Calling registerDevice from login");
            AJS.$("#hardware-token-main-div").hide();
            AJS.$("#hardware-token-touch-key-div").show();

            require('aui/flag')({
                title: 'Configure Yubikey Hardware Token',
                type: 'info',
                close: 'manual',
                body: '<p>Insert Your Security Key & Touch it.</p>'
            });
        }
        return getCableData(register,username,origin, methodUnderConsideration, attestationType, authenticatorType, userVerification, residentKey);
    }
    else {
        if(origin==="login"){
            console.log("Calling webAuthn from login");

            require('aui/flag')({
                title: 'Configure WebAuthn as 2FA method',
                type: 'info',
                close: 'auto',
                body: '<p>Register your system authenticator.</p>'
            });
        }
        return getCableData(register,username,origin, methodUnderConsideration, attestationType, authenticatorType, userVerification, residentKey);
    }
}

function registerPlatformAuthenticator(response, isUsernamePassed, origin, attestationType, authenticatorType, userVerification, residentKey){
        const makeCredentialOptions = {};

          console.log("Response is :- ");
          console.log(response);
          var user = response.userName;
          user = user.trim();
          makeCredentialOptions.rp = { id:response.rpId , name:response.rpName };
          console.log(user);
                makeCredentialOptions.user = {       id: strToBin(response.userId),
                                                     name: user,
                                                     displayName: user
                                             };

          if (response.methodUnderConsideration == "yubikeyHardwareToken") {
          // Consider Yubikey Hardware Token as 2fa method
                makeCredentialOptions.authenticatorSelection = {
//                                                                    attestation: "none",
                                                                    authenticatorAttachment: "cross-platform",
                                                                    requireResidentKey: false,
                                                                    userVerification: "discouraged"
                                                            };
          }
          else {
          // Consider Web Authn as 2fa method
              if (authenticatorType == "unspecified") {
                makeCredentialOptions.authenticatorSelection = {
                                                                  attestation: attestationType,
                                                                  requireResidentKey: residentKey,
                                                                  userVerification: userVerification
                                                                  };
              }
              else {
                makeCredentialOptions.authenticatorSelection = {
                                                                  attestation: attestationType,
                                                                  authenticatorAttachment: authenticatorType,
                                                                  requireResidentKey: residentKey,
                                                                  userVerification: userVerification
                                                               };
              }
          }

    //    makeCredentialOptions.user.id = strToBin(options.user.id);
        makeCredentialOptions.user.id = Uint8Array.from(window.atob(response.userId), c=>c.charCodeAt(0));
        makeCredentialOptions.challenge = new Uint8Array([21,31,105 /* 29 more random bytes generated by the server */]);
        makeCredentialOptions.pubKeyCredParams =   [
                                                     {
                                                       type: "public-key",
                                                       alg: -7 // "ES256" as registered in the IANA COSE Algorithms registry
                                                     },
                                                     {
                                                       type: "public-key",
                                                       alg: -35 // Value registered by this specification for "RS256"
                                                     },
                                                     {
                                                        type: "public-key",
                                                        alg: -36 // Value registered by this specification for "RS256"
                                                      },
                                                     {
                                                        type: "public-key",
                                                        alg: -257 // Value registered by this specification for "RS256"
                                                      },
                                                     {
                                                        type: "public-key",
                                                        alg: -258 // Value registered by this specification for "RS256"
                                                      },
                                                     {
                                                        type: "public-key",
                                                        alg: -259 // Value registered by this specification for "RS256"
                                                      },
                                                     {
                                                        type: "public-key",
                                                        alg: -37 // Value registered by this specification for "RS256"
                                                      },
                                                     {
                                                        type: "public-key",
                                                        alg: -38 // Value registered by this specification for "RS256"
                                                      },
                                                     {
                                                        type: "public-key",
                                                        alg: -39 // Value registered by this specification for "RS256"
                                                      },
                                                   ];
        makeCredentialOptions.extensions = response.result;
        makeCredentialOptions.extensions.cableRegistration.rpPublicKey =
        strToBin(makeCredentialOptions.extensions.cableRegistration.rpPublicKey);
        console.log(makeCredentialOptions);

try{
 return navigator.credentials.create({
       "publicKey": makeCredentialOptions
     });
}catch(e){
    var errMsg = String(e);
    console.log("Error occured in register function :- " + e);
    if(errMsg==="TypeError: navigator.credentials is undefined"){
        errMsg = "SSL setup is required or server should be running on a localhost for Registration";
    }

        if((typeof isUsernamePassed == 'undefined') || (isUsernamePassed == null)){
            document.getElementById("err_div").style.display="block";
            document.getElementById("wait_div").style.display="none";
            document.getElementById("err_div_msg").innerHTML = errMsg;

        }
        else{
           document.getElementById("err_div").style.display="block";
           document.getElementById("wait_div").style.display="none";
           document.getElementById("err_div_msg").innerHTML = errMsg;
        }

    try{

    }
    catch(err){

    }
}

}

function binToStr(bin) {
  return btoa(new Uint8Array(bin).reduce(
    (s, byte) => s + String.fromCharCode(byte), ''
  ));
}

function strToBin(str) {
  return Uint8Array.from(atob(str), c => c.charCodeAt(0));
}

function authenticate1(user, methodUnderConsideration){

    console.log("user in authenticate1() = "+user);
    console.log("methodUnderConsideration in authenticate1() = "+methodUnderConsideration);

    var a = document.getElementsByClassName("aui-flag");
     for (var i=a.length-1;i>=0;i--) {
         a[i].remove();
     }

    if (methodUnderConsideration == "yubikeyHardwareToken") {
         require('aui/flag')({
             title: 'Validate Yubikey Hardware Token',
             type: 'info',
             close: 'manual',
             body: '<p>Insert Your Security Key & Touch it.</p>'
         });

         AJS.$("#hardware-token-main-div").hide();
         AJS.$("#validationButtonsDiv").hide();
         AJS.$("#hardware-token-touch-key-div").show();
    } else {
        require('aui/flag')({
            title: 'Validate System authenticator',
            type: 'info',
            close: 'auto',
            body: '<p>Validate your registered system authenticator to login.</p>'
        });
    }

     _fetch(AJS.contextPath() + '/plugins/servlet/webAuthn/DataStore', {
          action:"getRawId",
          username:user
    }).then(response => {
        console.log("Response received is");
        console.log(response);

        const requestOptions = {};
        requestOptions.challenge = strToBin(response.challenge);
        requestOptions.rpId = response.rpId;
       requestOptions.allowCredentials = credentialListConversion(response.allowCredential);

        console.log("Sending assertion request is :- ");
        console.log(requestOptions);

        return navigator.credentials.get({
              "publicKey": requestOptions
        });
    }).then(assertion => {
        console.log('received assertion response:');
        console.log(assertion);
        const publicKeyCredential = {};

        if ('id' in assertion) {
          publicKeyCredential.id = assertion.id;
        }
        if ('type' in assertion) {
          publicKeyCredential.type = assertion.type;

        }
        if ('rawId' in assertion) {
          publicKeyCredential.rawId = binToStr(assertion.rawId);
        }
        if (!assertion.response) {

          throw "Get assertion response lacking 'response' attribute";
        }
        if (assertion.getClientExtensionResults) {
          if (assertion.getClientExtensionResults().uvm != null) {
            publicKeyCredential.uvm = serializeUvm(assertion.getClientExtensionResults().uvm);
          }
        }


        const _response = assertion.response;

        publicKeyCredential.response = {
          clientDataJSON:     binToStr(_response.clientDataJSON),
          authenticatorData:  binToStr(_response.authenticatorData),
          signature:          binToStr(_response.signature),
          userHandle:         binToStr(_response.userHandle)
        };

        console.log("FinishGetAssertion :- ");
            console.log(publicKeyCredential);

         return _fetch(AJS.contextPath() + '/plugins/servlet/webAuthn/FinishAssertion', {
            data: JSON.stringify(publicKeyCredential),
            username: user
         });

    }).then(response => {
        console.log("Response after successful assertion :- ");
//
//        window.setTimeout(function(){
//            window.location.href = AJS.contextPath();
//        }, 2000);
//        successFullAssertion(user);
document.forms["mo-2fa-validate-form"].submit();
        console.log(response);
        if (methodUnderConsideration != "yubikeyHardwareToken") {
            document.getElementById("wait_div").style.display="none";
        }
    }).catch(err => {
        console.log("Error occured :- + " + err);
        var errMsg = String(err);
            if(errMsg==="TypeError: navigator.credentials is undefined"){
                errMsg = "Please make sure your SSL is set up or server is running on a localhost ";
            }
        var a = document.getElementsByClassName("aui-flag");
         for (var i=a.length-1;i>=0;i--) {
             a[i].remove();
         }
         require('aui/flag')({
             title: 'Error!',
             type: 'error',
             close: 'auto',
             body: errMsg
         });

        if (methodUnderConsideration == "yubikeyHardwareToken") {
            AJS.$("#hardware-token-main-div").show();
            AJS.$("#validationButtonsDiv").show();
            AJS.$("#hardware-token-touch-key-div").hide();
        } else {
            document.getElementById("wait_div").style.display="none";
            AJS.$("#2fa-validate-form-submit").show();
            AJS.$("#showOtherMethods").show();
            AJS.$("#logoutLink").show();
        }
    });
}

function success(){
    console.log("In success function");
}

function authenticate(){

}

function getContextPath(){
    return window.location.pathname.substring(0, window.location.pathname.indexOf("/",2));
}

function credentialListConversion(list) {
  // Filter unchecked credentials
  const filteredList = list.filter((element) => {
    try {
      const base64Id = '#switch-'.concat(element.id.replace(/\+/g, '-')
          .replace(/\//g,'_').replace(/=/g,'')).replace(/=/g, '');
      if (isChecked(base64Id)) {
        return true;
      } else {
        return false;
      }
    } catch(e) {
      return true;
    }
  });

  return filteredList.map(item => {
    const cred = {
      type: item.type,
      id: strToBin(item.id)
    };
    if (item.transports) {
      const newTransportList = [];
      // Filter out unchecked transports
      for (transport of item.transports) {
        try {
          // The transport id is the transport name concatenated with the
          // corresponding key handle
          const base64Id = '#'.concat(transport, item.id.replace(/\+/g, '-')
              .replace(/\//g,'_').replace(/=/g,''));
          if (isChecked(base64Id)) {
            newTransportList.push(transport);
          }
        } catch(e) {};
      }
      if (newTransportList.length) {
        cred.transports = newTransportList;
      }
    }
    return cred;
  });
}
function getCableData(_callback,username,origin, methodUnderConsideration, attestationType, authenticatorType, userVerification, residentKey){
    console.log(" username :- " + username);
    console.log("methodUnderConsideration = "+methodUnderConsideration);
    AJS.$
      .ajax({
          url: AJS.contextPath()
              + "/plugins/servlet/webAuthn/MoSecureUtil",
          type: "GET",
          data: {
               "action" : "cableRegistrationData",
               "username": username,
               "methodUnderConsideration": methodUnderConsideration
          },
          error: function () {
              console.log("Get configuration response status : ERROR");
              if((typeof username == 'undefined') || (username == null)){
                document.getElementById("err_div").style.display="block";
                document.getElementById("wait_div").style.display="none";
              } else {
                    document.getElementById("err_div").style.display="block";
                    document.getElementById("wait_div").style.display="none";
              }
              return false;
          },
          success: function (response) {
            console.log("Response send successfully");
            _callback(response,username,origin, attestationType, authenticatorType, userVerification, residentKey);
          }
      });
}

function _fetch(url, obj) {
  let headers = new Headers({
    'Content-Type': 'application/x-www-form-urlencoded'
  });
  let body;
  if (typeof URLSearchParams === "function") {
    body = new URLSearchParams();
    for (let key in obj) {
      body.append(key, obj[key]);
    }
    // Set body to string value to handle an Edge case
    body = body.toString();
  } else {
    // Add parameters to body manually if browser doesn't support URLSearchParams
    body = "";
    for (let key in obj) {
      body += encodeURIComponent(key) + "=" + encodeURIComponent(obj[key]) + "&";
    }
  }
  return fetch(url, {
    method: 'POST',
    headers: headers,
    credentials: 'include',
    body: body
  }).then(response => {
    if (response.status === 200) {
      return response.json();
    } else {
      throw response.statusText;
    }
  });
}

function serializeUvm(uvm) {
  var uvmJson = new Array();
  for (var i = 0; i < uvm.length; i ++) {
    const uvmEntry = {};
    uvmEntry.userVerificationMethod = uvm[i][0];
    uvmEntry.keyProtectionType = uvm[i][1];
    uvmEntry.atchuvmJsonerProtectionType = uvm[i][2];
    uvmJson.push(uvmEntry);
  }
  return uvmJson;
}

function checkUserRegistration(username,login_form,waiting_form,methodUnderConsideration){

    console.log("username in checkUserRegistration = "+username);
    console.log("methodUnderConsideration in checkUserRegistration = "+methodUnderConsideration);

    authenticate1(username, methodUnderConsideration);

    AJS.$
      .ajax({
          url: AJS.contextPath()
              + "/plugins/servlet/webAuthn/DataStore",
          type: "GET",
          data: {
               "action" : "CheckUserIsRegistered",
               "username" : username
          },
          error: function () {
              console.log("Get configiration response status : ERROR");
              return false;
          },
          success: function (response) {
          if(response.isUserActive){
                    if(response.checkUserIsRegistered){
                        if(response.isWebauthnDisabled){
                             $('#error_note').text('Sorry!! Admin has disabled Web Authentication for you.');
                             AJS.$("#waiting_form").hide();
                             AJS.$("#webauthn_note").hide();
                             AJS.$("#webauthn-form").show();
                             AJS.$("#webauthn_error_note").show();
                        }
                        else{
                            authenticate1(username, methodUnderConsideration);
                        }
                        return true;
                    }
                    else{
                        if((typeof response.doesUserExist == 'undefined') || (response.doesUserExist == null)){
                             $('#error_note').text('User Does not exist');
                             console.log("Inside else of checkUserIsRegistered");
                        }
                        else{
                            if(response.isWebauthnDisabled){
                                $('#error_note').text('Sorry!! Admin has disabled Web Authentication for you.');
                            }
                            else{
                                 $('#error_note').text('User Have not registered yet');
                                console.log("Should show inline registration");
                                AJS.$("#inline_registration").show();
                                AJS.$("#back-to-login-form").hide();
                                AJS.$("#webauthn-login").hide();
                                AJS.$("#tempId").hide();
//                                document.getElementById("inline_registration").style.display="block";
                            }
                        }
                        AJS.$("#waiting_form").hide();
                        AJS.$("#webauthn_note").hide();
                        AJS.$("#webauthn-form").show();
                        AJS.$("#webauthn_error_note").show();
                    }
                        return false;
              }
              else{
                    if((typeof response.doesUserExist == 'undefined') || (response.doesUserExist == null)){
                         $('#error_note').text('User Does not exist');
                    }
                    else{
                         $('#error_note').text('User is not Active');
                    }
                    waiting_form = "#" + waiting_form;
                    AJS.$("#waiting_form").hide();
                    AJS.$("#webauthn_note").hide();
                    AJS.$("#webauthn-form").show();
                    AJS.$("#webauthn_error_note").show();
                    return false;
              }
          }
      });
}

function clear12(){
    console.log("In the clear function");
    AJS.$
      .ajax({
          url: AJS.contextPath()
              + "/plugins/servlet/webAuthn/DataStore",
          type: "GET",
          async : false,
          data: {
               "action" : "clearPlugin"
          },
          error: function () {
              console.log("Get configiration response status : ERROR");
              return false;
          },
          success: function (response) {
                alert("CLear plugin settings successfully");
          }
      });
}

function printMap(){
    AJS.$
      .ajax({
          url: AJS.contextPath()
              + "/plugins/servlet/webAuthn/DataStore",
          type: "GET",
          async : false,
          data: {
               "action" : "printMap"
          },
          error: function () {
              console.log("Get configiration response status : ERROR");
              return false;
          },
          success: function (response) {

          }
      });
}

function yubikeyU2FRegisterActionSubmit(data) {
        console.log("Inside the yubikeyU2fRegisterActionSubmit");
        console.log(data);

        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/configure2famethods",
            data: {
                "method": "YubikeyHardwareTokenAsU2F"
            },
            type: "GET",
            success: function (response) {
                if (response.status == 200) {
                    console.log("Successfully configured Yubikey Hardware Token.");
                } else {
                    console.log("Issue with configuring Yubikey Hardware Token.");
                }
            },
            error: function (response) {
                if (response.status == 200) {
                    console.log("Successfully configured Yubikey Hardware Token.");
                } else {
                    console.log("Issue with configuring Yubikey Hardware Token.");
                }
            }
        });
    var html = '<div id="idSuccessMessage" class="aui-message aui-message-success"><p class="title"><strong>Success!</strong></p><p>You have successfully configured Hardware Token.</p></div>';
    AJS.$(html).insertBefore("#u2f-hardware-token-configuration-form");

    AJS.$("#showAfterSuccessHardwareToken").show();
    AJS.$("#u2f-hardware-token-configuration-form").hide();

    AJS.$('#u2f-hardware-token-form-close_1').focus();
    }





