<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <style>
            h4 {
                display: block;
                margin: 30px 65px 0px;
                font-weight: bold;
            }

            .aui-page-panel-content{
                padding: 0px !important;
            }

            .aui-page-panel{
                margin: 0px !important;
                border: 0px solid #dfe1e6;
            }

            .labelClass {
                width: 150px !important;
                margin-left: -160px !important;
            }

            .card{
                border: 2px;
                border-style: solid;
                box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
                transition: 0.3s;
            }

            /* On mouse-over, add a deeper shadow */
            .card:hover {
                box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
            }

            /* Add some padding inside the card container */
            .container {
                padding: 2px 16px;
            }
            .card-body{
                margin: 15px;
            }

            .aui-dialog2-header-main {
                max-width : 100%;
            }

            .aui-message:first-child {
                margin-right: 0px;
            }

            .mo-loading {
                background-image: url(/s/en_US/61008/1/3.0.4/_/download/resources/com.atlassian.upm.atlassian-universal-plugin-manager-plugin:upm-web-resources/images/throbber.gif);
                background-repeat: no-repeat;
                min-height: 30px;
            }
        </style>
        <script>
	        AJS.$(document).ready(function() {
	             AJS.$(window).scrollTop(0);
	             AJS.$(".aui-nav li").removeClass("aui-nav-selected");
	             AJS.$("#ADAPTIVEAUTHENTICATION").addClass("aui-nav-selected");
	             AJS.$('input').css("box-shadow","none");
	        });

	        function performActionChange(selectedAction) {
                console.log("Calling performActionChange For : "+selectedAction);
                jQuery.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
                    timeout: 0,
                    data: {
                        "action": "ChangeIpManagementSelectedAction",
                        "selectedAction": selectedAction
                    },
                    type: "POST",
                    success: function (response) {
                        var currentLocation = window.location.pathname;
                        window.location.href = currentLocation;
                    },
                    error: function (response) {
                        var currentLocation = window.location.pathname;
                        window.location.href = currentLocation;
                    },
                    async: true
                });
            }

            function removeWhitelistIp(ipAddress, ipAddressMessage)  {
                console.log("Calling removeWhitelistIp For : "+ipAddress);
                jQuery.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
                    timeout: 0,
                    data: {
                        "action": "RemoveWhitelistIp",
                        "ipAddress": ipAddress,
                        "ipAddressMessage": ipAddressMessage
                    },
                    type: "POST",
                    success: function (response) {
                        performRemoveWhitelistIp(response, ipAddress);
                    },
                    error: function (response) {
                        performRemoveWhitelistIp(response, ipAddress);
                    },
                    async: true
                });
            }

            function performRemoveWhitelistIp(response, ipAddress) {
                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Whitelist IP',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Removed IP : '+ipAddress+'</p>'
                    });
                    setTimeout(function() {
                        window.location.href = window.location.pathname;
                    }, 2000);
                } else {
                    require('aui/flag')({
                        title: 'Whitelist IP',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with removing IP : '+ipAddress+'</p>'
                    });
                }
            }

            function removeBlacklistIp(ipAddress, ipAddressMessage) {
                console.log("Calling removeBlacklistIp For : "+ipAddress);
                jQuery.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
                    timeout: 0,
                    data: {
                        "action": "RemoveBlacklistIp",
                        "ipAddress": ipAddress,
                        "ipAddressMessage": ipAddressMessage
                    },
                    type: "POST",
                    success: function (response) {
                        performRemoveBlacklistIp(response, ipAddress);
                    },
                    error: function (response) {
                        performRemoveBlacklistIp(response, ipAddress);
                    },
                    async: true
                });
            }

            function performRemoveBlacklistIp(response, ipAddress) {
                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Blacklist IP',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Removed IP : '+ipAddress+'</p>'
                    });
                    setTimeout(function() {
                        window.location.href = window.location.pathname;
                    }, 2000);
                } else {
                    require('aui/flag')({
                        title: 'Blacklist IP',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with removing IP : '+ipAddress+'</p>'
                    });
                }
            }

            function toggleAllWhitelistIps() {
                var isChecked = document.getElementById("selectAllWhitelistIps").checked;
                var startIndex = document.getElementById("startIndex").value;
                var endIndex = document.getElementById("endIndex").value - 1;

                for (var i=startIndex;i<=endIndex;i++) {
                    document.getElementById("selectedWhitelistIp"+i).checked = isChecked;
                }
            }

            function toggleAllBlacklistIps() {
                var isChecked = document.getElementById("selectAllBlacklistIps").checked;
                var startIndex = document.getElementById("startIndex").value;
                var endIndex = document.getElementById("endIndex").value - 1;

                for (var i=startIndex;i<=endIndex;i++) {
                    document.getElementById("selectedBlacklistIp"+i).checked = isChecked;
                }
            }

            function performBulkIpAction() {
                var action = document.getElementById("bulkIpAction");
                console.log("Action : "+action.value);
                if (action.value =="") {
                    document.getElementById("bulkIpAction").style.borderColor = "red";
                    alert("Please select valid Bulk Action");
                } else {
                    document.getElementById("bulkIpAction").style.borderColor = "";
                    console.log("Selected Action : "+action.value);
                    var startIndex = document.getElementById("startIndex").value;
                    var endIndex = document.getElementById("endIndex").value - 1;
                    switch (action.value) {
                        case "Delete Selected Whitelist IPs":
                            deleteSelectedWhitelistIps(startIndex, endIndex);
                            break;
                        case "Delete All Whitelist IPs":
                            deleteAllWhitelistIps();
                            break;
                        case "Delete Selected Blacklist IPs":
                            deleteSelectedBlacklistIps(startIndex, endIndex);
                            break;
                        case "Delete All Blacklist IPs":
                            deleteAllBlacklistIps();
                            break;
                    }
                }
            }

            function deleteSelectedWhitelistIps(startIndex, endIndex) {
                console.log("Calling deleteSelectedWhitelistIps");
                var isIpSelected = false;
                var selectedWhitelistIps = new Array();
                for (var i=startIndex;i<=endIndex;i++) {
                    var isChecked = document.getElementById("selectedWhitelistIp"+i).checked;
                    if (isChecked == true) {
                        isIpSelected = true;
                        selectedWhitelistIps.push(document.getElementById("selectedWhitelistIp"+i).value);
                    }
                }

                if (isIpSelected == true) {
                    require('aui/flag')({
                        title: 'Removing IPs',
                        type: 'info',
                        close: 'never',
                        body: '<p>We are currently Removing Selected IPs Whitelist in background. You can still access Bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
                    });
                    jQuery.ajax({
                        url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
                        timeout: 0,
                        data: {
                            "action": "RemoveSelectedWhitelistIps",
                            "selectedWhitelistIps":selectedWhitelistIps
                        },
                        type: "POST",
                        success: function (response) {
                            performDeleteSelectedWhitelistIps(response);
                        },
                        error: function (response) {
                            performDeleteSelectedWhitelistIps(response);
                        },
                        async: true
                    });
                } else {
                    require('aui/flag')({
                         title: 'Removing IPs',
                         type: 'error',
                         close: 'auto',
                         body: '<p>No IP is selected. Please select valid IP.</p>'
                    });
                }
            }

            function performDeleteSelectedWhitelistIps(response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }
                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Removing IPs',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Removed selected IPs from Whitelist.</p>'
                    });

                    setTimeout(function() {
                        window.location.href = window.location.pathname;
                    }, 2000);
                } else {
                    require('aui/flag')({
                        title: 'Removing IPs',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with Removing IPs from Whitelist.</p>'
                    });
                }
            }


            function deleteSelectedBlacklistIps(startIndex, endIndex) {
                console.log("Calling deleteSelectedBlacklistIps");
                var isIpSelected = false;
                var selectedBlacklistIps = new Array();
                for (var i=startIndex;i<=endIndex;i++) {
                    var isChecked = document.getElementById("selectedBlacklistIp"+i).checked;
                    if (isChecked == true) {
                        isIpSelected = true;
                        selectedBlacklistIps.push(document.getElementById("selectedBlacklistIp"+i).value);
                    }
                }

                if (isIpSelected == true) {
                    require('aui/flag')({
                        title: 'Removing IPs',
                        type: 'info',
                        close: 'never',
                        body: '<p>We are currently Removing Selected Blacklist IPs in background. You can still access Bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
                    });
                    jQuery.ajax({
                        url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
                        timeout: 0,
                        data: {
                            "action": "RemoveSelectedBlacklistIps",
                            "selectedBlacklistIps":selectedBlacklistIps
                        },
                        type: "POST",
                        success: function (response) {
                            performDeleteSelectedBlacklistIps(response);
                        },
                        error: function (response) {
                            performDeleteSelectedBlacklistIps(response);
                        },
                        async: true
                    });
                } else {
                    require('aui/flag')({
                         title: 'Removing IPs',
                         type: 'error',
                         close: 'auto',
                         body: '<p>No IP is selected. Please select valid IP.</p>'
                    });
                }
            }

            function performDeleteSelectedBlacklistIps(response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }
                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Removing IPs',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Removed selected IPs from Blacklist.</p>'
                    });

                    setTimeout(function() {
                        window.location.href = window.location.pathname;
                    }, 2000);
                } else {
                    require('aui/flag')({
                        title: 'Removing IPs',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with Removing IPs from Blacklist.</p>'
                    });
                }
            }

            function deleteAllWhitelistIps() {
                console.log("Calling deleteAllWhitelistIps");
                require('aui/flag')({
                    title: 'Removing IPs',
                    type: 'info',
                    close: 'never',
                    body: '<p>We are currently Removing All Whitelist IPs in background. You can still access Bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
                });
                jQuery.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
                    timeout: 0,
                    data: {
                        "action": "RemoveAllWhitelistIps"
                    },
                    type: "POST",
                    success: function (response) {
                        performRemoveAllWhitelistIps(response);
                    },
                    error: function (response) {
                        performRemoveAllWhitelistIps(response);
                    },
                    async: true
                });
            }

            function performRemoveAllWhitelistIps(response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }
                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Removing IPs',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Removed All IPs from Whitelist.</p>'
                    });

                    setTimeout(function() {
                        window.location.href = window.location.pathname;
                    }, 2000);
                } else {
                    require('aui/flag')({
                        title: 'Removing IPs',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with Removing All IPs from Whitelist.</p>'
                    });
                }
            }

            function deleteAllBlacklistIps() {
                console.log("Calling deleteAllBlacklistIps");
                require('aui/flag')({
                    title: 'Removing IPs',
                    type: 'info',
                    close: 'never',
                    body: '<p>We are currently Removing All Blacklist IPs in background. You can still access Bamboo, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
                });
                jQuery.ajax({
                    url: AJS.contextPath() + "/plugins/servlet/twofactor/moapi",
                    timeout: 0,
                    data: {
                        "action": "RemoveAllBlacklistIps"
                    },
                    type: "POST",
                    success: function (response) {
                        performRemoveAllBlacklistIps(response);
                    },
                    error: function (response) {
                        performRemoveAllBlacklistIps(response);
                    },
                    async: true
                });
            }

            function performRemoveAllBlacklistIps(response) {
                var a = document.getElementsByClassName("aui-flag");
                for (var i=a.length-1;i>=0;i--) {
                    a[i].remove();
                }
                if (response.status == 200) {
                    require('aui/flag')({
                        title: 'Removing IPs',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Removed All IPs from Blacklist.</p>'
                    });

                    setTimeout(function() {
                        window.location.href = window.location.pathname;
                    }, 2000);
                } else {
                    require('aui/flag')({
                        title: 'Removing IPs',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with Removing All IPs from Blacklist.</p>'
                    });
                }
            }

            function showIPAddress() {
                 require('aui/flag')({
                    title: 'Two Factor Authentication',
                    type: 'info',
                    body: '<p>Your Current IP Address is <strong>${currentIPAddress}</strong></p>'
                });
            }
        </script>

        <style type="text/css">
        	h4 {
        		display: block;
        		margin: 30px 65px 0px;
        		font-weight: bold;
        	}

        	a:hover {
                cursor:pointer;
            }

            .pill-nav {
                margin-top: 20px;
            }

            .pill-nav a {
                display: inline-block;
                color: black;
                text-align: center;
                padding: 14px;
                text-decoration: none;
                font-size: 15px;
                border-radius: 5px;
                background: #cec9c9;
            }

            .pill-nav a:hover {
                background-color: #ddd;
                color: black;
            }

            .pill-nav a.active {
                background-color: #0052cc;
                color: white;
            }

            .tab a {
                cursor: pointer;
                padding: 14px 16px;
                font-size: 17px;
                margin-left:1%;
            }
        </style>
	</head>

	<body>
    <#include "*/header.ftl" parse=true>
    <div class="tabs-pane active-pane" id="settings"  role="tabpanel" >
        <h2>IP Restrictions</h2>
        <div id="idpConfiguration">
            <nav class="aui-navgroup aui-navgroup-horizontal" id="min_topmenu">
                <div class="aui-navgroup-inner">
                    <div id="navbar" class="aui-navgroup-primary">
                        <div class="tab tab-config">
                            <ul class="aui-nav">
                                <li>
                                    <#if ipManagementSelectedAction == "WhitelistIpAction">
                                        <a class="tablinks active" onclick="performActionChange('WhitelistIpAction')">IP Whitelisting</a>
                                    <#else>
                                        <a class="tablinks" onclick="performActionChange('WhitelistIpAction')">IP Whitelisting</a>
                                    </#if>
                                </li>
                                <li>
                                    <#if ipManagementSelectedAction == "BlacklistIpAction">
                                    <a class="tablinks active" onclick="performActionChange('BlacklistIpAction')">IP Blocking</a>
                                    <#else>
                                        <a class="tablinks" onclick="performActionChange('BlacklistIpAction')">IP Blocking</a>
                                    </#if>
                                </li>
                            </ul>
                        </div>
                         <div style="position: absolute; right: 0;">
                            <input type="button" value='Show IP Address' class="aui-button aui-button-primary" onclick='showIPAddress()'>
                         </div>
                    </div>
                </div>
            </nav>
            <br>

            <#if (ipManagementSelectedAction == "WhitelistIpAction") >
                <div id="ipWhitelistingDiv">
                    <div class="aui-message aui-message-info">
                        <p id="whitelist-action-main-inst" >
                            IP whitelisting is a security feature that is often only used for trusted users who can directly log into Bamboo without asking for 2FA.</br>
                            If the request comes from the configured IP address then the plugin will consider the user as a Trusted user & it will not ask for the 2FA for that user.
                        </p>

                        <p>
                            You can use the below steps for adding IP address as a Whitelist IP address.
                            <ol>
                                <li>Add IP address against IP Address textbox</li>
                                <li>Click on Add IP button</li>
                            </ol>
                        </p>

                        <p>
                            Refer below to find out which IP address is considered a valid IP address.
                        </p>
                        <div id="valid-ip-recommendation">
                            <ol>
                                <li>
                                    It accepts only IPv4 addresses.
                                </li>
                                <li>
                                    You can enter the initials of IP address such as 172.16 or 172.16.254 or 172.16.254.2<br>
                                    So that it allows All IP Addresses which start with 172.16 or 172.16.254
                                </li>
                                <li>
                                    IP address can be entered in CIDR Notation such as 172.16.254.2/24<br>
                                    This will allow All IP Addressess which start with 172.16.254.0 to 172.16.254.255
                                </li>
                                <li>
                                    If you enter other than above format then that IP will be considered as an Invalid Address.
                                </li>
                            </ol>
                        </div>
                    </div>

                    <form id="ip-whitelisting-form" class="aui long-label" action="" method="POST">
                        <input type="hidden" name="atl_token" value="${xsrfToken}" />
                        <input type="hidden" name="whiteListIpFormSubmitted" value="true"/>

                        <div class="field-group">
                            <label for="ipAddress">IP Address :</label>
                            <input type="text" id="ipAddress" name="ipAddress" value="" placeholder="Enter IP Address to add" class="text long-field" style="width: 235px">&nbsp;&nbsp;

                        </div>

                        <div class="field-group">
                            <label for="ipAddressMessage">IP Comment :</label>
                            <input type="text" id="ipAddressMessage" name="ipAddressMessage" value="" placeholder="Enter a comment for this IP Address" class="text long-field" style="width: 235px">&nbsp;&nbsp;
                        </div>

                        <div class="field-group">
                            <input type="submit" value="Add IP" class="aui-button aui-button-primary" resolved="">
                        </div>
                        </br>
                    </form>
                    <form id="RequestedHeader" class="aui long-label" action="" method="POST" Style="margin-top:-2px; margin-bottom:40px">
                        <input type="hidden" name="atl_token" value="${xsrfToken}" />
                        <input type="Hidden" name="ClientRequestedIPHeaderSubmitted" value="true"/>
                        <div class="field-group">
                            <label for="clientIpRequestHeader"> HTTP Request Header Name: </label>

                             <select class="select" id="clientIpRequestHeader" name="clientIpRequestHeader">
                                <#foreach iterator in displayRequestHeader.keySet()>
                                    <#if clientIpRequestHeader.equals(iterator)>
                                        <option value="${iterator}"  selected>${iterator}</option>
                                    <#else>
                                        <option value="${iterator}">${iterator}</option>
                                    </#if>

                                </#foreach>
                             </select>

                             <button data-aui-trigger aria-controls="more-details" class="aui-button">
                                 View HTTP Request
                             </button>

                             <aui-inline-dialog id="more-details" aria-label="dialog" style="width:350px; height:350px; overflow-y:scroll; overflow-x:hidden; overflow-wrap: anywhere;">
                                 <div class="aui-inline-dialog-contents" style="box-shadow: none;">
                                 <#foreach iterator in displayRequestHeader.keySet()>
                                     <p><b>${iterator} :</b> &nbsp; ${displayRequestHeader.get(iterator)}</p>
                                 </#foreach>
                                 </div>
                             </aui-inline-dialog>
                             <input type="Submit" value="Save" class="aui-button aui-button-primary"/>
                        </div>
                        <div class="description" style="margin-left: 250px;">Enter the name of the header parameter in which the client IP is received in the HTTP Request. </br>
                        This feature will allow you to perform IP restrictions on those IPs using Proxy Servers to access Bamboo.</div>
                    </form>
                    <form id="ip-blacklisting-form" class="aui long-label" action="" method="POST">
                        <input type="hidden" name="whiteListIpFormSubmitted" value="false"/>
                        <input type="hidden" name="atl_token" value="${xsrfToken}" />
                        <div class ="field-group">
                            <label for="whiteListIpSearchKeyword">Search for IP Address :</label>
                            <input type="text"  id="whiteListIpSearchKeyword" name="whiteListIpSearchKeyword" value="${whiteListIpSearchKeyword}"
                                   placeholder="Enter IP Address for Search" class="text long-field" style="width: 200px"/>&nbsp;&nbsp;
                            <input type='submit' value='Search' id='search-group-button' class="aui-button aui-button-primary"/>
                        </div>

                        </br>
                        <#if (currentPageWhiteListIpAddressWithMessagesMap.size() > 0)>
                            <div class ="field-group" style="padding-left: 92px;">
                                <p>
                                    Bulk IP Action :&nbsp;
                                    <select class="select" name="bulkIpAction" id="bulkIpAction" class="bulkIpAction" style="width: 155px;">
                                        <option value="">Select Bulk Action</option>
                                        <optgroup label="Selected IPs">
                                            <option value="Delete Selected Whitelist IPs">Delete IPs</option>
                                        </optgroup>
                                        <optgroup label="All IPs">
                                            <option value="Delete All Whitelist IPs">Delete IPs</option>
                                        </optgroup>
                                    </select>&nbsp;
                                    <input type='button' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return performBulkIpAction()"/>&nbsp;
                                </p>

                                <hr class="header"/>
                                <table class="aui">
                                    <thead>
                                        <tr>
                                            <th id="number">
                                                <input type="checkbox" value="true" name="selectAllWhitelistIps" id="selectAllWhitelistIps" onclick="return toggleAllWhitelistIps()"/> &nbsp;
                                                #
                                            </th>
                                            <th id="whitelistIpAddress">IP Address</th>
                                            <th id="whiteListIpComment">IP Comment</th>
                                            <th id="action">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <input type="hidden" value="${startIndex}" id="startIndex"/>
                                        <#assign loopCount = startIndex>
                                        <#foreach iterator in currentPageWhiteListIpAddressWithMessagesMap.keySet()>
                                            <#assign trId = "trwhitelist"+loopCount>
                                            <tr id="${trId}">
                                                <td headers="number">
                                                    <#assign selectedWhitelistIp = "selectedWhitelistIp"+loopCount>
                                                    <input type="checkbox" value="${iterator}" name="selectedWhitelistIp" id="${selectedWhitelistIp}"/> &nbsp;
                                                    ${loopCount}
                                                </td>

                                                <td headers="whitelistIpAddress">${iterator}</td>
                                                <td headers="whiteListIpComment">${currentPageWhiteListIpAddressWithMessagesMap.get(iterator)}</td>
                                                <td headers="action">
                                                    <p>
                                                        <span>
                                                            <a onclick="return removeWhitelistIp('${iterator}','${currentPageWhiteListIpAddressWithMessagesMap.get(iterator)}')">Remove</a>
                                                        </span>
                                                    </p>
                                                </td>
                                            </tr>
                                            <#assign loopCount = loopCount + 1>
                                        </#foreach>
                                        <input type="hidden" value="${loopCount}" id="endIndex"/>
                                    </tbody>
                                </table>
                                </br>
                                <table style="width:100%">
                                    <tr>
                                        <td>
                                            <p>Displaying IPs <strong>${startIndex}</strong> to
                                            <#if (whitelistIpAddressWithMessagesMap.size() < endIndex)>
                                                <strong>${whitelistIpAddressWithMessagesMap.size()}</strong>
                                            <#else>
                                                <strong>${endIndex}</strong>
                                            </#if>
                                            of <strong>${whitelistIpAddressWithMessagesMap.size()}</strong>.</p>
                                        </td>
                                        <td>
                                            <#if (whitelistIpAddressWithMessagesMap.size() > numberOfRecordsPerPage)>
                                                <ol class="aui-nav aui-nav-pagination">
                                                    <#if (selectedPage != 1)>
                                                        <#assign prevStartIndex = startIndex - numberOfRecordsPerPage>
                                                        <#assign prevEndIndex = endIndex - numberOfRecordsPerPage>
                                                        <li class="aui-nav-previous"><a href="adaptiveauthentication.action?startIndex=${prevStartIndex}&endIndex=${prevEndIndex}&whiteListIpSearchKeywordUrl=${whiteListIpSearchKeyword}">&lt;&lt; Prev</a></li>
                                                    </#if>

                                                    <#assign loopCount = 1>

                                                    <#foreach currentPage in numberOfPagesList>
                                                        <#assign currentPageEndIndex = loopCount * numberOfRecordsPerPage>
                                                        <#assign currentPageStartIndex = currentPageEndIndex - numberOfRecordsPerPage + 1>
                                                        <#if (selectedPage == loopCount)>
                                                            <li class="aui-nav-selected">${loopCount}</li>
                                                        <#else>
                                                            <li><a href="adaptiveauthentication.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&whiteListIpSearchKeywordUrl=${whiteListIpSearchKeyword}">${loopCount}</a></li>
                                                        </#if>
                                                        <#assign loopCount = loopCount + 1>
                                                    </#foreach>

                                                    <#if (selectedPage != numberOfPagesList.size())>
                                                        <#assign nextStartIndex = startIndex + numberOfRecordsPerPage>
                                                        <#assign nextEndIndex = endIndex + numberOfRecordsPerPage>
                                                        <li class="aui-nav-next"><a href="adaptiveauthentication.action?startIndex=${nextStartIndex}&endIndex=${nextEndIndex}&whiteListIpSearchKeywordUrl=${whiteListIpSearchKeyword}">Next &gt;&gt;</a></li>
                                                    </#if>
                                                </ol>
                                            </#if>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        <#else>
                            <div class ="field-group" style="padding-left: 92px;">
                                <hr class="header"/>
                                <table class="aui">
                                    <thead>
                                        <tr>
                                            <th id="number">#</th>
                                            <th id="whitelistIpAddress">IP Address</th>
                                            <th id="whiteListIpComment">IP Comment</th>
                                            <th id="action">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="4">
                                                <p style="width:100%" align="center">
                                                    No Whitelisted IPs found.
                                                </p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </#if>
                    </form>
                </div> <!--End of Whitelist IP Details Div -->
            <#else>
                <div id="ipBlacklistingDiv">
                    <div class="aui-message aui-message-info">
                        <p id="blacklist-action-main-inst" >
                            An IP blacklist or block-list is a basic access control mechanism which blocks access to Bamboo Application based on the IP address. It will deny access for those IPs which are listed here.</br>
                            If the request comes from the configured IP address then the plugin will consider the IP as a spam & it will never give access to Bamboo.
                        </p>

                        <p>
                            You can use the below steps for adding IP address as a Blacklist IP address.
                            <ol>
                                <li>Add IP address against IP Address textbox</li>
                                <li>Click on Add IP button</li>
                            </ol>
                        </p>

                        <p>
                            Refer below to find out which IP address is considered a valid IP address.
                        </p>
                        <div id="valid-ip-recommendation">
                            <ol>
                                <li>
                                    It accepts only IPv4 addresses.
                                </li>
                                <li>
                                    You can enter the initials of IP address such as 172.16 or 172.16.254 or 172.16.254.2<br>
                                    So that it allows All IP Addresses which start with 172.16 or 172.16.254
                                </li>
                                <li>
                                    IP address can be entered in CIDR Notation such as 172.16.254.2/24<br>
                                    This will allow All IP Addressess which start with 172.16.254.0 to 172.16.254.255
                                </li>
                                <li>
                                    If you enter other than above format then that IP will be considered as an Invalid Address.
                                </li>
                            </ol>
                        </div>
                    </div>

                    <form id="ip-blacklisting-form" class="aui long-label" action="" method="POST">
                        <input type="hidden" name="atl_token" value="${xsrfToken}" />
                        <input type="hidden" name="blackListIpFormSubmitted" value="true"/>

                        <div class="field-group">
                            <label for="ipAddress">IP Address :</label>
                            <input type="text" id="ipAddress" name="ipAddress" value="" placeholder="Enter IP Address to add" class="text long-field" style="width: 235px">&nbsp;&nbsp;
                        </div>

                        <div class="field-group">
                            <label for="ipAddressMessage">IP Comment :</label>
                            <input type="text" id="ipAddressMessage" name="ipAddressMessage" value="" placeholder="Enter a comment for this IP Address" class="text long-field" style="width: 235px">&nbsp;&nbsp;
                        </div>

                        <div class="field-group">
                            <input type="submit" value="Add IP" class="aui-button aui-button-primary" resolved="">
                        </div>
                    </form>
                    <form id="RequestedHeader" class="aui long-label" action="" method="POST" Style="margin-top:-2px; margin-bottom:40px">
                        <input type="hidden" name="atl_token" value="${xsrfToken}" />
                        <input type="Hidden" name="ClientRequestedIPHeaderSubmitted" value="true"/>
                        <div class="field-group">
                            <label for="clientIpRequestHeader"> HTTP Request Header Name: </label>

                             <select class="select" id="clientIpRequestHeader" name="clientIpRequestHeader">
                                <#foreach iterator in displayRequestHeader.keySet()>
                                    <#if clientIpRequestHeader.equals(iterator)>
                                        <option value="${iterator}"  selected>${iterator}</option>
                                    <#else>
                                        <option value="${iterator}">${iterator}</option>
                                    </#if>

                                </#foreach>
                             </select>

                             <button data-aui-trigger aria-controls="more-details" class="aui-button">
                                 View HTTP Request
                             </button>

                             <aui-inline-dialog id="more-details" aria-label="dialog" style="width:350px; height:350px; overflow-y:scroll; overflow-x:hidden; overflow-wrap: anywhere;">
                                 <div class="aui-inline-dialog-contents" style="box-shadow: none;">
                                 <#foreach iterator in displayRequestHeader.keySet()>
                                     <p><b>${iterator} :</b> &nbsp; ${displayRequestHeader.get(iterator)}</p>
                                 </#foreach>
                                 </div>
                             </aui-inline-dialog>
                             <input type="Submit" value="Save" class="aui-button aui-button-primary"/>
                        </div>
                        <div class="description" style="margin-left: 250px;">Enter the name of the header parameter in which the client IP is received in the HTTP Request. </br>
                        This feature will allow you to perform IP restrictions on those IPs using Proxy Servers to access Bamboo.</div>
                    </form>
                    <form id="ip-blacklisting-form" class="aui long-label" action="" method="POST">
                        <input type="hidden" name="atl_token" value="${xsrfToken}" />
                        <input type="hidden" name="blackListIpFormSubmitted" value="false"/>
                        <div class ="field-group">
                            </br>
                            <label for="blackListIpSearchKeyword">Search for IP Address :</label>
                            <input type="text"  id="blackListIpSearchKeyword" name="blackListIpSearchKeyword" value="${blackListIpSearchKeyword}"
                                   placeholder="Enter IP Address for Search" class="text long-field" style="width: 200px"/>&nbsp;&nbsp;
                            <input type='submit' value='Search' id='search-group-button' class="aui-button aui-button-primary"/>
                        </div>

                        </br>
                        <#if (currentPageBlackListIpAddressWithMessagesMap.size() > 0)>
                            <div class ="field-group" style="padding-left: 92px;">
                                <p>
                                    Bulk IP Action :&nbsp;
                                    <select class="select" name="bulkIpAction" id="bulkIpAction" class="bulkIpAction" style="width: 155px;">
                                        <option value="">Select Bulk Action</option>
                                        <optgroup label="Selected IPs">
                                            <option value="Delete Selected Blacklist IPs">Delete IPs</option>
                                        </optgroup>
                                        <optgroup label="All IPs">
                                            <option value="Delete All Blacklist IPs">Delete IPs</option>
                                        </optgroup>
                                    </select>&nbsp;
                                    <input type='button' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return performBulkIpAction()"/>&nbsp;
                                </p>

                                <hr class="header"/>
                                <table class="aui">
                                    <thead>
                                        <tr>
                                            <th id="number">
                                                <input type="checkbox" value="true" name="selectAllBlacklistIps" id="selectAllBlacklistIps" onclick="return toggleAllBlacklistIps()"/> &nbsp;
                                                #
                                            </th>
                                            <th id="blacklistIpAddress">IP Address</th>
                                            <th id="blackListIpComment">IP Comment</th>
                                            <th id="action">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <input type="hidden" value="${startIndex}" id="startIndex"/>
                                        <#assign loopCount = startIndex>
                                        <#foreach iterator in currentPageBlackListIpAddressWithMessagesMap.keySet()>
                                            <#assign trId = "trbacklist"+loopCount>
                                            <tr id="${trId}">
                                                <td headers="number">
                                                    <#assign selectedBlacklistIp = "selectedBlacklistIp"+loopCount>
                                                    <input type="checkbox" value="${iterator}" name="selectedBlacklistIp" id="${selectedBlacklistIp}"/> &nbsp;
                                                    ${loopCount}
                                                </td>
                                                <td headers="blacklistIpAddress">${iterator}</td>
                                                <td headers="blackListIpComment">${currentPageBlackListIpAddressWithMessagesMap.get(iterator)}</td>
                                                <td headers="action">
                                                    <p>
                                                        <span>
                                                            <a onclick="return removeBlacklistIp('${iterator}', '${currentPageBlackListIpAddressWithMessagesMap.get(iterator)}')">Remove</a>
                                                        </span>
                                                    </p>
                                                </td>
                                            </tr>
                                            <#assign loopCount = loopCount + 1>
                                        </#foreach>
                                        <input type="hidden" value="${loopCount}" id="endIndex"/>
                                    </tbody>
                                </table>
                                </br>
                                <table style="width:100%">
                                    <tr>
                                        <td>
                                            <p>Displaying IPs <strong>${startIndex}</strong> to
                                            <#if (blacklistIpAddressWithMessagesMap.size() < endIndex)>
                                                <strong>${blacklistIpAddressWithMessagesMap.size()}</strong>
                                            <#else>
                                                <strong>${endIndex}</strong>
                                            </#if>
                                            of <strong>${blacklistIpAddressWithMessagesMap.size()}</strong>.</p>
                                        </td>
                                        <td>
                                            <#if (blacklistIpAddressWithMessagesMap.size() > numberOfRecordsPerPage)>
                                                <ol class="aui-nav aui-nav-pagination">
                                                    <#if (selectedPage != 1)>
                                                        <#assign prevStartIndex = startIndex - numberOfRecordsPerPage>
                                                        <#assign prevEndIndex = endIndex - numberOfRecordsPerPage>
                                                        <li class="aui-nav-previous"><a href="adaptiveauthentication.action?startIndex=${prevStartIndex}&endIndex=${prevEndIndex}&blackListIpSearchKeywordUrl=${blackListIpSearchKeyword}">&lt;&lt; Prev</a></li>
                                                    </#if>

                                                    <#assign loopCount = 1>

                                                    <#foreach currentPage in numberOfPagesList>
                                                        <#assign currentPageEndIndex = loopCount * numberOfRecordsPerPage>
                                                        <#assign currentPageStartIndex = currentPageEndIndex - numberOfRecordsPerPage + 1>
                                                        <#if (selectedPage == loopCount)>
                                                            <li class="aui-nav-selected">${loopCount}</li>
                                                        <#else>
                                                            <li><a href="adaptiveauthentication.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&blackListIpSearchKeywordUrl=${blackListIpSearchKeyword}">${loopCount}</a></li>
                                                        </#if>
                                                        <#assign loopCount = loopCount + 1>
                                                    </#foreach>

                                                    <#if (selectedPage != numberOfPagesList.size())>
                                                        <#assign nextStartIndex = startIndex + numberOfRecordsPerPage>
                                                        <#assign nextEndIndex = endIndex + numberOfRecordsPerPage>
                                                        <li class="aui-nav-next"><a href="adaptiveauthentication.action?startIndex=${nextStartIndex}&endIndex=${nextEndIndex}&blackListIpSearchKeywordUrl=${blackListIpSearchKeyword}">Next &gt;&gt;</a></li>
                                                    </#if>
                                                </ol>
                                            </#if>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        <#else>
                            <div class ="field-group" style="padding-left: 92px;">
                                <hr class="header"/>
                                <table class="aui">
                                    <thead>
                                        <tr>
                                            <th id="number">#</th>
                                            <th id="blacklistIpAddress">IP Address</th>
                                            <th id="blackListIpComment">IP Comment</th>
                                            <th id="action">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="4">
                                                <p style="width:100%" align="center">
                                                    No Blacklisted IPs found.
                                                </p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </#if>
                    </form>
                </div> <!--End of Blacklist IP Details Div -->
            </#if>
        </div>
    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>