    <!DOCTYPE html>
    <html>
    <head>
        <meta name="decorator" content="atl.general"/>
        <style>
            <#include "*/css/knowledgebase.css" parse=true>
            <#include "*/css/video.css" parse=true>
        </style>
       
        <script>
            let lastScrollY = window.scrollY;

            AJS.$(function() {
                AJS.$(".aui-nav li").removeClass("aui-nav-selected");
                AJS.$("#mo-knowledge-base").addClass("aui-nav-selected");
            });
            function alterKnowledgeBaseView(viewName) {
                lastScrollY = window.scrollY;
                localStorage.setItem('lastActiveTab', viewName);

                document.querySelectorAll('.view-section').forEach(section => {
                    section.classList.remove('active');
                });

                ['documentation_tab', 'videos_tab', 'faq_tab', 'handbook_tab'].forEach(id => {
                    const tab = document.getElementById(id);
                    if (tab) {
                        tab.classList.remove('aui-nav-selected');
                    }
                });

                const section = document.getElementById(viewName + 'View');
                if (section) section.classList.add('active');

                const tab = document.getElementById(viewName + '_tab');
                if (tab) tab.classList.add('aui-nav-selected');

                setTimeout(() => {
                    window.scrollTo(0, lastScrollY);
                }, 0);
            }

            document.addEventListener('DOMContentLoaded', function() {
                const lastTab = localStorage.getItem('lastActiveTab') || 'videos';
                alterKnowledgeBaseView(lastTab);
            });
        </script>
        
    </head>
    <body>
    <#include "*/saml/headers/samlheader.ftl" parse=true>
    <div style="padding: 20px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif; background: var(--background-primary);">
        <div class="aui-page-panel-inner">
            <div id="mo-configure" class="aui-tabs horizontal-tabs" role="application">
                <nav class="aui-navgroup aui-navgroup-horizontal">
                    <div class="aui-navgroup-inner" style="padding: 0px !important;">
                        <div class="aui-navgroup-primary">
                            <div id="saml-navigation-links" style="font-size: 17px">
                                <ul class="aui-nav">
                                    <li id="documentation_tab">
                                        <a id="card1" onclick="alterKnowledgeBaseView('documentation')" style="outline: none; box-shadow: none;">
                                            <strong>Documentation</strong>
                                        </a>
                                    </li>
                                    <li id="videos_tab">
                                        <a id="card1" onclick="alterKnowledgeBaseView('videos')" style="outline: none; box-shadow: none;">
                                            <strong>Videos</strong>
                                        </a>
                                    </li>
                                    <li id="faq_tab">
                                        <a id="card2" onclick="alterKnowledgeBaseView('faq')" style="outline: none; box-shadow: none;">
                                            <strong>FAQ</strong>
                                        </a>
                                    </li>
                                    <li id="handbook_tab">
                                        <a id="handbook_tab_link" href="https://developers.miniorange.com/docs/atlassian/saml-sso/overview" target="_blank" style="outline: none; box-shadow: none;">
                                            <strong>Handbook</strong>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </nav>
            </div>
        </div>

        <div id="videosView" class="view-section">
            <div class="video-section" style="margin-top: 30px;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px;">
                    <div style="display: flex; align-items: center; gap: 8px;">
                        <svg width="32" height="32" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="vertical-align: middle;">
                            <path d="M23.498 6.186a2.997 2.997 0 0 0-2.11-2.116C19.37 3.5 12 3.5 12 3.5s-7.37 0-9.388.57A2.997 2.997 0 0 0 .502 6.186C0 8.21 0 12 0 12s0 3.79.502 5.814a2.997 2.997 0 0 0 2.11 2.116C4.63 20.5 12 20.5 12 20.5s7.37 0 9.388-.57a2.997 2.997 0 0 0 2.11-2.116C24 15.79 24 12 24 12s0-3.79-.502-5.814zM9.545 16.02V7.98L16.182 12l-6.637 4.02z" fill="#FF0000"/>
                        </svg>
                        <h2 style="font-size: 20px; color: var(--text-primary); margin: 0;">Use Case Videos</h2>
                    </div>
                </div>

                <#assign demoVideoContent = [
                {
                    "src": "https://modemo.miniorange.com/static/media/overview-of-miniorange-saml-sso-scim-app.e8ce4c1421de77c42150.webp",
                    "description": "Overview of miniOrange SAML SSO & SCIM App",
                    "link": "https://www.youtube.com/watch?v=Tfvrfqw70dU&t=4s"
                },
                {
                    "src": "https://modemo.miniorange.com/static/media/customize-login-sso-error-pages-look-feel-in-miniorange-saml-sso.da6fe2db295b8823542e.webp",
                    "description": "Customize Login & SSO Error Pages",
                    "link": "https://www.youtube.com/watch?v=AZqiaQo1sLw"
                }
                ]>

                <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px;">
                    <#list demoVideoContent as content>
                        <a href="${content.link}" target="_blank" class="video-card-link">
                            <div class="video-card">
                                <div class="video-card-image-container">
                                    <img src="${content.src}" alt="${content.description}" class="video-card-static-image">
                                </div>
                                <div class="video-card-content">
                                    <p class="video-card-title">${content.description}</p>
                                </div>
                            </div>
                        </a>
                        <#--  <a href="${content.link}" target="_blank" style="text-decoration: none; display: block; color: inherit;">
                                <div style="border: 2px solid var(--border-color); border-radius: 4px; overflow: hidden; background: var(--card-background);">
                                    <div style="position: relative;">
                                    <img src="${content.src}" alt="#" style="width: 100%; height: 100%; object-fit: cover;">
                                </div>
                                <div style="padding: 20px;">
                                    <p style="font-weight: bold;font-size: 12px; color: var(--text-secondary); margin: 0 0 12px 0; line-height: 1.4;">${content.description}</p>
                                </div>
                            </div>
                        </a>  -->
                    </#list>
                </div>
            </div>
            <br>
            <hr>
            <div class="video-section" style="margin-top: 30px;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px;">
                    <div style="display: flex; align-items: center; gap: 8px;">
                        <svg width="32" height="32" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="vertical-align: middle;">
                            <path d="M23.498 6.186a2.997 2.997 0 0 0-2.11-2.116C19.37 3.5 12 3.5 12 3.5s-7.37 0-9.388.57A2.997 2.997 0 0 0 .502 6.186C0 8.21 0 12 0 12s0 3.79.502 5.814a2.997 2.997 0 0 0 2.11 2.116C4.63 20.5 12 20.5 12 20.5s7.37 0 9.388-.57a2.997 2.997 0 0 0 2.11-2.116C24 15.79 24 12 24 12s0-3.79-.502-5.814zM9.545 16.02V7.98L16.182 12l-6.637 4.02z" fill="#FF0000"/>
                        </svg>
                        <h2 style="font-size: 20px; color: var(--text-primary); margin: 0;">Setup Videos</h2>
                    </div>
                </div>

                <#assign setupVideoContent = [
                {
                    "src": "https://i.ytimg.com/vi/gazUrFaku4Y/hqdefault.jpg",
                    "description": "SAML Single Sign On (SSO) into Bamboo using any IDP",
                    "link": "https://www.youtube.com/embed/gazUrFaku4Y"
                }
                ]>

                <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px;">
                    <#list setupVideoContent as content>
                    <a href="${content.link}" target="_blank" class="video-card-link">
                        <div class="video-card">
                            <div class="video-card-image-container">
                                <img src="${content.src}" alt="${content.description}" class="video-card-static-image" style="width: 100%; object-fit: cover;">
                            </div>
                            <div class="video-card-content">
                                <p class="video-card-title">${content.description}</p>
                            </div>
                        </div>
                    </a>

                        <#--  <a href="${content.link}" target="_blank" style="text-decoration: none; display: block; color: inherit;">
                            <div style="border: 2px solid var(--border-color); border-radius: 4px; overflow: hidden; background: var(--card-background); display: flex; flex-direction: column; height: 266px;">
                                <div style="position: relative; height: 100%;">
                                    <iframe width="100%" height="100%" src="${content.link}" frameborder="0" allowfullscreen></iframe>
                                </div>
                                <div style="padding: 20px;">
                                    <p style="font-weight: bold; font-size: 12px; color: var(--text-secondary); margin: 0; line-height: 1.4; overflow: hidden; display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical;">
                                        ${content.description}
                                    </p>
                                </div>
                            </div>
                        </a>  -->
                    </#list>
                </div>
            </div>
        </div>
        <div id="documentationView" class="view-section">
            <#include "*/templates/saml/documentation.ftl" parse=true>
        </div>
        <div id="faqView" class="view-section">
            <#include "*/templates/saml/faqs.ftl" parse=true>
        </div>
    </div>
    </body>
    </html>
