<meta name="decorator" content="atl.general"/>
<style>
    <#include "*/css/faqs.css" parse=true>
</style>

<script type="text/javascript">
    var faqsData = [];
    var faqsPerPage = ${faqsPerPage};
    var currentPage = ${currentPage};
        <#if faqJsonData?has_content && faqJsonData?size != 0 >
        try {
            faqsData = JSON.parse('${faqJsonData}'.replace(/&quot;/g, '"').replace(/&#39;/g, "'"));
            console.log("Successfully loaded FAQ data with " + faqsData.length + " entries");
            document.addEventListener('DOMContentLoaded', function() {
                console.log("DOM loaded, displaying FAQs");
                displayFilteredFaqs();
                initializeFaqSearchHandler();
            });
        } catch(e) {
            console.error("Error parsing FAQ data: ", e);
            document.getElementById('faq-content').innerHTML = '<p>Error loading FAQs. Please try again later.</p>';
        }
        <#else>
        console.warn("No FAQ data available");
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('faq-content').innerHTML = '<p>No FAQs available.</p>';
        });
        </#if>
</script>

<script>
    <#include "/js/faqs.js">
</script>

<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />

<div id="app">
    <div class="faq-container">
            <header class="faq-header">
            <h1>Frequently Asked Questions</h1>
            <div class="search-container">
                <input type="search" id="faq-search" placeholder="Search Questions">
                <button class="search-button">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="11" cy="11" r="8"></circle>
                        <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                    </svg>
                </button>
            </div>
        </header>
        <div class="faq-content" id="faq-content"></div>
        <div class="faq-no-results" style="display: none;">
            <p>No matching questions found. Please try a different search term.</p>
        </div>
    </div>
</div>
