
function getFaqSearchInputValue() {
    var searchInput = document.getElementById('faq-search');
    return searchInput ? searchInput.value.trim().toLowerCase() : '';
}
function displayFilteredFaqs(searchTerm, page) {
    var content = document.getElementById('faq-content');
    var noResults = document.querySelector('.faq-no-results');
    if (!content) {
        console.error('FAQ content container not found');
        return;
    }
    content.innerHTML = '';
    var faqs = window.faqsData || [];
    console.log('Displaying FAQs, total count:', faqs.length);
    if (typeof searchTerm === 'undefined') searchTerm = getFaqSearchInputValue();
    if (typeof page === 'undefined') page = window.currentPage || 1;
    if (searchTerm) {
        faqs = faqs.filter(function(faq) {
            return (
            (faq.heading && faq.heading.toLowerCase().includes(searchTerm)) ||
            (faq.summary && faq.summary.toLowerCase().includes(searchTerm))
            );
        });
    }
    var totalPages = Math.ceil(faqs.length / window.faqsPerPage);
    if (faqs.length === 0) {
        if (noResults) noResults.style.display = 'block';
        return;
    } else {
        if (noResults) noResults.style.display = 'none';
    }
    if (page < 1) page = 1;
    if (page > totalPages) page = totalPages;
    window.currentPage = page;
    var startIdx = (page - 1) * window.faqsPerPage;
    var endIdx = startIdx + window.faqsPerPage;
    var faqsToShow = faqs.slice(startIdx, endIdx);
    var col1 = document.createElement('div');
    col1.className = 'faq-column';
    var col2 = document.createElement('div');
    col2.className = 'faq-column';
    faqsToShow.forEach(function(faq, idx) {
        var item = document.createElement('div');
        item.className = 'faq-item';
        item.innerHTML =
        '<div class="faq-question"><h3>' + (faq.heading || 'No Title') + '</h3><span class="faq-icon"></span></div>' +
        '<div class="faq-answer" style="max-height:0;overflow:hidden;transition:max-height 0.4s cubic-bezier(0.4,0,0.2,1),padding 0.4s;">' +
        '<p>' + (faq.summary || 'No Summary') + '</p>' +
        '<a href="' + (faq.readMoreLink || '#') + '" target="_blank">Read more</a></div>';
        var question = item.querySelector('.faq-question');
        var answer = item.querySelector('.faq-answer');
        question.onclick = function() {
            var isActive = item.classList.toggle('active');
            if (isActive) {
                answer.style.maxHeight = answer.scrollHeight + 32 + 'px';
                answer.style.padding = '0 16px 16px';
            } else {
                answer.style.maxHeight = '0';
                answer.style.padding = '0 16px';
            }
        };
        answer.style.padding = '0 16px';
        if (idx < Math.ceil(faqsToShow.length / 2)) {
            col1.appendChild(item);
        } else {
            col2.appendChild(item);
        }
    });
    var row = document.createElement('div');
    row.style.display = 'grid';
    row.style.gap = '32px';
    row.appendChild(col1);
    row.appendChild(col2);
    content.appendChild(row);
    var pagination = document.createElement('div');
    pagination.className = 'faq-pagination';
    pagination.style.textAlign = 'center';
    pagination.style.margin = '24px 0';
    var prevBtn = document.createElement('button');
    prevBtn.textContent = 'Previous';
    prevBtn.disabled = (page === 1);
    prevBtn.onclick = function() { displayFilteredFaqs(searchTerm, page - 1); };
    pagination.appendChild(prevBtn);
    for (var i = 1; i <= totalPages; i++) {
        var pageBtn = document.createElement('button');
        pageBtn.textContent = i;
        if (i === page) pageBtn.className = 'active';
        pageBtn.onclick = (function(i) {
            return function() { displayFilteredFaqs(searchTerm, i); };
        })(i);
        pagination.appendChild(pageBtn);
    }
    var nextBtn = document.createElement('button');
    nextBtn.textContent = 'Next';
    nextBtn.disabled = (page === totalPages);
    nextBtn.onclick = function() { displayFilteredFaqs(searchTerm, page + 1); };
    pagination.appendChild(nextBtn);
    content.appendChild(pagination);
}
function initializeFaqSearchHandler() {
    var searchInput = document.getElementById('faq-search');
    if (!searchInput) {
        console.error('Search input not found');
        return;
    }
    var debounceTimeout;
    searchInput.addEventListener('input', function() {
        clearTimeout(debounceTimeout);
        debounceTimeout = setTimeout(function() {
            displayFilteredFaqs(getFaqSearchInputValue(), 1);
        }, 200);
    });
}