/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecL;

class PolyVecMatrix {
    private final int dilithiumK;
    private final int dilithiumL;
    private final PolyVecL[] mat;

    public PolyVecMatrix(MLDSAEngine mLDSAEngine) {
        this.dilithiumK = mLDSAEngine.getDilithiumK();
        this.dilithiumL = mLDSAEngine.getDilithiumL();
        this.mat = new PolyVecL[this.dilithiumK];
        for (int i = 0; i < this.dilithiumK; ++i) {
            this.mat[i] = new PolyVecL(mLDSAEngine);
        }
    }

    public void pointwiseMontgomery(PolyVecK polyVecK, PolyVecL polyVecL) {
        for (int i = 0; i < this.dilithiumK; ++i) {
            polyVecK.getVectorIndex(i).pointwiseAccountMontgomery(this.mat[i], polyVecL);
        }
    }

    public void expandMatrix(byte[] byArray) {
        for (int i = 0; i < this.dilithiumK; ++i) {
            for (int j = 0; j < this.dilithiumL; ++j) {
                this.mat[i].getVectorIndex(j).uniformBlocks(byArray, (short)((i << 8) + j));
            }
        }
    }

    private String addString() {
        Object object = "[";
        for (int i = 0; i < this.dilithiumK; ++i) {
            object = (String)object + "Outer Matrix " + i + " [";
            object = (String)object + this.mat[i].toString();
            object = i == this.dilithiumK - 1 ? (String)object + "]\n" : (String)object + "],\n";
        }
        object = (String)object + "]\n";
        return object;
    }

    public String toString(String string) {
        return string.concat(": \n" + this.addString());
    }
}

