/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.utils;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.mail.Email;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.spring.container.ContainerManager;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoSendAlert {
    private BambooPermissionManager bambooPermissionManager;
    private BambooUserManager bambooUserManager;
    private MoSAMLSettings settings;
    private UserManager userManager;
    private static Log LOGGER = LogFactory.getLog(MoSendAlert.class);

    public MoSendAlert(BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager, MoSAMLSettings settings, UserManager userManager) {
        this.bambooPermissionManager = bambooPermissionManager;
        this.bambooUserManager = bambooUserManager;
        this.settings = settings;
        this.userManager = userManager;
    }

    public Boolean sendMail() {
        LOGGER.info((Object)"Sending Alert email to administrator user");
        String adminEmail = this.getAdminEmail();
        try {
            String recipients = this.getAdminEmail();
            String[] recipientList = recipients.split(",");
            String validTo = MoSAMLUtils.getCertificateInfo(this.settings.getPublicSPCertificate()).get("Valid To");
            SimpleDateFormat originalFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
            SimpleDateFormat desiredFormat = new SimpleDateFormat("EEE MMM dd yyyy");
            Date date = originalFormat.parse(validTo);
            validTo = desiredFormat.format(date);
            String subject = "[IMPORTANT] Expiration of SAML X.509 certificates in " + this.settings.getPluginName() + " application in " + this.settings.getSPCertExpireOn() + " days";
            String content = "Hello ! ";
            content = content + "<strong><br><br>Important Warning:</strong><br>";
            content = content + "The miniOrange SAML SSO certificates are due to expire in <strong>" + this.settings.getSPCertExpireOn() + " days </strong> on " + validTo + ". Please visit the plugin settings and update the certificates to ensure uninterrupted service.<br><br>";
            content = content + "<strong>Plugin Details:</strong><br>";
            content = content + "<ul><li><b>Plugin Name:</b> " + this.settings.getPluginName() + "</li>";
            content = content + "<li><b>Instance URL:</b> " + this.settings.getBaseUrl() + "</li></ul>";
            content = content + "<br><strong>Steps to Configure the Certificates:</strong><br>";
            content = content + "You can configure or update your certificates by following these steps: <br>";
            content = content + "<a href='https://faq.miniorange.com/knowledgebase/update-saml-certificate-miniorange-plugin/'>Click here to learn how to configure certificates</a>";
            try {
                Map<String, String> certificateInfo = MoSAMLUtils.getCertificateInfo(this.settings.getPublicSPCertificate());
                if (certificateInfo != null && !certificateInfo.isEmpty()) {
                    content = content + "<br><br><strong>Current certificate details:</strong><br><br>";
                    content = content + "<table style='border: 1px solid; border-collapse: collapse;'>";
                    content = content + "<thead style='background-color: #fff7dc;'><tr><th style='border: 1px solid; padding: 8px;'>Key</th><th style='border: 1px solid; padding: 8px;'>Value</th></tr></thead><tbody>";
                    for (Map.Entry<String, String> entry : certificateInfo.entrySet()) {
                        content = content + "<tr>";
                        content = content + "<td style='border: 1px solid; padding: 8px; font-weight: bold;'>" + entry.getKey() + "</td>";
                        content = content + "<td style='border: 1px solid; padding: 8px;'>" + entry.getValue() + "</td>";
                        content = content + "</tr>";
                    }
                    content = content + "</tbody></table>";
                } else {
                    content = content + "<br><br>Certificate Details: Unable to fetch certificate details.";
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error fetching certificate details: ", (Throwable)e);
                content = content + "<br><br>Certificate Details: An error occurred while retrieving certificate details.";
            }
            content = content + "<br><br><strong>Please Note:</strong><br>";
            content = content + "If the certificates are not updated, your SSO will stop working, and users will not be able to authenticate. Please ensure the certificates are updated properly to avoid any disruption in SSO service.<br><br>";
            content = content + "Feel free to reach out incase you need assistance or need additional guidance. We would be happy to help!<br>";
            content = content + "You can contact us at <a href='mailto:support-atlassian@miniorange.atlassian.net\n'>support-atlassian@miniorange.atlassian.net</a>.";
            content = content + "<br><br>Thanks<br>Miniorange Team";
            if (this.isBambooSmtpConfigured()) {
                LOGGER.debug((Object)"Using Bamboo SMTP server for sending email.");
                MailServerManager mailServerManager = (MailServerManager)ContainerManager.getComponent((String)"mailServerManager");
                SMTPMailServer smtpmailServer = mailServerManager.getDefaultSMTPMailServer();
                for (String recipient : recipientList) {
                    recipient = recipient.trim();
                    Email email = new Email(recipient).setSubject(subject).setBody(content).setFrom("no-reply@xecurify.com").setMimeType("text/html").setFromName("miniOrange");
                    smtpmailServer.send(email);
                    LOGGER.debug((Object)("Mail is sent to " + recipient));
                }
            } else {
                LOGGER.debug((Object)"Using Miniorange server for sending email.");
                for (String recipient : recipientList) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("customerKey", "16555");
                    jsonObject.put("sendEmail", true);
                    JSONObject emailObject = new JSONObject();
                    emailObject.put("customerKey", "16555");
                    emailObject.put("fromEmail", "no-reply@xecurify.com");
                    emailObject.put("bccEmail", "no-reply@xecurify.com");
                    emailObject.put("fromName", "miniOrange");
                    emailObject.put("toEmail", recipient);
                    emailObject.put("toName", recipient);
                    emailObject.put("bccEmail", recipient);
                    emailObject.put("subject", subject);
                    emailObject.put("content", content);
                    jsonObject.put("email", emailObject);
                    String json = jsonObject.toString();
                    LOGGER.debug((Object)"Sending Email... ");
                    StringBuilder url = new StringBuilder("https://auth.miniorange.com/moas");
                    url.append("https://auth.miniorange.com/moas/api/notify/send");
                    String response1 = MoHttpUtils.sendPostRequest(url.toString(), json, "application/json", MoPluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
                    LOGGER.debug((Object)("Send_feedback response: " + response1));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while sending the email alert.", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean isBambooSmtpConfigured() {
        MailServerManager mailServerManager = (MailServerManager)ContainerManager.getComponent((String)"mailServerManager");
        SMTPMailServer mailServer = mailServerManager.getDefaultSMTPMailServer();
        LOGGER.debug((Object)("Mailserver = " + mailServer));
        return mailServer != null && mailServer.getHostname() != null && !mailServer.getHostname().isEmpty() && mailServer.getPort() != null && !mailServer.getPort().isEmpty();
    }

    private Collection<String> getAdminUsers() {
        HashSet<String> adminUsers = new HashSet<String>();
        adminUsers.addAll(this.bambooPermissionManager.getAdminUsers());
        adminUsers.addAll(this.bambooPermissionManager.getRestrictedAdminUsers());
        for (String groupName : this.bambooPermissionManager.getAdminGroups()) {
            List users = this.bambooUserManager.getMemberNamesAsList(this.bambooUserManager.getGroup(groupName));
            adminUsers.addAll(users);
        }
        return adminUsers;
    }

    private String getAdminEmail() {
        String email = "";
        Boolean notifyMultipleAdmins = this.settings.getNotifyMultipleAdmins();
        String emailInput = this.settings.getRecipientsList();
        if (notifyMultipleAdmins.booleanValue()) {
            if (StringUtils.isNotBlank((CharSequence)emailInput)) {
                email = emailInput;
                LOGGER.debug((Object)("Notify multiple admin users: " + email));
            }
        } else {
            for (String adminUser : this.getAdminUsers()) {
                email = this.userManager.getUserProfile(adminUser).getEmail();
                LOGGER.debug((Object)("Admin users: " + email));
            }
        }
        return email;
    }

    public BambooPermissionManager getBambooPermissionManager() {
        return this.bambooPermissionManager;
    }

    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

